import java.util.ArrayList;


public class Tree {
     TreeNode root;
     TreeNode lastFind;
     
     Tree() {
    	 root = null;
    	 lastFind = null;
     }
     Tree(TreeNode r) {
    	 root = r;
     }
     
     public void addNode(int toAdd, int parent){
    	 TreeNode p = find(parent);
    	 if (p == null){
    		 System.out.println("could not find parent to add to.");
    		 return;
    	 }
    	 p.addChild(new TreeNode(toAdd));
     }
     
     public void mkRoot(int toAdd){
    	 root = new TreeNode(toAdd);
     }
     
     public TreeNode find(int d){
    	 if (lastFind != null){
    		 if (lastFind.dat == d){
        		 return lastFind;
        	 }
    	 }
    	 lastFind = find(d,root); //calls recursive find method with the root
    	 return lastFind;
     }
     
     private TreeNode find(int d, TreeNode w){
    	 if (w == null) return null;
    	 int numC = w.getNumChildren();
    	 if (w.dat == d){
    		 return w;
    	 }
    	 for (int i = 0; i <numC; i++){
    		TreeNode t = find(d,w.getChild(i));
    		if (t != null){
    			return t;
    		}
    	 }
    	 return null;
     }
}

class TreeNode {
	int dat;
	ArrayList <TreeNode> children;
	TreeNode parent;
	
	TreeNode(int d){
		this.dat = d;
		children = new ArrayList<TreeNode>();
		parent = null;
	}
	
	public TreeNode getParent(){
		return parent;
	}
	
	public void addChild(TreeNode t){
		t.parent = this;
		children.add(t);
	}
	
	public TreeNode getChild(int i){
		return children.get(i);
	}
	
	public int getNumChildren(){
		return children.size();
	}
	
	public int getData(){
		return dat;
	}
	
}