import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;


/*
 * graph class, contains information of the graph
 */
public class Graph {
	/* List of nodes in the graph */
	private ArrayList <GraphNode> nodes;
	
	
	Graph(){
		nodes = new ArrayList<GraphNode>();
	}
	/**
	 * add a node to the graph, as number n
	 */
	public void addNode(int n){
		if (this.find(n) != null){ //node already exists in graph
			return;
		}
		
		GraphNode tmp = new GraphNode();
		tmp.setNum(n);
		nodes.add(tmp);
	}
	
	public void addEdge(int from, int to){
		/**
		 * This method will add an edge from one node in the graph to another
		 * if either the from node, or the to node is not in the graph, it will be
		 *   created and added to the graph
		 */
		if (this.find(from) == null)
			this.addNode(from);
		GraphNode t = this.find(from);
		if (this.find(to) == null)
			this.addNode(to);
		if (t == null){ //node already exists in graph
			System.out.println("node #"+from+" doesnot exist in graph, edges cannont be added to it");
			return;
		}
		t.addSuccessor(to);
	}
	
	/*** finds a node in the graph 
	 * returns: the node, or null if it was not found
	 * ***/
	public  GraphNode find(int toFind){
		for (int i = 0; i < nodes.size(); i++){
			if (nodes.get(i).getNum() == toFind){
				GraphNode t = nodes.get(i);
				return t;
			}
		}
		return null;
	}
	
	public boolean breadth_Fisrt_Search(int init, int goal){
		Stack <Integer> path = new Stack<Integer>();
		LinkedList <TreeNode> queue = new LinkedList<TreeNode>();
		ArrayList<Integer> expanded = new ArrayList<Integer>();
		GraphNode n = this.find(init);
		if (n == null ) return false;
		int array[];
		//TreeNode  t = new TreeNode();
		int it = 1;
		TreeNode root = new TreeNode(n.getNum());
		TreeNode t1 = null;
		TreeNode t2 = null;
		queue.addLast(root); //add the same node in the tree to queue
		                 // this way the node can be accessed easyily without extra searches
		
		while (!queue.isEmpty()){
			//continue until stack is empty or find the goal
			t1 = queue.getFirst();
			queue.removeFirst();
			n = this.find(t1.getData());
			
			System.out.println("iteration number: "+it);
			System.out.println("  node to expand: "+n.getNum());
			System.out.println("  successors: "+n.edgesToString()+"\n");
			if (t1.getData() == goal){
				//the goal was reached
				System.out.print("Path Found: ");
				do{
					path.add(new Integer(t1.getData()));
					t1 = t1.getParent(); //backtrack to the root
				}while(t1 != null);
				
				while (!path.isEmpty()){
					//print out the path it found
					System.out.print(path.pop().intValue() + " ");
				}
				System.out.println();
				return true;
			}
			expanded.add(new Integer(n.getNum()));
			array = n.getSuccessor();
			if (array != null)
			for (int i = 0; i < array.length; i++){
				//add the possible pathes to the queue if they have not already been expanded
				if ( !expanded.contains(new Integer(array[i])) ){
					n = this.find(array[i]);
					t2 = new TreeNode(n.getNum()); //make new Tree node with graph information
					t1.addChild(t2); //make t2 a child of t1
					queue.addLast(t2); //insert the tree node in the queue to be found later
					t2 = null;
				}
			}
			it++;
		}
		return false;
	}

	public boolean depth_fisrt_search(int init, int goal){
		Stack <TreeNode> s = new Stack<TreeNode>();
		ArrayList<Integer> expanded = new ArrayList<Integer>();
		GraphNode n = this.find(init);
		if (n == null ) return false;
		int array[];
		Stack <Integer> path = new Stack<Integer>();
		int it = 1;
		TreeNode root = new TreeNode(n.getNum());
		TreeNode t1 = null;
		TreeNode t2 = null;
		s.push(root);
		
		while (!s.isEmpty()){
			//continue until stack is empty or find the goal
			System.out.println("Stack = " + s);
			t1 = s.pop();
			System.out.println("iteration number: "+it);
			System.out.println("  node to expand: "+n.getNum());
			System.out.println("  successors: "+n.edgesToString());
			if (t1.getData() == goal){
				//the goal was reached
				System.out.print("Path Found: ");
				do{
					path.add(new Integer(t1.getData()));
					t1 = t1.getParent(); //backtrack to the root
				}while(t1 != null);
				
				while (!path.isEmpty()){
					//print out the path it found
					System.out.print(path.pop().intValue() + " ");
				}
				System.out.println();
				return true;
			}
			expanded.add(new Integer(n.getNum()));
			array = n.getSuccessor();
			if (array != null)
			for (int i = 0; i < array.length; i++){
				//add the possible pathes to the stack if they have not already been expanded
				if ( !expanded.contains(new Integer(array[i])) ){
					n = this.find(array[i]);
					t2 = new TreeNode(n.getNum());
					t1.addChild(t2);
					s.push(t2);
					t2 = null;
				}
			}
			it++;
		}
		return false;
	}
}

class GraphNode {
	private int num;
	private int [] edges;
	
	public int[] getSuccessor( ){
		return edges;
	}
	public void setSuccessor( int [] a){
		edges = a.clone();
	}
	public void addSuccessor( int e){
		if (edges == null){
			edges = new int[1];
			edges[0] = e;
			return;
		}
		int a2[] = new int[edges.length+1];
		for (int i = 0; i < edges.length; i++){
			a2[i] = edges[i];
		}
		a2[edges.length] = e;
		edges = a2;
		
	}
	public int getNum(){ return num;}
	public void setNum(int n) { num = n; } 

	public String edgesToString(){
		if (edges == null) return "";
		String str = "";
		for (int i = 0; i < edges.length; i++){
			str = str + edges[i] + ", ";
		}
		return str;
	}
}
