// Scott Blauert
// CS 475
// Homework #3


#include <string>
#include <queue>
#include <stdio.h>
#include <stack>

using namespace std;

int *getSuccessor(int i);
int breadth_first_search(int init, int goal);
int depth_first_search(int init, int goal);

// Test Data:
/*
int nodes[] = {1,2,3,4};
int edges[][2] = {{1,2}, {2,3}, {1,4}};

int nodes[] = {1,2,3,4,5,6,7,8,9};
int edges[][2] = {{1,2}, {1,3}, {1,4}, {2,5}, {4,6}, {6,8}, {8,9}, {3,7}};
*/


int nodes[] = {3,5,6,4};
int edges[][2] = {{3,4}, {3,5}, {3,5}, {4,5}, {4,6}, {5,6}, {6,3}};

int main(int argc, char *argv[])
{
  int search, init, goal;
  int i;
  for (i = 1; i < argc; i++)
    {
      if (!strcmp(argv[i], "-s"))
        {
	  i++;
          search = atoi(argv[i]);
        }
      if (!strcmp(argv[i], "-i"))
        {
          i++;
          init = atoi(argv[i]);
        }
      if (!strcmp(argv[i], "-g"))
        {
          i++;
          goal = atoi(argv[i]);
        }
    }
  printf("\n");
   if (search == 1)
   {
     breadth_first_search(init, goal);
  }
   else if (search == 2)
    {
     depth_first_search(init, goal);
    }
  return 0;
}

int *getSuccessor(int i)
{
  int* list;

  int x = 0;
  int y = 0;
  while(edges[x][0] != 0)
    {
      if (edges[x][0] == i)
	{
	  list[y] = edges[x][1];
	  y++;
	} 
      x++;
    }
  list[y++] = 0;
  return list;
}

int breadth_first_search(int init, int goal)
{
  printf("Starting breadth-first-search...\n\n");
  int i = 0;
  int x;
  int front;
  int *successor;
  int *parent;
  for (x = 0; nodes[x] != 0; x++)
    {
      parent[nodes[x]] = 0;
    }
  queue< int > q;
  q.push(init);
  parent[init] = -1;
  while(!q.empty())
    {
      i++;
      printf("Iteration number: %d\n", i);
      front = q.front();
      printf("Node to expand: %d", front);
      q.pop();
      printf("\n");
      if (front == goal)
	{
	  stack < int > path;
	  int x1 = goal;
	  while (x1 != -1)
	    {
	      path.push(x1);
	      x1 = parent[x1];
	    }
          printf("\nSolution found via breadth-first search. Path is: ");
	  while(!path.empty())
	    {
	      printf("%d ", path.top());
	      path.pop();
	    }
	  printf("\n");
	  return 1;
	}
      else
	{
	  successor = getSuccessor(front);
	  x = 0;
	  printf("Successors: ");
	  while (successor[x] != 0)
	    {
	      if (parent[successor[x]] == 0)
		{
		  printf("%d ", successor[x]);
		  q.push(successor[x]);
		  parent[successor[x]] = front;
		}
	      x++;
	    } 
	  printf("\n\n");
	}
    }
  return 0;
}

int depth_first_search(int init, int goal)
{
  int i = 0;
  int x;
  int top;
  int *successor;
  int *parent;
  for (x = 0; nodes[x] != 0; x++)
    {
      parent[nodes[x]] = 0;
    }
  stack< int > s;
  s.push(init);
  parent[init] = -1;
  while(!s.empty())
    {
      i++;
      printf("Iteration number: %d\n", i);
      top = s.top();
      printf("Node to expand: %d", top);
      s.pop();
      printf("\n");
      if (top == goal)
        {
	  stack < int > path;
	  int x1 = goal;
	  while (x1 != -1)
	    {
	      path.push(x1);
	      x1 = parent[x1];
	    }
	  printf("\nSolution found via depthth-first search. Path is: ");
	  while(!path.empty())
	    {
	      printf("%d ", path.top());
	      path.pop();
	    }
	  printf("\n");
	  return 1;
	}
      else
        {
          successor = getSuccessor(top);
          x = 0;
          printf("Successors: ");

	  while (successor[x] != 0)
	    {
	      x++;
	    }

          while (successor[x] != 0)
            {
	      if (parent[successor[x]] == 0)
                {
                  printf("%d ", successor[x]);
                  s.push(successor[x]);
                  parent[successor[x]] = top;
                }
              x++;

            }
          printf("\n\n");
        }
    }
  return 0;
}
