#include <iostream>
#include <algorithm>
#include <iterator>
#include <vector>
#include <queue>
#include <stack>
using namespace std;

const int numnodes = 9;
const int numedges = 9;
// need to update the above constants to the correct sizes
int nodes[] = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };
int edges[][2] = { {1, 2}, {1, 3}, {1, 4}, {2, 5}, {3, 5}, {3, 6}, {4, 7}, {5, 8}, {5, 9} };


//const int numnodes = 5;
//const int numedges = 3;
//int nodes[] = {1,2,3,4,5};
//int edges[,] = {{1,2}, {1,3}, {3,4}};


vector < int >t;

bool visited[numnodes] = { false };

vector < int >*getSuccessor( int n )
{
	vector < int >*s = new vector < int >;
	for( int i = 0; i < numedges; i++ )
	{
		if( edges[i][0] == n )
			s->push_back( edges[i][1] );
	}
	return s;
}

int dfs( int start, int goal )
{
	stack < int >st;
	st.push( start );
	int node, iter = 0;

	while( !st.empty(  ) )
	{
		node = st.top(  );
		st.pop(  );
		if( node == goal )
		{
			cout << "Traversed nodes: ";
			copy( t.begin(  ), t.end(  ), ostream_iterator < int >( cout, " " ) );
			cout << node << endl;
			return 1;
		}

		if( visited[node] )
			continue;
		else
			visited[node] = true;

		vector < int >*s = getSuccessor( node );

		for( unsigned i = 0; i < s->size(  ); ++i )
		{
			st.push( s->at( i ) );
		}

		cout << "iteration number: " << iter++ << endl;
		cout << "  node to expand: " << node << endl;
		cout << "  successors: ";
		// print out successors
		copy( s->begin(  ), s->end(  ), ostream_iterator < int >( cout, " " ) );
		cout << endl;

		t.push_back( node );

		delete s;
	}
	return 0;
}

int bfs( int start, int goal )
{
	int node, iter = 0;
	queue < int >q;

	q.push( start );

	while( !q.empty(  ) )
	{
		node = q.front(  );
		q.pop(  );

		if( node == goal )
		{
			cout << "Traversed nodes: ";
			copy( t.begin(  ), t.end(  ), ostream_iterator < int >( cout, " " ) );
			cout << node << endl;
			return 1;
		}

		if( visited[node] )
			continue;
		else
			visited[node] = true;

		vector < int >*s = getSuccessor( node );

		for( unsigned i = 0; i < s->size(  ); ++i )
		{
			q.push( s->at( i ) );
		}

		cout << "iteration number: " << iter++ << endl;
		cout << "  node to expand: " << node << endl;
		cout << "  successors: ";
		// print out successors
		copy( s->begin(  ), s->end(  ), ostream_iterator < int >( cout, " " ) );
		cout << endl;

		t.push_back( node );

		delete s;
	}
	return 0;
}

int main( int argc, char *argv[] )
{
	int strategy, start, goal;
	cout << "breadth-first search: 1" << endl << "depth-first search: 2" << endl << "Please select search strategy: ";
	cin >> strategy;
	if( !( strategy == 1 || strategy == 2 ) )
	{
		cout << "Error: unknown search strategy" << endl;
		exit( 1 );
	}
	cout << "Search strategy is: " << strategy << endl;

	cout << "The graph has " << numnodes << " nodes." << endl;
	cout << "start node: ";
	cin >> start;
	cout << "goal node: ";
	cin >> goal;
	if( ( start < 0 ) || ( start > numnodes ) || ( goal < 0 ) || ( goal > numnodes ) )
	{
		cout << "Invalid start/end node." << endl;
		exit( 1 );
	}

	int result;
	if( strategy == 1 )
		result = bfs( start, goal );
	else
		result = dfs( start, goal );

	cout << "Result: " << result << endl;

	return 0;
}
