/***************************************************************************
 *   Copyright (C) 2007 by Khoi Hoang Nguyen   *
 *   knguyen@klap2   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Queue.h"
#include "Stack.h"



struct EDGE {  
   int start;   
   int end;
};

int Nodes[MAX];		// The nodes list
EDGE edges[MAX*MAX];   // The edges list
int NumNode;		// The number of Nodes
int NumEdge;		// The number of Edges
Queue BFS;		// The queue for BFS
Stack DFS;		// The stack for DFS
bool travel[MAX];	// The list of nodes have been travelled


int *getSuccessor(int i, int& NumSucc);
int breadth_first_search(int init, int goal);
int depth_first_search(int init, int goal);

int main(int argc, char *argv[])
{
	/*test1:
	Nodes[0] = 1;
	Nodes[1] = 2;
	Nodes[2] = 3;
	Nodes[3] = 4;
	Nodes[4] = 5;
	Nodes[5] = 6;
	NumNode = 6;
	NumEdge = 6;
	edges[0].start = 1;
	edges[0].end = 2;
	edges[1].start = 1;
	edges[1].end = 3;
	edges[2].start = 3;
	edges[2].end = 5;
	edges[3].start = 2;
	edges[3].end = 4;
	edges[4].start = 5;
	edges[4].end = 6;
	edges[5].start = 3;
	edges[5].end = 2;
	breadth_first_search(1,6);*/
	/*test2:
	Nodes[0] = 1;
	Nodes[1] = 2;
	Nodes[2] = 3;
	Nodes[3] = 4;
	Nodes[4] = 5;
	Nodes[5] = 6;
	Nodes[6] = 7;
	NumNode = 7;
	NumEdge = 8;
	edges[0].start = 1;
	edges[0].end = 2;
	edges[1].start = 1;
	edges[1].end = 3;
	edges[2].start = 3;
	edges[2].end = 5;
	edges[3].start = 2;
	edges[3].end = 4;
	edges[4].start = 5;
	edges[4].end = 6;
	edges[5].start = 3;
	edges[5].end = 2;
	edges[6].start = 6;
	edges[6].end = 7;
	edges[7].start=4;
	edges[7].end=7;
	breadth_first_search(1,7);*/
	/*test3:
	Nodes[0] = 1;
	Nodes[1] = 2;
	Nodes[2] = 3;
	Nodes[3] = 4;
	Nodes[4] = 5;
	Nodes[5] = 6;
	NumNode = 6;
	NumEdge = 6;
	edges[0].start = 1;
	edges[0].end = 2;
	edges[1].start = 1;
	edges[1].end = 3;
	edges[2].start = 2;
	edges[2].end = 5;
	edges[3].start = 2;
	edges[3].end = 4;
	edges[4].start = 5;
	edges[4].end = 6;
	edges[5].start = 3;
	edges[5].end = 2;
	
	depth_first_search(1,6);*/
	Nodes[0] = 1;
	Nodes[1] = 2;
	Nodes[2] = 3;
	Nodes[3] = 6;
	Nodes[4] = 4;
	Nodes[5] = 5;
	NumNode = 6;
	NumEdge = 6;
	edges[0].start = 1;
	edges[0].end = 2;
	edges[1].start = 1;
	edges[1].end = 3;
	edges[2].start = 2;
	edges[2].end = 5;
	edges[3].start = 2;
	edges[3].end = 4;
	edges[4].start = 5;
	edges[4].end = 6;
	edges[5].start = 3;
	edges[5].end = 2;	

	int init, goal;
	printf("\nEnter the init node:");
	scanf("%d",&init);
	printf("\nEnter the goal node:");
	scanf("%d",&goal);
	int searchstrategy=0;
	printf("\nChoose search strategy: 1 for breadth_first-search, 2 for depth_first search");
	while((searchstrategy!=1)&&(searchstrategy!=2))
	{		
		scanf("%d",&searchstrategy);
	}
	if(searchstrategy==1)
	{
		breadth_first_search(init,goal);
	}
	if(searchstrategy==2)
	{
		depth_first_search(init,goal);
	}	
	return EXIT_SUCCESS;
}



int *getSuccessor(int i, int& NumSuccessors)
{
	int* Successors;
	for(int k=0; k < NumEdge; k++)
	{	
		if(( edges[k].start == i)&&(travel[edges[k].end]==false))
		{
			NumSuccessors++;
		}	
	}
	Successors = new int [NumSuccessors];
	int l = 0;
	for(int k=0; k < NumEdge; k++)
	{	
		if(( edges[k].start == i)&&(travel[edges[k].end]==false))
		{
			Successors[l] = edges[k].end;
			l++;
		}	
	}
	return Successors;
}

int breadth_first_search(int init, int goal)
{
	if(init == goal)
	{
		printf("Find path: %d",goal);
		return 1;
	}
	int ite = 1;
	BFS.Enqueue(init,NULL);
	int CurPoint = 0;
	element* current = new element;
	current = BFS.head;
	int CurSize = BFS.getQueueSize();
	while(CurPoint<CurSize)
	{
		printf("\niteration number: %d",ite);
		for(int i = CurPoint; i < CurSize; i++)
		{
			int* Successors;
			int NumSuccessors = 0;
			if(current->value == goal)
			{ 
				char path[2*MAX];
				char tmp[2*MAX]="";
				sprintf(path,"%d %s",current->value, tmp);
				while(current->parent!=NULL)
				{
					current = current->parent;
					sprintf(tmp, "%s", path);
					sprintf(path,"%d %s",current->value, tmp);
				}
				printf("\nFind path: %s",path );
				return 1;
			}
			Successors = getSuccessor(current->value, NumSuccessors);
			printf("\n node to expand: %d", current->value);
			printf("\n  successor:      ");
			int l;
			for(l = 0;l < NumSuccessors;l++)
			{
				travel[Successors[l]]=1;
				BFS.Enqueue(Successors[l],current);
				printf(" %d", Successors[l]);
			}
			current=current->next;
		}
		CurPoint = CurSize;
		CurSize = BFS.getQueueSize();
		ite++;
	}	
	return 0;
}

int depth_first_search(int init, int goal)
{
	if(init == goal)
	{
		printf("Find path: %d",goal);
		return 1;
	}
	int ite = 1;
	DFS.Push(init, "");
	while(!DFS.isEmpty())
	{
		int* Successors;
		int NumSuccessors = 0;
		stackelement* current = DFS.Pop();
		if(current->value == goal) 
		{
			printf("\nfind path:%s",current->path);
			return 1;
		}
		printf("\niteration number: %d",ite);
		Successors = getSuccessor(current->value, NumSuccessors);
		printf("\n node to expand: %d", current->value);
		printf("\n  successor:      ");
		int l;
		for(l = 0;l < NumSuccessors;l++)
		{
			travel[Successors[l]]=1;
			DFS.Push(Successors[l],current->path);
			printf(" %d", Successors[l]);
		}
		ite++;
	}	
	return 0;
}




