#include <stdio.h>
#include <stdlib.h>

void ring_domain(int n_rooms);

int main(int argc, char **argv)
{
  int n_rooms;

  if (argc != 2) {
    printf("Usage: ring #rooms\n");
    exit(1);
  }
  n_rooms = atoi(argv[1]);
  ring_domain(n_rooms);
}

// domain: RING
void ring_domain(int n_rooms)
{
  int r,r1,r2;	// loop variables
  int next,prev;
  
  // print header
  printf("%% Ring Domain: %d rooms\n\n",n_rooms);

  // add fluents
  printf("%% Fluents\n");
  for (r = 0; r < n_rooms; r++) {
    printf("fluent pos(%d), closed(%d), locked(%d);\n",r,r,r);

  }

  printf("\n");
  printf("%% Actions\n");
  for (r = 0; r < n_rooms; r++) {
    if (r == n_rooms-1)
      next = 0;
    else
      next = r+1;
    
    if (r == 0)
      prev = n_rooms-1;
    else
      prev = r-1;

    // 1. fwd action
    printf("fwd causes pos(%d) if pos(%d);\n",next,r);

    // 2. back action
    printf("back causes pos(%d) if pos(%d);\n",prev,r);
    
    // 3. close action
    printf("close causes closed(%d) if pos(%d);\n",r,r);

    // 3. lock action
    printf("executable lock if pos(%d), closed(%d);\n");
    printf("lock causes locked(%d) if pos(%d);\n",r,r);
    printf("\n");
  }

  // add static laws
  printf("%% Static Laws\n");

  for (r1 = 0; r1 < n_rooms; r1++) {
    for (r2 = 0; r2 < n_rooms; r2++) {
      // -pos(r1) if pos(r2), r1 != r2;
      if (r1 != r2)
	printf("-pos(%d) if pos(%d);\n",r1,r2);
    }
  }

  printf("\n");

  // define problem
  printf("\n");
  printf("%% Initial State\n");
  printf("%% the position of the robot is unknown;\n");
  printf("initially\n");

  for (r = 0; r < n_rooms; r++) {
    if (r != n_rooms-1)
      printf("\tpos(%d) |\n",r);
    else
      printf("\tpos(%d);\n",r);
  }

  printf("\n");
  printf("%% Goal \n");
  for (r = 0; r < n_rooms; r++)
    printf("goal locked(%d);\n",r);

}
