% *************************************************************
% Domain: Logistics locations=3 cities=2 packages=2
%	- number of cities: 2
%	- number of trucks per city: 1
%	- number of locations per city: 3
%	- number of airports per city: 1
%	- number of packages: 2
%	- number of planes: 1
% *************************************************************
% Fluent declarations
fluent at_truck(c0_t0,c0_l0);
fluent at_truck(c0_t0,c0_l1);
fluent at_truck(c0_t0,c0_l2);
fluent in_package(o0,c0_t0);
fluent in_package(o1,c0_t0);
fluent at_package(o0,c0_l0);
fluent at_package(o1,c0_l0);
fluent at_package(o0,c0_l1);
fluent at_package(o1,c0_l1);
fluent at_package(o0,c0_l2);
fluent at_package(o1,c0_l2);
fluent at_plane(p0,c0_l0);
fluent at_truck(c1_t0,c1_l0);
fluent at_truck(c1_t0,c1_l1);
fluent at_truck(c1_t0,c1_l2);
fluent in_package(o0,c1_t0);
fluent in_package(o1,c1_t0);
fluent at_package(o0,c1_l0);
fluent at_package(o1,c1_l0);
fluent at_package(o0,c1_l1);
fluent at_package(o1,c1_l1);
fluent at_package(o0,c1_l2);
fluent at_package(o1,c1_l2);
fluent at_plane(p0,c1_l0);
fluent in_package(o0,p0);
fluent in_package(o1,p0);

% Actions

% load_truck(package,truck,location)
executable load_truck(o0,c0_t0,c0_l0) if at_truck(c0_t0,c0_l0);
load_truck(o0,c0_t0,c0_l0) causes in_package(o0,c0_t0) if at_package(o0,c0_l0);

executable load_truck(o0,c1_t0,c1_l0) if at_truck(c1_t0,c1_l0);
load_truck(o0,c1_t0,c1_l0) causes in_package(o0,c1_t0) if at_package(o0,c1_l0);

executable load_truck(o0,c0_t0,c0_l1) if at_truck(c0_t0,c0_l1);
load_truck(o0,c0_t0,c0_l1) causes in_package(o0,c0_t0) if at_package(o0,c0_l1);

executable load_truck(o0,c1_t0,c1_l1) if at_truck(c1_t0,c1_l1);
load_truck(o0,c1_t0,c1_l1) causes in_package(o0,c1_t0) if at_package(o0,c1_l1);

executable load_truck(o0,c0_t0,c0_l2) if at_truck(c0_t0,c0_l2);
load_truck(o0,c0_t0,c0_l2) causes in_package(o0,c0_t0) if at_package(o0,c0_l2);

executable load_truck(o0,c1_t0,c1_l2) if at_truck(c1_t0,c1_l2);
load_truck(o0,c1_t0,c1_l2) causes in_package(o0,c1_t0) if at_package(o0,c1_l2);

executable load_truck(o1,c0_t0,c0_l0) if at_truck(c0_t0,c0_l0);
load_truck(o1,c0_t0,c0_l0) causes in_package(o1,c0_t0) if at_package(o1,c0_l0);

executable load_truck(o1,c1_t0,c1_l0) if at_truck(c1_t0,c1_l0);
load_truck(o1,c1_t0,c1_l0) causes in_package(o1,c1_t0) if at_package(o1,c1_l0);

executable load_truck(o1,c0_t0,c0_l1) if at_truck(c0_t0,c0_l1);
load_truck(o1,c0_t0,c0_l1) causes in_package(o1,c0_t0) if at_package(o1,c0_l1);

executable load_truck(o1,c1_t0,c1_l1) if at_truck(c1_t0,c1_l1);
load_truck(o1,c1_t0,c1_l1) causes in_package(o1,c1_t0) if at_package(o1,c1_l1);

executable load_truck(o1,c0_t0,c0_l2) if at_truck(c0_t0,c0_l2);
load_truck(o1,c0_t0,c0_l2) causes in_package(o1,c0_t0) if at_package(o1,c0_l2);

executable load_truck(o1,c1_t0,c1_l2) if at_truck(c1_t0,c1_l2);
load_truck(o1,c1_t0,c1_l2) causes in_package(o1,c1_t0) if at_package(o1,c1_l2);


% load_plane(package,plane,airport)
executable load_plane(o0,p0,c0_l0) if at_plane(p0,c0_l0), at_package(o0,c0_l0);
load_plane(o0,p0,c0_l0) causes in_package(o0,p0);

executable load_plane(o0,p0,c1_l0) if at_plane(p0,c1_l0), at_package(o0,c1_l0);
load_plane(o0,p0,c1_l0) causes in_package(o0,p0);

executable load_plane(o1,p0,c0_l0) if at_plane(p0,c0_l0), at_package(o1,c0_l0);
load_plane(o1,p0,c0_l0) causes in_package(o1,p0);

executable load_plane(o1,p0,c1_l0) if at_plane(p0,c1_l0), at_package(o1,c1_l0);
load_plane(o1,p0,c1_l0) causes in_package(o1,p0);


% unload_truck(package,truck,location)
executable unload_truck(o0,c0_t0,c0_l0) if at_truck(c0_t0,c0_l0);
unload_truck(o0,c0_t0,c0_l0) causes at_package(o0,c0_l0) if in_package(o0,c0_t0);

executable unload_truck(o0,c1_t0,c1_l0) if at_truck(c1_t0,c1_l0);
unload_truck(o0,c1_t0,c1_l0) causes at_package(o0,c1_l0) if in_package(o0,c1_t0);

executable unload_truck(o0,c0_t0,c0_l1) if at_truck(c0_t0,c0_l1);
unload_truck(o0,c0_t0,c0_l1) causes at_package(o0,c0_l1) if in_package(o0,c0_t0);

executable unload_truck(o0,c1_t0,c1_l1) if at_truck(c1_t0,c1_l1);
unload_truck(o0,c1_t0,c1_l1) causes at_package(o0,c1_l1) if in_package(o0,c1_t0);

executable unload_truck(o0,c0_t0,c0_l2) if at_truck(c0_t0,c0_l2);
unload_truck(o0,c0_t0,c0_l2) causes at_package(o0,c0_l2) if in_package(o0,c0_t0);

executable unload_truck(o0,c1_t0,c1_l2) if at_truck(c1_t0,c1_l2);
unload_truck(o0,c1_t0,c1_l2) causes at_package(o0,c1_l2) if in_package(o0,c1_t0);

executable unload_truck(o1,c0_t0,c0_l0) if at_truck(c0_t0,c0_l0);
unload_truck(o1,c0_t0,c0_l0) causes at_package(o1,c0_l0) if in_package(o1,c0_t0);

executable unload_truck(o1,c1_t0,c1_l0) if at_truck(c1_t0,c1_l0);
unload_truck(o1,c1_t0,c1_l0) causes at_package(o1,c1_l0) if in_package(o1,c1_t0);

executable unload_truck(o1,c0_t0,c0_l1) if at_truck(c0_t0,c0_l1);
unload_truck(o1,c0_t0,c0_l1) causes at_package(o1,c0_l1) if in_package(o1,c0_t0);

executable unload_truck(o1,c1_t0,c1_l1) if at_truck(c1_t0,c1_l1);
unload_truck(o1,c1_t0,c1_l1) causes at_package(o1,c1_l1) if in_package(o1,c1_t0);

executable unload_truck(o1,c0_t0,c0_l2) if at_truck(c0_t0,c0_l2);
unload_truck(o1,c0_t0,c0_l2) causes at_package(o1,c0_l2) if in_package(o1,c0_t0);

executable unload_truck(o1,c1_t0,c1_l2) if at_truck(c1_t0,c1_l2);
unload_truck(o1,c1_t0,c1_l2) causes at_package(o1,c1_l2) if in_package(o1,c1_t0);


% unload_plane(package,plane,airport)
executable unload_plane(o0,p0,c0_l0) if at_plane(p0,c0_l0), in_package(o0,p0);
unload_plane(o0,p0,c0_l0) causes at_package(o0,c0_l0);

executable unload_plane(o0,p0,c1_l0) if at_plane(p0,c1_l0), in_package(o0,p0);
unload_plane(o0,p0,c1_l0) causes at_package(o0,c1_l0);

executable unload_plane(o1,p0,c0_l0) if at_plane(p0,c0_l0), in_package(o1,p0);
unload_plane(o1,p0,c0_l0) causes at_package(o1,c0_l0);

executable unload_plane(o1,p0,c1_l0) if at_plane(p0,c1_l0), in_package(o1,p0);
unload_plane(o1,p0,c1_l0) causes at_package(o1,c1_l0);


% drive(truck,from,to)
executable drive(c0_t0,c0_l0,c0_l1) if at_truck(c0_t0,c0_l0);
drive(c0_t0,c0_l0,c0_l1) causes at_truck(c0_t0,c0_l1);

executable drive(c0_t0,c0_l0,c0_l2) if at_truck(c0_t0,c0_l0);
drive(c0_t0,c0_l0,c0_l2) causes at_truck(c0_t0,c0_l2);

executable drive(c0_t0,c0_l1,c0_l0) if at_truck(c0_t0,c0_l1);
drive(c0_t0,c0_l1,c0_l0) causes at_truck(c0_t0,c0_l0);

executable drive(c0_t0,c0_l1,c0_l2) if at_truck(c0_t0,c0_l1);
drive(c0_t0,c0_l1,c0_l2) causes at_truck(c0_t0,c0_l2);

executable drive(c0_t0,c0_l2,c0_l0) if at_truck(c0_t0,c0_l2);
drive(c0_t0,c0_l2,c0_l0) causes at_truck(c0_t0,c0_l0);

executable drive(c0_t0,c0_l2,c0_l1) if at_truck(c0_t0,c0_l2);
drive(c0_t0,c0_l2,c0_l1) causes at_truck(c0_t0,c0_l1);

executable drive(c1_t0,c1_l0,c1_l1) if at_truck(c1_t0,c1_l0);
drive(c1_t0,c1_l0,c1_l1) causes at_truck(c1_t0,c1_l1);

executable drive(c1_t0,c1_l0,c1_l2) if at_truck(c1_t0,c1_l0);
drive(c1_t0,c1_l0,c1_l2) causes at_truck(c1_t0,c1_l2);

executable drive(c1_t0,c1_l1,c1_l0) if at_truck(c1_t0,c1_l1);
drive(c1_t0,c1_l1,c1_l0) causes at_truck(c1_t0,c1_l0);

executable drive(c1_t0,c1_l1,c1_l2) if at_truck(c1_t0,c1_l1);
drive(c1_t0,c1_l1,c1_l2) causes at_truck(c1_t0,c1_l2);

executable drive(c1_t0,c1_l2,c1_l0) if at_truck(c1_t0,c1_l2);
drive(c1_t0,c1_l2,c1_l0) causes at_truck(c1_t0,c1_l0);

executable drive(c1_t0,c1_l2,c1_l1) if at_truck(c1_t0,c1_l2);
drive(c1_t0,c1_l2,c1_l1) causes at_truck(c1_t0,c1_l1);


% fly(plane,airport1,airport2)
executable fly(p0,c0_l0,c1_l0) if at_plane(p0,c0_l0);
fly(p0,c0_l0,c1_l0) causes at_plane(p0,c1_l0);

executable fly(p0,c1_l0,c0_l0) if at_plane(p0,c1_l0);
fly(p0,c1_l0,c0_l0) causes at_plane(p0,c0_l0);


% Static law 
-at_package(o0,c0_l1),-at_package(o0,c0_l2),-in_package(o0,c0_t0),-at_package(o0,c1_l0),-at_package(o0,c1_l1),-at_package(o0,c1_l2),-in_package(o0,c1_t0),-in_package(o0,p0) if at_package(o0,c0_l0);

-at_package(o0,c0_l0),-at_package(o0,c0_l2),-in_package(o0,c0_t0),-at_package(o0,c1_l0),-at_package(o0,c1_l1),-at_package(o0,c1_l2),-in_package(o0,c1_t0),-in_package(o0,p0) if at_package(o0,c0_l1);

-at_package(o0,c0_l0),-at_package(o0,c0_l1),-in_package(o0,c0_t0),-at_package(o0,c1_l0),-at_package(o0,c1_l1),-at_package(o0,c1_l2),-in_package(o0,c1_t0),-in_package(o0,p0) if at_package(o0,c0_l2);

-at_package(o0,c0_l0),-at_package(o0,c0_l1),-at_package(o0,c0_l2),-at_package(o0,c1_l0),-at_package(o0,c1_l1),-at_package(o0,c1_l2),-in_package(o0,c1_t0),-in_package(o0,p0) if in_package(o0,c0_t0);

-at_package(o0,c0_l0),-at_package(o0,c0_l1),-at_package(o0,c0_l2),-in_package(o0,c0_t0),-at_package(o0,c1_l1),-at_package(o0,c1_l2),-in_package(o0,c1_t0),-in_package(o0,p0) if at_package(o0,c1_l0);

-at_package(o0,c0_l0),-at_package(o0,c0_l1),-at_package(o0,c0_l2),-in_package(o0,c0_t0),-at_package(o0,c1_l0),-at_package(o0,c1_l2),-in_package(o0,c1_t0),-in_package(o0,p0) if at_package(o0,c1_l1);

-at_package(o0,c0_l0),-at_package(o0,c0_l1),-at_package(o0,c0_l2),-in_package(o0,c0_t0),-at_package(o0,c1_l0),-at_package(o0,c1_l1),-in_package(o0,c1_t0),-in_package(o0,p0) if at_package(o0,c1_l2);

-at_package(o0,c0_l0),-at_package(o0,c0_l1),-at_package(o0,c0_l2),-in_package(o0,c0_t0),-at_package(o0,c1_l0),-at_package(o0,c1_l1),-at_package(o0,c1_l2),-in_package(o0,p0) if in_package(o0,c1_t0);

-at_package(o0,c0_l0),-at_package(o0,c0_l1),-at_package(o0,c0_l2),-in_package(o0,c0_t0),-at_package(o0,c1_l0),-at_package(o0,c1_l1),-at_package(o0,c1_l2),-in_package(o0,c1_t0) if in_package(o0,p0);

-at_package(o1,c0_l1),-at_package(o1,c0_l2),-in_package(o1,c0_t0),-at_package(o1,c1_l0),-at_package(o1,c1_l1),-at_package(o1,c1_l2),-in_package(o1,c1_t0),-in_package(o1,p0) if at_package(o1,c0_l0);

-at_package(o1,c0_l0),-at_package(o1,c0_l2),-in_package(o1,c0_t0),-at_package(o1,c1_l0),-at_package(o1,c1_l1),-at_package(o1,c1_l2),-in_package(o1,c1_t0),-in_package(o1,p0) if at_package(o1,c0_l1);

-at_package(o1,c0_l0),-at_package(o1,c0_l1),-in_package(o1,c0_t0),-at_package(o1,c1_l0),-at_package(o1,c1_l1),-at_package(o1,c1_l2),-in_package(o1,c1_t0),-in_package(o1,p0) if at_package(o1,c0_l2);

-at_package(o1,c0_l0),-at_package(o1,c0_l1),-at_package(o1,c0_l2),-at_package(o1,c1_l0),-at_package(o1,c1_l1),-at_package(o1,c1_l2),-in_package(o1,c1_t0),-in_package(o1,p0) if in_package(o1,c0_t0);

-at_package(o1,c0_l0),-at_package(o1,c0_l1),-at_package(o1,c0_l2),-in_package(o1,c0_t0),-at_package(o1,c1_l1),-at_package(o1,c1_l2),-in_package(o1,c1_t0),-in_package(o1,p0) if at_package(o1,c1_l0);

-at_package(o1,c0_l0),-at_package(o1,c0_l1),-at_package(o1,c0_l2),-in_package(o1,c0_t0),-at_package(o1,c1_l0),-at_package(o1,c1_l2),-in_package(o1,c1_t0),-in_package(o1,p0) if at_package(o1,c1_l1);

-at_package(o1,c0_l0),-at_package(o1,c0_l1),-at_package(o1,c0_l2),-in_package(o1,c0_t0),-at_package(o1,c1_l0),-at_package(o1,c1_l1),-in_package(o1,c1_t0),-in_package(o1,p0) if at_package(o1,c1_l2);

-at_package(o1,c0_l0),-at_package(o1,c0_l1),-at_package(o1,c0_l2),-in_package(o1,c0_t0),-at_package(o1,c1_l0),-at_package(o1,c1_l1),-at_package(o1,c1_l2),-in_package(o1,p0) if in_package(o1,c1_t0);

-at_package(o1,c0_l0),-at_package(o1,c0_l1),-at_package(o1,c0_l2),-in_package(o1,c0_t0),-at_package(o1,c1_l0),-at_package(o1,c1_l1),-at_package(o1,c1_l2),-in_package(o1,c1_t0) if in_package(o1,p0);

-at_truck(c0_t0,c0_l1),-at_truck(c0_t0,c0_l2) if at_truck(c0_t0,c0_l0);

-at_truck(c0_t0,c0_l0),-at_truck(c0_t0,c0_l2) if at_truck(c0_t0,c0_l1);

-at_truck(c0_t0,c0_l0),-at_truck(c0_t0,c0_l1) if at_truck(c0_t0,c0_l2);

-at_truck(c1_t0,c1_l1),-at_truck(c1_t0,c1_l2) if at_truck(c1_t0,c1_l0);

-at_truck(c1_t0,c1_l0),-at_truck(c1_t0,c1_l2) if at_truck(c1_t0,c1_l1);

-at_truck(c1_t0,c1_l0),-at_truck(c1_t0,c1_l1) if at_truck(c1_t0,c1_l2);

-at_plane(p0,c1_l0) if at_plane(p0,c0_l0);

-at_plane(p0,c0_l0) if at_plane(p0,c1_l0);


% Initial state
initially at_truck(c0_t0,c0_l0);
initially at_truck(c1_t0,c1_l0);

initially at_plane(p0,c0_l0);

initially 
	at_package(o0,c0_l0) |
	at_package(o0,c0_l1) |
	at_package(o0,c0_l2);
initially 
	at_package(o1,c1_l0) |
	at_package(o1,c1_l1) |
	at_package(o1,c1_l2);

goal at_package(o0,c0_l1);
goal at_package(o1,c0_l1);