#include <stdio.h>
#include <stdlib.h>

void logistics(int n_cities, /* number of cities */
	       int n_trucks, /* trucks per city */
	       int n_locations, /* locations/city */
	       int n_airports, /* airports/city */
	       int n_packages, /* number of packages */
	       int n_planes
	       );

void print_oneof();

int n_size;
char oneof[100][100];

int main(int argc, char *argv[])
{
  int n_cities; /* number of cities */
  int n_trucks; /* trucks per city */
  int n_locations; /* locations/city */
  int n_airports; /* airports/city */
  int n_packages; /* number of packages */
  int n_planes;   /* number of planes */

  if (argc != 3) {
    printf("Usage: %s #locations_per_city #cities\n",argv[0]);
    exit(1);
  }

  n_cities = atoi(argv[2]);
  n_trucks = 1; // one truck per city
  n_locations = atoi(argv[1]);
  n_airports = 1; // one airport per city
  n_packages = n_cities;
  n_planes = 1;

  logistics(n_cities,n_trucks,n_locations,
	    n_airports,n_packages,n_planes);
}

void logistics(int n_cities, /* number of cities */
	       int n_trucks, /* trucks per city */
	       int n_locations, /* locations/city */
	       int n_airports, /* airports/city */
	       int n_packages, /* number of packages */
	       int n_planes
	       )
{
  int c,c1,t,l,l1,o,p;
  char act[100];

  printf("%% *************************************************************\n");
  printf("%% Domain: Logistics locations=%d cities=%d packages=%d\n",
	 n_locations,n_cities,n_packages);
  printf("%%\t- number of cities: %d\n",n_cities);
  printf("%%\t- number of trucks per city: %d\n",n_trucks);
  printf("%%\t- number of locations per city: %d\n",n_locations);
  printf("%%\t- number of airports per city: %d\n",n_airports);
  printf("%%\t- number of packages: %d\n",n_packages);
  printf("%%\t- number of planes: %d\n",n_planes);
  printf("%% *************************************************************\n");

  // fluents
  printf("%% Fluent declarations\n");
  for (c = 0; c < n_cities; c++) {
    for (t = 0; t < n_trucks; t++) {
      // 1. location of the truck: 
      // either at a location    
      for (l = 0; l < n_locations; l++) {
	printf("fluent at_truck(c%d_t%d,c%d_l%d);\n",c,t,c,l);
      }

      // packages in the truck
      for (o = 0; o < n_packages; o++) {
	printf("fluent in_package(o%d,c%d_t%d);\n",o,c,t);
      }
    }

    // 3. Locations within the city
    for (l = 0; l < n_locations; l++) {
      for (o = 0; o < n_packages; o++) {
	printf("fluent at_package(o%d,c%d_l%d);\n",o,c,l);
      }
    }
   
    for (p = 0; p < n_planes; p++) {
      printf("fluent at_plane(p%d,c%d_l0);\n",p,c); 
    }
  }

  for (o = 0; o < n_packages; o++) {
    for (p = 0; p < n_planes; p++) {
      printf("fluent in_package(o%d,p%d);\n",o,p);
    }
  }

  printf("\n%% Actions\n");

  // 1. load_tl(package,truck,location)
  printf("\n%% load_truck(package,truck,location)\n");
  for (o = 0; o < n_packages; o++) {
    for (t = 0; t < n_trucks; t++) {
      for (l = 0; l < n_locations; l++) {
	for (c = 0; c < n_cities; c++) {
	  sprintf(act,"load_truck(o%d,c%d_t%d,c%d_l%d)",o,c,t,c,l);
	  
	  // executablity condition
	  printf("executable %s if at_truck(c%d_t%d,c%d_l%d);\n",
		 act,c,t,c,l);
	  // effect
	  printf("%s causes in_package(o%d,c%d_t%d) if \
at_package(o%d,c%d_l%d);\n\n", act,o,c,t,o,c,l);
	}
      }
    }
  }


  // 3. load_plane(package,plane,airport)
  printf("\n%% load_plane(package,plane,airport)\n");
  for (o = 0; o < n_packages; o++) {
    for (p = 0; p < n_planes; p++) {
      for (c = 0; c < n_cities; c++) {
	sprintf(act,"load_plane(o%d,p%d,c%d_l0)",o,p,c);
	
	// executability condition
	printf("executable %s if at_plane(p%d,c%d_l0), at_package(o%d,c%d_l0);\n",
	       act,p,c,o,c);

	// effect
	printf("%s causes in_package(o%d,p%d);\n\n",
	       act,o,p);
      }      
    }
  }

  // 4. unload_truck(package,truck,location)
  printf("\n%% unload_truck(package,truck,location)\n");
  for (o = 0; o < n_packages; o++) {
    for (t = 0; t < n_trucks; t++) {
      for (l = 0; l < n_locations; l++) {
	for (c = 0; c < n_cities; c++) {
	  sprintf(act,"unload_truck(o%d,c%d_t%d,c%d_l%d)",o,c,t,c,l);
	  
	  // executablity condition
	  printf("executable %s if at_truck(c%d_t%d,c%d_l%d);\n",
		 act,c,t,c,l);
	  // effect
	  printf("%s causes at_package(o%d,c%d_l%d) if \
in_package(o%d,c%d_t%d);\n\n",act,o,c,l,o,c,t);
	}
      }
    }
  }


  // 6. unload_plane(package,plane,airport)
  printf("\n%% unload_plane(package,plane,airport)\n");
  for (o = 0; o < n_packages; o++) {
    for (p = 0; p < n_planes; p++) {
      for (c = 0; c < n_cities; c++) {
	sprintf(act,"unload_plane(o%d,p%d,c%d_l0)",o,p,c);
	
	// executability condition
	printf("executable %s if at_plane(p%d,c%d_l0), in_package(o%d,p%d);\n",
	       act,p,c,o,p);

	// effect
	printf("%s causes at_package(o%d,c%d_l0);\n\n",
	       act,o,c);
      }      
    }
  }

  // 7. drive(truck,loc1,loc2):
  //    drive back and forth between locations and airports
  printf("\n%% drive(truck,from,to)\n");
  for (c = 0; c < n_cities; c++) {
    for (t = 0; t < n_trucks; t++) {
      for (l = 0; l < n_locations; l++) {
	for (l1 = 0; l1 < n_locations; l1++) {
	  if (l != l1) {
	    // a. from location to airport
	    sprintf(act,"drive(c%d_t%d,c%d_l%d,c%d_l%d)",
		    c,t,c,l,c,l1);

	    // executablity
	    printf("executable %s if at_truck(c%d_t%d,c%d_l%d);\n",
		   act,c,t,c,l);
	  
	    // effect
	    printf("%s causes at_truck(c%d_t%d,c%d_l%d);\n\n",
		   act,c,t,c,l1);
	  }
	}
      }
    }
  }

  // 8. fly(plane,airport1,airport2)
  printf("\n%% fly(plane,airport1,airport2)\n");
  for (p = 0; p < n_planes; p++) {
    for (c = 0; c < n_cities; c++) {
      for (c1 = 0; c1 < n_cities; c1++) {
	if (c != c1) {
	  sprintf(act,"fly(p%d,c%d_l0,c%d_l0)",
		  p,c,c1);
	      
	  // executablity
	  printf("executable %s if at_plane(p%d,c%d_l0);\n",
		 act,p,c);
	      
	  // effect
	  printf("%s causes at_plane(p%d,c%d_l0);\n\n",
		 act,p,c1);
	}
      }
    }
  }

  // Static laws
  printf("\n%% Static law \n");

  // 1. position of the package
  for (o = 0; o < n_packages; o++)   {
    n_size = 0;
    for (c = 0; c < n_cities; c++) {
      // either at a location
      for (l = 0; l < n_locations; l++) {
	sprintf(act,"at_package(o%d,c%d_l%d)",o,c,l);
	strcpy(oneof[n_size++],act);
      }

      // or in a truck
      for (t = 0; t < n_trucks; t++) {
	sprintf(act,"in_package(o%d,c%d_t%d)",o,c,t);
	strcpy(oneof[n_size++],act);
      }
    }
    // or in a plane
    for (p = 0; p < n_planes; p++) {
      sprintf(act,"in_package(o%d,p%d)",o,p);
      strcpy(oneof[n_size++],act);      
    }
    print_oneof();
  }


  // 2. location of the truck
  for (c = 0; c < n_cities; c++) {
    for (t = 0; t < n_trucks; t++) {
      n_size = 0;
      // either at a location
      for (l = 0; l < n_locations; l++) {
	sprintf(act,"at_truck(c%d_t%d,c%d_l%d)",c,t,c,l);
	strcpy(oneof[n_size++],act);      
      }
      print_oneof();
    }
  }

  n_size = 0;

  // 3. position of the plane
  for (p = 0; p < n_planes; p++) {
    for (c = 0; c < n_cities; c++) {
      // at the first location
      sprintf(act,"at_plane(p%d,c%d_l0)",p,c);
      strcpy(oneof[n_size++],act);
    }    
  }


  print_oneof();

  // Init state:
  printf("\n%% Initial state\n");

  // trucks are at the first location of cities
  for (c = 0; c < n_cities; c++) {
    for (t = 0; t < n_trucks; t++) {      
      printf("initially at_truck(c%d_t%d,c%d_l0);\n",
	     c,t,c);
    }
  }

  printf("\n");

  // locations of planes: at the first location of the first city
  printf("initially at_plane(p0,c0_l0);\n");
  
  // the location of the package within the city is unknown
  /*  for (c = 0; c < n_cities; c++) {
    printf("initially \n");
    for (l = 0; l < n_locations; l++) {
      if (l != n_locations-1) {
	printf("\tat_package(o%d,c%d_l%d) |\n",c,c,l);
      }
      else
	printf("\tat_package(o%d,c%d_l%d);\n",c,c,l);
    }
  }

  // goal
  // all packages are at location 0 of city 0
  for (o = 0; o < n_packages; o++) {
    printf("goal at_package(o%d,c%d_l0);\n",o,o);
  }
  */
}


void print_oneof()
{
  int i,j;

  for (i = 0; i < n_size; i++) {
    for (j = 0; j < n_size; j++) {
      if (j != i) {
	if (j == n_size-1 || (i == n_size-1 && j == n_size-2)) 
	  printf("-%s if ", oneof[j]);
	else
	  printf("-%s,",oneof[j]);
      }
    }
    printf("%s;\n\n",oneof[i]);
  }
}
