#include <stdio.h>
#include <stdlib.h>

void cleaner_domain(int n_rooms, int n_tasks);

int main(int argc, char **argv)
{
  int n_rooms,n_tasks;

  if (argc != 3) {
    printf("Usage: %s #rooms #tasksperroom\n",argv[0]);
    exit(1);
  }
  n_rooms = atoi(argv[1]);
  n_tasks = atoi(argv[2]);

  cleaner_domain(n_rooms,n_tasks);
}

// domain: CLEANER
void cleaner_domain(int n_rooms, int n_tasks)
{
  int r,r1,r2,t;	// loop variables
  int next,prev;
  
  // print header
  printf("%% Ring Domain: %d rooms\n\n",n_rooms);

  // add fluents
  printf("%% Fluents\n");
  for (r = 0; r < n_rooms; r++) {
    printf("fluent pos(%d);\n",r,r,r);
    for (t = 0; t < n_tasks; t++) {
      printf("fluent cleaned(%d,%d);\n",r,t);
    }

  }

  printf("\n");
  printf("%% Actions\n");
  for (r = 0; r < n_rooms; r++) {
    next = (r == n_rooms-1) ? r : r+1;
    prev = (r == 0) ? 0 : r-1;

    // 1. fwd action
    printf("fwd causes pos(%d) if pos(%d);\n",next,r);

    // 2. back action
    printf("back causes pos(%d) if pos(%d);\n",prev,r);
    
    // 3. perform a specific task
    for (t = 0; t < n_tasks; t++) {
      printf("clean_object(%d) causes cleaned(%d,%d) if pos(%d);\n",
	     t,r,t,r);
    }
    printf("\n");
  }

  // add static laws
  printf("%% Static Laws\n");

  for (r1 = 0; r1 < n_rooms; r1++) {
    for (r2 = 0; r2 < n_rooms; r2++) {
      // -pos(r1) if pos(r2), r1 != r2;
      if (r1 != r2)
	printf("-pos(%d) if pos(%d);\n",r1,r2);
    }
  }

  printf("\n");

  // define problem
  printf("\n");
  printf("%% Initial State\n");
  printf("%% the position of the robot is at unknown;\n");
  printf("initially pos(0);\n");
  //  for (r = 0; r < n_rooms; r++) {
  //    if (r != n_rooms - 1)
  //      printf("\tpos(%d) |\n",r);
  //    else
  //      printf("\tpos(%d);\n\n",r);
  //  }

  printf("\n");
  printf("%% Goal \n");
  for (r = 0; r < n_rooms; r++) {
    for (t = 0; t < n_tasks; t++) {
      printf("goal cleaned(%d,%d);\n",r,t);
    }
  }
}
