#include <stdio.h>
#include <stdlib.h>

void bmtcs_domain(int n_packages, int n_toilets);
void bmtc_domain(int n_packages, int n_toilets);

int main(int argc, char **argv)
{
  int n_packages;
  int n_toilets;

  if (argc != 3) {
    printf("Usage: bmtc #packages #toilets\n");
    exit(1);
  }
  n_packages = atoi(argv[1]);
  n_toilets = atoi(argv[2]);

  bmtc_domain(n_packages,n_toilets);
}

// domain Bomb In the Toilet with Clogging.
void bmtc_domain(int n_packages, int n_toilets)
{
  int p,t;	// loop variables

  for (p=1; p <= n_packages; p++) {
	// dunked 
    //	printf("fluent dunked(%d);\n",p);

	// armed
	printf("fluent armed(%d);\n",p);
  }

  for (t=1; t <= n_toilets; t++) {
	// add fluent 
	printf("fluent clogged(%d);\n",t);		
  }

  for (t=1; t <= n_toilets; t++) {
    // 1. flush action
    //    effect: causes(flush(T),neg(clogged(T)),[]) :- toilet(T).
    printf("flush(%d) causes -clogged(%d);\n",t,t);	
		
    for (p=1; p <= n_packages; p++) {
      // 1. dunk actions
      //    executability condition: executable dunk(p,t) if -clogged(t)
      printf("executable dunk(%d,%d) if -clogged(%d);\n",p,t,t);

      //    effect: causes(dunk(P,T),neg(armed(P)),[]) :- pkg(P), toilet(T).
      printf("dunk(%d,%d) causes -armed(%d),clogged(%d);\n",
	      p,t,p,t);
    }
  }	


  // define problem
  //  for (p = 1; p <= n_packages; p++) {
	// initially(neg(dunked(P))) :-	pkg(P).
  //	printf("initially -dunked(%d);\n",p);
  //  }


  // no nothing about the status of toilet
  /*  for (t = 1; t <= n_toilets; t++) {
    // initially(neg(clogged(T))) :- pkg(T).
    printf("initially -clogged(%d);\n",t);
    }*/

  printf("\n");

  for (p = 1; p <= n_packages; p++) {
    printf("goal -armed(%d);\n",p);
  }

}
