%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Rover domain - Problem rover_2_4_2_3_3_1
%	n_rovers = 2, n_waypoints = 4, n_stores = 2, n_cameras = 3
%	n_modes = 3, n_landers = 1, n_objectives = 3
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fluent 
	at(r0,w0),
	at(r0,w1),
	at(r0,w2),
	at(r0,w3),
	at(r1,w0),
	at(r1,w1),
	at(r1,w2),
	at(r1,w3);
fluent 
	at_lander(l0,w0),
	at_lander(l0,w1),
	at_lander(l0,w2),
	at_lander(l0,w3);
fluent 
	can_traverse(r0,w0,w1),
	can_traverse(r0,w0,w2),
	can_traverse(r0,w0,w3),
	can_traverse(r0,w1,w0),
	can_traverse(r0,w1,w1),
	can_traverse(r0,w1,w2),
	can_traverse(r0,w1,w3),
	can_traverse(r0,w2,w0),
	can_traverse(r0,w2,w1),
	can_traverse(r0,w2,w2),
	can_traverse(r0,w2,w3),
	can_traverse(r0,w3,w0),
	can_traverse(r0,w3,w1),
	can_traverse(r0,w3,w2),
	can_traverse(r0,w3,w3),
	can_traverse(r1,w0,w1),
	can_traverse(r1,w0,w2),
	can_traverse(r1,w0,w3),
	can_traverse(r1,w1,w0),
	can_traverse(r1,w1,w1),
	can_traverse(r1,w1,w2),
	can_traverse(r1,w1,w3),
	can_traverse(r1,w2,w0),
	can_traverse(r1,w2,w1),
	can_traverse(r1,w2,w2),
	can_traverse(r1,w2,w3),
	can_traverse(r1,w3,w0),
	can_traverse(r1,w3,w1),
	can_traverse(r1,w3,w2),
	can_traverse(r1,w3,w3);
	fluent available(r0);
	fluent equipped_for_soil_analysis(r0);
	fluent equipped_for_imaging(r0);
	fluent equipped_for_rock_analysis(r0);
	fluent have_rock_analysis(r0,w0);
	fluent have_soil_analysis(r0,w0);
	fluent have_rock_analysis(r0,w1);
	fluent have_soil_analysis(r0,w1);
	fluent have_rock_analysis(r0,w2);
	fluent have_soil_analysis(r0,w2);
	fluent have_rock_analysis(r0,w3);
	fluent have_soil_analysis(r0,w3);
	fluent available(r1);
	fluent equipped_for_soil_analysis(r1);
	fluent equipped_for_imaging(r1);
	fluent equipped_for_rock_analysis(r1);
	fluent have_rock_analysis(r1,w0);
	fluent have_soil_analysis(r1,w0);
	fluent have_rock_analysis(r1,w1);
	fluent have_soil_analysis(r1,w1);
	fluent have_rock_analysis(r1,w2);
	fluent have_soil_analysis(r1,w2);
	fluent have_rock_analysis(r1,w3);
	fluent have_soil_analysis(r1,w3);
fluent communicated_soil_data(w0),communicated_rock_data(w0);
fluent communicated_soil_data(w1),communicated_rock_data(w1);
fluent communicated_soil_data(w2),communicated_rock_data(w2);
fluent communicated_soil_data(w3),communicated_rock_data(w3);
fluent
	empty(s0),
	full(s0),
	empty(s1),
	full(s1);
fluent
	supports(c0,m0),
	supports(c0,m1),
	supports(c0,m2),
	supports(c1,m0),
	supports(c1,m1),
	supports(c1,m2),
	supports(c2,m0),
	supports(c2,m1),
	supports(c2,m2);
fluent
	calibrated(c0,r0),
	calibrated(c0,r1),
	calibrated(c1,r0),
	calibrated(c1,r1),
	calibrated(c2,r0),
	calibrated(c2,r1);
	fluent visible(w0,w1);
	fluent visible(w0,w2);
	fluent visible(w0,w3);
	fluent visible(w1,w0);
	fluent visible(w1,w2);
	fluent visible(w1,w3);
	fluent visible(w2,w0);
	fluent visible(w2,w1);
	fluent visible(w2,w3);
	fluent visible(w3,w0);
	fluent visible(w3,w1);
	fluent visible(w3,w2);
fluent
	have_image(r0,o0,m0),
	have_image(r0,o0,m1),
	have_image(r0,o0,m2),
	have_image(r0,o1,m0),
	have_image(r0,o1,m1),
	have_image(r0,o1,m2),
	have_image(r0,o2,m0),
	have_image(r0,o2,m1),
	have_image(r0,o2,m2),
	have_image(r1,o0,m0),
	have_image(r1,o0,m1),
	have_image(r1,o0,m2),
	have_image(r1,o1,m0),
	have_image(r1,o1,m1),
	have_image(r1,o1,m2),
	have_image(r1,o2,m0),
	have_image(r1,o2,m1),
	have_image(r1,o2,m2);
fluent
	communicated_image_data(o0,m0),
	communicated_image_data(o0,m1),
	communicated_image_data(o0,m2),
	communicated_image_data(o1,m0),
	communicated_image_data(o1,m1),
	communicated_image_data(o1,m2),
	communicated_image_data(o2,m0),
	communicated_image_data(o2,m1),
	communicated_image_data(o2,m2);
fluent
	at_soil_sample(w0),
	at_rock_sample(w0),
	at_soil_sample(w1),
	at_rock_sample(w1),
	at_soil_sample(w2),
	at_rock_sample(w2),
	at_soil_sample(w3),
	at_rock_sample(w3);
fluent
	visible_from(o0,w0),
	visible_from(o0,w1),
	visible_from(o0,w2),
	visible_from(o0,w3),
	visible_from(o1,w0),
	visible_from(o1,w1),
	visible_from(o1,w2),
	visible_from(o1,w3),
	visible_from(o2,w0),
	visible_from(o2,w1),
	visible_from(o2,w2),
	visible_from(o2,w3);
fluent
	store_of(s0,r0),
	store_of(s0,r1),
	store_of(s1,r0),
	store_of(s1,r1);
fluent
	calibration_target(c0,o0),
	calibration_target(c0,o1),
	calibration_target(c0,o2),
	calibration_target(c1,o0),
	calibration_target(c1,o1),
	calibration_target(c1,o2),
	calibration_target(c2,o0),
	calibration_target(c2,o1),
	calibration_target(c2,o2);
fluent
	on_board(c0,r0),
	on_board(c0,r1),
	on_board(c1,r0),
	on_board(c1,r1),
	on_board(c2,r0),
	on_board(c2,r1);
fluent
	channel_free(l0);

executable navigate(r0,w0,w1) if can_traverse(r0,w0,w1),at(r0,w0),visible(w0,w1);
navigate(r0,w0,w1) causes at(r0,w1);

executable navigate(r0,w0,w2) if can_traverse(r0,w0,w2),at(r0,w0),visible(w0,w2);
navigate(r0,w0,w2) causes at(r0,w2);

executable navigate(r0,w0,w3) if can_traverse(r0,w0,w3),at(r0,w0),visible(w0,w3);
navigate(r0,w0,w3) causes at(r0,w3);

executable navigate(r0,w1,w0) if can_traverse(r0,w1,w0),at(r0,w1),visible(w1,w0);
navigate(r0,w1,w0) causes at(r0,w0);

executable navigate(r0,w1,w2) if can_traverse(r0,w1,w2),at(r0,w1),visible(w1,w2);
navigate(r0,w1,w2) causes at(r0,w2);

executable navigate(r0,w1,w3) if can_traverse(r0,w1,w3),at(r0,w1),visible(w1,w3);
navigate(r0,w1,w3) causes at(r0,w3);

executable navigate(r0,w2,w0) if can_traverse(r0,w2,w0),at(r0,w2),visible(w2,w0);
navigate(r0,w2,w0) causes at(r0,w0);

executable navigate(r0,w2,w1) if can_traverse(r0,w2,w1),at(r0,w2),visible(w2,w1);
navigate(r0,w2,w1) causes at(r0,w1);

executable navigate(r0,w2,w3) if can_traverse(r0,w2,w3),at(r0,w2),visible(w2,w3);
navigate(r0,w2,w3) causes at(r0,w3);

executable navigate(r0,w3,w0) if can_traverse(r0,w3,w0),at(r0,w3),visible(w3,w0);
navigate(r0,w3,w0) causes at(r0,w0);

executable navigate(r0,w3,w1) if can_traverse(r0,w3,w1),at(r0,w3),visible(w3,w1);
navigate(r0,w3,w1) causes at(r0,w1);

executable navigate(r0,w3,w2) if can_traverse(r0,w3,w2),at(r0,w3),visible(w3,w2);
navigate(r0,w3,w2) causes at(r0,w2);

executable navigate(r1,w0,w1) if can_traverse(r1,w0,w1),at(r1,w0),visible(w0,w1);
navigate(r1,w0,w1) causes at(r1,w1);

executable navigate(r1,w0,w2) if can_traverse(r1,w0,w2),at(r1,w0),visible(w0,w2);
navigate(r1,w0,w2) causes at(r1,w2);

executable navigate(r1,w0,w3) if can_traverse(r1,w0,w3),at(r1,w0),visible(w0,w3);
navigate(r1,w0,w3) causes at(r1,w3);

executable navigate(r1,w1,w0) if can_traverse(r1,w1,w0),at(r1,w1),visible(w1,w0);
navigate(r1,w1,w0) causes at(r1,w0);

executable navigate(r1,w1,w2) if can_traverse(r1,w1,w2),at(r1,w1),visible(w1,w2);
navigate(r1,w1,w2) causes at(r1,w2);

executable navigate(r1,w1,w3) if can_traverse(r1,w1,w3),at(r1,w1),visible(w1,w3);
navigate(r1,w1,w3) causes at(r1,w3);

executable navigate(r1,w2,w0) if can_traverse(r1,w2,w0),at(r1,w2),visible(w2,w0);
navigate(r1,w2,w0) causes at(r1,w0);

executable navigate(r1,w2,w1) if can_traverse(r1,w2,w1),at(r1,w2),visible(w2,w1);
navigate(r1,w2,w1) causes at(r1,w1);

executable navigate(r1,w2,w3) if can_traverse(r1,w2,w3),at(r1,w2),visible(w2,w3);
navigate(r1,w2,w3) causes at(r1,w3);

executable navigate(r1,w3,w0) if can_traverse(r1,w3,w0),at(r1,w3),visible(w3,w0);
navigate(r1,w3,w0) causes at(r1,w0);

executable navigate(r1,w3,w1) if can_traverse(r1,w3,w1),at(r1,w3),visible(w3,w1);
navigate(r1,w3,w1) causes at(r1,w1);

executable navigate(r1,w3,w2) if can_traverse(r1,w3,w2),at(r1,w3),visible(w3,w2);
navigate(r1,w3,w2) causes at(r1,w2);


executable sample_soil(r0,s0,w0) if at(r0,w0),at_soil_sample(w0),equipped_for_soil_analysis(r0),store_of(s0,r0),empty(s0);
sample_soil(r0,s0,w0) causes -empty(s0),full(s0),have_soil_analysis(r0,w0),-at_soil_sample(w0);

executable sample_soil(r0,s1,w0) if at(r0,w0),at_soil_sample(w0),equipped_for_soil_analysis(r0),store_of(s1,r0),empty(s1);
sample_soil(r0,s1,w0) causes -empty(s1),full(s1),have_soil_analysis(r0,w0),-at_soil_sample(w0);

executable sample_soil(r0,s0,w1) if at(r0,w1),at_soil_sample(w1),equipped_for_soil_analysis(r0),store_of(s0,r0),empty(s0);
sample_soil(r0,s0,w1) causes -empty(s0),full(s0),have_soil_analysis(r0,w1),-at_soil_sample(w1);

executable sample_soil(r0,s1,w1) if at(r0,w1),at_soil_sample(w1),equipped_for_soil_analysis(r0),store_of(s1,r0),empty(s1);
sample_soil(r0,s1,w1) causes -empty(s1),full(s1),have_soil_analysis(r0,w1),-at_soil_sample(w1);

executable sample_soil(r0,s0,w2) if at(r0,w2),at_soil_sample(w2),equipped_for_soil_analysis(r0),store_of(s0,r0),empty(s0);
sample_soil(r0,s0,w2) causes -empty(s0),full(s0),have_soil_analysis(r0,w2),-at_soil_sample(w2);

executable sample_soil(r0,s1,w2) if at(r0,w2),at_soil_sample(w2),equipped_for_soil_analysis(r0),store_of(s1,r0),empty(s1);
sample_soil(r0,s1,w2) causes -empty(s1),full(s1),have_soil_analysis(r0,w2),-at_soil_sample(w2);

executable sample_soil(r0,s0,w3) if at(r0,w3),at_soil_sample(w3),equipped_for_soil_analysis(r0),store_of(s0,r0),empty(s0);
sample_soil(r0,s0,w3) causes -empty(s0),full(s0),have_soil_analysis(r0,w3),-at_soil_sample(w3);

executable sample_soil(r0,s1,w3) if at(r0,w3),at_soil_sample(w3),equipped_for_soil_analysis(r0),store_of(s1,r0),empty(s1);
sample_soil(r0,s1,w3) causes -empty(s1),full(s1),have_soil_analysis(r0,w3),-at_soil_sample(w3);

executable sample_soil(r1,s0,w0) if at(r1,w0),at_soil_sample(w0),equipped_for_soil_analysis(r1),store_of(s0,r1),empty(s0);
sample_soil(r1,s0,w0) causes -empty(s0),full(s0),have_soil_analysis(r1,w0),-at_soil_sample(w0);

executable sample_soil(r1,s1,w0) if at(r1,w0),at_soil_sample(w0),equipped_for_soil_analysis(r1),store_of(s1,r1),empty(s1);
sample_soil(r1,s1,w0) causes -empty(s1),full(s1),have_soil_analysis(r1,w0),-at_soil_sample(w0);

executable sample_soil(r1,s0,w1) if at(r1,w1),at_soil_sample(w1),equipped_for_soil_analysis(r1),store_of(s0,r1),empty(s0);
sample_soil(r1,s0,w1) causes -empty(s0),full(s0),have_soil_analysis(r1,w1),-at_soil_sample(w1);

executable sample_soil(r1,s1,w1) if at(r1,w1),at_soil_sample(w1),equipped_for_soil_analysis(r1),store_of(s1,r1),empty(s1);
sample_soil(r1,s1,w1) causes -empty(s1),full(s1),have_soil_analysis(r1,w1),-at_soil_sample(w1);

executable sample_soil(r1,s0,w2) if at(r1,w2),at_soil_sample(w2),equipped_for_soil_analysis(r1),store_of(s0,r1),empty(s0);
sample_soil(r1,s0,w2) causes -empty(s0),full(s0),have_soil_analysis(r1,w2),-at_soil_sample(w2);

executable sample_soil(r1,s1,w2) if at(r1,w2),at_soil_sample(w2),equipped_for_soil_analysis(r1),store_of(s1,r1),empty(s1);
sample_soil(r1,s1,w2) causes -empty(s1),full(s1),have_soil_analysis(r1,w2),-at_soil_sample(w2);

executable sample_soil(r1,s0,w3) if at(r1,w3),at_soil_sample(w3),equipped_for_soil_analysis(r1),store_of(s0,r1),empty(s0);
sample_soil(r1,s0,w3) causes -empty(s0),full(s0),have_soil_analysis(r1,w3),-at_soil_sample(w3);

executable sample_soil(r1,s1,w3) if at(r1,w3),at_soil_sample(w3),equipped_for_soil_analysis(r1),store_of(s1,r1),empty(s1);
sample_soil(r1,s1,w3) causes -empty(s1),full(s1),have_soil_analysis(r1,w3),-at_soil_sample(w3);


executable sample_rock(r0,s0,w0) if at(r0,w0),at_rock_sample(w0),equipped_for_rock_analysis(r0),store_of(s0,r0),empty(s0);
sample_rock(r0,s0,w0) causes -empty(s0),full(s0),have_rock_analysis(r0,w0),-at_rock_sample(w0);

executable sample_rock(r0,s1,w0) if at(r0,w0),at_rock_sample(w0),equipped_for_rock_analysis(r0),store_of(s1,r0),empty(s1);
sample_rock(r0,s1,w0) causes -empty(s1),full(s1),have_rock_analysis(r0,w0),-at_rock_sample(w0);

executable sample_rock(r0,s0,w1) if at(r0,w1),at_rock_sample(w1),equipped_for_rock_analysis(r0),store_of(s0,r0),empty(s0);
sample_rock(r0,s0,w1) causes -empty(s0),full(s0),have_rock_analysis(r0,w1),-at_rock_sample(w1);

executable sample_rock(r0,s1,w1) if at(r0,w1),at_rock_sample(w1),equipped_for_rock_analysis(r0),store_of(s1,r0),empty(s1);
sample_rock(r0,s1,w1) causes -empty(s1),full(s1),have_rock_analysis(r0,w1),-at_rock_sample(w1);

executable sample_rock(r0,s0,w2) if at(r0,w2),at_rock_sample(w2),equipped_for_rock_analysis(r0),store_of(s0,r0),empty(s0);
sample_rock(r0,s0,w2) causes -empty(s0),full(s0),have_rock_analysis(r0,w2),-at_rock_sample(w2);

executable sample_rock(r0,s1,w2) if at(r0,w2),at_rock_sample(w2),equipped_for_rock_analysis(r0),store_of(s1,r0),empty(s1);
sample_rock(r0,s1,w2) causes -empty(s1),full(s1),have_rock_analysis(r0,w2),-at_rock_sample(w2);

executable sample_rock(r0,s0,w3) if at(r0,w3),at_rock_sample(w3),equipped_for_rock_analysis(r0),store_of(s0,r0),empty(s0);
sample_rock(r0,s0,w3) causes -empty(s0),full(s0),have_rock_analysis(r0,w3),-at_rock_sample(w3);

executable sample_rock(r0,s1,w3) if at(r0,w3),at_rock_sample(w3),equipped_for_rock_analysis(r0),store_of(s1,r0),empty(s1);
sample_rock(r0,s1,w3) causes -empty(s1),full(s1),have_rock_analysis(r0,w3),-at_rock_sample(w3);

executable sample_rock(r1,s0,w0) if at(r1,w0),at_rock_sample(w0),equipped_for_rock_analysis(r1),store_of(s0,r1),empty(s0);
sample_rock(r1,s0,w0) causes -empty(s0),full(s0),have_rock_analysis(r1,w0),-at_rock_sample(w0);

executable sample_rock(r1,s1,w0) if at(r1,w0),at_rock_sample(w0),equipped_for_rock_analysis(r1),store_of(s1,r1),empty(s1);
sample_rock(r1,s1,w0) causes -empty(s1),full(s1),have_rock_analysis(r1,w0),-at_rock_sample(w0);

executable sample_rock(r1,s0,w1) if at(r1,w1),at_rock_sample(w1),equipped_for_rock_analysis(r1),store_of(s0,r1),empty(s0);
sample_rock(r1,s0,w1) causes -empty(s0),full(s0),have_rock_analysis(r1,w1),-at_rock_sample(w1);

executable sample_rock(r1,s1,w1) if at(r1,w1),at_rock_sample(w1),equipped_for_rock_analysis(r1),store_of(s1,r1),empty(s1);
sample_rock(r1,s1,w1) causes -empty(s1),full(s1),have_rock_analysis(r1,w1),-at_rock_sample(w1);

executable sample_rock(r1,s0,w2) if at(r1,w2),at_rock_sample(w2),equipped_for_rock_analysis(r1),store_of(s0,r1),empty(s0);
sample_rock(r1,s0,w2) causes -empty(s0),full(s0),have_rock_analysis(r1,w2),-at_rock_sample(w2);

executable sample_rock(r1,s1,w2) if at(r1,w2),at_rock_sample(w2),equipped_for_rock_analysis(r1),store_of(s1,r1),empty(s1);
sample_rock(r1,s1,w2) causes -empty(s1),full(s1),have_rock_analysis(r1,w2),-at_rock_sample(w2);

executable sample_rock(r1,s0,w3) if at(r1,w3),at_rock_sample(w3),equipped_for_rock_analysis(r1),store_of(s0,r1),empty(s0);
sample_rock(r1,s0,w3) causes -empty(s0),full(s0),have_rock_analysis(r1,w3),-at_rock_sample(w3);

executable sample_rock(r1,s1,w3) if at(r1,w3),at_rock_sample(w3),equipped_for_rock_analysis(r1),store_of(s1,r1),empty(s1);
sample_rock(r1,s1,w3) causes -empty(s1),full(s1),have_rock_analysis(r1,w3),-at_rock_sample(w3);


executable drop(r0,s0) if store_of(s0,r0), full(s0);
drop(r0,s0) causes -full(s0), empty(s0);

executable drop(r0,s1) if store_of(s1,r0), full(s1);
drop(r0,s1) causes -full(s1), empty(s1);

executable drop(r1,s0) if store_of(s0,r1), full(s0);
drop(r1,s0) causes -full(s0), empty(s0);

executable drop(r1,s1) if store_of(s1,r1), full(s1);
drop(r1,s1) causes -full(s1), empty(s1);


executable calibrate(r0,c0,o0,w0) if equipped_for_imaging(r0),calibration_target(c0,o0),at(r0,w0),visible_from(o0,w0),on_board(c0,r0);
calibrate(r0,c0,o0,w0) causes calibrated(c0,r0);

executable calibrate(r0,c0,o0,w1) if equipped_for_imaging(r0),calibration_target(c0,o0),at(r0,w1),visible_from(o0,w1),on_board(c0,r0);
calibrate(r0,c0,o0,w1) causes calibrated(c0,r0);

executable calibrate(r0,c0,o0,w2) if equipped_for_imaging(r0),calibration_target(c0,o0),at(r0,w2),visible_from(o0,w2),on_board(c0,r0);
calibrate(r0,c0,o0,w2) causes calibrated(c0,r0);

executable calibrate(r0,c0,o0,w3) if equipped_for_imaging(r0),calibration_target(c0,o0),at(r0,w3),visible_from(o0,w3),on_board(c0,r0);
calibrate(r0,c0,o0,w3) causes calibrated(c0,r0);

executable calibrate(r0,c0,o1,w0) if equipped_for_imaging(r0),calibration_target(c0,o1),at(r0,w0),visible_from(o1,w0),on_board(c0,r0);
calibrate(r0,c0,o1,w0) causes calibrated(c0,r0);

executable calibrate(r0,c0,o1,w1) if equipped_for_imaging(r0),calibration_target(c0,o1),at(r0,w1),visible_from(o1,w1),on_board(c0,r0);
calibrate(r0,c0,o1,w1) causes calibrated(c0,r0);

executable calibrate(r0,c0,o1,w2) if equipped_for_imaging(r0),calibration_target(c0,o1),at(r0,w2),visible_from(o1,w2),on_board(c0,r0);
calibrate(r0,c0,o1,w2) causes calibrated(c0,r0);

executable calibrate(r0,c0,o1,w3) if equipped_for_imaging(r0),calibration_target(c0,o1),at(r0,w3),visible_from(o1,w3),on_board(c0,r0);
calibrate(r0,c0,o1,w3) causes calibrated(c0,r0);

executable calibrate(r0,c0,o2,w0) if equipped_for_imaging(r0),calibration_target(c0,o2),at(r0,w0),visible_from(o2,w0),on_board(c0,r0);
calibrate(r0,c0,o2,w0) causes calibrated(c0,r0);

executable calibrate(r0,c0,o2,w1) if equipped_for_imaging(r0),calibration_target(c0,o2),at(r0,w1),visible_from(o2,w1),on_board(c0,r0);
calibrate(r0,c0,o2,w1) causes calibrated(c0,r0);

executable calibrate(r0,c0,o2,w2) if equipped_for_imaging(r0),calibration_target(c0,o2),at(r0,w2),visible_from(o2,w2),on_board(c0,r0);
calibrate(r0,c0,o2,w2) causes calibrated(c0,r0);

executable calibrate(r0,c0,o2,w3) if equipped_for_imaging(r0),calibration_target(c0,o2),at(r0,w3),visible_from(o2,w3),on_board(c0,r0);
calibrate(r0,c0,o2,w3) causes calibrated(c0,r0);

executable calibrate(r0,c1,o0,w0) if equipped_for_imaging(r0),calibration_target(c1,o0),at(r0,w0),visible_from(o0,w0),on_board(c1,r0);
calibrate(r0,c1,o0,w0) causes calibrated(c1,r0);

executable calibrate(r0,c1,o0,w1) if equipped_for_imaging(r0),calibration_target(c1,o0),at(r0,w1),visible_from(o0,w1),on_board(c1,r0);
calibrate(r0,c1,o0,w1) causes calibrated(c1,r0);

executable calibrate(r0,c1,o0,w2) if equipped_for_imaging(r0),calibration_target(c1,o0),at(r0,w2),visible_from(o0,w2),on_board(c1,r0);
calibrate(r0,c1,o0,w2) causes calibrated(c1,r0);

executable calibrate(r0,c1,o0,w3) if equipped_for_imaging(r0),calibration_target(c1,o0),at(r0,w3),visible_from(o0,w3),on_board(c1,r0);
calibrate(r0,c1,o0,w3) causes calibrated(c1,r0);

executable calibrate(r0,c1,o1,w0) if equipped_for_imaging(r0),calibration_target(c1,o1),at(r0,w0),visible_from(o1,w0),on_board(c1,r0);
calibrate(r0,c1,o1,w0) causes calibrated(c1,r0);

executable calibrate(r0,c1,o1,w1) if equipped_for_imaging(r0),calibration_target(c1,o1),at(r0,w1),visible_from(o1,w1),on_board(c1,r0);
calibrate(r0,c1,o1,w1) causes calibrated(c1,r0);

executable calibrate(r0,c1,o1,w2) if equipped_for_imaging(r0),calibration_target(c1,o1),at(r0,w2),visible_from(o1,w2),on_board(c1,r0);
calibrate(r0,c1,o1,w2) causes calibrated(c1,r0);

executable calibrate(r0,c1,o1,w3) if equipped_for_imaging(r0),calibration_target(c1,o1),at(r0,w3),visible_from(o1,w3),on_board(c1,r0);
calibrate(r0,c1,o1,w3) causes calibrated(c1,r0);

executable calibrate(r0,c1,o2,w0) if equipped_for_imaging(r0),calibration_target(c1,o2),at(r0,w0),visible_from(o2,w0),on_board(c1,r0);
calibrate(r0,c1,o2,w0) causes calibrated(c1,r0);

executable calibrate(r0,c1,o2,w1) if equipped_for_imaging(r0),calibration_target(c1,o2),at(r0,w1),visible_from(o2,w1),on_board(c1,r0);
calibrate(r0,c1,o2,w1) causes calibrated(c1,r0);

executable calibrate(r0,c1,o2,w2) if equipped_for_imaging(r0),calibration_target(c1,o2),at(r0,w2),visible_from(o2,w2),on_board(c1,r0);
calibrate(r0,c1,o2,w2) causes calibrated(c1,r0);

executable calibrate(r0,c1,o2,w3) if equipped_for_imaging(r0),calibration_target(c1,o2),at(r0,w3),visible_from(o2,w3),on_board(c1,r0);
calibrate(r0,c1,o2,w3) causes calibrated(c1,r0);

executable calibrate(r0,c2,o0,w0) if equipped_for_imaging(r0),calibration_target(c2,o0),at(r0,w0),visible_from(o0,w0),on_board(c2,r0);
calibrate(r0,c2,o0,w0) causes calibrated(c2,r0);

executable calibrate(r0,c2,o0,w1) if equipped_for_imaging(r0),calibration_target(c2,o0),at(r0,w1),visible_from(o0,w1),on_board(c2,r0);
calibrate(r0,c2,o0,w1) causes calibrated(c2,r0);

executable calibrate(r0,c2,o0,w2) if equipped_for_imaging(r0),calibration_target(c2,o0),at(r0,w2),visible_from(o0,w2),on_board(c2,r0);
calibrate(r0,c2,o0,w2) causes calibrated(c2,r0);

executable calibrate(r0,c2,o0,w3) if equipped_for_imaging(r0),calibration_target(c2,o0),at(r0,w3),visible_from(o0,w3),on_board(c2,r0);
calibrate(r0,c2,o0,w3) causes calibrated(c2,r0);

executable calibrate(r0,c2,o1,w0) if equipped_for_imaging(r0),calibration_target(c2,o1),at(r0,w0),visible_from(o1,w0),on_board(c2,r0);
calibrate(r0,c2,o1,w0) causes calibrated(c2,r0);

executable calibrate(r0,c2,o1,w1) if equipped_for_imaging(r0),calibration_target(c2,o1),at(r0,w1),visible_from(o1,w1),on_board(c2,r0);
calibrate(r0,c2,o1,w1) causes calibrated(c2,r0);

executable calibrate(r0,c2,o1,w2) if equipped_for_imaging(r0),calibration_target(c2,o1),at(r0,w2),visible_from(o1,w2),on_board(c2,r0);
calibrate(r0,c2,o1,w2) causes calibrated(c2,r0);

executable calibrate(r0,c2,o1,w3) if equipped_for_imaging(r0),calibration_target(c2,o1),at(r0,w3),visible_from(o1,w3),on_board(c2,r0);
calibrate(r0,c2,o1,w3) causes calibrated(c2,r0);

executable calibrate(r0,c2,o2,w0) if equipped_for_imaging(r0),calibration_target(c2,o2),at(r0,w0),visible_from(o2,w0),on_board(c2,r0);
calibrate(r0,c2,o2,w0) causes calibrated(c2,r0);

executable calibrate(r0,c2,o2,w1) if equipped_for_imaging(r0),calibration_target(c2,o2),at(r0,w1),visible_from(o2,w1),on_board(c2,r0);
calibrate(r0,c2,o2,w1) causes calibrated(c2,r0);

executable calibrate(r0,c2,o2,w2) if equipped_for_imaging(r0),calibration_target(c2,o2),at(r0,w2),visible_from(o2,w2),on_board(c2,r0);
calibrate(r0,c2,o2,w2) causes calibrated(c2,r0);

executable calibrate(r0,c2,o2,w3) if equipped_for_imaging(r0),calibration_target(c2,o2),at(r0,w3),visible_from(o2,w3),on_board(c2,r0);
calibrate(r0,c2,o2,w3) causes calibrated(c2,r0);

executable calibrate(r1,c0,o0,w0) if equipped_for_imaging(r1),calibration_target(c0,o0),at(r1,w0),visible_from(o0,w0),on_board(c0,r1);
calibrate(r1,c0,o0,w0) causes calibrated(c0,r1);

executable calibrate(r1,c0,o0,w1) if equipped_for_imaging(r1),calibration_target(c0,o0),at(r1,w1),visible_from(o0,w1),on_board(c0,r1);
calibrate(r1,c0,o0,w1) causes calibrated(c0,r1);

executable calibrate(r1,c0,o0,w2) if equipped_for_imaging(r1),calibration_target(c0,o0),at(r1,w2),visible_from(o0,w2),on_board(c0,r1);
calibrate(r1,c0,o0,w2) causes calibrated(c0,r1);

executable calibrate(r1,c0,o0,w3) if equipped_for_imaging(r1),calibration_target(c0,o0),at(r1,w3),visible_from(o0,w3),on_board(c0,r1);
calibrate(r1,c0,o0,w3) causes calibrated(c0,r1);

executable calibrate(r1,c0,o1,w0) if equipped_for_imaging(r1),calibration_target(c0,o1),at(r1,w0),visible_from(o1,w0),on_board(c0,r1);
calibrate(r1,c0,o1,w0) causes calibrated(c0,r1);

executable calibrate(r1,c0,o1,w1) if equipped_for_imaging(r1),calibration_target(c0,o1),at(r1,w1),visible_from(o1,w1),on_board(c0,r1);
calibrate(r1,c0,o1,w1) causes calibrated(c0,r1);

executable calibrate(r1,c0,o1,w2) if equipped_for_imaging(r1),calibration_target(c0,o1),at(r1,w2),visible_from(o1,w2),on_board(c0,r1);
calibrate(r1,c0,o1,w2) causes calibrated(c0,r1);

executable calibrate(r1,c0,o1,w3) if equipped_for_imaging(r1),calibration_target(c0,o1),at(r1,w3),visible_from(o1,w3),on_board(c0,r1);
calibrate(r1,c0,o1,w3) causes calibrated(c0,r1);

executable calibrate(r1,c0,o2,w0) if equipped_for_imaging(r1),calibration_target(c0,o2),at(r1,w0),visible_from(o2,w0),on_board(c0,r1);
calibrate(r1,c0,o2,w0) causes calibrated(c0,r1);

executable calibrate(r1,c0,o2,w1) if equipped_for_imaging(r1),calibration_target(c0,o2),at(r1,w1),visible_from(o2,w1),on_board(c0,r1);
calibrate(r1,c0,o2,w1) causes calibrated(c0,r1);

executable calibrate(r1,c0,o2,w2) if equipped_for_imaging(r1),calibration_target(c0,o2),at(r1,w2),visible_from(o2,w2),on_board(c0,r1);
calibrate(r1,c0,o2,w2) causes calibrated(c0,r1);

executable calibrate(r1,c0,o2,w3) if equipped_for_imaging(r1),calibration_target(c0,o2),at(r1,w3),visible_from(o2,w3),on_board(c0,r1);
calibrate(r1,c0,o2,w3) causes calibrated(c0,r1);

executable calibrate(r1,c1,o0,w0) if equipped_for_imaging(r1),calibration_target(c1,o0),at(r1,w0),visible_from(o0,w0),on_board(c1,r1);
calibrate(r1,c1,o0,w0) causes calibrated(c1,r1);

executable calibrate(r1,c1,o0,w1) if equipped_for_imaging(r1),calibration_target(c1,o0),at(r1,w1),visible_from(o0,w1),on_board(c1,r1);
calibrate(r1,c1,o0,w1) causes calibrated(c1,r1);

executable calibrate(r1,c1,o0,w2) if equipped_for_imaging(r1),calibration_target(c1,o0),at(r1,w2),visible_from(o0,w2),on_board(c1,r1);
calibrate(r1,c1,o0,w2) causes calibrated(c1,r1);

executable calibrate(r1,c1,o0,w3) if equipped_for_imaging(r1),calibration_target(c1,o0),at(r1,w3),visible_from(o0,w3),on_board(c1,r1);
calibrate(r1,c1,o0,w3) causes calibrated(c1,r1);

executable calibrate(r1,c1,o1,w0) if equipped_for_imaging(r1),calibration_target(c1,o1),at(r1,w0),visible_from(o1,w0),on_board(c1,r1);
calibrate(r1,c1,o1,w0) causes calibrated(c1,r1);

executable calibrate(r1,c1,o1,w1) if equipped_for_imaging(r1),calibration_target(c1,o1),at(r1,w1),visible_from(o1,w1),on_board(c1,r1);
calibrate(r1,c1,o1,w1) causes calibrated(c1,r1);

executable calibrate(r1,c1,o1,w2) if equipped_for_imaging(r1),calibration_target(c1,o1),at(r1,w2),visible_from(o1,w2),on_board(c1,r1);
calibrate(r1,c1,o1,w2) causes calibrated(c1,r1);

executable calibrate(r1,c1,o1,w3) if equipped_for_imaging(r1),calibration_target(c1,o1),at(r1,w3),visible_from(o1,w3),on_board(c1,r1);
calibrate(r1,c1,o1,w3) causes calibrated(c1,r1);

executable calibrate(r1,c1,o2,w0) if equipped_for_imaging(r1),calibration_target(c1,o2),at(r1,w0),visible_from(o2,w0),on_board(c1,r1);
calibrate(r1,c1,o2,w0) causes calibrated(c1,r1);

executable calibrate(r1,c1,o2,w1) if equipped_for_imaging(r1),calibration_target(c1,o2),at(r1,w1),visible_from(o2,w1),on_board(c1,r1);
calibrate(r1,c1,o2,w1) causes calibrated(c1,r1);

executable calibrate(r1,c1,o2,w2) if equipped_for_imaging(r1),calibration_target(c1,o2),at(r1,w2),visible_from(o2,w2),on_board(c1,r1);
calibrate(r1,c1,o2,w2) causes calibrated(c1,r1);

executable calibrate(r1,c1,o2,w3) if equipped_for_imaging(r1),calibration_target(c1,o2),at(r1,w3),visible_from(o2,w3),on_board(c1,r1);
calibrate(r1,c1,o2,w3) causes calibrated(c1,r1);

executable calibrate(r1,c2,o0,w0) if equipped_for_imaging(r1),calibration_target(c2,o0),at(r1,w0),visible_from(o0,w0),on_board(c2,r1);
calibrate(r1,c2,o0,w0) causes calibrated(c2,r1);

executable calibrate(r1,c2,o0,w1) if equipped_for_imaging(r1),calibration_target(c2,o0),at(r1,w1),visible_from(o0,w1),on_board(c2,r1);
calibrate(r1,c2,o0,w1) causes calibrated(c2,r1);

executable calibrate(r1,c2,o0,w2) if equipped_for_imaging(r1),calibration_target(c2,o0),at(r1,w2),visible_from(o0,w2),on_board(c2,r1);
calibrate(r1,c2,o0,w2) causes calibrated(c2,r1);

executable calibrate(r1,c2,o0,w3) if equipped_for_imaging(r1),calibration_target(c2,o0),at(r1,w3),visible_from(o0,w3),on_board(c2,r1);
calibrate(r1,c2,o0,w3) causes calibrated(c2,r1);

executable calibrate(r1,c2,o1,w0) if equipped_for_imaging(r1),calibration_target(c2,o1),at(r1,w0),visible_from(o1,w0),on_board(c2,r1);
calibrate(r1,c2,o1,w0) causes calibrated(c2,r1);

executable calibrate(r1,c2,o1,w1) if equipped_for_imaging(r1),calibration_target(c2,o1),at(r1,w1),visible_from(o1,w1),on_board(c2,r1);
calibrate(r1,c2,o1,w1) causes calibrated(c2,r1);

executable calibrate(r1,c2,o1,w2) if equipped_for_imaging(r1),calibration_target(c2,o1),at(r1,w2),visible_from(o1,w2),on_board(c2,r1);
calibrate(r1,c2,o1,w2) causes calibrated(c2,r1);

executable calibrate(r1,c2,o1,w3) if equipped_for_imaging(r1),calibration_target(c2,o1),at(r1,w3),visible_from(o1,w3),on_board(c2,r1);
calibrate(r1,c2,o1,w3) causes calibrated(c2,r1);

executable calibrate(r1,c2,o2,w0) if equipped_for_imaging(r1),calibration_target(c2,o2),at(r1,w0),visible_from(o2,w0),on_board(c2,r1);
calibrate(r1,c2,o2,w0) causes calibrated(c2,r1);

executable calibrate(r1,c2,o2,w1) if equipped_for_imaging(r1),calibration_target(c2,o2),at(r1,w1),visible_from(o2,w1),on_board(c2,r1);
calibrate(r1,c2,o2,w1) causes calibrated(c2,r1);

executable calibrate(r1,c2,o2,w2) if equipped_for_imaging(r1),calibration_target(c2,o2),at(r1,w2),visible_from(o2,w2),on_board(c2,r1);
calibrate(r1,c2,o2,w2) causes calibrated(c2,r1);

executable calibrate(r1,c2,o2,w3) if equipped_for_imaging(r1),calibration_target(c2,o2),at(r1,w3),visible_from(o2,w3),on_board(c2,r1);
calibrate(r1,c2,o2,w3) causes calibrated(c2,r1);


executable take_image(r0,w0,o0,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o0,w0);
take_image(r0,w0,o0,c0,m0) causes have_image(r0,o0,m0),-calibrated(c0,r0);

executable take_image(r0,w0,o0,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o0,w0);
take_image(r0,w0,o0,c0,m1) causes have_image(r0,o0,m1),-calibrated(c0,r0);

executable take_image(r0,w0,o0,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o0,w0);
take_image(r0,w0,o0,c0,m2) causes have_image(r0,o0,m2),-calibrated(c0,r0);

executable take_image(r0,w0,o0,c1,m0) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m0),visible_from(o0,w0);
take_image(r0,w0,o0,c1,m0) causes have_image(r0,o0,m0),-calibrated(c1,r0);

executable take_image(r0,w0,o0,c1,m1) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m1),visible_from(o0,w0);
take_image(r0,w0,o0,c1,m1) causes have_image(r0,o0,m1),-calibrated(c1,r0);

executable take_image(r0,w0,o0,c1,m2) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m2),visible_from(o0,w0);
take_image(r0,w0,o0,c1,m2) causes have_image(r0,o0,m2),-calibrated(c1,r0);

executable take_image(r0,w0,o0,c2,m0) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m0),visible_from(o0,w0);
take_image(r0,w0,o0,c2,m0) causes have_image(r0,o0,m0),-calibrated(c2,r0);

executable take_image(r0,w0,o0,c2,m1) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m1),visible_from(o0,w0);
take_image(r0,w0,o0,c2,m1) causes have_image(r0,o0,m1),-calibrated(c2,r0);

executable take_image(r0,w0,o0,c2,m2) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m2),visible_from(o0,w0);
take_image(r0,w0,o0,c2,m2) causes have_image(r0,o0,m2),-calibrated(c2,r0);

executable take_image(r0,w0,o1,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o1,w0);
take_image(r0,w0,o1,c0,m0) causes have_image(r0,o1,m0),-calibrated(c0,r0);

executable take_image(r0,w0,o1,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o1,w0);
take_image(r0,w0,o1,c0,m1) causes have_image(r0,o1,m1),-calibrated(c0,r0);

executable take_image(r0,w0,o1,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o1,w0);
take_image(r0,w0,o1,c0,m2) causes have_image(r0,o1,m2),-calibrated(c0,r0);

executable take_image(r0,w0,o1,c1,m0) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m0),visible_from(o1,w0);
take_image(r0,w0,o1,c1,m0) causes have_image(r0,o1,m0),-calibrated(c1,r0);

executable take_image(r0,w0,o1,c1,m1) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m1),visible_from(o1,w0);
take_image(r0,w0,o1,c1,m1) causes have_image(r0,o1,m1),-calibrated(c1,r0);

executable take_image(r0,w0,o1,c1,m2) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m2),visible_from(o1,w0);
take_image(r0,w0,o1,c1,m2) causes have_image(r0,o1,m2),-calibrated(c1,r0);

executable take_image(r0,w0,o1,c2,m0) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m0),visible_from(o1,w0);
take_image(r0,w0,o1,c2,m0) causes have_image(r0,o1,m0),-calibrated(c2,r0);

executable take_image(r0,w0,o1,c2,m1) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m1),visible_from(o1,w0);
take_image(r0,w0,o1,c2,m1) causes have_image(r0,o1,m1),-calibrated(c2,r0);

executable take_image(r0,w0,o1,c2,m2) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m2),visible_from(o1,w0);
take_image(r0,w0,o1,c2,m2) causes have_image(r0,o1,m2),-calibrated(c2,r0);

executable take_image(r0,w0,o2,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o2,w0);
take_image(r0,w0,o2,c0,m0) causes have_image(r0,o2,m0),-calibrated(c0,r0);

executable take_image(r0,w0,o2,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o2,w0);
take_image(r0,w0,o2,c0,m1) causes have_image(r0,o2,m1),-calibrated(c0,r0);

executable take_image(r0,w0,o2,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o2,w0);
take_image(r0,w0,o2,c0,m2) causes have_image(r0,o2,m2),-calibrated(c0,r0);

executable take_image(r0,w0,o2,c1,m0) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m0),visible_from(o2,w0);
take_image(r0,w0,o2,c1,m0) causes have_image(r0,o2,m0),-calibrated(c1,r0);

executable take_image(r0,w0,o2,c1,m1) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m1),visible_from(o2,w0);
take_image(r0,w0,o2,c1,m1) causes have_image(r0,o2,m1),-calibrated(c1,r0);

executable take_image(r0,w0,o2,c1,m2) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m2),visible_from(o2,w0);
take_image(r0,w0,o2,c1,m2) causes have_image(r0,o2,m2),-calibrated(c1,r0);

executable take_image(r0,w0,o2,c2,m0) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m0),visible_from(o2,w0);
take_image(r0,w0,o2,c2,m0) causes have_image(r0,o2,m0),-calibrated(c2,r0);

executable take_image(r0,w0,o2,c2,m1) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m1),visible_from(o2,w0);
take_image(r0,w0,o2,c2,m1) causes have_image(r0,o2,m1),-calibrated(c2,r0);

executable take_image(r0,w0,o2,c2,m2) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m2),visible_from(o2,w0);
take_image(r0,w0,o2,c2,m2) causes have_image(r0,o2,m2),-calibrated(c2,r0);

executable take_image(r0,w1,o0,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o0,w1);
take_image(r0,w1,o0,c0,m0) causes have_image(r0,o0,m0),-calibrated(c0,r0);

executable take_image(r0,w1,o0,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o0,w1);
take_image(r0,w1,o0,c0,m1) causes have_image(r0,o0,m1),-calibrated(c0,r0);

executable take_image(r0,w1,o0,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o0,w1);
take_image(r0,w1,o0,c0,m2) causes have_image(r0,o0,m2),-calibrated(c0,r0);

executable take_image(r0,w1,o0,c1,m0) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m0),visible_from(o0,w1);
take_image(r0,w1,o0,c1,m0) causes have_image(r0,o0,m0),-calibrated(c1,r0);

executable take_image(r0,w1,o0,c1,m1) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m1),visible_from(o0,w1);
take_image(r0,w1,o0,c1,m1) causes have_image(r0,o0,m1),-calibrated(c1,r0);

executable take_image(r0,w1,o0,c1,m2) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m2),visible_from(o0,w1);
take_image(r0,w1,o0,c1,m2) causes have_image(r0,o0,m2),-calibrated(c1,r0);

executable take_image(r0,w1,o0,c2,m0) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m0),visible_from(o0,w1);
take_image(r0,w1,o0,c2,m0) causes have_image(r0,o0,m0),-calibrated(c2,r0);

executable take_image(r0,w1,o0,c2,m1) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m1),visible_from(o0,w1);
take_image(r0,w1,o0,c2,m1) causes have_image(r0,o0,m1),-calibrated(c2,r0);

executable take_image(r0,w1,o0,c2,m2) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m2),visible_from(o0,w1);
take_image(r0,w1,o0,c2,m2) causes have_image(r0,o0,m2),-calibrated(c2,r0);

executable take_image(r0,w1,o1,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o1,w1);
take_image(r0,w1,o1,c0,m0) causes have_image(r0,o1,m0),-calibrated(c0,r0);

executable take_image(r0,w1,o1,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o1,w1);
take_image(r0,w1,o1,c0,m1) causes have_image(r0,o1,m1),-calibrated(c0,r0);

executable take_image(r0,w1,o1,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o1,w1);
take_image(r0,w1,o1,c0,m2) causes have_image(r0,o1,m2),-calibrated(c0,r0);

executable take_image(r0,w1,o1,c1,m0) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m0),visible_from(o1,w1);
take_image(r0,w1,o1,c1,m0) causes have_image(r0,o1,m0),-calibrated(c1,r0);

executable take_image(r0,w1,o1,c1,m1) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m1),visible_from(o1,w1);
take_image(r0,w1,o1,c1,m1) causes have_image(r0,o1,m1),-calibrated(c1,r0);

executable take_image(r0,w1,o1,c1,m2) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m2),visible_from(o1,w1);
take_image(r0,w1,o1,c1,m2) causes have_image(r0,o1,m2),-calibrated(c1,r0);

executable take_image(r0,w1,o1,c2,m0) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m0),visible_from(o1,w1);
take_image(r0,w1,o1,c2,m0) causes have_image(r0,o1,m0),-calibrated(c2,r0);

executable take_image(r0,w1,o1,c2,m1) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m1),visible_from(o1,w1);
take_image(r0,w1,o1,c2,m1) causes have_image(r0,o1,m1),-calibrated(c2,r0);

executable take_image(r0,w1,o1,c2,m2) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m2),visible_from(o1,w1);
take_image(r0,w1,o1,c2,m2) causes have_image(r0,o1,m2),-calibrated(c2,r0);

executable take_image(r0,w1,o2,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o2,w1);
take_image(r0,w1,o2,c0,m0) causes have_image(r0,o2,m0),-calibrated(c0,r0);

executable take_image(r0,w1,o2,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o2,w1);
take_image(r0,w1,o2,c0,m1) causes have_image(r0,o2,m1),-calibrated(c0,r0);

executable take_image(r0,w1,o2,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o2,w1);
take_image(r0,w1,o2,c0,m2) causes have_image(r0,o2,m2),-calibrated(c0,r0);

executable take_image(r0,w1,o2,c1,m0) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m0),visible_from(o2,w1);
take_image(r0,w1,o2,c1,m0) causes have_image(r0,o2,m0),-calibrated(c1,r0);

executable take_image(r0,w1,o2,c1,m1) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m1),visible_from(o2,w1);
take_image(r0,w1,o2,c1,m1) causes have_image(r0,o2,m1),-calibrated(c1,r0);

executable take_image(r0,w1,o2,c1,m2) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m2),visible_from(o2,w1);
take_image(r0,w1,o2,c1,m2) causes have_image(r0,o2,m2),-calibrated(c1,r0);

executable take_image(r0,w1,o2,c2,m0) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m0),visible_from(o2,w1);
take_image(r0,w1,o2,c2,m0) causes have_image(r0,o2,m0),-calibrated(c2,r0);

executable take_image(r0,w1,o2,c2,m1) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m1),visible_from(o2,w1);
take_image(r0,w1,o2,c2,m1) causes have_image(r0,o2,m1),-calibrated(c2,r0);

executable take_image(r0,w1,o2,c2,m2) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m2),visible_from(o2,w1);
take_image(r0,w1,o2,c2,m2) causes have_image(r0,o2,m2),-calibrated(c2,r0);

executable take_image(r0,w2,o0,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o0,w2);
take_image(r0,w2,o0,c0,m0) causes have_image(r0,o0,m0),-calibrated(c0,r0);

executable take_image(r0,w2,o0,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o0,w2);
take_image(r0,w2,o0,c0,m1) causes have_image(r0,o0,m1),-calibrated(c0,r0);

executable take_image(r0,w2,o0,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o0,w2);
take_image(r0,w2,o0,c0,m2) causes have_image(r0,o0,m2),-calibrated(c0,r0);

executable take_image(r0,w2,o0,c1,m0) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m0),visible_from(o0,w2);
take_image(r0,w2,o0,c1,m0) causes have_image(r0,o0,m0),-calibrated(c1,r0);

executable take_image(r0,w2,o0,c1,m1) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m1),visible_from(o0,w2);
take_image(r0,w2,o0,c1,m1) causes have_image(r0,o0,m1),-calibrated(c1,r0);

executable take_image(r0,w2,o0,c1,m2) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m2),visible_from(o0,w2);
take_image(r0,w2,o0,c1,m2) causes have_image(r0,o0,m2),-calibrated(c1,r0);

executable take_image(r0,w2,o0,c2,m0) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m0),visible_from(o0,w2);
take_image(r0,w2,o0,c2,m0) causes have_image(r0,o0,m0),-calibrated(c2,r0);

executable take_image(r0,w2,o0,c2,m1) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m1),visible_from(o0,w2);
take_image(r0,w2,o0,c2,m1) causes have_image(r0,o0,m1),-calibrated(c2,r0);

executable take_image(r0,w2,o0,c2,m2) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m2),visible_from(o0,w2);
take_image(r0,w2,o0,c2,m2) causes have_image(r0,o0,m2),-calibrated(c2,r0);

executable take_image(r0,w2,o1,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o1,w2);
take_image(r0,w2,o1,c0,m0) causes have_image(r0,o1,m0),-calibrated(c0,r0);

executable take_image(r0,w2,o1,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o1,w2);
take_image(r0,w2,o1,c0,m1) causes have_image(r0,o1,m1),-calibrated(c0,r0);

executable take_image(r0,w2,o1,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o1,w2);
take_image(r0,w2,o1,c0,m2) causes have_image(r0,o1,m2),-calibrated(c0,r0);

executable take_image(r0,w2,o1,c1,m0) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m0),visible_from(o1,w2);
take_image(r0,w2,o1,c1,m0) causes have_image(r0,o1,m0),-calibrated(c1,r0);

executable take_image(r0,w2,o1,c1,m1) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m1),visible_from(o1,w2);
take_image(r0,w2,o1,c1,m1) causes have_image(r0,o1,m1),-calibrated(c1,r0);

executable take_image(r0,w2,o1,c1,m2) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m2),visible_from(o1,w2);
take_image(r0,w2,o1,c1,m2) causes have_image(r0,o1,m2),-calibrated(c1,r0);

executable take_image(r0,w2,o1,c2,m0) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m0),visible_from(o1,w2);
take_image(r0,w2,o1,c2,m0) causes have_image(r0,o1,m0),-calibrated(c2,r0);

executable take_image(r0,w2,o1,c2,m1) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m1),visible_from(o1,w2);
take_image(r0,w2,o1,c2,m1) causes have_image(r0,o1,m1),-calibrated(c2,r0);

executable take_image(r0,w2,o1,c2,m2) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m2),visible_from(o1,w2);
take_image(r0,w2,o1,c2,m2) causes have_image(r0,o1,m2),-calibrated(c2,r0);

executable take_image(r0,w2,o2,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o2,w2);
take_image(r0,w2,o2,c0,m0) causes have_image(r0,o2,m0),-calibrated(c0,r0);

executable take_image(r0,w2,o2,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o2,w2);
take_image(r0,w2,o2,c0,m1) causes have_image(r0,o2,m1),-calibrated(c0,r0);

executable take_image(r0,w2,o2,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o2,w2);
take_image(r0,w2,o2,c0,m2) causes have_image(r0,o2,m2),-calibrated(c0,r0);

executable take_image(r0,w2,o2,c1,m0) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m0),visible_from(o2,w2);
take_image(r0,w2,o2,c1,m0) causes have_image(r0,o2,m0),-calibrated(c1,r0);

executable take_image(r0,w2,o2,c1,m1) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m1),visible_from(o2,w2);
take_image(r0,w2,o2,c1,m1) causes have_image(r0,o2,m1),-calibrated(c1,r0);

executable take_image(r0,w2,o2,c1,m2) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m2),visible_from(o2,w2);
take_image(r0,w2,o2,c1,m2) causes have_image(r0,o2,m2),-calibrated(c1,r0);

executable take_image(r0,w2,o2,c2,m0) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m0),visible_from(o2,w2);
take_image(r0,w2,o2,c2,m0) causes have_image(r0,o2,m0),-calibrated(c2,r0);

executable take_image(r0,w2,o2,c2,m1) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m1),visible_from(o2,w2);
take_image(r0,w2,o2,c2,m1) causes have_image(r0,o2,m1),-calibrated(c2,r0);

executable take_image(r0,w2,o2,c2,m2) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m2),visible_from(o2,w2);
take_image(r0,w2,o2,c2,m2) causes have_image(r0,o2,m2),-calibrated(c2,r0);

executable take_image(r0,w3,o0,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o0,w3);
take_image(r0,w3,o0,c0,m0) causes have_image(r0,o0,m0),-calibrated(c0,r0);

executable take_image(r0,w3,o0,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o0,w3);
take_image(r0,w3,o0,c0,m1) causes have_image(r0,o0,m1),-calibrated(c0,r0);

executable take_image(r0,w3,o0,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o0,w3);
take_image(r0,w3,o0,c0,m2) causes have_image(r0,o0,m2),-calibrated(c0,r0);

executable take_image(r0,w3,o0,c1,m0) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m0),visible_from(o0,w3);
take_image(r0,w3,o0,c1,m0) causes have_image(r0,o0,m0),-calibrated(c1,r0);

executable take_image(r0,w3,o0,c1,m1) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m1),visible_from(o0,w3);
take_image(r0,w3,o0,c1,m1) causes have_image(r0,o0,m1),-calibrated(c1,r0);

executable take_image(r0,w3,o0,c1,m2) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m2),visible_from(o0,w3);
take_image(r0,w3,o0,c1,m2) causes have_image(r0,o0,m2),-calibrated(c1,r0);

executable take_image(r0,w3,o0,c2,m0) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m0),visible_from(o0,w3);
take_image(r0,w3,o0,c2,m0) causes have_image(r0,o0,m0),-calibrated(c2,r0);

executable take_image(r0,w3,o0,c2,m1) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m1),visible_from(o0,w3);
take_image(r0,w3,o0,c2,m1) causes have_image(r0,o0,m1),-calibrated(c2,r0);

executable take_image(r0,w3,o0,c2,m2) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m2),visible_from(o0,w3);
take_image(r0,w3,o0,c2,m2) causes have_image(r0,o0,m2),-calibrated(c2,r0);

executable take_image(r0,w3,o1,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o1,w3);
take_image(r0,w3,o1,c0,m0) causes have_image(r0,o1,m0),-calibrated(c0,r0);

executable take_image(r0,w3,o1,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o1,w3);
take_image(r0,w3,o1,c0,m1) causes have_image(r0,o1,m1),-calibrated(c0,r0);

executable take_image(r0,w3,o1,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o1,w3);
take_image(r0,w3,o1,c0,m2) causes have_image(r0,o1,m2),-calibrated(c0,r0);

executable take_image(r0,w3,o1,c1,m0) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m0),visible_from(o1,w3);
take_image(r0,w3,o1,c1,m0) causes have_image(r0,o1,m0),-calibrated(c1,r0);

executable take_image(r0,w3,o1,c1,m1) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m1),visible_from(o1,w3);
take_image(r0,w3,o1,c1,m1) causes have_image(r0,o1,m1),-calibrated(c1,r0);

executable take_image(r0,w3,o1,c1,m2) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m2),visible_from(o1,w3);
take_image(r0,w3,o1,c1,m2) causes have_image(r0,o1,m2),-calibrated(c1,r0);

executable take_image(r0,w3,o1,c2,m0) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m0),visible_from(o1,w3);
take_image(r0,w3,o1,c2,m0) causes have_image(r0,o1,m0),-calibrated(c2,r0);

executable take_image(r0,w3,o1,c2,m1) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m1),visible_from(o1,w3);
take_image(r0,w3,o1,c2,m1) causes have_image(r0,o1,m1),-calibrated(c2,r0);

executable take_image(r0,w3,o1,c2,m2) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m2),visible_from(o1,w3);
take_image(r0,w3,o1,c2,m2) causes have_image(r0,o1,m2),-calibrated(c2,r0);

executable take_image(r0,w3,o2,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o2,w3);
take_image(r0,w3,o2,c0,m0) causes have_image(r0,o2,m0),-calibrated(c0,r0);

executable take_image(r0,w3,o2,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o2,w3);
take_image(r0,w3,o2,c0,m1) causes have_image(r0,o2,m1),-calibrated(c0,r0);

executable take_image(r0,w3,o2,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o2,w3);
take_image(r0,w3,o2,c0,m2) causes have_image(r0,o2,m2),-calibrated(c0,r0);

executable take_image(r0,w3,o2,c1,m0) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m0),visible_from(o2,w3);
take_image(r0,w3,o2,c1,m0) causes have_image(r0,o2,m0),-calibrated(c1,r0);

executable take_image(r0,w3,o2,c1,m1) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m1),visible_from(o2,w3);
take_image(r0,w3,o2,c1,m1) causes have_image(r0,o2,m1),-calibrated(c1,r0);

executable take_image(r0,w3,o2,c1,m2) if calibrated(c1,r0),on_board(c1,r0), equipped_for_imaging(r0),supports(c1,m2),visible_from(o2,w3);
take_image(r0,w3,o2,c1,m2) causes have_image(r0,o2,m2),-calibrated(c1,r0);

executable take_image(r0,w3,o2,c2,m0) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m0),visible_from(o2,w3);
take_image(r0,w3,o2,c2,m0) causes have_image(r0,o2,m0),-calibrated(c2,r0);

executable take_image(r0,w3,o2,c2,m1) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m1),visible_from(o2,w3);
take_image(r0,w3,o2,c2,m1) causes have_image(r0,o2,m1),-calibrated(c2,r0);

executable take_image(r0,w3,o2,c2,m2) if calibrated(c2,r0),on_board(c2,r0), equipped_for_imaging(r0),supports(c2,m2),visible_from(o2,w3);
take_image(r0,w3,o2,c2,m2) causes have_image(r0,o2,m2),-calibrated(c2,r0);

executable take_image(r1,w0,o0,c0,m0) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m0),visible_from(o0,w0);
take_image(r1,w0,o0,c0,m0) causes have_image(r1,o0,m0),-calibrated(c0,r1);

executable take_image(r1,w0,o0,c0,m1) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m1),visible_from(o0,w0);
take_image(r1,w0,o0,c0,m1) causes have_image(r1,o0,m1),-calibrated(c0,r1);

executable take_image(r1,w0,o0,c0,m2) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m2),visible_from(o0,w0);
take_image(r1,w0,o0,c0,m2) causes have_image(r1,o0,m2),-calibrated(c0,r1);

executable take_image(r1,w0,o0,c1,m0) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m0),visible_from(o0,w0);
take_image(r1,w0,o0,c1,m0) causes have_image(r1,o0,m0),-calibrated(c1,r1);

executable take_image(r1,w0,o0,c1,m1) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m1),visible_from(o0,w0);
take_image(r1,w0,o0,c1,m1) causes have_image(r1,o0,m1),-calibrated(c1,r1);

executable take_image(r1,w0,o0,c1,m2) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m2),visible_from(o0,w0);
take_image(r1,w0,o0,c1,m2) causes have_image(r1,o0,m2),-calibrated(c1,r1);

executable take_image(r1,w0,o0,c2,m0) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m0),visible_from(o0,w0);
take_image(r1,w0,o0,c2,m0) causes have_image(r1,o0,m0),-calibrated(c2,r1);

executable take_image(r1,w0,o0,c2,m1) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m1),visible_from(o0,w0);
take_image(r1,w0,o0,c2,m1) causes have_image(r1,o0,m1),-calibrated(c2,r1);

executable take_image(r1,w0,o0,c2,m2) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m2),visible_from(o0,w0);
take_image(r1,w0,o0,c2,m2) causes have_image(r1,o0,m2),-calibrated(c2,r1);

executable take_image(r1,w0,o1,c0,m0) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m0),visible_from(o1,w0);
take_image(r1,w0,o1,c0,m0) causes have_image(r1,o1,m0),-calibrated(c0,r1);

executable take_image(r1,w0,o1,c0,m1) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m1),visible_from(o1,w0);
take_image(r1,w0,o1,c0,m1) causes have_image(r1,o1,m1),-calibrated(c0,r1);

executable take_image(r1,w0,o1,c0,m2) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m2),visible_from(o1,w0);
take_image(r1,w0,o1,c0,m2) causes have_image(r1,o1,m2),-calibrated(c0,r1);

executable take_image(r1,w0,o1,c1,m0) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m0),visible_from(o1,w0);
take_image(r1,w0,o1,c1,m0) causes have_image(r1,o1,m0),-calibrated(c1,r1);

executable take_image(r1,w0,o1,c1,m1) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m1),visible_from(o1,w0);
take_image(r1,w0,o1,c1,m1) causes have_image(r1,o1,m1),-calibrated(c1,r1);

executable take_image(r1,w0,o1,c1,m2) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m2),visible_from(o1,w0);
take_image(r1,w0,o1,c1,m2) causes have_image(r1,o1,m2),-calibrated(c1,r1);

executable take_image(r1,w0,o1,c2,m0) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m0),visible_from(o1,w0);
take_image(r1,w0,o1,c2,m0) causes have_image(r1,o1,m0),-calibrated(c2,r1);

executable take_image(r1,w0,o1,c2,m1) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m1),visible_from(o1,w0);
take_image(r1,w0,o1,c2,m1) causes have_image(r1,o1,m1),-calibrated(c2,r1);

executable take_image(r1,w0,o1,c2,m2) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m2),visible_from(o1,w0);
take_image(r1,w0,o1,c2,m2) causes have_image(r1,o1,m2),-calibrated(c2,r1);

executable take_image(r1,w0,o2,c0,m0) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m0),visible_from(o2,w0);
take_image(r1,w0,o2,c0,m0) causes have_image(r1,o2,m0),-calibrated(c0,r1);

executable take_image(r1,w0,o2,c0,m1) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m1),visible_from(o2,w0);
take_image(r1,w0,o2,c0,m1) causes have_image(r1,o2,m1),-calibrated(c0,r1);

executable take_image(r1,w0,o2,c0,m2) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m2),visible_from(o2,w0);
take_image(r1,w0,o2,c0,m2) causes have_image(r1,o2,m2),-calibrated(c0,r1);

executable take_image(r1,w0,o2,c1,m0) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m0),visible_from(o2,w0);
take_image(r1,w0,o2,c1,m0) causes have_image(r1,o2,m0),-calibrated(c1,r1);

executable take_image(r1,w0,o2,c1,m1) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m1),visible_from(o2,w0);
take_image(r1,w0,o2,c1,m1) causes have_image(r1,o2,m1),-calibrated(c1,r1);

executable take_image(r1,w0,o2,c1,m2) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m2),visible_from(o2,w0);
take_image(r1,w0,o2,c1,m2) causes have_image(r1,o2,m2),-calibrated(c1,r1);

executable take_image(r1,w0,o2,c2,m0) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m0),visible_from(o2,w0);
take_image(r1,w0,o2,c2,m0) causes have_image(r1,o2,m0),-calibrated(c2,r1);

executable take_image(r1,w0,o2,c2,m1) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m1),visible_from(o2,w0);
take_image(r1,w0,o2,c2,m1) causes have_image(r1,o2,m1),-calibrated(c2,r1);

executable take_image(r1,w0,o2,c2,m2) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m2),visible_from(o2,w0);
take_image(r1,w0,o2,c2,m2) causes have_image(r1,o2,m2),-calibrated(c2,r1);

executable take_image(r1,w1,o0,c0,m0) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m0),visible_from(o0,w1);
take_image(r1,w1,o0,c0,m0) causes have_image(r1,o0,m0),-calibrated(c0,r1);

executable take_image(r1,w1,o0,c0,m1) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m1),visible_from(o0,w1);
take_image(r1,w1,o0,c0,m1) causes have_image(r1,o0,m1),-calibrated(c0,r1);

executable take_image(r1,w1,o0,c0,m2) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m2),visible_from(o0,w1);
take_image(r1,w1,o0,c0,m2) causes have_image(r1,o0,m2),-calibrated(c0,r1);

executable take_image(r1,w1,o0,c1,m0) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m0),visible_from(o0,w1);
take_image(r1,w1,o0,c1,m0) causes have_image(r1,o0,m0),-calibrated(c1,r1);

executable take_image(r1,w1,o0,c1,m1) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m1),visible_from(o0,w1);
take_image(r1,w1,o0,c1,m1) causes have_image(r1,o0,m1),-calibrated(c1,r1);

executable take_image(r1,w1,o0,c1,m2) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m2),visible_from(o0,w1);
take_image(r1,w1,o0,c1,m2) causes have_image(r1,o0,m2),-calibrated(c1,r1);

executable take_image(r1,w1,o0,c2,m0) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m0),visible_from(o0,w1);
take_image(r1,w1,o0,c2,m0) causes have_image(r1,o0,m0),-calibrated(c2,r1);

executable take_image(r1,w1,o0,c2,m1) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m1),visible_from(o0,w1);
take_image(r1,w1,o0,c2,m1) causes have_image(r1,o0,m1),-calibrated(c2,r1);

executable take_image(r1,w1,o0,c2,m2) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m2),visible_from(o0,w1);
take_image(r1,w1,o0,c2,m2) causes have_image(r1,o0,m2),-calibrated(c2,r1);

executable take_image(r1,w1,o1,c0,m0) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m0),visible_from(o1,w1);
take_image(r1,w1,o1,c0,m0) causes have_image(r1,o1,m0),-calibrated(c0,r1);

executable take_image(r1,w1,o1,c0,m1) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m1),visible_from(o1,w1);
take_image(r1,w1,o1,c0,m1) causes have_image(r1,o1,m1),-calibrated(c0,r1);

executable take_image(r1,w1,o1,c0,m2) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m2),visible_from(o1,w1);
take_image(r1,w1,o1,c0,m2) causes have_image(r1,o1,m2),-calibrated(c0,r1);

executable take_image(r1,w1,o1,c1,m0) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m0),visible_from(o1,w1);
take_image(r1,w1,o1,c1,m0) causes have_image(r1,o1,m0),-calibrated(c1,r1);

executable take_image(r1,w1,o1,c1,m1) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m1),visible_from(o1,w1);
take_image(r1,w1,o1,c1,m1) causes have_image(r1,o1,m1),-calibrated(c1,r1);

executable take_image(r1,w1,o1,c1,m2) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m2),visible_from(o1,w1);
take_image(r1,w1,o1,c1,m2) causes have_image(r1,o1,m2),-calibrated(c1,r1);

executable take_image(r1,w1,o1,c2,m0) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m0),visible_from(o1,w1);
take_image(r1,w1,o1,c2,m0) causes have_image(r1,o1,m0),-calibrated(c2,r1);

executable take_image(r1,w1,o1,c2,m1) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m1),visible_from(o1,w1);
take_image(r1,w1,o1,c2,m1) causes have_image(r1,o1,m1),-calibrated(c2,r1);

executable take_image(r1,w1,o1,c2,m2) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m2),visible_from(o1,w1);
take_image(r1,w1,o1,c2,m2) causes have_image(r1,o1,m2),-calibrated(c2,r1);

executable take_image(r1,w1,o2,c0,m0) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m0),visible_from(o2,w1);
take_image(r1,w1,o2,c0,m0) causes have_image(r1,o2,m0),-calibrated(c0,r1);

executable take_image(r1,w1,o2,c0,m1) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m1),visible_from(o2,w1);
take_image(r1,w1,o2,c0,m1) causes have_image(r1,o2,m1),-calibrated(c0,r1);

executable take_image(r1,w1,o2,c0,m2) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m2),visible_from(o2,w1);
take_image(r1,w1,o2,c0,m2) causes have_image(r1,o2,m2),-calibrated(c0,r1);

executable take_image(r1,w1,o2,c1,m0) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m0),visible_from(o2,w1);
take_image(r1,w1,o2,c1,m0) causes have_image(r1,o2,m0),-calibrated(c1,r1);

executable take_image(r1,w1,o2,c1,m1) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m1),visible_from(o2,w1);
take_image(r1,w1,o2,c1,m1) causes have_image(r1,o2,m1),-calibrated(c1,r1);

executable take_image(r1,w1,o2,c1,m2) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m2),visible_from(o2,w1);
take_image(r1,w1,o2,c1,m2) causes have_image(r1,o2,m2),-calibrated(c1,r1);

executable take_image(r1,w1,o2,c2,m0) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m0),visible_from(o2,w1);
take_image(r1,w1,o2,c2,m0) causes have_image(r1,o2,m0),-calibrated(c2,r1);

executable take_image(r1,w1,o2,c2,m1) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m1),visible_from(o2,w1);
take_image(r1,w1,o2,c2,m1) causes have_image(r1,o2,m1),-calibrated(c2,r1);

executable take_image(r1,w1,o2,c2,m2) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m2),visible_from(o2,w1);
take_image(r1,w1,o2,c2,m2) causes have_image(r1,o2,m2),-calibrated(c2,r1);

executable take_image(r1,w2,o0,c0,m0) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m0),visible_from(o0,w2);
take_image(r1,w2,o0,c0,m0) causes have_image(r1,o0,m0),-calibrated(c0,r1);

executable take_image(r1,w2,o0,c0,m1) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m1),visible_from(o0,w2);
take_image(r1,w2,o0,c0,m1) causes have_image(r1,o0,m1),-calibrated(c0,r1);

executable take_image(r1,w2,o0,c0,m2) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m2),visible_from(o0,w2);
take_image(r1,w2,o0,c0,m2) causes have_image(r1,o0,m2),-calibrated(c0,r1);

executable take_image(r1,w2,o0,c1,m0) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m0),visible_from(o0,w2);
take_image(r1,w2,o0,c1,m0) causes have_image(r1,o0,m0),-calibrated(c1,r1);

executable take_image(r1,w2,o0,c1,m1) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m1),visible_from(o0,w2);
take_image(r1,w2,o0,c1,m1) causes have_image(r1,o0,m1),-calibrated(c1,r1);

executable take_image(r1,w2,o0,c1,m2) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m2),visible_from(o0,w2);
take_image(r1,w2,o0,c1,m2) causes have_image(r1,o0,m2),-calibrated(c1,r1);

executable take_image(r1,w2,o0,c2,m0) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m0),visible_from(o0,w2);
take_image(r1,w2,o0,c2,m0) causes have_image(r1,o0,m0),-calibrated(c2,r1);

executable take_image(r1,w2,o0,c2,m1) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m1),visible_from(o0,w2);
take_image(r1,w2,o0,c2,m1) causes have_image(r1,o0,m1),-calibrated(c2,r1);

executable take_image(r1,w2,o0,c2,m2) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m2),visible_from(o0,w2);
take_image(r1,w2,o0,c2,m2) causes have_image(r1,o0,m2),-calibrated(c2,r1);

executable take_image(r1,w2,o1,c0,m0) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m0),visible_from(o1,w2);
take_image(r1,w2,o1,c0,m0) causes have_image(r1,o1,m0),-calibrated(c0,r1);

executable take_image(r1,w2,o1,c0,m1) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m1),visible_from(o1,w2);
take_image(r1,w2,o1,c0,m1) causes have_image(r1,o1,m1),-calibrated(c0,r1);

executable take_image(r1,w2,o1,c0,m2) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m2),visible_from(o1,w2);
take_image(r1,w2,o1,c0,m2) causes have_image(r1,o1,m2),-calibrated(c0,r1);

executable take_image(r1,w2,o1,c1,m0) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m0),visible_from(o1,w2);
take_image(r1,w2,o1,c1,m0) causes have_image(r1,o1,m0),-calibrated(c1,r1);

executable take_image(r1,w2,o1,c1,m1) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m1),visible_from(o1,w2);
take_image(r1,w2,o1,c1,m1) causes have_image(r1,o1,m1),-calibrated(c1,r1);

executable take_image(r1,w2,o1,c1,m2) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m2),visible_from(o1,w2);
take_image(r1,w2,o1,c1,m2) causes have_image(r1,o1,m2),-calibrated(c1,r1);

executable take_image(r1,w2,o1,c2,m0) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m0),visible_from(o1,w2);
take_image(r1,w2,o1,c2,m0) causes have_image(r1,o1,m0),-calibrated(c2,r1);

executable take_image(r1,w2,o1,c2,m1) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m1),visible_from(o1,w2);
take_image(r1,w2,o1,c2,m1) causes have_image(r1,o1,m1),-calibrated(c2,r1);

executable take_image(r1,w2,o1,c2,m2) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m2),visible_from(o1,w2);
take_image(r1,w2,o1,c2,m2) causes have_image(r1,o1,m2),-calibrated(c2,r1);

executable take_image(r1,w2,o2,c0,m0) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m0),visible_from(o2,w2);
take_image(r1,w2,o2,c0,m0) causes have_image(r1,o2,m0),-calibrated(c0,r1);

executable take_image(r1,w2,o2,c0,m1) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m1),visible_from(o2,w2);
take_image(r1,w2,o2,c0,m1) causes have_image(r1,o2,m1),-calibrated(c0,r1);

executable take_image(r1,w2,o2,c0,m2) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m2),visible_from(o2,w2);
take_image(r1,w2,o2,c0,m2) causes have_image(r1,o2,m2),-calibrated(c0,r1);

executable take_image(r1,w2,o2,c1,m0) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m0),visible_from(o2,w2);
take_image(r1,w2,o2,c1,m0) causes have_image(r1,o2,m0),-calibrated(c1,r1);

executable take_image(r1,w2,o2,c1,m1) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m1),visible_from(o2,w2);
take_image(r1,w2,o2,c1,m1) causes have_image(r1,o2,m1),-calibrated(c1,r1);

executable take_image(r1,w2,o2,c1,m2) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m2),visible_from(o2,w2);
take_image(r1,w2,o2,c1,m2) causes have_image(r1,o2,m2),-calibrated(c1,r1);

executable take_image(r1,w2,o2,c2,m0) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m0),visible_from(o2,w2);
take_image(r1,w2,o2,c2,m0) causes have_image(r1,o2,m0),-calibrated(c2,r1);

executable take_image(r1,w2,o2,c2,m1) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m1),visible_from(o2,w2);
take_image(r1,w2,o2,c2,m1) causes have_image(r1,o2,m1),-calibrated(c2,r1);

executable take_image(r1,w2,o2,c2,m2) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m2),visible_from(o2,w2);
take_image(r1,w2,o2,c2,m2) causes have_image(r1,o2,m2),-calibrated(c2,r1);

executable take_image(r1,w3,o0,c0,m0) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m0),visible_from(o0,w3);
take_image(r1,w3,o0,c0,m0) causes have_image(r1,o0,m0),-calibrated(c0,r1);

executable take_image(r1,w3,o0,c0,m1) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m1),visible_from(o0,w3);
take_image(r1,w3,o0,c0,m1) causes have_image(r1,o0,m1),-calibrated(c0,r1);

executable take_image(r1,w3,o0,c0,m2) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m2),visible_from(o0,w3);
take_image(r1,w3,o0,c0,m2) causes have_image(r1,o0,m2),-calibrated(c0,r1);

executable take_image(r1,w3,o0,c1,m0) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m0),visible_from(o0,w3);
take_image(r1,w3,o0,c1,m0) causes have_image(r1,o0,m0),-calibrated(c1,r1);

executable take_image(r1,w3,o0,c1,m1) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m1),visible_from(o0,w3);
take_image(r1,w3,o0,c1,m1) causes have_image(r1,o0,m1),-calibrated(c1,r1);

executable take_image(r1,w3,o0,c1,m2) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m2),visible_from(o0,w3);
take_image(r1,w3,o0,c1,m2) causes have_image(r1,o0,m2),-calibrated(c1,r1);

executable take_image(r1,w3,o0,c2,m0) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m0),visible_from(o0,w3);
take_image(r1,w3,o0,c2,m0) causes have_image(r1,o0,m0),-calibrated(c2,r1);

executable take_image(r1,w3,o0,c2,m1) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m1),visible_from(o0,w3);
take_image(r1,w3,o0,c2,m1) causes have_image(r1,o0,m1),-calibrated(c2,r1);

executable take_image(r1,w3,o0,c2,m2) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m2),visible_from(o0,w3);
take_image(r1,w3,o0,c2,m2) causes have_image(r1,o0,m2),-calibrated(c2,r1);

executable take_image(r1,w3,o1,c0,m0) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m0),visible_from(o1,w3);
take_image(r1,w3,o1,c0,m0) causes have_image(r1,o1,m0),-calibrated(c0,r1);

executable take_image(r1,w3,o1,c0,m1) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m1),visible_from(o1,w3);
take_image(r1,w3,o1,c0,m1) causes have_image(r1,o1,m1),-calibrated(c0,r1);

executable take_image(r1,w3,o1,c0,m2) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m2),visible_from(o1,w3);
take_image(r1,w3,o1,c0,m2) causes have_image(r1,o1,m2),-calibrated(c0,r1);

executable take_image(r1,w3,o1,c1,m0) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m0),visible_from(o1,w3);
take_image(r1,w3,o1,c1,m0) causes have_image(r1,o1,m0),-calibrated(c1,r1);

executable take_image(r1,w3,o1,c1,m1) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m1),visible_from(o1,w3);
take_image(r1,w3,o1,c1,m1) causes have_image(r1,o1,m1),-calibrated(c1,r1);

executable take_image(r1,w3,o1,c1,m2) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m2),visible_from(o1,w3);
take_image(r1,w3,o1,c1,m2) causes have_image(r1,o1,m2),-calibrated(c1,r1);

executable take_image(r1,w3,o1,c2,m0) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m0),visible_from(o1,w3);
take_image(r1,w3,o1,c2,m0) causes have_image(r1,o1,m0),-calibrated(c2,r1);

executable take_image(r1,w3,o1,c2,m1) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m1),visible_from(o1,w3);
take_image(r1,w3,o1,c2,m1) causes have_image(r1,o1,m1),-calibrated(c2,r1);

executable take_image(r1,w3,o1,c2,m2) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m2),visible_from(o1,w3);
take_image(r1,w3,o1,c2,m2) causes have_image(r1,o1,m2),-calibrated(c2,r1);

executable take_image(r1,w3,o2,c0,m0) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m0),visible_from(o2,w3);
take_image(r1,w3,o2,c0,m0) causes have_image(r1,o2,m0),-calibrated(c0,r1);

executable take_image(r1,w3,o2,c0,m1) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m1),visible_from(o2,w3);
take_image(r1,w3,o2,c0,m1) causes have_image(r1,o2,m1),-calibrated(c0,r1);

executable take_image(r1,w3,o2,c0,m2) if calibrated(c0,r1),on_board(c0,r1), equipped_for_imaging(r1),supports(c0,m2),visible_from(o2,w3);
take_image(r1,w3,o2,c0,m2) causes have_image(r1,o2,m2),-calibrated(c0,r1);

executable take_image(r1,w3,o2,c1,m0) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m0),visible_from(o2,w3);
take_image(r1,w3,o2,c1,m0) causes have_image(r1,o2,m0),-calibrated(c1,r1);

executable take_image(r1,w3,o2,c1,m1) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m1),visible_from(o2,w3);
take_image(r1,w3,o2,c1,m1) causes have_image(r1,o2,m1),-calibrated(c1,r1);

executable take_image(r1,w3,o2,c1,m2) if calibrated(c1,r1),on_board(c1,r1), equipped_for_imaging(r1),supports(c1,m2),visible_from(o2,w3);
take_image(r1,w3,o2,c1,m2) causes have_image(r1,o2,m2),-calibrated(c1,r1);

executable take_image(r1,w3,o2,c2,m0) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m0),visible_from(o2,w3);
take_image(r1,w3,o2,c2,m0) causes have_image(r1,o2,m0),-calibrated(c2,r1);

executable take_image(r1,w3,o2,c2,m1) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m1),visible_from(o2,w3);
take_image(r1,w3,o2,c2,m1) causes have_image(r1,o2,m1),-calibrated(c2,r1);

executable take_image(r1,w3,o2,c2,m2) if calibrated(c2,r1),on_board(c2,r1), equipped_for_imaging(r1),supports(c2,m2),visible_from(o2,w3);
take_image(r1,w3,o2,c2,m2) causes have_image(r1,o2,m2),-calibrated(c2,r1);


take_image(r1,w3,o2,c2,m2) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w0,w1) if at(r0,w0),at_lander(l0,w1),have_soil_analysis(r0,w0),visible(w0,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w0,w1) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w0,w2) if at(r0,w0),at_lander(l0,w2),have_soil_analysis(r0,w0),visible(w0,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w0,w2) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w0,w3) if at(r0,w0),at_lander(l0,w3),have_soil_analysis(r0,w0),visible(w0,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w0,w3) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w1,w0) if at(r0,w1),at_lander(l0,w0),have_soil_analysis(r0,w0),visible(w1,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w1,w0) causes channel_free(l0),communicated_soil_data(w0), available(r0);

communicate_soil_data(r0,l0,w0,w1,w0) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w1,w2) if at(r0,w1),at_lander(l0,w2),have_soil_analysis(r0,w0),visible(w1,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w1,w2) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w1,w3) if at(r0,w1),at_lander(l0,w3),have_soil_analysis(r0,w0),visible(w1,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w1,w3) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w2,w0) if at(r0,w2),at_lander(l0,w0),have_soil_analysis(r0,w0),visible(w2,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w2,w0) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w2,w1) if at(r0,w2),at_lander(l0,w1),have_soil_analysis(r0,w0),visible(w2,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w2,w1) causes channel_free(l0),communicated_soil_data(w0), available(r0);

communicate_soil_data(r0,l0,w0,w2,w1) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w2,w3) if at(r0,w2),at_lander(l0,w3),have_soil_analysis(r0,w0),visible(w2,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w2,w3) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w3,w0) if at(r0,w3),at_lander(l0,w0),have_soil_analysis(r0,w0),visible(w3,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w3,w0) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w3,w1) if at(r0,w3),at_lander(l0,w1),have_soil_analysis(r0,w0),visible(w3,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w3,w1) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w3,w2) if at(r0,w3),at_lander(l0,w2),have_soil_analysis(r0,w0),visible(w3,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w3,w2) causes channel_free(l0),communicated_soil_data(w0), available(r0);

communicate_soil_data(r0,l0,w0,w3,w2) causes channel_free(l0),communicated_soil_data(w0), available(r0);

communicate_soil_data(r0,l0,w0,w3,w2) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w0,w1) if at(r0,w0),at_lander(l0,w1),have_soil_analysis(r0,w1),visible(w0,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w0,w1) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w0,w2) if at(r0,w0),at_lander(l0,w2),have_soil_analysis(r0,w1),visible(w0,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w0,w2) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w0,w3) if at(r0,w0),at_lander(l0,w3),have_soil_analysis(r0,w1),visible(w0,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w0,w3) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w1,w0) if at(r0,w1),at_lander(l0,w0),have_soil_analysis(r0,w1),visible(w1,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w1,w0) causes channel_free(l0),communicated_soil_data(w1), available(r0);

communicate_soil_data(r0,l0,w1,w1,w0) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w1,w2) if at(r0,w1),at_lander(l0,w2),have_soil_analysis(r0,w1),visible(w1,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w1,w2) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w1,w3) if at(r0,w1),at_lander(l0,w3),have_soil_analysis(r0,w1),visible(w1,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w1,w3) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w2,w0) if at(r0,w2),at_lander(l0,w0),have_soil_analysis(r0,w1),visible(w2,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w2,w0) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w2,w1) if at(r0,w2),at_lander(l0,w1),have_soil_analysis(r0,w1),visible(w2,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w2,w1) causes channel_free(l0),communicated_soil_data(w1), available(r0);

communicate_soil_data(r0,l0,w1,w2,w1) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w2,w3) if at(r0,w2),at_lander(l0,w3),have_soil_analysis(r0,w1),visible(w2,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w2,w3) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w3,w0) if at(r0,w3),at_lander(l0,w0),have_soil_analysis(r0,w1),visible(w3,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w3,w0) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w3,w1) if at(r0,w3),at_lander(l0,w1),have_soil_analysis(r0,w1),visible(w3,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w3,w1) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w3,w2) if at(r0,w3),at_lander(l0,w2),have_soil_analysis(r0,w1),visible(w3,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w3,w2) causes channel_free(l0),communicated_soil_data(w1), available(r0);

communicate_soil_data(r0,l0,w1,w3,w2) causes channel_free(l0),communicated_soil_data(w1), available(r0);

communicate_soil_data(r0,l0,w1,w3,w2) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w0,w1) if at(r0,w0),at_lander(l0,w1),have_soil_analysis(r0,w2),visible(w0,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w0,w1) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w0,w2) if at(r0,w0),at_lander(l0,w2),have_soil_analysis(r0,w2),visible(w0,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w0,w2) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w0,w3) if at(r0,w0),at_lander(l0,w3),have_soil_analysis(r0,w2),visible(w0,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w0,w3) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w1,w0) if at(r0,w1),at_lander(l0,w0),have_soil_analysis(r0,w2),visible(w1,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w1,w0) causes channel_free(l0),communicated_soil_data(w2), available(r0);

communicate_soil_data(r0,l0,w2,w1,w0) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w1,w2) if at(r0,w1),at_lander(l0,w2),have_soil_analysis(r0,w2),visible(w1,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w1,w2) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w1,w3) if at(r0,w1),at_lander(l0,w3),have_soil_analysis(r0,w2),visible(w1,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w1,w3) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w2,w0) if at(r0,w2),at_lander(l0,w0),have_soil_analysis(r0,w2),visible(w2,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w2,w0) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w2,w1) if at(r0,w2),at_lander(l0,w1),have_soil_analysis(r0,w2),visible(w2,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w2,w1) causes channel_free(l0),communicated_soil_data(w2), available(r0);

communicate_soil_data(r0,l0,w2,w2,w1) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w2,w3) if at(r0,w2),at_lander(l0,w3),have_soil_analysis(r0,w2),visible(w2,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w2,w3) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w3,w0) if at(r0,w3),at_lander(l0,w0),have_soil_analysis(r0,w2),visible(w3,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w3,w0) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w3,w1) if at(r0,w3),at_lander(l0,w1),have_soil_analysis(r0,w2),visible(w3,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w3,w1) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w3,w2) if at(r0,w3),at_lander(l0,w2),have_soil_analysis(r0,w2),visible(w3,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w3,w2) causes channel_free(l0),communicated_soil_data(w2), available(r0);

communicate_soil_data(r0,l0,w2,w3,w2) causes channel_free(l0),communicated_soil_data(w2), available(r0);

communicate_soil_data(r0,l0,w2,w3,w2) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w0,w1) if at(r0,w0),at_lander(l0,w1),have_soil_analysis(r0,w3),visible(w0,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w0,w1) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w0,w2) if at(r0,w0),at_lander(l0,w2),have_soil_analysis(r0,w3),visible(w0,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w0,w2) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w0,w3) if at(r0,w0),at_lander(l0,w3),have_soil_analysis(r0,w3),visible(w0,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w0,w3) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w1,w0) if at(r0,w1),at_lander(l0,w0),have_soil_analysis(r0,w3),visible(w1,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w1,w0) causes channel_free(l0),communicated_soil_data(w3), available(r0);

communicate_soil_data(r0,l0,w3,w1,w0) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w1,w2) if at(r0,w1),at_lander(l0,w2),have_soil_analysis(r0,w3),visible(w1,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w1,w2) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w1,w3) if at(r0,w1),at_lander(l0,w3),have_soil_analysis(r0,w3),visible(w1,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w1,w3) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w2,w0) if at(r0,w2),at_lander(l0,w0),have_soil_analysis(r0,w3),visible(w2,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w2,w0) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w2,w1) if at(r0,w2),at_lander(l0,w1),have_soil_analysis(r0,w3),visible(w2,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w2,w1) causes channel_free(l0),communicated_soil_data(w3), available(r0);

communicate_soil_data(r0,l0,w3,w2,w1) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w2,w3) if at(r0,w2),at_lander(l0,w3),have_soil_analysis(r0,w3),visible(w2,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w2,w3) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w3,w0) if at(r0,w3),at_lander(l0,w0),have_soil_analysis(r0,w3),visible(w3,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w3,w0) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w3,w1) if at(r0,w3),at_lander(l0,w1),have_soil_analysis(r0,w3),visible(w3,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w3,w1) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w3,w2) if at(r0,w3),at_lander(l0,w2),have_soil_analysis(r0,w3),visible(w3,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w3,w2) causes channel_free(l0),communicated_soil_data(w3), available(r0);

communicate_soil_data(r0,l0,w3,w3,w2) causes channel_free(l0),communicated_soil_data(w3), available(r0);

communicate_soil_data(r0,l0,w3,w3,w2) causes channel_free(l0),communicated_soil_data(w0), available(r1);

executable communicate_soil_data(r1,l0,w0,w0,w1) if at(r1,w0),at_lander(l0,w1),have_soil_analysis(r1,w0),visible(w0,w1),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w0,w0,w1) causes channel_free(l0),communicated_soil_data(w0), available(r1);

executable communicate_soil_data(r1,l0,w0,w0,w2) if at(r1,w0),at_lander(l0,w2),have_soil_analysis(r1,w0),visible(w0,w2),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w0,w0,w2) causes channel_free(l0),communicated_soil_data(w0), available(r1);

executable communicate_soil_data(r1,l0,w0,w0,w3) if at(r1,w0),at_lander(l0,w3),have_soil_analysis(r1,w0),visible(w0,w3),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w0,w0,w3) causes channel_free(l0),communicated_soil_data(w0), available(r1);

executable communicate_soil_data(r1,l0,w0,w1,w0) if at(r1,w1),at_lander(l0,w0),have_soil_analysis(r1,w0),visible(w1,w0),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w0,w1,w0) causes channel_free(l0),communicated_soil_data(w0), available(r1);

communicate_soil_data(r1,l0,w0,w1,w0) causes channel_free(l0),communicated_soil_data(w0), available(r1);

executable communicate_soil_data(r1,l0,w0,w1,w2) if at(r1,w1),at_lander(l0,w2),have_soil_analysis(r1,w0),visible(w1,w2),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w0,w1,w2) causes channel_free(l0),communicated_soil_data(w0), available(r1);

executable communicate_soil_data(r1,l0,w0,w1,w3) if at(r1,w1),at_lander(l0,w3),have_soil_analysis(r1,w0),visible(w1,w3),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w0,w1,w3) causes channel_free(l0),communicated_soil_data(w0), available(r1);

executable communicate_soil_data(r1,l0,w0,w2,w0) if at(r1,w2),at_lander(l0,w0),have_soil_analysis(r1,w0),visible(w2,w0),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w0,w2,w0) causes channel_free(l0),communicated_soil_data(w0), available(r1);

executable communicate_soil_data(r1,l0,w0,w2,w1) if at(r1,w2),at_lander(l0,w1),have_soil_analysis(r1,w0),visible(w2,w1),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w0,w2,w1) causes channel_free(l0),communicated_soil_data(w0), available(r1);

communicate_soil_data(r1,l0,w0,w2,w1) causes channel_free(l0),communicated_soil_data(w0), available(r1);

executable communicate_soil_data(r1,l0,w0,w2,w3) if at(r1,w2),at_lander(l0,w3),have_soil_analysis(r1,w0),visible(w2,w3),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w0,w2,w3) causes channel_free(l0),communicated_soil_data(w0), available(r1);

executable communicate_soil_data(r1,l0,w0,w3,w0) if at(r1,w3),at_lander(l0,w0),have_soil_analysis(r1,w0),visible(w3,w0),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w0,w3,w0) causes channel_free(l0),communicated_soil_data(w0), available(r1);

executable communicate_soil_data(r1,l0,w0,w3,w1) if at(r1,w3),at_lander(l0,w1),have_soil_analysis(r1,w0),visible(w3,w1),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w0,w3,w1) causes channel_free(l0),communicated_soil_data(w0), available(r1);

executable communicate_soil_data(r1,l0,w0,w3,w2) if at(r1,w3),at_lander(l0,w2),have_soil_analysis(r1,w0),visible(w3,w2),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w0,w3,w2) causes channel_free(l0),communicated_soil_data(w0), available(r1);

communicate_soil_data(r1,l0,w0,w3,w2) causes channel_free(l0),communicated_soil_data(w0), available(r1);

communicate_soil_data(r1,l0,w0,w3,w2) causes channel_free(l0),communicated_soil_data(w1), available(r1);

executable communicate_soil_data(r1,l0,w1,w0,w1) if at(r1,w0),at_lander(l0,w1),have_soil_analysis(r1,w1),visible(w0,w1),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w1,w0,w1) causes channel_free(l0),communicated_soil_data(w1), available(r1);

executable communicate_soil_data(r1,l0,w1,w0,w2) if at(r1,w0),at_lander(l0,w2),have_soil_analysis(r1,w1),visible(w0,w2),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w1,w0,w2) causes channel_free(l0),communicated_soil_data(w1), available(r1);

executable communicate_soil_data(r1,l0,w1,w0,w3) if at(r1,w0),at_lander(l0,w3),have_soil_analysis(r1,w1),visible(w0,w3),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w1,w0,w3) causes channel_free(l0),communicated_soil_data(w1), available(r1);

executable communicate_soil_data(r1,l0,w1,w1,w0) if at(r1,w1),at_lander(l0,w0),have_soil_analysis(r1,w1),visible(w1,w0),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w1,w1,w0) causes channel_free(l0),communicated_soil_data(w1), available(r1);

communicate_soil_data(r1,l0,w1,w1,w0) causes channel_free(l0),communicated_soil_data(w1), available(r1);

executable communicate_soil_data(r1,l0,w1,w1,w2) if at(r1,w1),at_lander(l0,w2),have_soil_analysis(r1,w1),visible(w1,w2),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w1,w1,w2) causes channel_free(l0),communicated_soil_data(w1), available(r1);

executable communicate_soil_data(r1,l0,w1,w1,w3) if at(r1,w1),at_lander(l0,w3),have_soil_analysis(r1,w1),visible(w1,w3),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w1,w1,w3) causes channel_free(l0),communicated_soil_data(w1), available(r1);

executable communicate_soil_data(r1,l0,w1,w2,w0) if at(r1,w2),at_lander(l0,w0),have_soil_analysis(r1,w1),visible(w2,w0),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w1,w2,w0) causes channel_free(l0),communicated_soil_data(w1), available(r1);

executable communicate_soil_data(r1,l0,w1,w2,w1) if at(r1,w2),at_lander(l0,w1),have_soil_analysis(r1,w1),visible(w2,w1),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w1,w2,w1) causes channel_free(l0),communicated_soil_data(w1), available(r1);

communicate_soil_data(r1,l0,w1,w2,w1) causes channel_free(l0),communicated_soil_data(w1), available(r1);

executable communicate_soil_data(r1,l0,w1,w2,w3) if at(r1,w2),at_lander(l0,w3),have_soil_analysis(r1,w1),visible(w2,w3),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w1,w2,w3) causes channel_free(l0),communicated_soil_data(w1), available(r1);

executable communicate_soil_data(r1,l0,w1,w3,w0) if at(r1,w3),at_lander(l0,w0),have_soil_analysis(r1,w1),visible(w3,w0),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w1,w3,w0) causes channel_free(l0),communicated_soil_data(w1), available(r1);

executable communicate_soil_data(r1,l0,w1,w3,w1) if at(r1,w3),at_lander(l0,w1),have_soil_analysis(r1,w1),visible(w3,w1),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w1,w3,w1) causes channel_free(l0),communicated_soil_data(w1), available(r1);

executable communicate_soil_data(r1,l0,w1,w3,w2) if at(r1,w3),at_lander(l0,w2),have_soil_analysis(r1,w1),visible(w3,w2),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w1,w3,w2) causes channel_free(l0),communicated_soil_data(w1), available(r1);

communicate_soil_data(r1,l0,w1,w3,w2) causes channel_free(l0),communicated_soil_data(w1), available(r1);

communicate_soil_data(r1,l0,w1,w3,w2) causes channel_free(l0),communicated_soil_data(w2), available(r1);

executable communicate_soil_data(r1,l0,w2,w0,w1) if at(r1,w0),at_lander(l0,w1),have_soil_analysis(r1,w2),visible(w0,w1),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w2,w0,w1) causes channel_free(l0),communicated_soil_data(w2), available(r1);

executable communicate_soil_data(r1,l0,w2,w0,w2) if at(r1,w0),at_lander(l0,w2),have_soil_analysis(r1,w2),visible(w0,w2),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w2,w0,w2) causes channel_free(l0),communicated_soil_data(w2), available(r1);

executable communicate_soil_data(r1,l0,w2,w0,w3) if at(r1,w0),at_lander(l0,w3),have_soil_analysis(r1,w2),visible(w0,w3),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w2,w0,w3) causes channel_free(l0),communicated_soil_data(w2), available(r1);

executable communicate_soil_data(r1,l0,w2,w1,w0) if at(r1,w1),at_lander(l0,w0),have_soil_analysis(r1,w2),visible(w1,w0),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w2,w1,w0) causes channel_free(l0),communicated_soil_data(w2), available(r1);

communicate_soil_data(r1,l0,w2,w1,w0) causes channel_free(l0),communicated_soil_data(w2), available(r1);

executable communicate_soil_data(r1,l0,w2,w1,w2) if at(r1,w1),at_lander(l0,w2),have_soil_analysis(r1,w2),visible(w1,w2),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w2,w1,w2) causes channel_free(l0),communicated_soil_data(w2), available(r1);

executable communicate_soil_data(r1,l0,w2,w1,w3) if at(r1,w1),at_lander(l0,w3),have_soil_analysis(r1,w2),visible(w1,w3),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w2,w1,w3) causes channel_free(l0),communicated_soil_data(w2), available(r1);

executable communicate_soil_data(r1,l0,w2,w2,w0) if at(r1,w2),at_lander(l0,w0),have_soil_analysis(r1,w2),visible(w2,w0),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w2,w2,w0) causes channel_free(l0),communicated_soil_data(w2), available(r1);

executable communicate_soil_data(r1,l0,w2,w2,w1) if at(r1,w2),at_lander(l0,w1),have_soil_analysis(r1,w2),visible(w2,w1),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w2,w2,w1) causes channel_free(l0),communicated_soil_data(w2), available(r1);

communicate_soil_data(r1,l0,w2,w2,w1) causes channel_free(l0),communicated_soil_data(w2), available(r1);

executable communicate_soil_data(r1,l0,w2,w2,w3) if at(r1,w2),at_lander(l0,w3),have_soil_analysis(r1,w2),visible(w2,w3),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w2,w2,w3) causes channel_free(l0),communicated_soil_data(w2), available(r1);

executable communicate_soil_data(r1,l0,w2,w3,w0) if at(r1,w3),at_lander(l0,w0),have_soil_analysis(r1,w2),visible(w3,w0),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w2,w3,w0) causes channel_free(l0),communicated_soil_data(w2), available(r1);

executable communicate_soil_data(r1,l0,w2,w3,w1) if at(r1,w3),at_lander(l0,w1),have_soil_analysis(r1,w2),visible(w3,w1),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w2,w3,w1) causes channel_free(l0),communicated_soil_data(w2), available(r1);

executable communicate_soil_data(r1,l0,w2,w3,w2) if at(r1,w3),at_lander(l0,w2),have_soil_analysis(r1,w2),visible(w3,w2),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w2,w3,w2) causes channel_free(l0),communicated_soil_data(w2), available(r1);

communicate_soil_data(r1,l0,w2,w3,w2) causes channel_free(l0),communicated_soil_data(w2), available(r1);

communicate_soil_data(r1,l0,w2,w3,w2) causes channel_free(l0),communicated_soil_data(w3), available(r1);

executable communicate_soil_data(r1,l0,w3,w0,w1) if at(r1,w0),at_lander(l0,w1),have_soil_analysis(r1,w3),visible(w0,w1),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w3,w0,w1) causes channel_free(l0),communicated_soil_data(w3), available(r1);

executable communicate_soil_data(r1,l0,w3,w0,w2) if at(r1,w0),at_lander(l0,w2),have_soil_analysis(r1,w3),visible(w0,w2),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w3,w0,w2) causes channel_free(l0),communicated_soil_data(w3), available(r1);

executable communicate_soil_data(r1,l0,w3,w0,w3) if at(r1,w0),at_lander(l0,w3),have_soil_analysis(r1,w3),visible(w0,w3),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w3,w0,w3) causes channel_free(l0),communicated_soil_data(w3), available(r1);

executable communicate_soil_data(r1,l0,w3,w1,w0) if at(r1,w1),at_lander(l0,w0),have_soil_analysis(r1,w3),visible(w1,w0),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w3,w1,w0) causes channel_free(l0),communicated_soil_data(w3), available(r1);

communicate_soil_data(r1,l0,w3,w1,w0) causes channel_free(l0),communicated_soil_data(w3), available(r1);

executable communicate_soil_data(r1,l0,w3,w1,w2) if at(r1,w1),at_lander(l0,w2),have_soil_analysis(r1,w3),visible(w1,w2),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w3,w1,w2) causes channel_free(l0),communicated_soil_data(w3), available(r1);

executable communicate_soil_data(r1,l0,w3,w1,w3) if at(r1,w1),at_lander(l0,w3),have_soil_analysis(r1,w3),visible(w1,w3),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w3,w1,w3) causes channel_free(l0),communicated_soil_data(w3), available(r1);

executable communicate_soil_data(r1,l0,w3,w2,w0) if at(r1,w2),at_lander(l0,w0),have_soil_analysis(r1,w3),visible(w2,w0),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w3,w2,w0) causes channel_free(l0),communicated_soil_data(w3), available(r1);

executable communicate_soil_data(r1,l0,w3,w2,w1) if at(r1,w2),at_lander(l0,w1),have_soil_analysis(r1,w3),visible(w2,w1),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w3,w2,w1) causes channel_free(l0),communicated_soil_data(w3), available(r1);

communicate_soil_data(r1,l0,w3,w2,w1) causes channel_free(l0),communicated_soil_data(w3), available(r1);

executable communicate_soil_data(r1,l0,w3,w2,w3) if at(r1,w2),at_lander(l0,w3),have_soil_analysis(r1,w3),visible(w2,w3),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w3,w2,w3) causes channel_free(l0),communicated_soil_data(w3), available(r1);

executable communicate_soil_data(r1,l0,w3,w3,w0) if at(r1,w3),at_lander(l0,w0),have_soil_analysis(r1,w3),visible(w3,w0),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w3,w3,w0) causes channel_free(l0),communicated_soil_data(w3), available(r1);

executable communicate_soil_data(r1,l0,w3,w3,w1) if at(r1,w3),at_lander(l0,w1),have_soil_analysis(r1,w3),visible(w3,w1),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w3,w3,w1) causes channel_free(l0),communicated_soil_data(w3), available(r1);

executable communicate_soil_data(r1,l0,w3,w3,w2) if at(r1,w3),at_lander(l0,w2),have_soil_analysis(r1,w3),visible(w3,w2),available(r1),channel_free(l0);
communicate_soil_data(r1,l0,w3,w3,w2) causes channel_free(l0),communicated_soil_data(w3), available(r1);

communicate_soil_data(r1,l0,w3,w3,w2) causes channel_free(l0),communicated_soil_data(w3), available(r1);


executable communicate_rock_data(r0,l0,w0,w0,w1) if at(r0,w0),at_lander(l0,w1),have_rock_analysis(r0,w0),visible(w0,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w0,w1) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w0,w2) if at(r0,w0),at_lander(l0,w2),have_rock_analysis(r0,w0),visible(w0,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w0,w2) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w0,w3) if at(r0,w0),at_lander(l0,w3),have_rock_analysis(r0,w0),visible(w0,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w0,w3) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w1,w0) if at(r0,w1),at_lander(l0,w0),have_rock_analysis(r0,w0),visible(w1,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w1,w0) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w1,w2) if at(r0,w1),at_lander(l0,w2),have_rock_analysis(r0,w0),visible(w1,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w1,w2) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w1,w3) if at(r0,w1),at_lander(l0,w3),have_rock_analysis(r0,w0),visible(w1,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w1,w3) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w2,w0) if at(r0,w2),at_lander(l0,w0),have_rock_analysis(r0,w0),visible(w2,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w2,w0) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w2,w1) if at(r0,w2),at_lander(l0,w1),have_rock_analysis(r0,w0),visible(w2,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w2,w1) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w2,w3) if at(r0,w2),at_lander(l0,w3),have_rock_analysis(r0,w0),visible(w2,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w2,w3) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w3,w0) if at(r0,w3),at_lander(l0,w0),have_rock_analysis(r0,w0),visible(w3,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w3,w0) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w3,w1) if at(r0,w3),at_lander(l0,w1),have_rock_analysis(r0,w0),visible(w3,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w3,w1) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w3,w2) if at(r0,w3),at_lander(l0,w2),have_rock_analysis(r0,w0),visible(w3,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w3,w2) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w1,w0,w1) if at(r0,w0),at_lander(l0,w1),have_rock_analysis(r0,w1),visible(w0,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w0,w1) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w0,w2) if at(r0,w0),at_lander(l0,w2),have_rock_analysis(r0,w1),visible(w0,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w0,w2) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w0,w3) if at(r0,w0),at_lander(l0,w3),have_rock_analysis(r0,w1),visible(w0,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w0,w3) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w1,w0) if at(r0,w1),at_lander(l0,w0),have_rock_analysis(r0,w1),visible(w1,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w1,w0) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w1,w2) if at(r0,w1),at_lander(l0,w2),have_rock_analysis(r0,w1),visible(w1,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w1,w2) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w1,w3) if at(r0,w1),at_lander(l0,w3),have_rock_analysis(r0,w1),visible(w1,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w1,w3) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w2,w0) if at(r0,w2),at_lander(l0,w0),have_rock_analysis(r0,w1),visible(w2,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w2,w0) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w2,w1) if at(r0,w2),at_lander(l0,w1),have_rock_analysis(r0,w1),visible(w2,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w2,w1) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w2,w3) if at(r0,w2),at_lander(l0,w3),have_rock_analysis(r0,w1),visible(w2,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w2,w3) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w3,w0) if at(r0,w3),at_lander(l0,w0),have_rock_analysis(r0,w1),visible(w3,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w3,w0) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w3,w1) if at(r0,w3),at_lander(l0,w1),have_rock_analysis(r0,w1),visible(w3,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w3,w1) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w3,w2) if at(r0,w3),at_lander(l0,w2),have_rock_analysis(r0,w1),visible(w3,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w3,w2) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w2,w0,w1) if at(r0,w0),at_lander(l0,w1),have_rock_analysis(r0,w2),visible(w0,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w0,w1) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w0,w2) if at(r0,w0),at_lander(l0,w2),have_rock_analysis(r0,w2),visible(w0,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w0,w2) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w0,w3) if at(r0,w0),at_lander(l0,w3),have_rock_analysis(r0,w2),visible(w0,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w0,w3) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w1,w0) if at(r0,w1),at_lander(l0,w0),have_rock_analysis(r0,w2),visible(w1,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w1,w0) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w1,w2) if at(r0,w1),at_lander(l0,w2),have_rock_analysis(r0,w2),visible(w1,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w1,w2) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w1,w3) if at(r0,w1),at_lander(l0,w3),have_rock_analysis(r0,w2),visible(w1,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w1,w3) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w2,w0) if at(r0,w2),at_lander(l0,w0),have_rock_analysis(r0,w2),visible(w2,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w2,w0) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w2,w1) if at(r0,w2),at_lander(l0,w1),have_rock_analysis(r0,w2),visible(w2,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w2,w1) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w2,w3) if at(r0,w2),at_lander(l0,w3),have_rock_analysis(r0,w2),visible(w2,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w2,w3) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w3,w0) if at(r0,w3),at_lander(l0,w0),have_rock_analysis(r0,w2),visible(w3,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w3,w0) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w3,w1) if at(r0,w3),at_lander(l0,w1),have_rock_analysis(r0,w2),visible(w3,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w3,w1) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w3,w2) if at(r0,w3),at_lander(l0,w2),have_rock_analysis(r0,w2),visible(w3,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w3,w2) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w3,w0,w1) if at(r0,w0),at_lander(l0,w1),have_rock_analysis(r0,w3),visible(w0,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w0,w1) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w0,w2) if at(r0,w0),at_lander(l0,w2),have_rock_analysis(r0,w3),visible(w0,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w0,w2) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w0,w3) if at(r0,w0),at_lander(l0,w3),have_rock_analysis(r0,w3),visible(w0,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w0,w3) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w1,w0) if at(r0,w1),at_lander(l0,w0),have_rock_analysis(r0,w3),visible(w1,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w1,w0) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w1,w2) if at(r0,w1),at_lander(l0,w2),have_rock_analysis(r0,w3),visible(w1,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w1,w2) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w1,w3) if at(r0,w1),at_lander(l0,w3),have_rock_analysis(r0,w3),visible(w1,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w1,w3) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w2,w0) if at(r0,w2),at_lander(l0,w0),have_rock_analysis(r0,w3),visible(w2,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w2,w0) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w2,w1) if at(r0,w2),at_lander(l0,w1),have_rock_analysis(r0,w3),visible(w2,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w2,w1) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w2,w3) if at(r0,w2),at_lander(l0,w3),have_rock_analysis(r0,w3),visible(w2,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w2,w3) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w3,w0) if at(r0,w3),at_lander(l0,w0),have_rock_analysis(r0,w3),visible(w3,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w3,w0) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w3,w1) if at(r0,w3),at_lander(l0,w1),have_rock_analysis(r0,w3),visible(w3,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w3,w1) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w3,w2) if at(r0,w3),at_lander(l0,w2),have_rock_analysis(r0,w3),visible(w3,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w3,w2) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r1,l0,w0,w0,w1) if at(r1,w0),at_lander(l0,w1),have_rock_analysis(r1,w0),visible(w0,w1),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w0,w0,w1) causes channel_free(l0),communicated_rock_data(w0), available(r1);

executable communicate_rock_data(r1,l0,w0,w0,w2) if at(r1,w0),at_lander(l0,w2),have_rock_analysis(r1,w0),visible(w0,w2),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w0,w0,w2) causes channel_free(l0),communicated_rock_data(w0), available(r1);

executable communicate_rock_data(r1,l0,w0,w0,w3) if at(r1,w0),at_lander(l0,w3),have_rock_analysis(r1,w0),visible(w0,w3),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w0,w0,w3) causes channel_free(l0),communicated_rock_data(w0), available(r1);

executable communicate_rock_data(r1,l0,w0,w1,w0) if at(r1,w1),at_lander(l0,w0),have_rock_analysis(r1,w0),visible(w1,w0),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w0,w1,w0) causes channel_free(l0),communicated_rock_data(w0), available(r1);

executable communicate_rock_data(r1,l0,w0,w1,w2) if at(r1,w1),at_lander(l0,w2),have_rock_analysis(r1,w0),visible(w1,w2),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w0,w1,w2) causes channel_free(l0),communicated_rock_data(w0), available(r1);

executable communicate_rock_data(r1,l0,w0,w1,w3) if at(r1,w1),at_lander(l0,w3),have_rock_analysis(r1,w0),visible(w1,w3),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w0,w1,w3) causes channel_free(l0),communicated_rock_data(w0), available(r1);

executable communicate_rock_data(r1,l0,w0,w2,w0) if at(r1,w2),at_lander(l0,w0),have_rock_analysis(r1,w0),visible(w2,w0),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w0,w2,w0) causes channel_free(l0),communicated_rock_data(w0), available(r1);

executable communicate_rock_data(r1,l0,w0,w2,w1) if at(r1,w2),at_lander(l0,w1),have_rock_analysis(r1,w0),visible(w2,w1),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w0,w2,w1) causes channel_free(l0),communicated_rock_data(w0), available(r1);

executable communicate_rock_data(r1,l0,w0,w2,w3) if at(r1,w2),at_lander(l0,w3),have_rock_analysis(r1,w0),visible(w2,w3),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w0,w2,w3) causes channel_free(l0),communicated_rock_data(w0), available(r1);

executable communicate_rock_data(r1,l0,w0,w3,w0) if at(r1,w3),at_lander(l0,w0),have_rock_analysis(r1,w0),visible(w3,w0),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w0,w3,w0) causes channel_free(l0),communicated_rock_data(w0), available(r1);

executable communicate_rock_data(r1,l0,w0,w3,w1) if at(r1,w3),at_lander(l0,w1),have_rock_analysis(r1,w0),visible(w3,w1),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w0,w3,w1) causes channel_free(l0),communicated_rock_data(w0), available(r1);

executable communicate_rock_data(r1,l0,w0,w3,w2) if at(r1,w3),at_lander(l0,w2),have_rock_analysis(r1,w0),visible(w3,w2),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w0,w3,w2) causes channel_free(l0),communicated_rock_data(w0), available(r1);

executable communicate_rock_data(r1,l0,w1,w0,w1) if at(r1,w0),at_lander(l0,w1),have_rock_analysis(r1,w1),visible(w0,w1),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w1,w0,w1) causes channel_free(l0),communicated_rock_data(w1), available(r1);

executable communicate_rock_data(r1,l0,w1,w0,w2) if at(r1,w0),at_lander(l0,w2),have_rock_analysis(r1,w1),visible(w0,w2),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w1,w0,w2) causes channel_free(l0),communicated_rock_data(w1), available(r1);

executable communicate_rock_data(r1,l0,w1,w0,w3) if at(r1,w0),at_lander(l0,w3),have_rock_analysis(r1,w1),visible(w0,w3),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w1,w0,w3) causes channel_free(l0),communicated_rock_data(w1), available(r1);

executable communicate_rock_data(r1,l0,w1,w1,w0) if at(r1,w1),at_lander(l0,w0),have_rock_analysis(r1,w1),visible(w1,w0),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w1,w1,w0) causes channel_free(l0),communicated_rock_data(w1), available(r1);

executable communicate_rock_data(r1,l0,w1,w1,w2) if at(r1,w1),at_lander(l0,w2),have_rock_analysis(r1,w1),visible(w1,w2),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w1,w1,w2) causes channel_free(l0),communicated_rock_data(w1), available(r1);

executable communicate_rock_data(r1,l0,w1,w1,w3) if at(r1,w1),at_lander(l0,w3),have_rock_analysis(r1,w1),visible(w1,w3),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w1,w1,w3) causes channel_free(l0),communicated_rock_data(w1), available(r1);

executable communicate_rock_data(r1,l0,w1,w2,w0) if at(r1,w2),at_lander(l0,w0),have_rock_analysis(r1,w1),visible(w2,w0),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w1,w2,w0) causes channel_free(l0),communicated_rock_data(w1), available(r1);

executable communicate_rock_data(r1,l0,w1,w2,w1) if at(r1,w2),at_lander(l0,w1),have_rock_analysis(r1,w1),visible(w2,w1),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w1,w2,w1) causes channel_free(l0),communicated_rock_data(w1), available(r1);

executable communicate_rock_data(r1,l0,w1,w2,w3) if at(r1,w2),at_lander(l0,w3),have_rock_analysis(r1,w1),visible(w2,w3),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w1,w2,w3) causes channel_free(l0),communicated_rock_data(w1), available(r1);

executable communicate_rock_data(r1,l0,w1,w3,w0) if at(r1,w3),at_lander(l0,w0),have_rock_analysis(r1,w1),visible(w3,w0),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w1,w3,w0) causes channel_free(l0),communicated_rock_data(w1), available(r1);

executable communicate_rock_data(r1,l0,w1,w3,w1) if at(r1,w3),at_lander(l0,w1),have_rock_analysis(r1,w1),visible(w3,w1),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w1,w3,w1) causes channel_free(l0),communicated_rock_data(w1), available(r1);

executable communicate_rock_data(r1,l0,w1,w3,w2) if at(r1,w3),at_lander(l0,w2),have_rock_analysis(r1,w1),visible(w3,w2),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w1,w3,w2) causes channel_free(l0),communicated_rock_data(w1), available(r1);

executable communicate_rock_data(r1,l0,w2,w0,w1) if at(r1,w0),at_lander(l0,w1),have_rock_analysis(r1,w2),visible(w0,w1),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w2,w0,w1) causes channel_free(l0),communicated_rock_data(w2), available(r1);

executable communicate_rock_data(r1,l0,w2,w0,w2) if at(r1,w0),at_lander(l0,w2),have_rock_analysis(r1,w2),visible(w0,w2),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w2,w0,w2) causes channel_free(l0),communicated_rock_data(w2), available(r1);

executable communicate_rock_data(r1,l0,w2,w0,w3) if at(r1,w0),at_lander(l0,w3),have_rock_analysis(r1,w2),visible(w0,w3),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w2,w0,w3) causes channel_free(l0),communicated_rock_data(w2), available(r1);

executable communicate_rock_data(r1,l0,w2,w1,w0) if at(r1,w1),at_lander(l0,w0),have_rock_analysis(r1,w2),visible(w1,w0),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w2,w1,w0) causes channel_free(l0),communicated_rock_data(w2), available(r1);

executable communicate_rock_data(r1,l0,w2,w1,w2) if at(r1,w1),at_lander(l0,w2),have_rock_analysis(r1,w2),visible(w1,w2),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w2,w1,w2) causes channel_free(l0),communicated_rock_data(w2), available(r1);

executable communicate_rock_data(r1,l0,w2,w1,w3) if at(r1,w1),at_lander(l0,w3),have_rock_analysis(r1,w2),visible(w1,w3),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w2,w1,w3) causes channel_free(l0),communicated_rock_data(w2), available(r1);

executable communicate_rock_data(r1,l0,w2,w2,w0) if at(r1,w2),at_lander(l0,w0),have_rock_analysis(r1,w2),visible(w2,w0),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w2,w2,w0) causes channel_free(l0),communicated_rock_data(w2), available(r1);

executable communicate_rock_data(r1,l0,w2,w2,w1) if at(r1,w2),at_lander(l0,w1),have_rock_analysis(r1,w2),visible(w2,w1),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w2,w2,w1) causes channel_free(l0),communicated_rock_data(w2), available(r1);

executable communicate_rock_data(r1,l0,w2,w2,w3) if at(r1,w2),at_lander(l0,w3),have_rock_analysis(r1,w2),visible(w2,w3),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w2,w2,w3) causes channel_free(l0),communicated_rock_data(w2), available(r1);

executable communicate_rock_data(r1,l0,w2,w3,w0) if at(r1,w3),at_lander(l0,w0),have_rock_analysis(r1,w2),visible(w3,w0),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w2,w3,w0) causes channel_free(l0),communicated_rock_data(w2), available(r1);

executable communicate_rock_data(r1,l0,w2,w3,w1) if at(r1,w3),at_lander(l0,w1),have_rock_analysis(r1,w2),visible(w3,w1),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w2,w3,w1) causes channel_free(l0),communicated_rock_data(w2), available(r1);

executable communicate_rock_data(r1,l0,w2,w3,w2) if at(r1,w3),at_lander(l0,w2),have_rock_analysis(r1,w2),visible(w3,w2),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w2,w3,w2) causes channel_free(l0),communicated_rock_data(w2), available(r1);

executable communicate_rock_data(r1,l0,w3,w0,w1) if at(r1,w0),at_lander(l0,w1),have_rock_analysis(r1,w3),visible(w0,w1),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w3,w0,w1) causes channel_free(l0),communicated_rock_data(w3), available(r1);

executable communicate_rock_data(r1,l0,w3,w0,w2) if at(r1,w0),at_lander(l0,w2),have_rock_analysis(r1,w3),visible(w0,w2),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w3,w0,w2) causes channel_free(l0),communicated_rock_data(w3), available(r1);

executable communicate_rock_data(r1,l0,w3,w0,w3) if at(r1,w0),at_lander(l0,w3),have_rock_analysis(r1,w3),visible(w0,w3),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w3,w0,w3) causes channel_free(l0),communicated_rock_data(w3), available(r1);

executable communicate_rock_data(r1,l0,w3,w1,w0) if at(r1,w1),at_lander(l0,w0),have_rock_analysis(r1,w3),visible(w1,w0),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w3,w1,w0) causes channel_free(l0),communicated_rock_data(w3), available(r1);

executable communicate_rock_data(r1,l0,w3,w1,w2) if at(r1,w1),at_lander(l0,w2),have_rock_analysis(r1,w3),visible(w1,w2),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w3,w1,w2) causes channel_free(l0),communicated_rock_data(w3), available(r1);

executable communicate_rock_data(r1,l0,w3,w1,w3) if at(r1,w1),at_lander(l0,w3),have_rock_analysis(r1,w3),visible(w1,w3),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w3,w1,w3) causes channel_free(l0),communicated_rock_data(w3), available(r1);

executable communicate_rock_data(r1,l0,w3,w2,w0) if at(r1,w2),at_lander(l0,w0),have_rock_analysis(r1,w3),visible(w2,w0),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w3,w2,w0) causes channel_free(l0),communicated_rock_data(w3), available(r1);

executable communicate_rock_data(r1,l0,w3,w2,w1) if at(r1,w2),at_lander(l0,w1),have_rock_analysis(r1,w3),visible(w2,w1),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w3,w2,w1) causes channel_free(l0),communicated_rock_data(w3), available(r1);

executable communicate_rock_data(r1,l0,w3,w2,w3) if at(r1,w2),at_lander(l0,w3),have_rock_analysis(r1,w3),visible(w2,w3),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w3,w2,w3) causes channel_free(l0),communicated_rock_data(w3), available(r1);

executable communicate_rock_data(r1,l0,w3,w3,w0) if at(r1,w3),at_lander(l0,w0),have_rock_analysis(r1,w3),visible(w3,w0),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w3,w3,w0) causes channel_free(l0),communicated_rock_data(w3), available(r1);

executable communicate_rock_data(r1,l0,w3,w3,w1) if at(r1,w3),at_lander(l0,w1),have_rock_analysis(r1,w3),visible(w3,w1),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w3,w3,w1) causes channel_free(l0),communicated_rock_data(w3), available(r1);

executable communicate_rock_data(r1,l0,w3,w3,w2) if at(r1,w3),at_lander(l0,w2),have_rock_analysis(r1,w3),visible(w3,w2),available(r1),channel_free(l0);
communicate_rock_data(r1,l0,w3,w3,w2) causes channel_free(l0),communicated_rock_data(w3), available(r1);


executable communicate_image_data(r0,l0,o0,m0,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o0,m0),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w0,w1) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o0,m0),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w0,w2) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o0,m0),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w0,w3) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o0,m0),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w1,w0) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o0,m0),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w1,w2) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o0,m0),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w1,w3) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o0,m0),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w2,w0) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o0,m0),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w2,w1) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o0,m0),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w2,w3) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o0,m0),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w3,w0) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o0,m0),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w3,w1) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o0,m0),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w3,w2) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o0,m1),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w0,w1) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o0,m1),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w0,w2) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o0,m1),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w0,w3) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o0,m1),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w1,w0) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o0,m1),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w1,w2) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o0,m1),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w1,w3) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o0,m1),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w2,w0) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o0,m1),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w2,w1) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o0,m1),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w2,w3) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o0,m1),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w3,w0) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o0,m1),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w3,w1) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o0,m1),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w3,w2) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o0,m2),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w0,w1) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o0,m2),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w0,w2) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o0,m2),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w0,w3) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o0,m2),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w1,w0) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o0,m2),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w1,w2) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o0,m2),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w1,w3) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o0,m2),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w2,w0) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o0,m2),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w2,w1) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o0,m2),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w2,w3) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o0,m2),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w3,w0) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o0,m2),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w3,w1) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o0,m2),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w3,w2) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o1,m0),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w0,w1) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o1,m0),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w0,w2) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o1,m0),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w0,w3) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o1,m0),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w1,w0) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o1,m0),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w1,w2) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o1,m0),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w1,w3) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o1,m0),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w2,w0) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o1,m0),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w2,w1) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o1,m0),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w2,w3) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o1,m0),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w3,w0) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o1,m0),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w3,w1) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o1,m0),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w3,w2) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o1,m1),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w0,w1) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o1,m1),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w0,w2) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o1,m1),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w0,w3) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o1,m1),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w1,w0) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o1,m1),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w1,w2) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o1,m1),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w1,w3) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o1,m1),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w2,w0) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o1,m1),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w2,w1) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o1,m1),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w2,w3) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o1,m1),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w3,w0) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o1,m1),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w3,w1) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o1,m1),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w3,w2) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o1,m2),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w0,w1) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o1,m2),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w0,w2) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o1,m2),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w0,w3) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o1,m2),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w1,w0) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o1,m2),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w1,w2) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o1,m2),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w1,w3) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o1,m2),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w2,w0) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o1,m2),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w2,w1) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o1,m2),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w2,w3) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o1,m2),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w3,w0) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o1,m2),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w3,w1) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o1,m2),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w3,w2) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o2,m0,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o2,m0),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m0,w0,w1) causes channel_free(l0),communicated_image_data(o2,m0),available(r0);

executable communicate_image_data(r0,l0,o2,m0,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o2,m0),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m0,w0,w2) causes channel_free(l0),communicated_image_data(o2,m0),available(r0);

executable communicate_image_data(r0,l0,o2,m0,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o2,m0),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m0,w0,w3) causes channel_free(l0),communicated_image_data(o2,m0),available(r0);

executable communicate_image_data(r0,l0,o2,m0,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o2,m0),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m0,w1,w0) causes channel_free(l0),communicated_image_data(o2,m0),available(r0);

executable communicate_image_data(r0,l0,o2,m0,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o2,m0),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m0,w1,w2) causes channel_free(l0),communicated_image_data(o2,m0),available(r0);

executable communicate_image_data(r0,l0,o2,m0,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o2,m0),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m0,w1,w3) causes channel_free(l0),communicated_image_data(o2,m0),available(r0);

executable communicate_image_data(r0,l0,o2,m0,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o2,m0),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m0,w2,w0) causes channel_free(l0),communicated_image_data(o2,m0),available(r0);

executable communicate_image_data(r0,l0,o2,m0,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o2,m0),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m0,w2,w1) causes channel_free(l0),communicated_image_data(o2,m0),available(r0);

executable communicate_image_data(r0,l0,o2,m0,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o2,m0),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m0,w2,w3) causes channel_free(l0),communicated_image_data(o2,m0),available(r0);

executable communicate_image_data(r0,l0,o2,m0,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o2,m0),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m0,w3,w0) causes channel_free(l0),communicated_image_data(o2,m0),available(r0);

executable communicate_image_data(r0,l0,o2,m0,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o2,m0),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m0,w3,w1) causes channel_free(l0),communicated_image_data(o2,m0),available(r0);

executable communicate_image_data(r0,l0,o2,m0,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o2,m0),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m0,w3,w2) causes channel_free(l0),communicated_image_data(o2,m0),available(r0);

executable communicate_image_data(r0,l0,o2,m1,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o2,m1),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m1,w0,w1) causes channel_free(l0),communicated_image_data(o2,m1),available(r0);

executable communicate_image_data(r0,l0,o2,m1,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o2,m1),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m1,w0,w2) causes channel_free(l0),communicated_image_data(o2,m1),available(r0);

executable communicate_image_data(r0,l0,o2,m1,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o2,m1),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m1,w0,w3) causes channel_free(l0),communicated_image_data(o2,m1),available(r0);

executable communicate_image_data(r0,l0,o2,m1,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o2,m1),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m1,w1,w0) causes channel_free(l0),communicated_image_data(o2,m1),available(r0);

executable communicate_image_data(r0,l0,o2,m1,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o2,m1),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m1,w1,w2) causes channel_free(l0),communicated_image_data(o2,m1),available(r0);

executable communicate_image_data(r0,l0,o2,m1,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o2,m1),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m1,w1,w3) causes channel_free(l0),communicated_image_data(o2,m1),available(r0);

executable communicate_image_data(r0,l0,o2,m1,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o2,m1),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m1,w2,w0) causes channel_free(l0),communicated_image_data(o2,m1),available(r0);

executable communicate_image_data(r0,l0,o2,m1,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o2,m1),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m1,w2,w1) causes channel_free(l0),communicated_image_data(o2,m1),available(r0);

executable communicate_image_data(r0,l0,o2,m1,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o2,m1),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m1,w2,w3) causes channel_free(l0),communicated_image_data(o2,m1),available(r0);

executable communicate_image_data(r0,l0,o2,m1,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o2,m1),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m1,w3,w0) causes channel_free(l0),communicated_image_data(o2,m1),available(r0);

executable communicate_image_data(r0,l0,o2,m1,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o2,m1),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m1,w3,w1) causes channel_free(l0),communicated_image_data(o2,m1),available(r0);

executable communicate_image_data(r0,l0,o2,m1,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o2,m1),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m1,w3,w2) causes channel_free(l0),communicated_image_data(o2,m1),available(r0);

executable communicate_image_data(r0,l0,o2,m2,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o2,m2),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m2,w0,w1) causes channel_free(l0),communicated_image_data(o2,m2),available(r0);

executable communicate_image_data(r0,l0,o2,m2,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o2,m2),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m2,w0,w2) causes channel_free(l0),communicated_image_data(o2,m2),available(r0);

executable communicate_image_data(r0,l0,o2,m2,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o2,m2),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m2,w0,w3) causes channel_free(l0),communicated_image_data(o2,m2),available(r0);

executable communicate_image_data(r0,l0,o2,m2,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o2,m2),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m2,w1,w0) causes channel_free(l0),communicated_image_data(o2,m2),available(r0);

executable communicate_image_data(r0,l0,o2,m2,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o2,m2),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m2,w1,w2) causes channel_free(l0),communicated_image_data(o2,m2),available(r0);

executable communicate_image_data(r0,l0,o2,m2,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o2,m2),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m2,w1,w3) causes channel_free(l0),communicated_image_data(o2,m2),available(r0);

executable communicate_image_data(r0,l0,o2,m2,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o2,m2),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m2,w2,w0) causes channel_free(l0),communicated_image_data(o2,m2),available(r0);

executable communicate_image_data(r0,l0,o2,m2,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o2,m2),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m2,w2,w1) causes channel_free(l0),communicated_image_data(o2,m2),available(r0);

executable communicate_image_data(r0,l0,o2,m2,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o2,m2),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m2,w2,w3) causes channel_free(l0),communicated_image_data(o2,m2),available(r0);

executable communicate_image_data(r0,l0,o2,m2,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o2,m2),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m2,w3,w0) causes channel_free(l0),communicated_image_data(o2,m2),available(r0);

executable communicate_image_data(r0,l0,o2,m2,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o2,m2),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m2,w3,w1) causes channel_free(l0),communicated_image_data(o2,m2),available(r0);

executable communicate_image_data(r0,l0,o2,m2,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o2,m2),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o2,m2,w3,w2) causes channel_free(l0),communicated_image_data(o2,m2),available(r0);

executable communicate_image_data(r1,l0,o0,m0,w0,w1) if at(r1,w0),at_lander(l0,w1),have_image(r1,o0,m0),visible(w0,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m0,w0,w1) causes channel_free(l0),communicated_image_data(o0,m0),available(r1);

executable communicate_image_data(r1,l0,o0,m0,w0,w2) if at(r1,w0),at_lander(l0,w2),have_image(r1,o0,m0),visible(w0,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m0,w0,w2) causes channel_free(l0),communicated_image_data(o0,m0),available(r1);

executable communicate_image_data(r1,l0,o0,m0,w0,w3) if at(r1,w0),at_lander(l0,w3),have_image(r1,o0,m0),visible(w0,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m0,w0,w3) causes channel_free(l0),communicated_image_data(o0,m0),available(r1);

executable communicate_image_data(r1,l0,o0,m0,w1,w0) if at(r1,w1),at_lander(l0,w0),have_image(r1,o0,m0),visible(w1,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m0,w1,w0) causes channel_free(l0),communicated_image_data(o0,m0),available(r1);

executable communicate_image_data(r1,l0,o0,m0,w1,w2) if at(r1,w1),at_lander(l0,w2),have_image(r1,o0,m0),visible(w1,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m0,w1,w2) causes channel_free(l0),communicated_image_data(o0,m0),available(r1);

executable communicate_image_data(r1,l0,o0,m0,w1,w3) if at(r1,w1),at_lander(l0,w3),have_image(r1,o0,m0),visible(w1,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m0,w1,w3) causes channel_free(l0),communicated_image_data(o0,m0),available(r1);

executable communicate_image_data(r1,l0,o0,m0,w2,w0) if at(r1,w2),at_lander(l0,w0),have_image(r1,o0,m0),visible(w2,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m0,w2,w0) causes channel_free(l0),communicated_image_data(o0,m0),available(r1);

executable communicate_image_data(r1,l0,o0,m0,w2,w1) if at(r1,w2),at_lander(l0,w1),have_image(r1,o0,m0),visible(w2,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m0,w2,w1) causes channel_free(l0),communicated_image_data(o0,m0),available(r1);

executable communicate_image_data(r1,l0,o0,m0,w2,w3) if at(r1,w2),at_lander(l0,w3),have_image(r1,o0,m0),visible(w2,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m0,w2,w3) causes channel_free(l0),communicated_image_data(o0,m0),available(r1);

executable communicate_image_data(r1,l0,o0,m0,w3,w0) if at(r1,w3),at_lander(l0,w0),have_image(r1,o0,m0),visible(w3,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m0,w3,w0) causes channel_free(l0),communicated_image_data(o0,m0),available(r1);

executable communicate_image_data(r1,l0,o0,m0,w3,w1) if at(r1,w3),at_lander(l0,w1),have_image(r1,o0,m0),visible(w3,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m0,w3,w1) causes channel_free(l0),communicated_image_data(o0,m0),available(r1);

executable communicate_image_data(r1,l0,o0,m0,w3,w2) if at(r1,w3),at_lander(l0,w2),have_image(r1,o0,m0),visible(w3,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m0,w3,w2) causes channel_free(l0),communicated_image_data(o0,m0),available(r1);

executable communicate_image_data(r1,l0,o0,m1,w0,w1) if at(r1,w0),at_lander(l0,w1),have_image(r1,o0,m1),visible(w0,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m1,w0,w1) causes channel_free(l0),communicated_image_data(o0,m1),available(r1);

executable communicate_image_data(r1,l0,o0,m1,w0,w2) if at(r1,w0),at_lander(l0,w2),have_image(r1,o0,m1),visible(w0,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m1,w0,w2) causes channel_free(l0),communicated_image_data(o0,m1),available(r1);

executable communicate_image_data(r1,l0,o0,m1,w0,w3) if at(r1,w0),at_lander(l0,w3),have_image(r1,o0,m1),visible(w0,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m1,w0,w3) causes channel_free(l0),communicated_image_data(o0,m1),available(r1);

executable communicate_image_data(r1,l0,o0,m1,w1,w0) if at(r1,w1),at_lander(l0,w0),have_image(r1,o0,m1),visible(w1,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m1,w1,w0) causes channel_free(l0),communicated_image_data(o0,m1),available(r1);

executable communicate_image_data(r1,l0,o0,m1,w1,w2) if at(r1,w1),at_lander(l0,w2),have_image(r1,o0,m1),visible(w1,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m1,w1,w2) causes channel_free(l0),communicated_image_data(o0,m1),available(r1);

executable communicate_image_data(r1,l0,o0,m1,w1,w3) if at(r1,w1),at_lander(l0,w3),have_image(r1,o0,m1),visible(w1,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m1,w1,w3) causes channel_free(l0),communicated_image_data(o0,m1),available(r1);

executable communicate_image_data(r1,l0,o0,m1,w2,w0) if at(r1,w2),at_lander(l0,w0),have_image(r1,o0,m1),visible(w2,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m1,w2,w0) causes channel_free(l0),communicated_image_data(o0,m1),available(r1);

executable communicate_image_data(r1,l0,o0,m1,w2,w1) if at(r1,w2),at_lander(l0,w1),have_image(r1,o0,m1),visible(w2,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m1,w2,w1) causes channel_free(l0),communicated_image_data(o0,m1),available(r1);

executable communicate_image_data(r1,l0,o0,m1,w2,w3) if at(r1,w2),at_lander(l0,w3),have_image(r1,o0,m1),visible(w2,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m1,w2,w3) causes channel_free(l0),communicated_image_data(o0,m1),available(r1);

executable communicate_image_data(r1,l0,o0,m1,w3,w0) if at(r1,w3),at_lander(l0,w0),have_image(r1,o0,m1),visible(w3,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m1,w3,w0) causes channel_free(l0),communicated_image_data(o0,m1),available(r1);

executable communicate_image_data(r1,l0,o0,m1,w3,w1) if at(r1,w3),at_lander(l0,w1),have_image(r1,o0,m1),visible(w3,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m1,w3,w1) causes channel_free(l0),communicated_image_data(o0,m1),available(r1);

executable communicate_image_data(r1,l0,o0,m1,w3,w2) if at(r1,w3),at_lander(l0,w2),have_image(r1,o0,m1),visible(w3,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m1,w3,w2) causes channel_free(l0),communicated_image_data(o0,m1),available(r1);

executable communicate_image_data(r1,l0,o0,m2,w0,w1) if at(r1,w0),at_lander(l0,w1),have_image(r1,o0,m2),visible(w0,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m2,w0,w1) causes channel_free(l0),communicated_image_data(o0,m2),available(r1);

executable communicate_image_data(r1,l0,o0,m2,w0,w2) if at(r1,w0),at_lander(l0,w2),have_image(r1,o0,m2),visible(w0,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m2,w0,w2) causes channel_free(l0),communicated_image_data(o0,m2),available(r1);

executable communicate_image_data(r1,l0,o0,m2,w0,w3) if at(r1,w0),at_lander(l0,w3),have_image(r1,o0,m2),visible(w0,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m2,w0,w3) causes channel_free(l0),communicated_image_data(o0,m2),available(r1);

executable communicate_image_data(r1,l0,o0,m2,w1,w0) if at(r1,w1),at_lander(l0,w0),have_image(r1,o0,m2),visible(w1,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m2,w1,w0) causes channel_free(l0),communicated_image_data(o0,m2),available(r1);

executable communicate_image_data(r1,l0,o0,m2,w1,w2) if at(r1,w1),at_lander(l0,w2),have_image(r1,o0,m2),visible(w1,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m2,w1,w2) causes channel_free(l0),communicated_image_data(o0,m2),available(r1);

executable communicate_image_data(r1,l0,o0,m2,w1,w3) if at(r1,w1),at_lander(l0,w3),have_image(r1,o0,m2),visible(w1,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m2,w1,w3) causes channel_free(l0),communicated_image_data(o0,m2),available(r1);

executable communicate_image_data(r1,l0,o0,m2,w2,w0) if at(r1,w2),at_lander(l0,w0),have_image(r1,o0,m2),visible(w2,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m2,w2,w0) causes channel_free(l0),communicated_image_data(o0,m2),available(r1);

executable communicate_image_data(r1,l0,o0,m2,w2,w1) if at(r1,w2),at_lander(l0,w1),have_image(r1,o0,m2),visible(w2,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m2,w2,w1) causes channel_free(l0),communicated_image_data(o0,m2),available(r1);

executable communicate_image_data(r1,l0,o0,m2,w2,w3) if at(r1,w2),at_lander(l0,w3),have_image(r1,o0,m2),visible(w2,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m2,w2,w3) causes channel_free(l0),communicated_image_data(o0,m2),available(r1);

executable communicate_image_data(r1,l0,o0,m2,w3,w0) if at(r1,w3),at_lander(l0,w0),have_image(r1,o0,m2),visible(w3,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m2,w3,w0) causes channel_free(l0),communicated_image_data(o0,m2),available(r1);

executable communicate_image_data(r1,l0,o0,m2,w3,w1) if at(r1,w3),at_lander(l0,w1),have_image(r1,o0,m2),visible(w3,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m2,w3,w1) causes channel_free(l0),communicated_image_data(o0,m2),available(r1);

executable communicate_image_data(r1,l0,o0,m2,w3,w2) if at(r1,w3),at_lander(l0,w2),have_image(r1,o0,m2),visible(w3,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o0,m2,w3,w2) causes channel_free(l0),communicated_image_data(o0,m2),available(r1);

executable communicate_image_data(r1,l0,o1,m0,w0,w1) if at(r1,w0),at_lander(l0,w1),have_image(r1,o1,m0),visible(w0,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m0,w0,w1) causes channel_free(l0),communicated_image_data(o1,m0),available(r1);

executable communicate_image_data(r1,l0,o1,m0,w0,w2) if at(r1,w0),at_lander(l0,w2),have_image(r1,o1,m0),visible(w0,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m0,w0,w2) causes channel_free(l0),communicated_image_data(o1,m0),available(r1);

executable communicate_image_data(r1,l0,o1,m0,w0,w3) if at(r1,w0),at_lander(l0,w3),have_image(r1,o1,m0),visible(w0,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m0,w0,w3) causes channel_free(l0),communicated_image_data(o1,m0),available(r1);

executable communicate_image_data(r1,l0,o1,m0,w1,w0) if at(r1,w1),at_lander(l0,w0),have_image(r1,o1,m0),visible(w1,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m0,w1,w0) causes channel_free(l0),communicated_image_data(o1,m0),available(r1);

executable communicate_image_data(r1,l0,o1,m0,w1,w2) if at(r1,w1),at_lander(l0,w2),have_image(r1,o1,m0),visible(w1,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m0,w1,w2) causes channel_free(l0),communicated_image_data(o1,m0),available(r1);

executable communicate_image_data(r1,l0,o1,m0,w1,w3) if at(r1,w1),at_lander(l0,w3),have_image(r1,o1,m0),visible(w1,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m0,w1,w3) causes channel_free(l0),communicated_image_data(o1,m0),available(r1);

executable communicate_image_data(r1,l0,o1,m0,w2,w0) if at(r1,w2),at_lander(l0,w0),have_image(r1,o1,m0),visible(w2,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m0,w2,w0) causes channel_free(l0),communicated_image_data(o1,m0),available(r1);

executable communicate_image_data(r1,l0,o1,m0,w2,w1) if at(r1,w2),at_lander(l0,w1),have_image(r1,o1,m0),visible(w2,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m0,w2,w1) causes channel_free(l0),communicated_image_data(o1,m0),available(r1);

executable communicate_image_data(r1,l0,o1,m0,w2,w3) if at(r1,w2),at_lander(l0,w3),have_image(r1,o1,m0),visible(w2,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m0,w2,w3) causes channel_free(l0),communicated_image_data(o1,m0),available(r1);

executable communicate_image_data(r1,l0,o1,m0,w3,w0) if at(r1,w3),at_lander(l0,w0),have_image(r1,o1,m0),visible(w3,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m0,w3,w0) causes channel_free(l0),communicated_image_data(o1,m0),available(r1);

executable communicate_image_data(r1,l0,o1,m0,w3,w1) if at(r1,w3),at_lander(l0,w1),have_image(r1,o1,m0),visible(w3,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m0,w3,w1) causes channel_free(l0),communicated_image_data(o1,m0),available(r1);

executable communicate_image_data(r1,l0,o1,m0,w3,w2) if at(r1,w3),at_lander(l0,w2),have_image(r1,o1,m0),visible(w3,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m0,w3,w2) causes channel_free(l0),communicated_image_data(o1,m0),available(r1);

executable communicate_image_data(r1,l0,o1,m1,w0,w1) if at(r1,w0),at_lander(l0,w1),have_image(r1,o1,m1),visible(w0,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m1,w0,w1) causes channel_free(l0),communicated_image_data(o1,m1),available(r1);

executable communicate_image_data(r1,l0,o1,m1,w0,w2) if at(r1,w0),at_lander(l0,w2),have_image(r1,o1,m1),visible(w0,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m1,w0,w2) causes channel_free(l0),communicated_image_data(o1,m1),available(r1);

executable communicate_image_data(r1,l0,o1,m1,w0,w3) if at(r1,w0),at_lander(l0,w3),have_image(r1,o1,m1),visible(w0,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m1,w0,w3) causes channel_free(l0),communicated_image_data(o1,m1),available(r1);

executable communicate_image_data(r1,l0,o1,m1,w1,w0) if at(r1,w1),at_lander(l0,w0),have_image(r1,o1,m1),visible(w1,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m1,w1,w0) causes channel_free(l0),communicated_image_data(o1,m1),available(r1);

executable communicate_image_data(r1,l0,o1,m1,w1,w2) if at(r1,w1),at_lander(l0,w2),have_image(r1,o1,m1),visible(w1,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m1,w1,w2) causes channel_free(l0),communicated_image_data(o1,m1),available(r1);

executable communicate_image_data(r1,l0,o1,m1,w1,w3) if at(r1,w1),at_lander(l0,w3),have_image(r1,o1,m1),visible(w1,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m1,w1,w3) causes channel_free(l0),communicated_image_data(o1,m1),available(r1);

executable communicate_image_data(r1,l0,o1,m1,w2,w0) if at(r1,w2),at_lander(l0,w0),have_image(r1,o1,m1),visible(w2,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m1,w2,w0) causes channel_free(l0),communicated_image_data(o1,m1),available(r1);

executable communicate_image_data(r1,l0,o1,m1,w2,w1) if at(r1,w2),at_lander(l0,w1),have_image(r1,o1,m1),visible(w2,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m1,w2,w1) causes channel_free(l0),communicated_image_data(o1,m1),available(r1);

executable communicate_image_data(r1,l0,o1,m1,w2,w3) if at(r1,w2),at_lander(l0,w3),have_image(r1,o1,m1),visible(w2,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m1,w2,w3) causes channel_free(l0),communicated_image_data(o1,m1),available(r1);

executable communicate_image_data(r1,l0,o1,m1,w3,w0) if at(r1,w3),at_lander(l0,w0),have_image(r1,o1,m1),visible(w3,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m1,w3,w0) causes channel_free(l0),communicated_image_data(o1,m1),available(r1);

executable communicate_image_data(r1,l0,o1,m1,w3,w1) if at(r1,w3),at_lander(l0,w1),have_image(r1,o1,m1),visible(w3,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m1,w3,w1) causes channel_free(l0),communicated_image_data(o1,m1),available(r1);

executable communicate_image_data(r1,l0,o1,m1,w3,w2) if at(r1,w3),at_lander(l0,w2),have_image(r1,o1,m1),visible(w3,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m1,w3,w2) causes channel_free(l0),communicated_image_data(o1,m1),available(r1);

executable communicate_image_data(r1,l0,o1,m2,w0,w1) if at(r1,w0),at_lander(l0,w1),have_image(r1,o1,m2),visible(w0,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m2,w0,w1) causes channel_free(l0),communicated_image_data(o1,m2),available(r1);

executable communicate_image_data(r1,l0,o1,m2,w0,w2) if at(r1,w0),at_lander(l0,w2),have_image(r1,o1,m2),visible(w0,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m2,w0,w2) causes channel_free(l0),communicated_image_data(o1,m2),available(r1);

executable communicate_image_data(r1,l0,o1,m2,w0,w3) if at(r1,w0),at_lander(l0,w3),have_image(r1,o1,m2),visible(w0,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m2,w0,w3) causes channel_free(l0),communicated_image_data(o1,m2),available(r1);

executable communicate_image_data(r1,l0,o1,m2,w1,w0) if at(r1,w1),at_lander(l0,w0),have_image(r1,o1,m2),visible(w1,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m2,w1,w0) causes channel_free(l0),communicated_image_data(o1,m2),available(r1);

executable communicate_image_data(r1,l0,o1,m2,w1,w2) if at(r1,w1),at_lander(l0,w2),have_image(r1,o1,m2),visible(w1,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m2,w1,w2) causes channel_free(l0),communicated_image_data(o1,m2),available(r1);

executable communicate_image_data(r1,l0,o1,m2,w1,w3) if at(r1,w1),at_lander(l0,w3),have_image(r1,o1,m2),visible(w1,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m2,w1,w3) causes channel_free(l0),communicated_image_data(o1,m2),available(r1);

executable communicate_image_data(r1,l0,o1,m2,w2,w0) if at(r1,w2),at_lander(l0,w0),have_image(r1,o1,m2),visible(w2,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m2,w2,w0) causes channel_free(l0),communicated_image_data(o1,m2),available(r1);

executable communicate_image_data(r1,l0,o1,m2,w2,w1) if at(r1,w2),at_lander(l0,w1),have_image(r1,o1,m2),visible(w2,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m2,w2,w1) causes channel_free(l0),communicated_image_data(o1,m2),available(r1);

executable communicate_image_data(r1,l0,o1,m2,w2,w3) if at(r1,w2),at_lander(l0,w3),have_image(r1,o1,m2),visible(w2,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m2,w2,w3) causes channel_free(l0),communicated_image_data(o1,m2),available(r1);

executable communicate_image_data(r1,l0,o1,m2,w3,w0) if at(r1,w3),at_lander(l0,w0),have_image(r1,o1,m2),visible(w3,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m2,w3,w0) causes channel_free(l0),communicated_image_data(o1,m2),available(r1);

executable communicate_image_data(r1,l0,o1,m2,w3,w1) if at(r1,w3),at_lander(l0,w1),have_image(r1,o1,m2),visible(w3,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m2,w3,w1) causes channel_free(l0),communicated_image_data(o1,m2),available(r1);

executable communicate_image_data(r1,l0,o1,m2,w3,w2) if at(r1,w3),at_lander(l0,w2),have_image(r1,o1,m2),visible(w3,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o1,m2,w3,w2) causes channel_free(l0),communicated_image_data(o1,m2),available(r1);

executable communicate_image_data(r1,l0,o2,m0,w0,w1) if at(r1,w0),at_lander(l0,w1),have_image(r1,o2,m0),visible(w0,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m0,w0,w1) causes channel_free(l0),communicated_image_data(o2,m0),available(r1);

executable communicate_image_data(r1,l0,o2,m0,w0,w2) if at(r1,w0),at_lander(l0,w2),have_image(r1,o2,m0),visible(w0,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m0,w0,w2) causes channel_free(l0),communicated_image_data(o2,m0),available(r1);

executable communicate_image_data(r1,l0,o2,m0,w0,w3) if at(r1,w0),at_lander(l0,w3),have_image(r1,o2,m0),visible(w0,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m0,w0,w3) causes channel_free(l0),communicated_image_data(o2,m0),available(r1);

executable communicate_image_data(r1,l0,o2,m0,w1,w0) if at(r1,w1),at_lander(l0,w0),have_image(r1,o2,m0),visible(w1,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m0,w1,w0) causes channel_free(l0),communicated_image_data(o2,m0),available(r1);

executable communicate_image_data(r1,l0,o2,m0,w1,w2) if at(r1,w1),at_lander(l0,w2),have_image(r1,o2,m0),visible(w1,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m0,w1,w2) causes channel_free(l0),communicated_image_data(o2,m0),available(r1);

executable communicate_image_data(r1,l0,o2,m0,w1,w3) if at(r1,w1),at_lander(l0,w3),have_image(r1,o2,m0),visible(w1,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m0,w1,w3) causes channel_free(l0),communicated_image_data(o2,m0),available(r1);

executable communicate_image_data(r1,l0,o2,m0,w2,w0) if at(r1,w2),at_lander(l0,w0),have_image(r1,o2,m0),visible(w2,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m0,w2,w0) causes channel_free(l0),communicated_image_data(o2,m0),available(r1);

executable communicate_image_data(r1,l0,o2,m0,w2,w1) if at(r1,w2),at_lander(l0,w1),have_image(r1,o2,m0),visible(w2,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m0,w2,w1) causes channel_free(l0),communicated_image_data(o2,m0),available(r1);

executable communicate_image_data(r1,l0,o2,m0,w2,w3) if at(r1,w2),at_lander(l0,w3),have_image(r1,o2,m0),visible(w2,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m0,w2,w3) causes channel_free(l0),communicated_image_data(o2,m0),available(r1);

executable communicate_image_data(r1,l0,o2,m0,w3,w0) if at(r1,w3),at_lander(l0,w0),have_image(r1,o2,m0),visible(w3,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m0,w3,w0) causes channel_free(l0),communicated_image_data(o2,m0),available(r1);

executable communicate_image_data(r1,l0,o2,m0,w3,w1) if at(r1,w3),at_lander(l0,w1),have_image(r1,o2,m0),visible(w3,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m0,w3,w1) causes channel_free(l0),communicated_image_data(o2,m0),available(r1);

executable communicate_image_data(r1,l0,o2,m0,w3,w2) if at(r1,w3),at_lander(l0,w2),have_image(r1,o2,m0),visible(w3,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m0,w3,w2) causes channel_free(l0),communicated_image_data(o2,m0),available(r1);

executable communicate_image_data(r1,l0,o2,m1,w0,w1) if at(r1,w0),at_lander(l0,w1),have_image(r1,o2,m1),visible(w0,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m1,w0,w1) causes channel_free(l0),communicated_image_data(o2,m1),available(r1);

executable communicate_image_data(r1,l0,o2,m1,w0,w2) if at(r1,w0),at_lander(l0,w2),have_image(r1,o2,m1),visible(w0,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m1,w0,w2) causes channel_free(l0),communicated_image_data(o2,m1),available(r1);

executable communicate_image_data(r1,l0,o2,m1,w0,w3) if at(r1,w0),at_lander(l0,w3),have_image(r1,o2,m1),visible(w0,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m1,w0,w3) causes channel_free(l0),communicated_image_data(o2,m1),available(r1);

executable communicate_image_data(r1,l0,o2,m1,w1,w0) if at(r1,w1),at_lander(l0,w0),have_image(r1,o2,m1),visible(w1,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m1,w1,w0) causes channel_free(l0),communicated_image_data(o2,m1),available(r1);

executable communicate_image_data(r1,l0,o2,m1,w1,w2) if at(r1,w1),at_lander(l0,w2),have_image(r1,o2,m1),visible(w1,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m1,w1,w2) causes channel_free(l0),communicated_image_data(o2,m1),available(r1);

executable communicate_image_data(r1,l0,o2,m1,w1,w3) if at(r1,w1),at_lander(l0,w3),have_image(r1,o2,m1),visible(w1,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m1,w1,w3) causes channel_free(l0),communicated_image_data(o2,m1),available(r1);

executable communicate_image_data(r1,l0,o2,m1,w2,w0) if at(r1,w2),at_lander(l0,w0),have_image(r1,o2,m1),visible(w2,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m1,w2,w0) causes channel_free(l0),communicated_image_data(o2,m1),available(r1);

executable communicate_image_data(r1,l0,o2,m1,w2,w1) if at(r1,w2),at_lander(l0,w1),have_image(r1,o2,m1),visible(w2,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m1,w2,w1) causes channel_free(l0),communicated_image_data(o2,m1),available(r1);

executable communicate_image_data(r1,l0,o2,m1,w2,w3) if at(r1,w2),at_lander(l0,w3),have_image(r1,o2,m1),visible(w2,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m1,w2,w3) causes channel_free(l0),communicated_image_data(o2,m1),available(r1);

executable communicate_image_data(r1,l0,o2,m1,w3,w0) if at(r1,w3),at_lander(l0,w0),have_image(r1,o2,m1),visible(w3,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m1,w3,w0) causes channel_free(l0),communicated_image_data(o2,m1),available(r1);

executable communicate_image_data(r1,l0,o2,m1,w3,w1) if at(r1,w3),at_lander(l0,w1),have_image(r1,o2,m1),visible(w3,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m1,w3,w1) causes channel_free(l0),communicated_image_data(o2,m1),available(r1);

executable communicate_image_data(r1,l0,o2,m1,w3,w2) if at(r1,w3),at_lander(l0,w2),have_image(r1,o2,m1),visible(w3,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m1,w3,w2) causes channel_free(l0),communicated_image_data(o2,m1),available(r1);

executable communicate_image_data(r1,l0,o2,m2,w0,w1) if at(r1,w0),at_lander(l0,w1),have_image(r1,o2,m2),visible(w0,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m2,w0,w1) causes channel_free(l0),communicated_image_data(o2,m2),available(r1);

executable communicate_image_data(r1,l0,o2,m2,w0,w2) if at(r1,w0),at_lander(l0,w2),have_image(r1,o2,m2),visible(w0,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m2,w0,w2) causes channel_free(l0),communicated_image_data(o2,m2),available(r1);

executable communicate_image_data(r1,l0,o2,m2,w0,w3) if at(r1,w0),at_lander(l0,w3),have_image(r1,o2,m2),visible(w0,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m2,w0,w3) causes channel_free(l0),communicated_image_data(o2,m2),available(r1);

executable communicate_image_data(r1,l0,o2,m2,w1,w0) if at(r1,w1),at_lander(l0,w0),have_image(r1,o2,m2),visible(w1,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m2,w1,w0) causes channel_free(l0),communicated_image_data(o2,m2),available(r1);

executable communicate_image_data(r1,l0,o2,m2,w1,w2) if at(r1,w1),at_lander(l0,w2),have_image(r1,o2,m2),visible(w1,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m2,w1,w2) causes channel_free(l0),communicated_image_data(o2,m2),available(r1);

executable communicate_image_data(r1,l0,o2,m2,w1,w3) if at(r1,w1),at_lander(l0,w3),have_image(r1,o2,m2),visible(w1,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m2,w1,w3) causes channel_free(l0),communicated_image_data(o2,m2),available(r1);

executable communicate_image_data(r1,l0,o2,m2,w2,w0) if at(r1,w2),at_lander(l0,w0),have_image(r1,o2,m2),visible(w2,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m2,w2,w0) causes channel_free(l0),communicated_image_data(o2,m2),available(r1);

executable communicate_image_data(r1,l0,o2,m2,w2,w1) if at(r1,w2),at_lander(l0,w1),have_image(r1,o2,m2),visible(w2,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m2,w2,w1) causes channel_free(l0),communicated_image_data(o2,m2),available(r1);

executable communicate_image_data(r1,l0,o2,m2,w2,w3) if at(r1,w2),at_lander(l0,w3),have_image(r1,o2,m2),visible(w2,w3),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m2,w2,w3) causes channel_free(l0),communicated_image_data(o2,m2),available(r1);

executable communicate_image_data(r1,l0,o2,m2,w3,w0) if at(r1,w3),at_lander(l0,w0),have_image(r1,o2,m2),visible(w3,w0),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m2,w3,w0) causes channel_free(l0),communicated_image_data(o2,m2),available(r1);

executable communicate_image_data(r1,l0,o2,m2,w3,w1) if at(r1,w3),at_lander(l0,w1),have_image(r1,o2,m2),visible(w3,w1),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m2,w3,w1) causes channel_free(l0),communicated_image_data(o2,m2),available(r1);

executable communicate_image_data(r1,l0,o2,m2,w3,w2) if at(r1,w3),at_lander(l0,w2),have_image(r1,o2,m2),visible(w3,w2),available(r1),channel_free(l0);
communicate_image_data(r1,l0,o2,m2,w3,w2) causes channel_free(l0),communicated_image_data(o2,m2),available(r1);


-at(r0,w1) if at(r0,w0);
-at(r0,w2) if at(r0,w0);
-at(r0,w3) if at(r0,w0);

-at(r0,w0) if at(r0,w1);
-at(r0,w2) if at(r0,w1);
-at(r0,w3) if at(r0,w1);

-at(r0,w0) if at(r0,w2);
-at(r0,w1) if at(r0,w2);
-at(r0,w3) if at(r0,w2);

-at(r0,w0) if at(r0,w3);
-at(r0,w1) if at(r0,w3);
-at(r0,w2) if at(r0,w3);

-at(r1,w1) if at(r1,w0);
-at(r1,w2) if at(r1,w0);
-at(r1,w3) if at(r1,w0);

-at(r1,w0) if at(r1,w1);
-at(r1,w2) if at(r1,w1);
-at(r1,w3) if at(r1,w1);

-at(r1,w0) if at(r1,w2);
-at(r1,w1) if at(r1,w2);
-at(r1,w3) if at(r1,w2);

-at(r1,w0) if at(r1,w3);
-at(r1,w1) if at(r1,w3);
-at(r1,w2) if at(r1,w3);


visible(w1,w0) if visible(w0,w1);
visible(w2,w0) if visible(w0,w2);
visible(w3,w0) if visible(w0,w3);

visible(w0,w1) if visible(w1,w0);
visible(w2,w1) if visible(w1,w2);
visible(w3,w1) if visible(w1,w3);

visible(w0,w2) if visible(w2,w0);
visible(w1,w2) if visible(w2,w1);
visible(w3,w2) if visible(w2,w3);

visible(w0,w3) if visible(w3,w0);
visible(w1,w3) if visible(w3,w1);
visible(w2,w3) if visible(w3,w2);


% initial state
initially visible(w0,w1);
initially visible(w1,w2);
initially visible(w1,w3);
initially visible(w2,w3);

initially at_rock_sample(w1),
	at_rock_sample(w3);

initially at_soil_sample(w2),
	at_soil_sample(w3);

initially at_lander(l0,w2);
initially channel_free(l0);

% rover 1
initially at(r0,w3),
  available(r0),
  store_of(s0,r0),
  empty(s0),
  equipped_for_soil_analysis(r0),
  equipped_for_imaging(r0);

initially can_traverse(r0,w1,w3),
  can_traverse(r0,w3,w1);

% rover 2
initially at(r1,w2),
  available(r1),
  store_of(s1,r1),
  empty(s1),
  equipped_for_soil_analysis(r1),
  equipped_for_rock_analysis(r1),
  equipped_for_imaging(r1);  

initially can_traverse(r1,w0,w1),
  can_traverse(r1,w1,w0),
  can_traverse(r1,w1,w2),
  can_traverse(r1,w2,w1),
  can_traverse(r1,w2,w3),
  can_traverse(r1,w3,w2);

% camera 1
initially on_board(c0,r1),
  calibration_target(c0,o0),
  supports(c0,m0),
  supports(c0,m1);

% camera 2
initially on_board(c1,r0),
  calibration_target(c1,o0),
  supports(c1,m0),
  supports(c1,m2);

% camera 3
initially on_board(c2,r0),
	calibration_target(c2,o1),
	supports(c2,m2);

initially visible_from(o0,w0),
  visible_from(o0,w1),
  visible_from(o0,w2),
  visible_from(o0,w3),
	visible_from(o1,w0),
	visible_from(o1,w1),
	visible_from(o2,w0),
	visible_from(o2,w1),
	visible_from(o2,w2);

goal
  communicated_soil_data(w3),
  communicated_rock_data(w1),
  communicated_image_data(o0,m1);

