%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Rover domain - Problem rover_1_4_1_1_3_1
%	n_rovers = 1, n_waypoints = 4, n_stores = 1, n_cameras = 1
%	n_modes = 3, n_landers = 1, n_objectives = 2
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fluent 
	at(r0,w0),
	at(r0,w1),
	at(r0,w2),
	at(r0,w3);
fluent 
	at_lander(l0,w0),
	at_lander(l0,w1),
	at_lander(l0,w2),
	at_lander(l0,w3);
fluent 
	can_traverse(r0,w0,w1),
	can_traverse(r0,w0,w2),
	can_traverse(r0,w0,w3),
	can_traverse(r0,w1,w0),
	can_traverse(r0,w1,w1),
	can_traverse(r0,w1,w2),
	can_traverse(r0,w1,w3),
	can_traverse(r0,w2,w0),
	can_traverse(r0,w2,w1),
	can_traverse(r0,w2,w2),
	can_traverse(r0,w2,w3),
	can_traverse(r0,w3,w0),
	can_traverse(r0,w3,w1),
	can_traverse(r0,w3,w2),
	can_traverse(r0,w3,w3);
	fluent available(r0);
	fluent equipped_for_soil_analysis(r0);
	fluent equipped_for_imaging(r0);
	fluent equipped_for_rock_analysis(r0);
	fluent have_rock_analysis(r0,w0);
	fluent have_soil_analysis(r0,w0);
	fluent have_rock_analysis(r0,w1);
	fluent have_soil_analysis(r0,w1);
	fluent have_rock_analysis(r0,w2);
	fluent have_soil_analysis(r0,w2);
	fluent have_rock_analysis(r0,w3);
	fluent have_soil_analysis(r0,w3);
fluent communicated_soil_data(w0),communicated_rock_data(w0);
fluent communicated_soil_data(w1),communicated_rock_data(w1);
fluent communicated_soil_data(w2),communicated_rock_data(w2);
fluent communicated_soil_data(w3),communicated_rock_data(w3);
fluent
	empty(s0),
	full(s0);
fluent
	supports(c0,m0),
	supports(c0,m1),
	supports(c0,m2);
fluent
	calibrated(c0,r0);
	fluent visible(w0,w1);
	fluent visible(w0,w2);
	fluent visible(w0,w3);
	fluent visible(w1,w0);
	fluent visible(w1,w2);
	fluent visible(w1,w3);
	fluent visible(w2,w0);
	fluent visible(w2,w1);
	fluent visible(w2,w3);
	fluent visible(w3,w0);
	fluent visible(w3,w1);
	fluent visible(w3,w2);
fluent
	have_image(r0,o0,m0),
	have_image(r0,o0,m1),
	have_image(r0,o0,m2),
	have_image(r0,o1,m0),
	have_image(r0,o1,m1),
	have_image(r0,o1,m2);
fluent
	communicated_image_data(o0,m0),
	communicated_image_data(o0,m1),
	communicated_image_data(o0,m2),
	communicated_image_data(o1,m0),
	communicated_image_data(o1,m1),
	communicated_image_data(o1,m2);
fluent
	at_soil_sample(w0),
	at_rock_sample(w0),
	at_soil_sample(w1),
	at_rock_sample(w1),
	at_soil_sample(w2),
	at_rock_sample(w2),
	at_soil_sample(w3),
	at_rock_sample(w3);
fluent
	visible_from(o0,w0),
	visible_from(o0,w1),
	visible_from(o0,w2),
	visible_from(o0,w3),
	visible_from(o1,w0),
	visible_from(o1,w1),
	visible_from(o1,w2),
	visible_from(o1,w3);
fluent
	store_of(s0,r0);
fluent
	calibration_target(c0,o0),
	calibration_target(c0,o1);
fluent
	on_board(c0,r0);
fluent
	channel_free(l0);

executable navigate(r0,w0,w1) if can_traverse(r0,w0,w1),at(r0,w0),visible(w0,w1);
navigate(r0,w0,w1) causes at(r0,w1);

executable navigate(r0,w0,w2) if can_traverse(r0,w0,w2),at(r0,w0),visible(w0,w2);
navigate(r0,w0,w2) causes at(r0,w2);

executable navigate(r0,w0,w3) if can_traverse(r0,w0,w3),at(r0,w0),visible(w0,w3);
navigate(r0,w0,w3) causes at(r0,w3);

executable navigate(r0,w1,w0) if can_traverse(r0,w1,w0),at(r0,w1),visible(w1,w0);
navigate(r0,w1,w0) causes at(r0,w0);

executable navigate(r0,w1,w2) if can_traverse(r0,w1,w2),at(r0,w1),visible(w1,w2);
navigate(r0,w1,w2) causes at(r0,w2);

executable navigate(r0,w1,w3) if can_traverse(r0,w1,w3),at(r0,w1),visible(w1,w3);
navigate(r0,w1,w3) causes at(r0,w3);

executable navigate(r0,w2,w0) if can_traverse(r0,w2,w0),at(r0,w2),visible(w2,w0);
navigate(r0,w2,w0) causes at(r0,w0);

executable navigate(r0,w2,w1) if can_traverse(r0,w2,w1),at(r0,w2),visible(w2,w1);
navigate(r0,w2,w1) causes at(r0,w1);

executable navigate(r0,w2,w3) if can_traverse(r0,w2,w3),at(r0,w2),visible(w2,w3);
navigate(r0,w2,w3) causes at(r0,w3);

executable navigate(r0,w3,w0) if can_traverse(r0,w3,w0),at(r0,w3),visible(w3,w0);
navigate(r0,w3,w0) causes at(r0,w0);

executable navigate(r0,w3,w1) if can_traverse(r0,w3,w1),at(r0,w3),visible(w3,w1);
navigate(r0,w3,w1) causes at(r0,w1);

executable navigate(r0,w3,w2) if can_traverse(r0,w3,w2),at(r0,w3),visible(w3,w2);
navigate(r0,w3,w2) causes at(r0,w2);


executable sample_soil(r0,s0,w0) if at(r0,w0),at_soil_sample(w0),equipped_for_soil_analysis(r0),store_of(s0,r0),empty(s0);
sample_soil(r0,s0,w0) causes -empty(s0),full(s0),have_soil_analysis(r0,w0),-at_soil_sample(w0);

executable sample_soil(r0,s0,w1) if at(r0,w1),at_soil_sample(w1),equipped_for_soil_analysis(r0),store_of(s0,r0),empty(s0);
sample_soil(r0,s0,w1) causes -empty(s0),full(s0),have_soil_analysis(r0,w1),-at_soil_sample(w1);

executable sample_soil(r0,s0,w2) if at(r0,w2),at_soil_sample(w2),equipped_for_soil_analysis(r0),store_of(s0,r0),empty(s0);
sample_soil(r0,s0,w2) causes -empty(s0),full(s0),have_soil_analysis(r0,w2),-at_soil_sample(w2);

executable sample_soil(r0,s0,w3) if at(r0,w3),at_soil_sample(w3),equipped_for_soil_analysis(r0),store_of(s0,r0),empty(s0);
sample_soil(r0,s0,w3) causes -empty(s0),full(s0),have_soil_analysis(r0,w3),-at_soil_sample(w3);


executable sample_rock(r0,s0,w0) if at(r0,w0),at_rock_sample(w0),equipped_for_rock_analysis(r0),store_of(s0,r0),empty(s0);
sample_rock(r0,s0,w0) causes -empty(s0),full(s0),have_rock_analysis(r0,w0),-at_rock_sample(w0);

executable sample_rock(r0,s0,w1) if at(r0,w1),at_rock_sample(w1),equipped_for_rock_analysis(r0),store_of(s0,r0),empty(s0);
sample_rock(r0,s0,w1) causes -empty(s0),full(s0),have_rock_analysis(r0,w1),-at_rock_sample(w1);

executable sample_rock(r0,s0,w2) if at(r0,w2),at_rock_sample(w2),equipped_for_rock_analysis(r0),store_of(s0,r0),empty(s0);
sample_rock(r0,s0,w2) causes -empty(s0),full(s0),have_rock_analysis(r0,w2),-at_rock_sample(w2);

executable sample_rock(r0,s0,w3) if at(r0,w3),at_rock_sample(w3),equipped_for_rock_analysis(r0),store_of(s0,r0),empty(s0);
sample_rock(r0,s0,w3) causes -empty(s0),full(s0),have_rock_analysis(r0,w3),-at_rock_sample(w3);


executable drop(r0,s0) if store_of(s0,r0), full(s0);
drop(r0,s0) causes -full(s0), empty(s0);


executable calibrate(r0,c0,o0,w0) if equipped_for_imaging(r0),calibration_target(c0,o0),at(r0,w0),visible_from(o0,w0),on_board(c0,r0);
calibrate(r0,c0,o0,w0) causes calibrated(c0,r0);

executable calibrate(r0,c0,o0,w1) if equipped_for_imaging(r0),calibration_target(c0,o0),at(r0,w1),visible_from(o0,w1),on_board(c0,r0);
calibrate(r0,c0,o0,w1) causes calibrated(c0,r0);

executable calibrate(r0,c0,o0,w2) if equipped_for_imaging(r0),calibration_target(c0,o0),at(r0,w2),visible_from(o0,w2),on_board(c0,r0);
calibrate(r0,c0,o0,w2) causes calibrated(c0,r0);

executable calibrate(r0,c0,o0,w3) if equipped_for_imaging(r0),calibration_target(c0,o0),at(r0,w3),visible_from(o0,w3),on_board(c0,r0);
calibrate(r0,c0,o0,w3) causes calibrated(c0,r0);

executable calibrate(r0,c0,o1,w0) if equipped_for_imaging(r0),calibration_target(c0,o1),at(r0,w0),visible_from(o1,w0),on_board(c0,r0);
calibrate(r0,c0,o1,w0) causes calibrated(c0,r0);

executable calibrate(r0,c0,o1,w1) if equipped_for_imaging(r0),calibration_target(c0,o1),at(r0,w1),visible_from(o1,w1),on_board(c0,r0);
calibrate(r0,c0,o1,w1) causes calibrated(c0,r0);

executable calibrate(r0,c0,o1,w2) if equipped_for_imaging(r0),calibration_target(c0,o1),at(r0,w2),visible_from(o1,w2),on_board(c0,r0);
calibrate(r0,c0,o1,w2) causes calibrated(c0,r0);

executable calibrate(r0,c0,o1,w3) if equipped_for_imaging(r0),calibration_target(c0,o1),at(r0,w3),visible_from(o1,w3),on_board(c0,r0);
calibrate(r0,c0,o1,w3) causes calibrated(c0,r0);


executable take_image(r0,w0,o0,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o0,w0);
take_image(r0,w0,o0,c0,m0) causes have_image(r0,o0,m0),-calibrated(c0,r0);

executable take_image(r0,w0,o0,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o0,w0);
take_image(r0,w0,o0,c0,m1) causes have_image(r0,o0,m1),-calibrated(c0,r0);

executable take_image(r0,w0,o0,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o0,w0);
take_image(r0,w0,o0,c0,m2) causes have_image(r0,o0,m2),-calibrated(c0,r0);

executable take_image(r0,w0,o1,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o1,w0);
take_image(r0,w0,o1,c0,m0) causes have_image(r0,o1,m0),-calibrated(c0,r0);

executable take_image(r0,w0,o1,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o1,w0);
take_image(r0,w0,o1,c0,m1) causes have_image(r0,o1,m1),-calibrated(c0,r0);

executable take_image(r0,w0,o1,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o1,w0);
take_image(r0,w0,o1,c0,m2) causes have_image(r0,o1,m2),-calibrated(c0,r0);

executable take_image(r0,w1,o0,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o0,w1);
take_image(r0,w1,o0,c0,m0) causes have_image(r0,o0,m0),-calibrated(c0,r0);

executable take_image(r0,w1,o0,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o0,w1);
take_image(r0,w1,o0,c0,m1) causes have_image(r0,o0,m1),-calibrated(c0,r0);

executable take_image(r0,w1,o0,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o0,w1);
take_image(r0,w1,o0,c0,m2) causes have_image(r0,o0,m2),-calibrated(c0,r0);

executable take_image(r0,w1,o1,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o1,w1);
take_image(r0,w1,o1,c0,m0) causes have_image(r0,o1,m0),-calibrated(c0,r0);

executable take_image(r0,w1,o1,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o1,w1);
take_image(r0,w1,o1,c0,m1) causes have_image(r0,o1,m1),-calibrated(c0,r0);

executable take_image(r0,w1,o1,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o1,w1);
take_image(r0,w1,o1,c0,m2) causes have_image(r0,o1,m2),-calibrated(c0,r0);

executable take_image(r0,w2,o0,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o0,w2);
take_image(r0,w2,o0,c0,m0) causes have_image(r0,o0,m0),-calibrated(c0,r0);

executable take_image(r0,w2,o0,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o0,w2);
take_image(r0,w2,o0,c0,m1) causes have_image(r0,o0,m1),-calibrated(c0,r0);

executable take_image(r0,w2,o0,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o0,w2);
take_image(r0,w2,o0,c0,m2) causes have_image(r0,o0,m2),-calibrated(c0,r0);

executable take_image(r0,w2,o1,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o1,w2);
take_image(r0,w2,o1,c0,m0) causes have_image(r0,o1,m0),-calibrated(c0,r0);

executable take_image(r0,w2,o1,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o1,w2);
take_image(r0,w2,o1,c0,m1) causes have_image(r0,o1,m1),-calibrated(c0,r0);

executable take_image(r0,w2,o1,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o1,w2);
take_image(r0,w2,o1,c0,m2) causes have_image(r0,o1,m2),-calibrated(c0,r0);

executable take_image(r0,w3,o0,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o0,w3);
take_image(r0,w3,o0,c0,m0) causes have_image(r0,o0,m0),-calibrated(c0,r0);

executable take_image(r0,w3,o0,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o0,w3);
take_image(r0,w3,o0,c0,m1) causes have_image(r0,o0,m1),-calibrated(c0,r0);

executable take_image(r0,w3,o0,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o0,w3);
take_image(r0,w3,o0,c0,m2) causes have_image(r0,o0,m2),-calibrated(c0,r0);

executable take_image(r0,w3,o1,c0,m0) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m0),visible_from(o1,w3);
take_image(r0,w3,o1,c0,m0) causes have_image(r0,o1,m0),-calibrated(c0,r0);

executable take_image(r0,w3,o1,c0,m1) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m1),visible_from(o1,w3);
take_image(r0,w3,o1,c0,m1) causes have_image(r0,o1,m1),-calibrated(c0,r0);

executable take_image(r0,w3,o1,c0,m2) if calibrated(c0,r0),on_board(c0,r0), equipped_for_imaging(r0),supports(c0,m2),visible_from(o1,w3);
take_image(r0,w3,o1,c0,m2) causes have_image(r0,o1,m2),-calibrated(c0,r0);


take_image(r0,w3,o1,c0,m2) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w0,w1) if at(r0,w0),at_lander(l0,w1),have_soil_analysis(r0,w0),visible(w0,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w0,w1) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w0,w2) if at(r0,w0),at_lander(l0,w2),have_soil_analysis(r0,w0),visible(w0,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w0,w2) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w0,w3) if at(r0,w0),at_lander(l0,w3),have_soil_analysis(r0,w0),visible(w0,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w0,w3) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w1,w0) if at(r0,w1),at_lander(l0,w0),have_soil_analysis(r0,w0),visible(w1,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w1,w0) causes channel_free(l0),communicated_soil_data(w0), available(r0);

communicate_soil_data(r0,l0,w0,w1,w0) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w1,w2) if at(r0,w1),at_lander(l0,w2),have_soil_analysis(r0,w0),visible(w1,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w1,w2) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w1,w3) if at(r0,w1),at_lander(l0,w3),have_soil_analysis(r0,w0),visible(w1,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w1,w3) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w2,w0) if at(r0,w2),at_lander(l0,w0),have_soil_analysis(r0,w0),visible(w2,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w2,w0) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w2,w1) if at(r0,w2),at_lander(l0,w1),have_soil_analysis(r0,w0),visible(w2,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w2,w1) causes channel_free(l0),communicated_soil_data(w0), available(r0);

communicate_soil_data(r0,l0,w0,w2,w1) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w2,w3) if at(r0,w2),at_lander(l0,w3),have_soil_analysis(r0,w0),visible(w2,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w2,w3) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w3,w0) if at(r0,w3),at_lander(l0,w0),have_soil_analysis(r0,w0),visible(w3,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w3,w0) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w3,w1) if at(r0,w3),at_lander(l0,w1),have_soil_analysis(r0,w0),visible(w3,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w3,w1) causes channel_free(l0),communicated_soil_data(w0), available(r0);

executable communicate_soil_data(r0,l0,w0,w3,w2) if at(r0,w3),at_lander(l0,w2),have_soil_analysis(r0,w0),visible(w3,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w0,w3,w2) causes channel_free(l0),communicated_soil_data(w0), available(r0);

communicate_soil_data(r0,l0,w0,w3,w2) causes channel_free(l0),communicated_soil_data(w0), available(r0);

communicate_soil_data(r0,l0,w0,w3,w2) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w0,w1) if at(r0,w0),at_lander(l0,w1),have_soil_analysis(r0,w1),visible(w0,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w0,w1) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w0,w2) if at(r0,w0),at_lander(l0,w2),have_soil_analysis(r0,w1),visible(w0,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w0,w2) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w0,w3) if at(r0,w0),at_lander(l0,w3),have_soil_analysis(r0,w1),visible(w0,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w0,w3) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w1,w0) if at(r0,w1),at_lander(l0,w0),have_soil_analysis(r0,w1),visible(w1,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w1,w0) causes channel_free(l0),communicated_soil_data(w1), available(r0);

communicate_soil_data(r0,l0,w1,w1,w0) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w1,w2) if at(r0,w1),at_lander(l0,w2),have_soil_analysis(r0,w1),visible(w1,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w1,w2) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w1,w3) if at(r0,w1),at_lander(l0,w3),have_soil_analysis(r0,w1),visible(w1,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w1,w3) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w2,w0) if at(r0,w2),at_lander(l0,w0),have_soil_analysis(r0,w1),visible(w2,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w2,w0) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w2,w1) if at(r0,w2),at_lander(l0,w1),have_soil_analysis(r0,w1),visible(w2,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w2,w1) causes channel_free(l0),communicated_soil_data(w1), available(r0);

communicate_soil_data(r0,l0,w1,w2,w1) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w2,w3) if at(r0,w2),at_lander(l0,w3),have_soil_analysis(r0,w1),visible(w2,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w2,w3) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w3,w0) if at(r0,w3),at_lander(l0,w0),have_soil_analysis(r0,w1),visible(w3,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w3,w0) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w3,w1) if at(r0,w3),at_lander(l0,w1),have_soil_analysis(r0,w1),visible(w3,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w3,w1) causes channel_free(l0),communicated_soil_data(w1), available(r0);

executable communicate_soil_data(r0,l0,w1,w3,w2) if at(r0,w3),at_lander(l0,w2),have_soil_analysis(r0,w1),visible(w3,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w1,w3,w2) causes channel_free(l0),communicated_soil_data(w1), available(r0);

communicate_soil_data(r0,l0,w1,w3,w2) causes channel_free(l0),communicated_soil_data(w1), available(r0);

communicate_soil_data(r0,l0,w1,w3,w2) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w0,w1) if at(r0,w0),at_lander(l0,w1),have_soil_analysis(r0,w2),visible(w0,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w0,w1) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w0,w2) if at(r0,w0),at_lander(l0,w2),have_soil_analysis(r0,w2),visible(w0,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w0,w2) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w0,w3) if at(r0,w0),at_lander(l0,w3),have_soil_analysis(r0,w2),visible(w0,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w0,w3) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w1,w0) if at(r0,w1),at_lander(l0,w0),have_soil_analysis(r0,w2),visible(w1,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w1,w0) causes channel_free(l0),communicated_soil_data(w2), available(r0);

communicate_soil_data(r0,l0,w2,w1,w0) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w1,w2) if at(r0,w1),at_lander(l0,w2),have_soil_analysis(r0,w2),visible(w1,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w1,w2) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w1,w3) if at(r0,w1),at_lander(l0,w3),have_soil_analysis(r0,w2),visible(w1,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w1,w3) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w2,w0) if at(r0,w2),at_lander(l0,w0),have_soil_analysis(r0,w2),visible(w2,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w2,w0) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w2,w1) if at(r0,w2),at_lander(l0,w1),have_soil_analysis(r0,w2),visible(w2,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w2,w1) causes channel_free(l0),communicated_soil_data(w2), available(r0);

communicate_soil_data(r0,l0,w2,w2,w1) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w2,w3) if at(r0,w2),at_lander(l0,w3),have_soil_analysis(r0,w2),visible(w2,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w2,w3) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w3,w0) if at(r0,w3),at_lander(l0,w0),have_soil_analysis(r0,w2),visible(w3,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w3,w0) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w3,w1) if at(r0,w3),at_lander(l0,w1),have_soil_analysis(r0,w2),visible(w3,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w3,w1) causes channel_free(l0),communicated_soil_data(w2), available(r0);

executable communicate_soil_data(r0,l0,w2,w3,w2) if at(r0,w3),at_lander(l0,w2),have_soil_analysis(r0,w2),visible(w3,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w2,w3,w2) causes channel_free(l0),communicated_soil_data(w2), available(r0);

communicate_soil_data(r0,l0,w2,w3,w2) causes channel_free(l0),communicated_soil_data(w2), available(r0);

communicate_soil_data(r0,l0,w2,w3,w2) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w0,w1) if at(r0,w0),at_lander(l0,w1),have_soil_analysis(r0,w3),visible(w0,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w0,w1) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w0,w2) if at(r0,w0),at_lander(l0,w2),have_soil_analysis(r0,w3),visible(w0,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w0,w2) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w0,w3) if at(r0,w0),at_lander(l0,w3),have_soil_analysis(r0,w3),visible(w0,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w0,w3) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w1,w0) if at(r0,w1),at_lander(l0,w0),have_soil_analysis(r0,w3),visible(w1,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w1,w0) causes channel_free(l0),communicated_soil_data(w3), available(r0);

communicate_soil_data(r0,l0,w3,w1,w0) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w1,w2) if at(r0,w1),at_lander(l0,w2),have_soil_analysis(r0,w3),visible(w1,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w1,w2) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w1,w3) if at(r0,w1),at_lander(l0,w3),have_soil_analysis(r0,w3),visible(w1,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w1,w3) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w2,w0) if at(r0,w2),at_lander(l0,w0),have_soil_analysis(r0,w3),visible(w2,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w2,w0) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w2,w1) if at(r0,w2),at_lander(l0,w1),have_soil_analysis(r0,w3),visible(w2,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w2,w1) causes channel_free(l0),communicated_soil_data(w3), available(r0);

communicate_soil_data(r0,l0,w3,w2,w1) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w2,w3) if at(r0,w2),at_lander(l0,w3),have_soil_analysis(r0,w3),visible(w2,w3),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w2,w3) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w3,w0) if at(r0,w3),at_lander(l0,w0),have_soil_analysis(r0,w3),visible(w3,w0),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w3,w0) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w3,w1) if at(r0,w3),at_lander(l0,w1),have_soil_analysis(r0,w3),visible(w3,w1),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w3,w1) causes channel_free(l0),communicated_soil_data(w3), available(r0);

executable communicate_soil_data(r0,l0,w3,w3,w2) if at(r0,w3),at_lander(l0,w2),have_soil_analysis(r0,w3),visible(w3,w2),available(r0),channel_free(l0);
communicate_soil_data(r0,l0,w3,w3,w2) causes channel_free(l0),communicated_soil_data(w3), available(r0);

communicate_soil_data(r0,l0,w3,w3,w2) causes channel_free(l0),communicated_soil_data(w3), available(r0);


executable communicate_rock_data(r0,l0,w0,w0,w1) if at(r0,w0),at_lander(l0,w1),have_rock_analysis(r0,w0),visible(w0,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w0,w1) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w0,w2) if at(r0,w0),at_lander(l0,w2),have_rock_analysis(r0,w0),visible(w0,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w0,w2) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w0,w3) if at(r0,w0),at_lander(l0,w3),have_rock_analysis(r0,w0),visible(w0,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w0,w3) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w1,w0) if at(r0,w1),at_lander(l0,w0),have_rock_analysis(r0,w0),visible(w1,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w1,w0) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w1,w2) if at(r0,w1),at_lander(l0,w2),have_rock_analysis(r0,w0),visible(w1,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w1,w2) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w1,w3) if at(r0,w1),at_lander(l0,w3),have_rock_analysis(r0,w0),visible(w1,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w1,w3) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w2,w0) if at(r0,w2),at_lander(l0,w0),have_rock_analysis(r0,w0),visible(w2,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w2,w0) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w2,w1) if at(r0,w2),at_lander(l0,w1),have_rock_analysis(r0,w0),visible(w2,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w2,w1) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w2,w3) if at(r0,w2),at_lander(l0,w3),have_rock_analysis(r0,w0),visible(w2,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w2,w3) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w3,w0) if at(r0,w3),at_lander(l0,w0),have_rock_analysis(r0,w0),visible(w3,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w3,w0) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w3,w1) if at(r0,w3),at_lander(l0,w1),have_rock_analysis(r0,w0),visible(w3,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w3,w1) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w0,w3,w2) if at(r0,w3),at_lander(l0,w2),have_rock_analysis(r0,w0),visible(w3,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w0,w3,w2) causes channel_free(l0),communicated_rock_data(w0), available(r0);

executable communicate_rock_data(r0,l0,w1,w0,w1) if at(r0,w0),at_lander(l0,w1),have_rock_analysis(r0,w1),visible(w0,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w0,w1) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w0,w2) if at(r0,w0),at_lander(l0,w2),have_rock_analysis(r0,w1),visible(w0,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w0,w2) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w0,w3) if at(r0,w0),at_lander(l0,w3),have_rock_analysis(r0,w1),visible(w0,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w0,w3) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w1,w0) if at(r0,w1),at_lander(l0,w0),have_rock_analysis(r0,w1),visible(w1,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w1,w0) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w1,w2) if at(r0,w1),at_lander(l0,w2),have_rock_analysis(r0,w1),visible(w1,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w1,w2) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w1,w3) if at(r0,w1),at_lander(l0,w3),have_rock_analysis(r0,w1),visible(w1,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w1,w3) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w2,w0) if at(r0,w2),at_lander(l0,w0),have_rock_analysis(r0,w1),visible(w2,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w2,w0) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w2,w1) if at(r0,w2),at_lander(l0,w1),have_rock_analysis(r0,w1),visible(w2,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w2,w1) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w2,w3) if at(r0,w2),at_lander(l0,w3),have_rock_analysis(r0,w1),visible(w2,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w2,w3) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w3,w0) if at(r0,w3),at_lander(l0,w0),have_rock_analysis(r0,w1),visible(w3,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w3,w0) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w3,w1) if at(r0,w3),at_lander(l0,w1),have_rock_analysis(r0,w1),visible(w3,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w3,w1) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w1,w3,w2) if at(r0,w3),at_lander(l0,w2),have_rock_analysis(r0,w1),visible(w3,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w1,w3,w2) causes channel_free(l0),communicated_rock_data(w1), available(r0);

executable communicate_rock_data(r0,l0,w2,w0,w1) if at(r0,w0),at_lander(l0,w1),have_rock_analysis(r0,w2),visible(w0,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w0,w1) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w0,w2) if at(r0,w0),at_lander(l0,w2),have_rock_analysis(r0,w2),visible(w0,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w0,w2) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w0,w3) if at(r0,w0),at_lander(l0,w3),have_rock_analysis(r0,w2),visible(w0,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w0,w3) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w1,w0) if at(r0,w1),at_lander(l0,w0),have_rock_analysis(r0,w2),visible(w1,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w1,w0) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w1,w2) if at(r0,w1),at_lander(l0,w2),have_rock_analysis(r0,w2),visible(w1,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w1,w2) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w1,w3) if at(r0,w1),at_lander(l0,w3),have_rock_analysis(r0,w2),visible(w1,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w1,w3) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w2,w0) if at(r0,w2),at_lander(l0,w0),have_rock_analysis(r0,w2),visible(w2,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w2,w0) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w2,w1) if at(r0,w2),at_lander(l0,w1),have_rock_analysis(r0,w2),visible(w2,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w2,w1) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w2,w3) if at(r0,w2),at_lander(l0,w3),have_rock_analysis(r0,w2),visible(w2,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w2,w3) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w3,w0) if at(r0,w3),at_lander(l0,w0),have_rock_analysis(r0,w2),visible(w3,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w3,w0) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w3,w1) if at(r0,w3),at_lander(l0,w1),have_rock_analysis(r0,w2),visible(w3,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w3,w1) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w2,w3,w2) if at(r0,w3),at_lander(l0,w2),have_rock_analysis(r0,w2),visible(w3,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w2,w3,w2) causes channel_free(l0),communicated_rock_data(w2), available(r0);

executable communicate_rock_data(r0,l0,w3,w0,w1) if at(r0,w0),at_lander(l0,w1),have_rock_analysis(r0,w3),visible(w0,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w0,w1) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w0,w2) if at(r0,w0),at_lander(l0,w2),have_rock_analysis(r0,w3),visible(w0,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w0,w2) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w0,w3) if at(r0,w0),at_lander(l0,w3),have_rock_analysis(r0,w3),visible(w0,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w0,w3) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w1,w0) if at(r0,w1),at_lander(l0,w0),have_rock_analysis(r0,w3),visible(w1,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w1,w0) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w1,w2) if at(r0,w1),at_lander(l0,w2),have_rock_analysis(r0,w3),visible(w1,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w1,w2) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w1,w3) if at(r0,w1),at_lander(l0,w3),have_rock_analysis(r0,w3),visible(w1,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w1,w3) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w2,w0) if at(r0,w2),at_lander(l0,w0),have_rock_analysis(r0,w3),visible(w2,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w2,w0) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w2,w1) if at(r0,w2),at_lander(l0,w1),have_rock_analysis(r0,w3),visible(w2,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w2,w1) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w2,w3) if at(r0,w2),at_lander(l0,w3),have_rock_analysis(r0,w3),visible(w2,w3),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w2,w3) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w3,w0) if at(r0,w3),at_lander(l0,w0),have_rock_analysis(r0,w3),visible(w3,w0),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w3,w0) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w3,w1) if at(r0,w3),at_lander(l0,w1),have_rock_analysis(r0,w3),visible(w3,w1),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w3,w1) causes channel_free(l0),communicated_rock_data(w3), available(r0);

executable communicate_rock_data(r0,l0,w3,w3,w2) if at(r0,w3),at_lander(l0,w2),have_rock_analysis(r0,w3),visible(w3,w2),available(r0),channel_free(l0);
communicate_rock_data(r0,l0,w3,w3,w2) causes channel_free(l0),communicated_rock_data(w3), available(r0);


executable communicate_image_data(r0,l0,o0,m0,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o0,m0),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w0,w1) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o0,m0),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w0,w2) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o0,m0),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w0,w3) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o0,m0),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w1,w0) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o0,m0),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w1,w2) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o0,m0),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w1,w3) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o0,m0),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w2,w0) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o0,m0),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w2,w1) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o0,m0),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w2,w3) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o0,m0),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w3,w0) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o0,m0),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w3,w1) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m0,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o0,m0),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m0,w3,w2) causes channel_free(l0),communicated_image_data(o0,m0),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o0,m1),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w0,w1) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o0,m1),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w0,w2) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o0,m1),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w0,w3) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o0,m1),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w1,w0) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o0,m1),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w1,w2) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o0,m1),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w1,w3) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o0,m1),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w2,w0) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o0,m1),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w2,w1) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o0,m1),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w2,w3) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o0,m1),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w3,w0) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o0,m1),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w3,w1) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m1,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o0,m1),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m1,w3,w2) causes channel_free(l0),communicated_image_data(o0,m1),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o0,m2),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w0,w1) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o0,m2),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w0,w2) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o0,m2),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w0,w3) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o0,m2),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w1,w0) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o0,m2),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w1,w2) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o0,m2),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w1,w3) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o0,m2),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w2,w0) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o0,m2),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w2,w1) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o0,m2),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w2,w3) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o0,m2),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w3,w0) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o0,m2),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w3,w1) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o0,m2,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o0,m2),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o0,m2,w3,w2) causes channel_free(l0),communicated_image_data(o0,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o1,m0),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w0,w1) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o1,m0),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w0,w2) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o1,m0),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w0,w3) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o1,m0),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w1,w0) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o1,m0),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w1,w2) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o1,m0),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w1,w3) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o1,m0),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w2,w0) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o1,m0),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w2,w1) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o1,m0),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w2,w3) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o1,m0),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w3,w0) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o1,m0),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w3,w1) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m0,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o1,m0),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m0,w3,w2) causes channel_free(l0),communicated_image_data(o1,m0),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o1,m1),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w0,w1) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o1,m1),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w0,w2) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o1,m1),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w0,w3) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o1,m1),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w1,w0) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o1,m1),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w1,w2) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o1,m1),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w1,w3) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o1,m1),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w2,w0) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o1,m1),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w2,w1) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o1,m1),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w2,w3) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o1,m1),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w3,w0) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o1,m1),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w3,w1) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m1,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o1,m1),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m1,w3,w2) causes channel_free(l0),communicated_image_data(o1,m1),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w0,w1) if at(r0,w0),at_lander(l0,w1),have_image(r0,o1,m2),visible(w0,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w0,w1) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w0,w2) if at(r0,w0),at_lander(l0,w2),have_image(r0,o1,m2),visible(w0,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w0,w2) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w0,w3) if at(r0,w0),at_lander(l0,w3),have_image(r0,o1,m2),visible(w0,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w0,w3) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w1,w0) if at(r0,w1),at_lander(l0,w0),have_image(r0,o1,m2),visible(w1,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w1,w0) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w1,w2) if at(r0,w1),at_lander(l0,w2),have_image(r0,o1,m2),visible(w1,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w1,w2) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w1,w3) if at(r0,w1),at_lander(l0,w3),have_image(r0,o1,m2),visible(w1,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w1,w3) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w2,w0) if at(r0,w2),at_lander(l0,w0),have_image(r0,o1,m2),visible(w2,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w2,w0) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w2,w1) if at(r0,w2),at_lander(l0,w1),have_image(r0,o1,m2),visible(w2,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w2,w1) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w2,w3) if at(r0,w2),at_lander(l0,w3),have_image(r0,o1,m2),visible(w2,w3),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w2,w3) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w3,w0) if at(r0,w3),at_lander(l0,w0),have_image(r0,o1,m2),visible(w3,w0),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w3,w0) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w3,w1) if at(r0,w3),at_lander(l0,w1),have_image(r0,o1,m2),visible(w3,w1),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w3,w1) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);

executable communicate_image_data(r0,l0,o1,m2,w3,w2) if at(r0,w3),at_lander(l0,w2),have_image(r0,o1,m2),visible(w3,w2),available(r0),channel_free(l0);
communicate_image_data(r0,l0,o1,m2,w3,w2) causes channel_free(l0),communicated_image_data(o1,m2),available(r0);


-at(r0,w1) if at(r0,w0);
-at(r0,w2) if at(r0,w0);
-at(r0,w3) if at(r0,w0);

-at(r0,w0) if at(r0,w1);
-at(r0,w2) if at(r0,w1);
-at(r0,w3) if at(r0,w1);

-at(r0,w0) if at(r0,w2);
-at(r0,w1) if at(r0,w2);
-at(r0,w3) if at(r0,w2);

-at(r0,w0) if at(r0,w3);
-at(r0,w1) if at(r0,w3);
-at(r0,w2) if at(r0,w3);


visible(w1,w0) if visible(w0,w1);
visible(w2,w0) if visible(w0,w2);
visible(w3,w0) if visible(w0,w3);

visible(w0,w1) if visible(w1,w0);
visible(w2,w1) if visible(w1,w2);
visible(w3,w1) if visible(w1,w3);

visible(w0,w2) if visible(w2,w0);
visible(w1,w2) if visible(w2,w1);
visible(w3,w2) if visible(w2,w3);

visible(w0,w3) if visible(w3,w0);
visible(w1,w3) if visible(w3,w1);
visible(w2,w3) if visible(w3,w2);


% Init state
initially visible(w0,w1);
initially visible(w0,w2);
initially visible(w0,w3);
initially visible(w1,w2);
initially visible(w1,w3);
initially visible(w2,w3);

initially at_soil_sample(w0);
initially at_soil_sample(w2);
initially at_soil_sample(w3);
initially at_rock_sample(w1);
initially at_rock_sample(w2);
initially at_rock_sample(w3);

initially at_lander(l0,w0);
initially channel_free(l0);

initially at(r0,w3);
initially available(r0);
initially store_of(s0,r0);
initially empty(s0);

initially equipped_for_soil_analysis(r0);
initially equipped_for_rock_analysis(r0);
initially equipped_for_imaging(r0);

initially can_traverse(r0,w3,w0);
initially can_traverse(r0,w0,w3);
initially can_traverse(r0,w3,w1);
initially can_traverse(r0,w1,w3);
initially can_traverse(r0,w1,w2);
initially can_traverse(r0,w2,w1);

initially on_board(c0,r0);
initially calibration_target(c0,o0);
initially supports(c0,m0);
initially supports(c0,m1);

initially visible_from(o0,w0);
initially visible_from(o0,w1);
initially visible_from(o0,w2);
initially visible_from(o1,w3);
initially visible_from(o1,w0);
initially visible_from(o1,w1);
initially visible_from(o1,w2);
initially visible_from(o1,w3);

% goal 
goal communicated_soil_data(w2);
goal communicated_rock_data(w3);
goal communicated_image_data(o1,m1);
