#include <stdio.h>
#include <stdlib.h>

void rover(int n_rovers, int n_waypoints, int n_stores, int n_cameras,
	   int n_modes, int n_landers, int n_objectives);

int main(int argc, char** argv)
{
  int n_rovers = 1;
  int n_waypoints = 4;
  int n_stores = 1;
  int n_cameras = 1;
  int n_modes = 3;
  int n_landers = 1;
  int n_objectives = 2;

  if (argc != 8) {
    printf("Usage: %s #rovers #waypoints #stores #cameras\
#camera_modes #landers #objectives\n",argv[0]);
    exit(1);
  }

  n_rovers = atoi(argv[1]);
  n_waypoints = atoi(argv[2]);
  n_stores = atoi(argv[3]);
  n_cameras = atoi(argv[4]);
  n_modes = atoi(argv[5]);
  n_landers = atoi(argv[6]);
  n_objectives = atoi(argv[7]);

  rover(n_rovers,n_waypoints,n_stores,n_cameras,
	n_modes,n_landers,n_objectives);

  exit(0);
}

void rover(int n_rovers, int n_waypoints, int n_stores, int n_cameras,
	   int n_modes, int n_landers, int n_objectives)
{
  int r,w,s,c,m,l,o;
  int w1,w2;
  char temp[100];

  printf("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
  printf("%% Rover domain - Problem rover_%d_%d_%d_%d_%d_%d\n",
	 n_rovers,n_waypoints,n_stores,n_cameras,
	 n_modes,n_landers,n_objectives);
  printf("%%\tn_rovers = %d, n_waypoints = %d, n_stores = %d,\
 n_cameras = %d\n",
	 n_rovers,n_waypoints,n_stores,n_cameras);
  printf("%%\tn_modes = %d, n_landers = %d, n_objectives = %d\n",
	 n_modes,n_landers,n_objectives);
  printf("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");  
  // fluents
  // 1. fluent at(rover,waypoint)
  printf("fluent \n");

  for (r = 0; r < n_rovers; r++) {
    for (w = 0; w < n_waypoints; w++) {
      if (w != n_waypoints-1 || r != n_rovers-1)
	printf("\tat(r%d,w%d),\n",r,w);
      else
	printf("\tat(r%d,w%d);\n",r,w);
    }
  }

  // 2. fluent at_lander(lander,waypoint)
  printf("fluent \n");

  for (l = 0; l < n_landers; l++) {
    for (w = 0; w < n_waypoints; w++) {
      if (w != n_waypoints-1 || l != n_landers-1)
	printf("\tat_lander(l%d,w%d),\n",l,w);
      else
	printf("\tat_lander(l%d,w%d);\n",l,w);
    }
  }

  // 3. fluent can_traverse(rover,waypoint1,waypoint2)
  printf("fluent \n");

  for (r = 0; r < n_rovers; r++) {
    for (w1 = 0; w1 < n_waypoints; w1++) {
      for (w2 = 0; w2 < n_waypoints; w2++) {
	if (w1 | w2) {
	if (w1 != n_waypoints-1 || w2 != n_waypoints-1 || r != n_rovers-1)
	  printf("\tcan_traverse(r%d,w%d,w%d),\n",r,w1,w2);
	else
	  printf("\tcan_traverse(r%d,w%d,w%d);\n",r,w1,w2);
	}
      }
    }
  }

  // 4. fluent available(rover)
  // 5. fluent have_rock_analysis(rover,waypoint)
  // 6. fluent have_soil_analysis(rover,waypoint)
  // 7. fluent equipped_for_soil_analysis(rover)
  // 8. fluent equipped_for_rock_analysis(rover)
  // 9. fluent equipped_for_imaging(rover)


  for (r = 0; r < n_rovers; r++) {
      printf("\tfluent available(r%d);\n",r);
      printf("\tfluent equipped_for_soil_analysis(r%d);\n",r);
      printf("\tfluent equipped_for_imaging(r%d);\n",r);
      printf("\tfluent equipped_for_rock_analysis(r%d);\n",r);

      for (w = 0; w < n_waypoints; w++) {
	printf("\tfluent have_rock_analysis(r%d,w%d);\n",r,w);
	printf("\tfluent have_soil_analysis(r%d,w%d);\n",r,w);
      }

  }

  // 10. fluent communicated_soil_data(w)
  // 11. fluent communicated_rock_data(w)
  for (w = 0; w < n_waypoints; w++) {
    printf("fluent communicated_soil_data(w%d),communicated_rock_data(w%d);\n",w,w);
  }
  
  // 12. fluent full(store)
  // 13. fluent empty(store)
  printf("fluent\n");
  for (s = 0; s < n_stores; s++) {
    if (s != n_stores-1) {
      printf("\tempty(s%d),\n",s);      
      printf("\tfull(s%d),\n",s);    
    }
    else {
      printf("\tempty(s%d),\n",s);      
      printf("\tfull(s%d);\n",s);    
    }
  }

  // 14. fluent supports(camera,mode)
  printf("fluent\n");
  for (c = 0; c < n_cameras; c++) {
    for (m = 0; m < n_modes; m++) {
      if (m != n_modes-1 || c != n_cameras-1) 
	printf("\tsupports(c%d,m%d),\n",c,m);  	
      else
	printf("\tsupports(c%d,m%d);\n",c,m);  	
    }
  }

  // 15. fluent calibrated(camera,rover)
  printf("fluent\n");
  for (c = 0; c < n_cameras; c++) 
    for (r = 0; r < n_rovers; r++)
      if (c+r != n_cameras+n_rovers-2) 
	printf("\tcalibrated(c%d,r%d),\n",c,r); 
      else
	printf("\tcalibrated(c%d,r%d);\n",c,r); 

  // 16. fluent visible(waypoint,waypoint)
  for (w1 = 0; w1 < n_waypoints; w1++)
    for (w2 = 0; w2 < n_waypoints; w2++)
      if (w1 != w2) {
	  printf("\tfluent visible(w%d,w%d);\n",w1,w2);
      }

  // 17. fluent have_image(rover,objective,mode)
  printf("fluent\n");
  for (r = 0; r < n_rovers; r++)
    for (o = 0; o < n_objectives; o++)
      for (m = 0; m < n_modes; m++)
	if (r+o+m != n_rovers+n_objectives+n_modes-3)
	  printf("\thave_image(r%d,o%d,m%d),\n",r,o,m); 
	else
	  printf("\thave_image(r%d,o%d,m%d);\n",r,o,m); 

  // 18. fluent communicated(objective,mode)
  printf("fluent\n");
  for (o = 0; o < n_objectives; o++)
    for (m = 0; m < n_modes; m++)
      if (o+m != n_objectives+n_modes-2)
	printf("\tcommunicated_image_data(o%d,m%d),\n",o,m); 
      else
	printf("\tcommunicated_image_data(o%d,m%d);\n",o,m); 

  // 19. fluent at_soil_sample(waypoint)
  // 20. fluent at_rock_sample(waypoint)
  printf("fluent\n");
  for (w = 0; w < n_waypoints; w++) {
    if (w != n_waypoints-1) {
      printf("\tat_soil_sample(w%d),\n",w);
      printf("\tat_rock_sample(w%d),\n",w);
    }
    else {
      printf("\tat_soil_sample(w%d),\n",w);
      printf("\tat_rock_sample(w%d);\n",w);
    }
  }

  // 21. fluent visible_from(objective,waypoint)
  printf("fluent\n");
  for (o = 0; o < n_objectives; o++) 
    for (w = 0; w < n_waypoints; w++)
      if (o+w != n_objectives+n_waypoints-2)
	printf("\tvisible_from(o%d,w%d),\n",o,w);       
      else
	printf("\tvisible_from(o%d,w%d);\n",o,w);     

  // 22. fluent store_of(store,rover)
  printf("fluent\n");
  for (s = 0; s < n_stores; s++)
    for (r = 0; r < n_rovers; r++) 
      if (s+r != n_stores+n_rovers-2)
	printf("\tstore_of(s%d,r%d),\n",s,r);       
      else
	printf("\tstore_of(s%d,r%d);\n",s,r);      

  // 23. fluent calibration_target(camera,objective)
  printf("fluent\n");
  for (c = 0; c < n_cameras; c++) 
    for (o = 0; o < n_objectives; o++)
      if (c+o != n_cameras+n_objectives-2)
	printf("\tcalibration_target(c%d,o%d),\n",c,o);       
      else
	printf("\tcalibration_target(c%d,o%d);\n",c,o);    

  // 24. fluent on_board(camera,rover)
  printf("fluent\n");
  for (c = 0; c < n_cameras; c++) 
    for (r = 0; r < n_rovers; r++) 
      if (c+r != n_cameras+n_rovers-2)
	printf("\ton_board(c%d,r%d),\n",c,r);       
      else
	printf("\ton_board(c%d,r%d);\n",c,r);  

  // 25. fluent channel_free(lander)
  printf("fluent\n");
  for (l = 0; l < n_landers; l++) {
    if (l != n_landers-1) 
      printf("\tchannel_free(l%d),\n",l);
    else
      printf("\tchannel_free(l%d);\n",l);
  }

  // actions

  // 1. Action navigate(r,w1,w2) 
  //      Precondition: can_traverse(r,w1,w2), available(r),
  //                    at(r,w1)   visible(w1,w2)
  //      Effect: at(r,w2)
  printf("\n");
  for (r = 0; r < n_rovers; r++) 
    for (w1 = 0; w1 < n_waypoints; w1++)
      for (w2 = 0; w2 < n_waypoints; w2++) {	
	if (w1 != w2) {
	sprintf(temp,"navigate(r%d,w%d,w%d)",r,w1,w2);

	// executability
	printf("executable %s if can_traverse(r%d,w%d,w%d),\
at(r%d,w%d),visible(w%d,w%d);\n",temp,r,w1,w2,r,w1,w1,w2);

	// effect
	printf("%s causes at(r%d,w%d);\n\n",temp,r,w2,r,w1);
	}
      }

  // 2. Action sample_soil(r,s,w): takes a soil sample at
  // waypoint w
  //   precondition: at(r,w), at_soil_sample(w),
  //        equipped_for_soil_analysis(r), store_of(s,r),
  //        empty(s)
  printf("\n");
  for (r = 0; r < n_rovers; r++) 
    for (w = 0; w < n_waypoints; w++)
      for (s = 0; s < n_stores; s++) {  
	sprintf(temp,"sample_soil(r%d,s%d,w%d)",r,s,w);

	// executability
	printf("executable %s if at(r%d,w%d),at_soil_sample(w%d),\
equipped_for_soil_analysis(r%d),store_of(s%d,r%d),empty(s%d);\n",
	       temp,r,w,w,r,s,r,s);

	// effect
	printf("%s causes -empty(s%d),full(s%d),\
have_soil_analysis(r%d,w%d),-at_soil_sample(w%d);\n\n",
	       temp,s,s,r,w,w);	
      }

  // 3. Action sample_rock(r,s,w): takes a rock sample at
  // waypoint w
  //   precondition: at(r,w), at_rock_sample(w),
  //        equipped_for_rock_analysis(r), store_of(s,r),
  //        empty(s)
  printf("\n");
  for (r = 0; r < n_rovers; r++) 
    for (w = 0; w < n_waypoints; w++)
      for (s = 0; s < n_stores; s++) {  
	sprintf(temp,"sample_rock(r%d,s%d,w%d)",r,s,w);

	// executability
	printf("executable %s if at(r%d,w%d),at_rock_sample(w%d),\
equipped_for_rock_analysis(r%d),store_of(s%d,r%d),empty(s%d);\n",
	       temp,r,w,w,r,s,r,s);

	// effect
	printf("%s causes -empty(s%d),full(s%d),\
have_rock_analysis(r%d,w%d),-at_rock_sample(w%d);\n\n",
	       temp,s,s,r,w,w);	
      }

  // 4. Action drop:
  printf("\n");
  for (r = 0; r < n_rovers; r++) 
    for (s = 0; s < n_stores; s++) { 
      sprintf(temp,"drop(r%d,s%d)",r,s);	

      // executability
      printf("executable %s if store_of(s%d,r%d), full(s%d);\n",
	     temp,s,r,s);

      printf("%s causes -full(s%d), empty(s%d);\n\n",
	     temp,s,s);

    }

  // 5. Action calibrate
  printf("\n");
  for (r = 0; r < n_rovers; r++)
    for (c = 0; c < n_cameras; c++) 
      for (o = 0; o < n_objectives; o++)
	for (w = 0; w < n_waypoints; w++) {
	  sprintf(temp,"calibrate(r%d,c%d,o%d,w%d)",r,c,o,w);	

	  // executability
	  printf("executable %s if equipped_for_imaging(r%d),\
calibration_target(c%d,o%d),at(r%d,w%d),visible_from(o%d,w%d),\
on_board(c%d,r%d);\n",temp,r,c,o,r,w,o,w,c,r);

	  printf("%s causes calibrated(c%d,r%d);\n\n",
		 temp,c,r);	   
	}

  // 6. Action take_image(r,w,o,c,m)
  printf("\n");
  for (r = 0; r < n_rovers; r++)
    for (w = 0; w < n_waypoints; w++)
      for (o = 0; o < n_objectives; o++)
	for (c = 0; c < n_cameras; c++) 
	  for (m = 0; m < n_modes; m++)
	    {
	      sprintf(temp,"take_image(r%d,w%d,o%d,c%d,m%d)",r,w,o,c,m);
	      
	      // executability
	      printf("executable %s if calibrated(c%d,r%d),\
on_board(c%d,r%d), equipped_for_imaging(r%d),supports(c%d,m%d),\
visible_from(o%d,w%d);\n",temp,c,r,c,r,r,c,m,o,w);

	      // effect
	      printf("%s causes have_image(r%d,o%d,m%d),\
-calibrated(c%d,r%d);\n\n",temp,r,o,m,c,r);
	    }  

  // 7. Action communicate_soil_data(r,l,w,w1,w2)
  printf("\n");
  for (r = 0; r < n_rovers; r++)
    for (l = 0; l < n_landers; l++) 
      for (w = 0; w < n_waypoints; w++)
	for (w1 = 0; w1 < n_waypoints; w1++)
	  for (w2 = 0; w2 < n_waypoints; w2++) {
	    // action
	    if (w1 != w2) {
	    sprintf(temp,
		    "communicate_soil_data(r%d,l%d,w%d,w%d,w%d)",
		    r,l,w,w1,w2);

	    // executable communicate_soil_data(r,l,w,w1,w2) if
	    // at(r,w1), at_lander(l,w2), 
	    // has_soil_analysis(r,w), visible(w1,w2), 
	    // available(r), channel_free(l)
	    printf("executable %s if at(r%d,w%d),\
at_lander(l%d,w%d),have_soil_analysis(r%d,w%d),visible(w%d,w%d),\
available(r%d),channel_free(l%d);\n",
		   temp,
		   r,w1,l,w2,
		   r,w,w1,w2,r,l);
	    }
	    // effect
	    printf("%s causes channel_free(l%d),\
communicated_soil_data(w%d), available(r%d);\n\n",temp,l,w,r);
	  }

  // 8. Action communicate_rock_data(r,l,w,w1,w2)
  printf("\n");
  for (r = 0; r < n_rovers; r++)
    for (l = 0; l < n_landers; l++) 
      for (w = 0; w < n_waypoints; w++)
	for (w1 = 0; w1 < n_waypoints; w1++)
	  for (w2 = 0; w2 < n_waypoints; w2++) {
	    if (w1 != w2) {
	    // action
	    sprintf(temp,
		    "communicate_rock_data(r%d,l%d,w%d,w%d,w%d)",
		    r,l,w,w1,w2);

	    // executability
	    printf("executable %s if at(r%d,w%d),\
at_lander(l%d,w%d),have_rock_analysis(r%d,w%d),visible(w%d,w%d),\
available(r%d),channel_free(l%d);\n",temp,r,w1,l,w2,r,w,w1,w2,r,l);

	    // effect
	    printf("%s causes channel_free(l%d),\
communicated_rock_data(w%d), available(r%d);\n\n",temp,l,w,r);
	    }
	  }

  // 9. Action communicate_image_data(r,l,o,m,w1,w2)
  printf("\n");
  for (r = 0; r < n_rovers; r++)
    for (l = 0; l < n_landers; l++) 
      for (o = 0; o < n_objectives; o++)
	for (m = 0; m < n_modes; m++)
	  for (w1 = 0; w1 < n_waypoints; w1++)
	    for (w2 = 0; w2 < n_waypoints; w2++) {
	      if (w1 != w2) {
	      sprintf(temp,
		      "communicate_image_data(r%d,l%d,o%d,m%d,w%d,w%d)",
		      r,l,o,m,w1,w2);
	      
	      // executability
	      printf("executable %s if at(r%d,w%d),\
at_lander(l%d,w%d),have_image(r%d,o%d,m%d),\
visible(w%d,w%d),available(r%d),channel_free(l%d);\n",
		     temp,r,w1,l,w2,r,o,m,w1,w2,r,l);

	      // effect

	      printf("%s causes channel_free(l%d),\
communicated_image_data(o%d,m%d),available(r%d);\n\n",
		     temp,l,o,m,r);
	      }
	    }  
  
  
  // static laws
  printf("\n");
  for (r = 0; r < n_rovers; r++)
    for (w1 = 0; w1 < n_waypoints; w1++) {
      for (w2 = 0; w2 < n_waypoints; w2++) {	  
	if (w1 != w2)
	  printf("-at(r%d,w%d) if at(r%d,w%d);\n",
		 r,w2,r,w1);
      }
      printf("\n");
    }

  // visible(w2,w1) if visible(w1,w2);
  printf("\n");
  for (w1 = 0; w1 < n_waypoints; w1++) {
    for (w2 = 0; w2 < n_waypoints; w2++) {	  
      if (w1 != w2)
	printf("visible(w%d,w%d) if visible(w%d,w%d);\n",
	       w2,w1,w1,w2);
    }
    printf("\n");
  }
  printf("\n");
}
