%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% BLOCKS WORLD DOMAIN
%
%   INITIAL STATE       GOAL STATE
%
%
%   3       8           8       6
%   4   5   7           4   3   1
%   1   2   6           5   7   2
%   --------------    ---------------
%
% A possible conformant plan is:
%     move_3_table  move_5_table  move_4_5  move_8_4
%     move_1_2      move_7_table  move_3_7  move_6_1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fluent occupied_1, occupied_2, occupied_3, occupied_4, occupied_5;
fluent occupied_6, occupied_7, occupied_8;

fluent
	on_1_table,
	on_1_2,
	on_1_3,
	on_1_4,
	on_1_5,
	on_1_6,
	on_1_7,
	on_1_8,
	on_2_table,
	on_2_1,
	on_2_3,
	on_2_4,
	on_2_5,
	on_2_6,
	on_2_7,
	on_2_8,
	on_3_table,
	on_3_1,
	on_3_2,
	on_3_4,
	on_3_5,
	on_3_6,
	on_3_7,
	on_3_8,
	on_4_table,
	on_4_1,
	on_4_2,
	on_4_3,
	on_4_5,
	on_4_6,
	on_4_7,
	on_4_8,
	on_5_table,
	on_5_1,
	on_5_2,
	on_5_3,
	on_5_4,
	on_5_6,
	on_5_7,
	on_5_8,
	on_6_table,
	on_6_1,
	on_6_2,
	on_6_3,
	on_6_4,
	on_6_5,
	on_6_7,
	on_6_8,
	on_7_table,
	on_7_1,
	on_7_2,
	on_7_3,
	on_7_4,
	on_7_5,
	on_7_6,
	on_7_8,
	on_8_table,
	on_8_1,
	on_8_2,
	on_8_3,
	on_8_4,
	on_8_5,
	on_8_6,
	on_8_7;

action
	move_1_table,
	move_1_2,
	move_1_3,
	move_1_4,
	move_1_5,
	move_1_6,
	move_1_7,
	move_1_8,
	move_2_table,
	move_2_1,
	move_2_3,
	move_2_4,
	move_2_5,
	move_2_6,
	move_2_7,
	move_2_8,
	move_3_table,
	move_3_1,
	move_3_2,
	move_3_4,
	move_3_5,
	move_3_6,
	move_3_7,
	move_3_8,
	move_4_table,
	move_4_1,
	move_4_2,
	move_4_3,
	move_4_5,
	move_4_6,
	move_4_7,
	move_4_8,
	move_5_table,
	move_5_1,
	move_5_2,
	move_5_3,
	move_5_4,
	move_5_6,
	move_5_7,
	move_5_8,
	move_6_table,
	move_6_1,
	move_6_2,
	move_6_3,
	move_6_4,
	move_6_5,
	move_6_7,
	move_6_8,
	move_7_table,
	move_7_1,
	move_7_2,
	move_7_3,
	move_7_4,
	move_7_5,
	move_7_6,
	move_7_8,
	move_8_table,
	move_8_1,
	move_8_2,
	move_8_3,
	move_8_4,
	move_8_5,
	move_8_6,
	move_8_7;

executable move_1_table if -occupied_1;
move_1_table causes on_1_table;
move_1_table causes -occupied_2 if on_1_2;
move_1_table causes -occupied_3 if on_1_3;
move_1_table causes -occupied_4 if on_1_4;
move_1_table causes -occupied_5 if on_1_5;
move_1_table causes -occupied_6 if on_1_6;
move_1_table causes -occupied_7 if on_1_7;
move_1_table causes -occupied_8 if on_1_8;


executable move_1_2 if -occupied_1, -occupied_2;
move_1_2 causes on_1_2;
move_1_2 causes -occupied_3 if on_1_3;
move_1_2 causes -occupied_4 if on_1_4;
move_1_2 causes -occupied_5 if on_1_5;
move_1_2 causes -occupied_6 if on_1_6;
move_1_2 causes -occupied_7 if on_1_7;
move_1_2 causes -occupied_8 if on_1_8;

executable move_1_3 if -occupied_1, -occupied_3;
move_1_3 causes on_1_3;
move_1_3 causes -occupied_2 if on_1_2;
move_1_3 causes -occupied_4 if on_1_4;
move_1_3 causes -occupied_5 if on_1_5;
move_1_3 causes -occupied_6 if on_1_6;
move_1_3 causes -occupied_7 if on_1_7;
move_1_3 causes -occupied_8 if on_1_8;

executable move_1_4 if -occupied_1, -occupied_4;
move_1_4 causes on_1_4;
move_1_4 causes -occupied_2 if on_1_2;
move_1_4 causes -occupied_3 if on_1_3;
move_1_4 causes -occupied_5 if on_1_5;
move_1_4 causes -occupied_6 if on_1_6;
move_1_4 causes -occupied_7 if on_1_7;
move_1_4 causes -occupied_8 if on_1_8;

executable move_1_5 if -occupied_1, -occupied_5;
move_1_5 causes on_1_5;
move_1_5 causes -occupied_2 if on_1_2;
move_1_5 causes -occupied_3 if on_1_3;
move_1_5 causes -occupied_4 if on_1_4;
move_1_5 causes -occupied_6 if on_1_6;
move_1_5 causes -occupied_7 if on_1_7;
move_1_5 causes -occupied_8 if on_1_8;

executable move_1_6 if -occupied_1, -occupied_6;
move_1_6 causes on_1_6;
move_1_6 causes -occupied_2 if on_1_2;
move_1_6 causes -occupied_3 if on_1_3;
move_1_6 causes -occupied_4 if on_1_4;
move_1_6 causes -occupied_5 if on_1_5;
move_1_6 causes -occupied_7 if on_1_7;
move_1_6 causes -occupied_8 if on_1_8;

executable move_1_7 if -occupied_1, -occupied_7;
move_1_7 causes on_1_7;
move_1_7 causes -occupied_2 if on_1_2;
move_1_7 causes -occupied_3 if on_1_3;
move_1_7 causes -occupied_4 if on_1_4;
move_1_7 causes -occupied_5 if on_1_5;
move_1_7 causes -occupied_6 if on_1_6;
move_1_7 causes -occupied_8 if on_1_8;

executable move_1_8 if -occupied_1, -occupied_8;
move_1_8 causes on_1_8;
move_1_8 causes -occupied_2 if on_1_2;
move_1_8 causes -occupied_3 if on_1_3;
move_1_8 causes -occupied_4 if on_1_4;
move_1_8 causes -occupied_5 if on_1_5;
move_1_8 causes -occupied_6 if on_1_6;
move_1_8 causes -occupied_7 if on_1_7;

executable move_2_table if -occupied_2;
move_2_table causes on_2_table;
move_2_table causes -occupied_1 if on_2_1;
move_2_table causes -occupied_3 if on_2_3;
move_2_table causes -occupied_4 if on_2_4;
move_2_table causes -occupied_5 if on_2_5;
move_2_table causes -occupied_6 if on_2_6;
move_2_table causes -occupied_7 if on_2_7;
move_2_table causes -occupied_8 if on_2_8;

executable move_2_1 if -occupied_2, -occupied_1;
move_2_1 causes on_2_1;
move_2_1 causes -occupied_3 if on_2_3;
move_2_1 causes -occupied_4 if on_2_4;
move_2_1 causes -occupied_5 if on_2_5;
move_2_1 causes -occupied_6 if on_2_6;
move_2_1 causes -occupied_7 if on_2_7;
move_2_1 causes -occupied_8 if on_2_8;


executable move_2_3 if -occupied_2, -occupied_3;
move_2_3 causes on_2_3;
move_2_3 causes -occupied_1 if on_2_1;
move_2_3 causes -occupied_4 if on_2_4;
move_2_3 causes -occupied_5 if on_2_5;
move_2_3 causes -occupied_6 if on_2_6;
move_2_3 causes -occupied_7 if on_2_7;
move_2_3 causes -occupied_8 if on_2_8;

executable move_2_4 if -occupied_2, -occupied_4;
move_2_4 causes on_2_4;
move_2_4 causes -occupied_1 if on_2_1;
move_2_4 causes -occupied_3 if on_2_3;
move_2_4 causes -occupied_5 if on_2_5;
move_2_4 causes -occupied_6 if on_2_6;
move_2_4 causes -occupied_7 if on_2_7;
move_2_4 causes -occupied_8 if on_2_8;

executable move_2_5 if -occupied_2, -occupied_5;
move_2_5 causes on_2_5;
move_2_5 causes -occupied_1 if on_2_1;
move_2_5 causes -occupied_3 if on_2_3;
move_2_5 causes -occupied_4 if on_2_4;
move_2_5 causes -occupied_6 if on_2_6;
move_2_5 causes -occupied_7 if on_2_7;
move_2_5 causes -occupied_8 if on_2_8;

executable move_2_6 if -occupied_2, -occupied_6;
move_2_6 causes on_2_6;
move_2_6 causes -occupied_1 if on_2_1;
move_2_6 causes -occupied_3 if on_2_3;
move_2_6 causes -occupied_4 if on_2_4;
move_2_6 causes -occupied_5 if on_2_5;
move_2_6 causes -occupied_7 if on_2_7;
move_2_6 causes -occupied_8 if on_2_8;

executable move_2_7 if -occupied_2, -occupied_7;
move_2_7 causes on_2_7;
move_2_7 causes -occupied_1 if on_2_1;
move_2_7 causes -occupied_3 if on_2_3;
move_2_7 causes -occupied_4 if on_2_4;
move_2_7 causes -occupied_5 if on_2_5;
move_2_7 causes -occupied_6 if on_2_6;
move_2_7 causes -occupied_8 if on_2_8;

executable move_2_8 if -occupied_2, -occupied_8;
move_2_8 causes on_2_8;
move_2_8 causes -occupied_1 if on_2_1;
move_2_8 causes -occupied_3 if on_2_3;
move_2_8 causes -occupied_4 if on_2_4;
move_2_8 causes -occupied_5 if on_2_5;
move_2_8 causes -occupied_6 if on_2_6;
move_2_8 causes -occupied_7 if on_2_7;

executable move_3_table if -occupied_3;
move_3_table causes on_3_table;
move_3_table causes -occupied_1 if on_3_1;
move_3_table causes -occupied_2 if on_3_2;
move_3_table causes -occupied_4 if on_3_4;
move_3_table causes -occupied_5 if on_3_5;
move_3_table causes -occupied_6 if on_3_6;
move_3_table causes -occupied_7 if on_3_7;
move_3_table causes -occupied_8 if on_3_8;

executable move_3_1 if -occupied_3, -occupied_1;
move_3_1 causes on_3_1;
move_3_1 causes -occupied_2 if on_3_2;
move_3_1 causes -occupied_4 if on_3_4;
move_3_1 causes -occupied_5 if on_3_5;
move_3_1 causes -occupied_6 if on_3_6;
move_3_1 causes -occupied_7 if on_3_7;
move_3_1 causes -occupied_8 if on_3_8;

executable move_3_2 if -occupied_3, -occupied_2;
move_3_2 causes on_3_2;
move_3_2 causes -occupied_1 if on_3_1;
move_3_2 causes -occupied_4 if on_3_4;
move_3_2 causes -occupied_5 if on_3_5;
move_3_2 causes -occupied_6 if on_3_6;
move_3_2 causes -occupied_7 if on_3_7;
move_3_2 causes -occupied_8 if on_3_8;


executable move_3_4 if -occupied_3, -occupied_4;
move_3_4 causes on_3_4;
move_3_4 causes -occupied_1 if on_3_1;
move_3_4 causes -occupied_2 if on_3_2;
move_3_4 causes -occupied_5 if on_3_5;
move_3_4 causes -occupied_6 if on_3_6;
move_3_4 causes -occupied_7 if on_3_7;
move_3_4 causes -occupied_8 if on_3_8;

executable move_3_5 if -occupied_3, -occupied_5;
move_3_5 causes on_3_5;
move_3_5 causes -occupied_1 if on_3_1;
move_3_5 causes -occupied_2 if on_3_2;
move_3_5 causes -occupied_4 if on_3_4;
move_3_5 causes -occupied_6 if on_3_6;
move_3_5 causes -occupied_7 if on_3_7;
move_3_5 causes -occupied_8 if on_3_8;

executable move_3_6 if -occupied_3, -occupied_6;
move_3_6 causes on_3_6;
move_3_6 causes -occupied_1 if on_3_1;
move_3_6 causes -occupied_2 if on_3_2;
move_3_6 causes -occupied_4 if on_3_4;
move_3_6 causes -occupied_5 if on_3_5;
move_3_6 causes -occupied_7 if on_3_7;
move_3_6 causes -occupied_8 if on_3_8;

executable move_3_7 if -occupied_3, -occupied_7;
move_3_7 causes on_3_7;
move_3_7 causes -occupied_1 if on_3_1;
move_3_7 causes -occupied_2 if on_3_2;
move_3_7 causes -occupied_4 if on_3_4;
move_3_7 causes -occupied_5 if on_3_5;
move_3_7 causes -occupied_6 if on_3_6;
move_3_7 causes -occupied_8 if on_3_8;

executable move_3_8 if -occupied_3, -occupied_8;
move_3_8 causes on_3_8;
move_3_8 causes -occupied_1 if on_3_1;
move_3_8 causes -occupied_2 if on_3_2;
move_3_8 causes -occupied_4 if on_3_4;
move_3_8 causes -occupied_5 if on_3_5;
move_3_8 causes -occupied_6 if on_3_6;
move_3_8 causes -occupied_7 if on_3_7;

executable move_4_table if -occupied_4;
move_4_table causes on_4_table;
move_4_table causes -occupied_1 if on_4_1;
move_4_table causes -occupied_2 if on_4_2;
move_4_table causes -occupied_3 if on_4_3;
move_4_table causes -occupied_5 if on_4_5;
move_4_table causes -occupied_6 if on_4_6;
move_4_table causes -occupied_7 if on_4_7;
move_4_table causes -occupied_8 if on_4_8;

executable move_4_1 if -occupied_4, -occupied_1;
move_4_1 causes on_4_1;
move_4_1 causes -occupied_2 if on_4_2;
move_4_1 causes -occupied_3 if on_4_3;
move_4_1 causes -occupied_5 if on_4_5;
move_4_1 causes -occupied_6 if on_4_6;
move_4_1 causes -occupied_7 if on_4_7;
move_4_1 causes -occupied_8 if on_4_8;

executable move_4_2 if -occupied_4, -occupied_2;
move_4_2 causes on_4_2;
move_4_2 causes -occupied_1 if on_4_1;
move_4_2 causes -occupied_3 if on_4_3;
move_4_2 causes -occupied_5 if on_4_5;
move_4_2 causes -occupied_6 if on_4_6;
move_4_2 causes -occupied_7 if on_4_7;
move_4_2 causes -occupied_8 if on_4_8;

executable move_4_3 if -occupied_4, -occupied_3;
move_4_3 causes on_4_3;
move_4_3 causes -occupied_1 if on_4_1;
move_4_3 causes -occupied_2 if on_4_2;
move_4_3 causes -occupied_5 if on_4_5;
move_4_3 causes -occupied_6 if on_4_6;
move_4_3 causes -occupied_7 if on_4_7;
move_4_3 causes -occupied_8 if on_4_8;


executable move_4_5 if -occupied_4, -occupied_5;
move_4_5 causes on_4_5;
move_4_5 causes -occupied_1 if on_4_1;
move_4_5 causes -occupied_2 if on_4_2;
move_4_5 causes -occupied_3 if on_4_3;
move_4_5 causes -occupied_6 if on_4_6;
move_4_5 causes -occupied_7 if on_4_7;
move_4_5 causes -occupied_8 if on_4_8;

executable move_4_6 if -occupied_4, -occupied_6;
move_4_6 causes on_4_6;
move_4_6 causes -occupied_1 if on_4_1;
move_4_6 causes -occupied_2 if on_4_2;
move_4_6 causes -occupied_3 if on_4_3;
move_4_6 causes -occupied_5 if on_4_5;
move_4_6 causes -occupied_7 if on_4_7;
move_4_6 causes -occupied_8 if on_4_8;

executable move_4_7 if -occupied_4, -occupied_7;
move_4_7 causes on_4_7;
move_4_7 causes -occupied_1 if on_4_1;
move_4_7 causes -occupied_2 if on_4_2;
move_4_7 causes -occupied_3 if on_4_3;
move_4_7 causes -occupied_5 if on_4_5;
move_4_7 causes -occupied_6 if on_4_6;
move_4_7 causes -occupied_8 if on_4_8;

executable move_4_8 if -occupied_4, -occupied_8;
move_4_8 causes on_4_8;
move_4_8 causes -occupied_1 if on_4_1;
move_4_8 causes -occupied_2 if on_4_2;
move_4_8 causes -occupied_3 if on_4_3;
move_4_8 causes -occupied_5 if on_4_5;
move_4_8 causes -occupied_6 if on_4_6;
move_4_8 causes -occupied_7 if on_4_7;

executable move_5_table if -occupied_5;
move_5_table causes on_5_table;
move_5_table causes -occupied_1 if on_5_1;
move_5_table causes -occupied_2 if on_5_2;
move_5_table causes -occupied_3 if on_5_3;
move_5_table causes -occupied_4 if on_5_4;
move_5_table causes -occupied_6 if on_5_6;
move_5_table causes -occupied_7 if on_5_7;
move_5_table causes -occupied_8 if on_5_8;

executable move_5_1 if -occupied_5, -occupied_1;
move_5_1 causes on_5_1;
move_5_1 causes -occupied_2 if on_5_2;
move_5_1 causes -occupied_3 if on_5_3;
move_5_1 causes -occupied_4 if on_5_4;
move_5_1 causes -occupied_6 if on_5_6;
move_5_1 causes -occupied_7 if on_5_7;
move_5_1 causes -occupied_8 if on_5_8;

executable move_5_2 if -occupied_5, -occupied_2;
move_5_2 causes on_5_2;
move_5_2 causes -occupied_1 if on_5_1;
move_5_2 causes -occupied_3 if on_5_3;
move_5_2 causes -occupied_4 if on_5_4;
move_5_2 causes -occupied_6 if on_5_6;
move_5_2 causes -occupied_7 if on_5_7;
move_5_2 causes -occupied_8 if on_5_8;

executable move_5_3 if -occupied_5, -occupied_3;
move_5_3 causes on_5_3;
move_5_3 causes -occupied_1 if on_5_1;
move_5_3 causes -occupied_2 if on_5_2;
move_5_3 causes -occupied_4 if on_5_4;
move_5_3 causes -occupied_6 if on_5_6;
move_5_3 causes -occupied_7 if on_5_7;
move_5_3 causes -occupied_8 if on_5_8;

executable move_5_4 if -occupied_5, -occupied_4;
move_5_4 causes on_5_4;
move_5_4 causes -occupied_1 if on_5_1;
move_5_4 causes -occupied_2 if on_5_2;
move_5_4 causes -occupied_3 if on_5_3;
move_5_4 causes -occupied_6 if on_5_6;
move_5_4 causes -occupied_7 if on_5_7;
move_5_4 causes -occupied_8 if on_5_8;


executable move_5_6 if -occupied_5, -occupied_6;
move_5_6 causes on_5_6;
move_5_6 causes -occupied_1 if on_5_1;
move_5_6 causes -occupied_2 if on_5_2;
move_5_6 causes -occupied_3 if on_5_3;
move_5_6 causes -occupied_4 if on_5_4;
move_5_6 causes -occupied_7 if on_5_7;
move_5_6 causes -occupied_8 if on_5_8;

executable move_5_7 if -occupied_5, -occupied_7;
move_5_7 causes on_5_7;
move_5_7 causes -occupied_1 if on_5_1;
move_5_7 causes -occupied_2 if on_5_2;
move_5_7 causes -occupied_3 if on_5_3;
move_5_7 causes -occupied_4 if on_5_4;
move_5_7 causes -occupied_6 if on_5_6;
move_5_7 causes -occupied_8 if on_5_8;

executable move_5_8 if -occupied_5, -occupied_8;
move_5_8 causes on_5_8;
move_5_8 causes -occupied_1 if on_5_1;
move_5_8 causes -occupied_2 if on_5_2;
move_5_8 causes -occupied_3 if on_5_3;
move_5_8 causes -occupied_4 if on_5_4;
move_5_8 causes -occupied_6 if on_5_6;
move_5_8 causes -occupied_7 if on_5_7;

executable move_6_table if -occupied_6;
move_6_table causes on_6_table;
move_6_table causes -occupied_1 if on_6_1;
move_6_table causes -occupied_2 if on_6_2;
move_6_table causes -occupied_3 if on_6_3;
move_6_table causes -occupied_4 if on_6_4;
move_6_table causes -occupied_5 if on_6_5;
move_6_table causes -occupied_7 if on_6_7;
move_6_table causes -occupied_8 if on_6_8;

executable move_6_1 if -occupied_6, -occupied_1;
move_6_1 causes on_6_1;
move_6_1 causes -occupied_2 if on_6_2;
move_6_1 causes -occupied_3 if on_6_3;
move_6_1 causes -occupied_4 if on_6_4;
move_6_1 causes -occupied_5 if on_6_5;
move_6_1 causes -occupied_7 if on_6_7;
move_6_1 causes -occupied_8 if on_6_8;

executable move_6_2 if -occupied_6, -occupied_2;
move_6_2 causes on_6_2;
move_6_2 causes -occupied_1 if on_6_1;
move_6_2 causes -occupied_3 if on_6_3;
move_6_2 causes -occupied_4 if on_6_4;
move_6_2 causes -occupied_5 if on_6_5;
move_6_2 causes -occupied_7 if on_6_7;
move_6_2 causes -occupied_8 if on_6_8;

executable move_6_3 if -occupied_6, -occupied_3;
move_6_3 causes on_6_3;
move_6_3 causes -occupied_1 if on_6_1;
move_6_3 causes -occupied_2 if on_6_2;
move_6_3 causes -occupied_4 if on_6_4;
move_6_3 causes -occupied_5 if on_6_5;
move_6_3 causes -occupied_7 if on_6_7;
move_6_3 causes -occupied_8 if on_6_8;

executable move_6_4 if -occupied_6, -occupied_4;
move_6_4 causes on_6_4;
move_6_4 causes -occupied_1 if on_6_1;
move_6_4 causes -occupied_2 if on_6_2;
move_6_4 causes -occupied_3 if on_6_3;
move_6_4 causes -occupied_5 if on_6_5;
move_6_4 causes -occupied_7 if on_6_7;
move_6_4 causes -occupied_8 if on_6_8;

executable move_6_5 if -occupied_6, -occupied_5;
move_6_5 causes on_6_5;
move_6_5 causes -occupied_1 if on_6_1;
move_6_5 causes -occupied_2 if on_6_2;
move_6_5 causes -occupied_3 if on_6_3;
move_6_5 causes -occupied_4 if on_6_4;
move_6_5 causes -occupied_7 if on_6_7;
move_6_5 causes -occupied_8 if on_6_8;


executable move_6_7 if -occupied_6, -occupied_7;
move_6_7 causes on_6_7;
move_6_7 causes -occupied_1 if on_6_1;
move_6_7 causes -occupied_2 if on_6_2;
move_6_7 causes -occupied_3 if on_6_3;
move_6_7 causes -occupied_4 if on_6_4;
move_6_7 causes -occupied_5 if on_6_5;
move_6_7 causes -occupied_8 if on_6_8;

executable move_6_8 if -occupied_6, -occupied_8;
move_6_8 causes on_6_8;
move_6_8 causes -occupied_1 if on_6_1;
move_6_8 causes -occupied_2 if on_6_2;
move_6_8 causes -occupied_3 if on_6_3;
move_6_8 causes -occupied_4 if on_6_4;
move_6_8 causes -occupied_5 if on_6_5;
move_6_8 causes -occupied_7 if on_6_7;

executable move_7_table if -occupied_7;
move_7_table causes on_7_table;
move_7_table causes -occupied_1 if on_7_1;
move_7_table causes -occupied_2 if on_7_2;
move_7_table causes -occupied_3 if on_7_3;
move_7_table causes -occupied_4 if on_7_4;
move_7_table causes -occupied_5 if on_7_5;
move_7_table causes -occupied_6 if on_7_6;
move_7_table causes -occupied_8 if on_7_8;

executable move_7_1 if -occupied_7, -occupied_1;
move_7_1 causes on_7_1;
move_7_1 causes -occupied_2 if on_7_2;
move_7_1 causes -occupied_3 if on_7_3;
move_7_1 causes -occupied_4 if on_7_4;
move_7_1 causes -occupied_5 if on_7_5;
move_7_1 causes -occupied_6 if on_7_6;
move_7_1 causes -occupied_8 if on_7_8;

executable move_7_2 if -occupied_7, -occupied_2;
move_7_2 causes on_7_2;
move_7_2 causes -occupied_1 if on_7_1;
move_7_2 causes -occupied_3 if on_7_3;
move_7_2 causes -occupied_4 if on_7_4;
move_7_2 causes -occupied_5 if on_7_5;
move_7_2 causes -occupied_6 if on_7_6;
move_7_2 causes -occupied_8 if on_7_8;

executable move_7_3 if -occupied_7, -occupied_3;
move_7_3 causes on_7_3;
move_7_3 causes -occupied_1 if on_7_1;
move_7_3 causes -occupied_2 if on_7_2;
move_7_3 causes -occupied_4 if on_7_4;
move_7_3 causes -occupied_5 if on_7_5;
move_7_3 causes -occupied_6 if on_7_6;
move_7_3 causes -occupied_8 if on_7_8;

executable move_7_4 if -occupied_7, -occupied_4;
move_7_4 causes on_7_4;
move_7_4 causes -occupied_1 if on_7_1;
move_7_4 causes -occupied_2 if on_7_2;
move_7_4 causes -occupied_3 if on_7_3;
move_7_4 causes -occupied_5 if on_7_5;
move_7_4 causes -occupied_6 if on_7_6;
move_7_4 causes -occupied_8 if on_7_8;

executable move_7_5 if -occupied_7, -occupied_5;
move_7_5 causes on_7_5;
move_7_5 causes -occupied_1 if on_7_1;
move_7_5 causes -occupied_2 if on_7_2;
move_7_5 causes -occupied_3 if on_7_3;
move_7_5 causes -occupied_4 if on_7_4;
move_7_5 causes -occupied_6 if on_7_6;
move_7_5 causes -occupied_8 if on_7_8;

executable move_7_6 if -occupied_7, -occupied_6;
move_7_6 causes on_7_6;
move_7_6 causes -occupied_1 if on_7_1;
move_7_6 causes -occupied_2 if on_7_2;
move_7_6 causes -occupied_3 if on_7_3;
move_7_6 causes -occupied_4 if on_7_4;
move_7_6 causes -occupied_5 if on_7_5;
move_7_6 causes -occupied_8 if on_7_8;


executable move_7_8 if -occupied_7, -occupied_8;
move_7_8 causes on_7_8;
move_7_8 causes -occupied_1 if on_7_1;
move_7_8 causes -occupied_2 if on_7_2;
move_7_8 causes -occupied_3 if on_7_3;
move_7_8 causes -occupied_4 if on_7_4;
move_7_8 causes -occupied_5 if on_7_5;
move_7_8 causes -occupied_6 if on_7_6;

executable move_8_table if -occupied_8;
move_8_table causes on_8_table;
move_8_table causes -occupied_1 if on_8_1;
move_8_table causes -occupied_2 if on_8_2;
move_8_table causes -occupied_3 if on_8_3;
move_8_table causes -occupied_4 if on_8_4;
move_8_table causes -occupied_5 if on_8_5;
move_8_table causes -occupied_6 if on_8_6;
move_8_table causes -occupied_7 if on_8_7;

executable move_8_1 if -occupied_8, -occupied_1;
move_8_1 causes on_8_1;
move_8_1 causes -occupied_2 if on_8_2;
move_8_1 causes -occupied_3 if on_8_3;
move_8_1 causes -occupied_4 if on_8_4;
move_8_1 causes -occupied_5 if on_8_5;
move_8_1 causes -occupied_6 if on_8_6;
move_8_1 causes -occupied_7 if on_8_7;

executable move_8_2 if -occupied_8, -occupied_2;
move_8_2 causes on_8_2;
move_8_2 causes -occupied_1 if on_8_1;
move_8_2 causes -occupied_3 if on_8_3;
move_8_2 causes -occupied_4 if on_8_4;
move_8_2 causes -occupied_5 if on_8_5;
move_8_2 causes -occupied_6 if on_8_6;
move_8_2 causes -occupied_7 if on_8_7;

executable move_8_3 if -occupied_8, -occupied_3;
move_8_3 causes on_8_3;
move_8_3 causes -occupied_1 if on_8_1;
move_8_3 causes -occupied_2 if on_8_2;
move_8_3 causes -occupied_4 if on_8_4;
move_8_3 causes -occupied_5 if on_8_5;
move_8_3 causes -occupied_6 if on_8_6;
move_8_3 causes -occupied_7 if on_8_7;

executable move_8_4 if -occupied_8, -occupied_4;
move_8_4 causes on_8_4;
move_8_4 causes -occupied_1 if on_8_1;
move_8_4 causes -occupied_2 if on_8_2;
move_8_4 causes -occupied_3 if on_8_3;
move_8_4 causes -occupied_5 if on_8_5;
move_8_4 causes -occupied_6 if on_8_6;
move_8_4 causes -occupied_7 if on_8_7;

executable move_8_5 if -occupied_8, -occupied_5;
move_8_5 causes on_8_5;
move_8_5 causes -occupied_1 if on_8_1;
move_8_5 causes -occupied_2 if on_8_2;
move_8_5 causes -occupied_3 if on_8_3;
move_8_5 causes -occupied_4 if on_8_4;
move_8_5 causes -occupied_6 if on_8_6;
move_8_5 causes -occupied_7 if on_8_7;

executable move_8_6 if -occupied_8, -occupied_6;
move_8_6 causes on_8_6;
move_8_6 causes -occupied_1 if on_8_1;
move_8_6 causes -occupied_2 if on_8_2;
move_8_6 causes -occupied_3 if on_8_3;
move_8_6 causes -occupied_4 if on_8_4;
move_8_6 causes -occupied_5 if on_8_5;
move_8_6 causes -occupied_7 if on_8_7;

executable move_8_7 if -occupied_8, -occupied_7;
move_8_7 causes on_8_7;
move_8_7 causes -occupied_1 if on_8_1;
move_8_7 causes -occupied_2 if on_8_2;
move_8_7 causes -occupied_3 if on_8_3;
move_8_7 causes -occupied_4 if on_8_4;
move_8_7 causes -occupied_5 if on_8_5;
move_8_7 causes -occupied_6 if on_8_6;


-on_1_2 if on_1_table;
-on_1_3 if on_1_table;
-on_1_4 if on_1_table;
-on_1_5 if on_1_table;
-on_1_6 if on_1_table;
-on_1_7 if on_1_table;
-on_1_8 if on_1_table;

-on_1_table if on_1_2;
-on_1_3 if on_1_2;
-on_1_4 if on_1_2;
-on_1_5 if on_1_2;
-on_1_6 if on_1_2;
-on_1_7 if on_1_2;
-on_1_8 if on_1_2;
occupied_2 if on_1_2;

-on_1_table if on_1_3;
-on_1_2 if on_1_3;
-on_1_4 if on_1_3;
-on_1_5 if on_1_3;
-on_1_6 if on_1_3;
-on_1_7 if on_1_3;
-on_1_8 if on_1_3;
occupied_3 if on_1_3;

-on_1_table if on_1_4;
-on_1_2 if on_1_4;
-on_1_3 if on_1_4;
-on_1_5 if on_1_4;
-on_1_6 if on_1_4;
-on_1_7 if on_1_4;
-on_1_8 if on_1_4;
occupied_4 if on_1_4;

-on_1_table if on_1_5;
-on_1_2 if on_1_5;
-on_1_3 if on_1_5;
-on_1_4 if on_1_5;
-on_1_6 if on_1_5;
-on_1_7 if on_1_5;
-on_1_8 if on_1_5;
occupied_5 if on_1_5;

-on_1_table if on_1_6;
-on_1_2 if on_1_6;
-on_1_3 if on_1_6;
-on_1_4 if on_1_6;
-on_1_5 if on_1_6;
-on_1_7 if on_1_6;
-on_1_8 if on_1_6;
occupied_6 if on_1_6;

-on_1_table if on_1_7;
-on_1_2 if on_1_7;
-on_1_3 if on_1_7;
-on_1_4 if on_1_7;
-on_1_5 if on_1_7;
-on_1_6 if on_1_7;
-on_1_8 if on_1_7;
occupied_7 if on_1_7;

-on_1_table if on_1_8;
-on_1_2 if on_1_8;
-on_1_3 if on_1_8;
-on_1_4 if on_1_8;
-on_1_5 if on_1_8;
-on_1_6 if on_1_8;
-on_1_7 if on_1_8;
occupied_8 if on_1_8;

-on_2_1 if on_2_table;
-on_2_3 if on_2_table;
-on_2_4 if on_2_table;
-on_2_5 if on_2_table;
-on_2_6 if on_2_table;
-on_2_7 if on_2_table;
-on_2_8 if on_2_table;

-on_2_table if on_2_1;
-on_2_3 if on_2_1;
-on_2_4 if on_2_1;
-on_2_5 if on_2_1;
-on_2_6 if on_2_1;
-on_2_7 if on_2_1;
-on_2_8 if on_2_1;
occupied_1 if on_2_1;

-on_2_table if on_2_3;
-on_2_1 if on_2_3;
-on_2_4 if on_2_3;
-on_2_5 if on_2_3;
-on_2_6 if on_2_3;
-on_2_7 if on_2_3;
-on_2_8 if on_2_3;
occupied_3 if on_2_3;

-on_2_table if on_2_4;
-on_2_1 if on_2_4;
-on_2_3 if on_2_4;
-on_2_5 if on_2_4;
-on_2_6 if on_2_4;
-on_2_7 if on_2_4;
-on_2_8 if on_2_4;
occupied_4 if on_2_4;

-on_2_table if on_2_5;
-on_2_1 if on_2_5;
-on_2_3 if on_2_5;
-on_2_4 if on_2_5;
-on_2_6 if on_2_5;
-on_2_7 if on_2_5;
-on_2_8 if on_2_5;
occupied_5 if on_2_5;

-on_2_table if on_2_6;
-on_2_1 if on_2_6;
-on_2_3 if on_2_6;
-on_2_4 if on_2_6;
-on_2_5 if on_2_6;
-on_2_7 if on_2_6;
-on_2_8 if on_2_6;
occupied_6 if on_2_6;

-on_2_table if on_2_7;
-on_2_1 if on_2_7;
-on_2_3 if on_2_7;
-on_2_4 if on_2_7;
-on_2_5 if on_2_7;
-on_2_6 if on_2_7;
-on_2_8 if on_2_7;
occupied_7 if on_2_7;

-on_2_table if on_2_8;
-on_2_1 if on_2_8;
-on_2_3 if on_2_8;
-on_2_4 if on_2_8;
-on_2_5 if on_2_8;
-on_2_6 if on_2_8;
-on_2_7 if on_2_8;
occupied_8 if on_2_8;

-on_3_1 if on_3_table;
-on_3_2 if on_3_table;
-on_3_4 if on_3_table;
-on_3_5 if on_3_table;
-on_3_6 if on_3_table;
-on_3_7 if on_3_table;
-on_3_8 if on_3_table;

-on_3_table if on_3_1;
-on_3_2 if on_3_1;
-on_3_4 if on_3_1;
-on_3_5 if on_3_1;
-on_3_6 if on_3_1;
-on_3_7 if on_3_1;
-on_3_8 if on_3_1;
occupied_1 if on_3_1;

-on_3_table if on_3_2;
-on_3_1 if on_3_2;
-on_3_4 if on_3_2;
-on_3_5 if on_3_2;
-on_3_6 if on_3_2;
-on_3_7 if on_3_2;
-on_3_8 if on_3_2;
occupied_2 if on_3_2;

-on_3_table if on_3_4;
-on_3_1 if on_3_4;
-on_3_2 if on_3_4;
-on_3_5 if on_3_4;
-on_3_6 if on_3_4;
-on_3_7 if on_3_4;
-on_3_8 if on_3_4;
occupied_4 if on_3_4;

-on_3_table if on_3_5;
-on_3_1 if on_3_5;
-on_3_2 if on_3_5;
-on_3_4 if on_3_5;
-on_3_6 if on_3_5;
-on_3_7 if on_3_5;
-on_3_8 if on_3_5;
occupied_5 if on_3_5;

-on_3_table if on_3_6;
-on_3_1 if on_3_6;
-on_3_2 if on_3_6;
-on_3_4 if on_3_6;
-on_3_5 if on_3_6;
-on_3_7 if on_3_6;
-on_3_8 if on_3_6;
occupied_6 if on_3_6;

-on_3_table if on_3_7;
-on_3_1 if on_3_7;
-on_3_2 if on_3_7;
-on_3_4 if on_3_7;
-on_3_5 if on_3_7;
-on_3_6 if on_3_7;
-on_3_8 if on_3_7;
occupied_7 if on_3_7;

-on_3_table if on_3_8;
-on_3_1 if on_3_8;
-on_3_2 if on_3_8;
-on_3_4 if on_3_8;
-on_3_5 if on_3_8;
-on_3_6 if on_3_8;
-on_3_7 if on_3_8;
occupied_8 if on_3_8;

-on_4_1 if on_4_table;
-on_4_2 if on_4_table;
-on_4_3 if on_4_table;
-on_4_5 if on_4_table;
-on_4_6 if on_4_table;
-on_4_7 if on_4_table;
-on_4_8 if on_4_table;

-on_4_table if on_4_1;
-on_4_2 if on_4_1;
-on_4_3 if on_4_1;
-on_4_5 if on_4_1;
-on_4_6 if on_4_1;
-on_4_7 if on_4_1;
-on_4_8 if on_4_1;
occupied_1 if on_4_1;

-on_4_table if on_4_2;
-on_4_1 if on_4_2;
-on_4_3 if on_4_2;
-on_4_5 if on_4_2;
-on_4_6 if on_4_2;
-on_4_7 if on_4_2;
-on_4_8 if on_4_2;
occupied_2 if on_4_2;

-on_4_table if on_4_3;
-on_4_1 if on_4_3;
-on_4_2 if on_4_3;
-on_4_5 if on_4_3;
-on_4_6 if on_4_3;
-on_4_7 if on_4_3;
-on_4_8 if on_4_3;
occupied_3 if on_4_3;

-on_4_table if on_4_5;
-on_4_1 if on_4_5;
-on_4_2 if on_4_5;
-on_4_3 if on_4_5;
-on_4_6 if on_4_5;
-on_4_7 if on_4_5;
-on_4_8 if on_4_5;
occupied_5 if on_4_5;

-on_4_table if on_4_6;
-on_4_1 if on_4_6;
-on_4_2 if on_4_6;
-on_4_3 if on_4_6;
-on_4_5 if on_4_6;
-on_4_7 if on_4_6;
-on_4_8 if on_4_6;
occupied_6 if on_4_6;

-on_4_table if on_4_7;
-on_4_1 if on_4_7;
-on_4_2 if on_4_7;
-on_4_3 if on_4_7;
-on_4_5 if on_4_7;
-on_4_6 if on_4_7;
-on_4_8 if on_4_7;
occupied_7 if on_4_7;

-on_4_table if on_4_8;
-on_4_1 if on_4_8;
-on_4_2 if on_4_8;
-on_4_3 if on_4_8;
-on_4_5 if on_4_8;
-on_4_6 if on_4_8;
-on_4_7 if on_4_8;
occupied_8 if on_4_8;

-on_5_1 if on_5_table;
-on_5_2 if on_5_table;
-on_5_3 if on_5_table;
-on_5_4 if on_5_table;
-on_5_6 if on_5_table;
-on_5_7 if on_5_table;
-on_5_8 if on_5_table;

-on_5_table if on_5_1;
-on_5_2 if on_5_1;
-on_5_3 if on_5_1;
-on_5_4 if on_5_1;
-on_5_6 if on_5_1;
-on_5_7 if on_5_1;
-on_5_8 if on_5_1;
occupied_1 if on_5_1;

-on_5_table if on_5_2;
-on_5_1 if on_5_2;
-on_5_3 if on_5_2;
-on_5_4 if on_5_2;
-on_5_6 if on_5_2;
-on_5_7 if on_5_2;
-on_5_8 if on_5_2;
occupied_2 if on_5_2;

-on_5_table if on_5_3;
-on_5_1 if on_5_3;
-on_5_2 if on_5_3;
-on_5_4 if on_5_3;
-on_5_6 if on_5_3;
-on_5_7 if on_5_3;
-on_5_8 if on_5_3;
occupied_3 if on_5_3;

-on_5_table if on_5_4;
-on_5_1 if on_5_4;
-on_5_2 if on_5_4;
-on_5_3 if on_5_4;
-on_5_6 if on_5_4;
-on_5_7 if on_5_4;
-on_5_8 if on_5_4;
occupied_4 if on_5_4;

-on_5_table if on_5_6;
-on_5_1 if on_5_6;
-on_5_2 if on_5_6;
-on_5_3 if on_5_6;
-on_5_4 if on_5_6;
-on_5_7 if on_5_6;
-on_5_8 if on_5_6;
occupied_6 if on_5_6;

-on_5_table if on_5_7;
-on_5_1 if on_5_7;
-on_5_2 if on_5_7;
-on_5_3 if on_5_7;
-on_5_4 if on_5_7;
-on_5_6 if on_5_7;
-on_5_8 if on_5_7;
occupied_7 if on_5_7;

-on_5_table if on_5_8;
-on_5_1 if on_5_8;
-on_5_2 if on_5_8;
-on_5_3 if on_5_8;
-on_5_4 if on_5_8;
-on_5_6 if on_5_8;
-on_5_7 if on_5_8;
occupied_8 if on_5_8;

-on_6_1 if on_6_table;
-on_6_2 if on_6_table;
-on_6_3 if on_6_table;
-on_6_4 if on_6_table;
-on_6_5 if on_6_table;
-on_6_7 if on_6_table;
-on_6_8 if on_6_table;

-on_6_table if on_6_1;
-on_6_2 if on_6_1;
-on_6_3 if on_6_1;
-on_6_4 if on_6_1;
-on_6_5 if on_6_1;
-on_6_7 if on_6_1;
-on_6_8 if on_6_1;
occupied_1 if on_6_1;

-on_6_table if on_6_2;
-on_6_1 if on_6_2;
-on_6_3 if on_6_2;
-on_6_4 if on_6_2;
-on_6_5 if on_6_2;
-on_6_7 if on_6_2;
-on_6_8 if on_6_2;
occupied_2 if on_6_2;

-on_6_table if on_6_3;
-on_6_1 if on_6_3;
-on_6_2 if on_6_3;
-on_6_4 if on_6_3;
-on_6_5 if on_6_3;
-on_6_7 if on_6_3;
-on_6_8 if on_6_3;
occupied_3 if on_6_3;

-on_6_table if on_6_4;
-on_6_1 if on_6_4;
-on_6_2 if on_6_4;
-on_6_3 if on_6_4;
-on_6_5 if on_6_4;
-on_6_7 if on_6_4;
-on_6_8 if on_6_4;
occupied_4 if on_6_4;

-on_6_table if on_6_5;
-on_6_1 if on_6_5;
-on_6_2 if on_6_5;
-on_6_3 if on_6_5;
-on_6_4 if on_6_5;
-on_6_7 if on_6_5;
-on_6_8 if on_6_5;
occupied_5 if on_6_5;

-on_6_table if on_6_7;
-on_6_1 if on_6_7;
-on_6_2 if on_6_7;
-on_6_3 if on_6_7;
-on_6_4 if on_6_7;
-on_6_5 if on_6_7;
-on_6_8 if on_6_7;
occupied_7 if on_6_7;

-on_6_table if on_6_8;
-on_6_1 if on_6_8;
-on_6_2 if on_6_8;
-on_6_3 if on_6_8;
-on_6_4 if on_6_8;
-on_6_5 if on_6_8;
-on_6_7 if on_6_8;
occupied_8 if on_6_8;

-on_7_1 if on_7_table;
-on_7_2 if on_7_table;
-on_7_3 if on_7_table;
-on_7_4 if on_7_table;
-on_7_5 if on_7_table;
-on_7_6 if on_7_table;
-on_7_8 if on_7_table;

-on_7_table if on_7_1;
-on_7_2 if on_7_1;
-on_7_3 if on_7_1;
-on_7_4 if on_7_1;
-on_7_5 if on_7_1;
-on_7_6 if on_7_1;
-on_7_8 if on_7_1;
occupied_1 if on_7_1;

-on_7_table if on_7_2;
-on_7_1 if on_7_2;
-on_7_3 if on_7_2;
-on_7_4 if on_7_2;
-on_7_5 if on_7_2;
-on_7_6 if on_7_2;
-on_7_8 if on_7_2;
occupied_2 if on_7_2;

-on_7_table if on_7_3;
-on_7_1 if on_7_3;
-on_7_2 if on_7_3;
-on_7_4 if on_7_3;
-on_7_5 if on_7_3;
-on_7_6 if on_7_3;
-on_7_8 if on_7_3;
occupied_3 if on_7_3;

-on_7_table if on_7_4;
-on_7_1 if on_7_4;
-on_7_2 if on_7_4;
-on_7_3 if on_7_4;
-on_7_5 if on_7_4;
-on_7_6 if on_7_4;
-on_7_8 if on_7_4;
occupied_4 if on_7_4;

-on_7_table if on_7_5;
-on_7_1 if on_7_5;
-on_7_2 if on_7_5;
-on_7_3 if on_7_5;
-on_7_4 if on_7_5;
-on_7_6 if on_7_5;
-on_7_8 if on_7_5;
occupied_5 if on_7_5;

-on_7_table if on_7_6;
-on_7_1 if on_7_6;
-on_7_2 if on_7_6;
-on_7_3 if on_7_6;
-on_7_4 if on_7_6;
-on_7_5 if on_7_6;
-on_7_8 if on_7_6;
occupied_6 if on_7_6;

-on_7_table if on_7_8;
-on_7_1 if on_7_8;
-on_7_2 if on_7_8;
-on_7_3 if on_7_8;
-on_7_4 if on_7_8;
-on_7_5 if on_7_8;
-on_7_6 if on_7_8;
occupied_8 if on_7_8;

-on_8_1 if on_8_table;
-on_8_2 if on_8_table;
-on_8_3 if on_8_table;
-on_8_4 if on_8_table;
-on_8_5 if on_8_table;
-on_8_6 if on_8_table;
-on_8_7 if on_8_table;

-on_8_table if on_8_1;
-on_8_2 if on_8_1;
-on_8_3 if on_8_1;
-on_8_4 if on_8_1;
-on_8_5 if on_8_1;
-on_8_6 if on_8_1;
-on_8_7 if on_8_1;
occupied_1 if on_8_1;

-on_8_table if on_8_2;
-on_8_1 if on_8_2;
-on_8_3 if on_8_2;
-on_8_4 if on_8_2;
-on_8_5 if on_8_2;
-on_8_6 if on_8_2;
-on_8_7 if on_8_2;
occupied_2 if on_8_2;

-on_8_table if on_8_3;
-on_8_1 if on_8_3;
-on_8_2 if on_8_3;
-on_8_4 if on_8_3;
-on_8_5 if on_8_3;
-on_8_6 if on_8_3;
-on_8_7 if on_8_3;
occupied_3 if on_8_3;

-on_8_table if on_8_4;
-on_8_1 if on_8_4;
-on_8_2 if on_8_4;
-on_8_3 if on_8_4;
-on_8_5 if on_8_4;
-on_8_6 if on_8_4;
-on_8_7 if on_8_4;
occupied_4 if on_8_4;

-on_8_table if on_8_5;
-on_8_1 if on_8_5;
-on_8_2 if on_8_5;
-on_8_3 if on_8_5;
-on_8_4 if on_8_5;
-on_8_6 if on_8_5;
-on_8_7 if on_8_5;
occupied_5 if on_8_5;

-on_8_table if on_8_6;
-on_8_1 if on_8_6;
-on_8_2 if on_8_6;
-on_8_3 if on_8_6;
-on_8_4 if on_8_6;
-on_8_5 if on_8_6;
-on_8_7 if on_8_6;
occupied_6 if on_8_6;

-on_8_table if on_8_7;
-on_8_1 if on_8_7;
-on_8_2 if on_8_7;
-on_8_3 if on_8_7;
-on_8_4 if on_8_7;
-on_8_5 if on_8_7;
-on_8_6 if on_8_7;
occupied_7 if on_8_7;

initially on_1_table, on_4_1, on_3_4, -occupied_3;
initially on_2_table, on_5_2, -occupied_5;
initially on_6_table, on_7_6, on_8_7, -occupied_8;

goal on_5_table, on_4_5, on_8_4;
goal on_7_table, on_3_7;
goal on_2_table, on_1_2, on_6_1;
