%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% BLOCKS WORLD DOMAIN: Problem 1
%
%   INITIAL STATE       GOAL STATE
%
%                            4
%                            3
%             4              2
%     1   2   3              1
% ------------------   ----------------
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% fluent declarations
fluent on_1_table, on_1_2, on_1_3, on_1_4;
fluent on_2_table, on_2_1, on_2_3, on_2_4;
fluent on_3_table, on_3_1, on_3_2, on_3_4;
fluent on_4_table, on_4_1, on_4_2, on_4_3;

fluent occupied_1, occupied_2, occupied_3, occupied_4;

% action declarations
action move_1_table, move_1_2, move_1_3, move_1_4;
action move_2_table, move_2_1, move_2_3, move_2_4;
action move_3_table, move_3_1, move_3_2, move_3_4;
action move_4_table, move_4_1, move_4_2, move_4_3;

% executability conditions
executable move_1_table if -occupied_1;
executable move_1_2 if -occupied_1, -occupied_2;
executable move_1_3 if -occupied_1, -occupied_3;
executable move_1_4 if -occupied_1, -occupied_4;

executable move_2_table if -occupied_2;
executable move_2_1 if -occupied_2, -occupied_1;
executable move_2_3 if -occupied_2, -occupied_3;
executable move_2_4 if -occupied_2, -occupied_4;

executable move_3_table if -occupied_3;
executable move_3_2 if -occupied_3, -occupied_2;
executable move_3_1 if -occupied_3, -occupied_1;
executable move_3_4 if -occupied_3, -occupied_4;

executable move_4_table if -occupied_4;
executable move_4_2 if -occupied_4, -occupied_2;
executable move_4_3 if -occupied_4, -occupied_3;
executable move_4_1 if -occupied_4, -occupied_1;

% dynamic laws
move_1_table causes on_1_table;
move_1_table causes -occupied_2 if on_1_2;
move_1_table causes -occupied_3 if on_1_3;
move_1_table causes -occupied_4 if on_1_4;

move_1_2 causes on_1_2;
move_1_2 causes -occupied_3 if on_1_3;
move_1_2 causes -occupied_4 if on_1_4;

move_1_3 causes on_1_3;
move_1_3 causes -occupied_2 if on_1_2;
move_1_3 causes -occupied_4 if on_1_4;

move_1_4 causes on_1_4;
move_1_4 causes -occupied_2 if on_1_2;
move_1_4 causes -occupied_3 if on_1_3;

move_2_table causes on_2_table;
move_2_table causes -occupied_1 if on_2_1;
move_2_table causes -occupied_3 if on_2_3;
move_2_table causes -occupied_4 if on_2_4;

move_2_1 causes on_2_1;
move_2_1 causes -occupied_3 if on_2_3;
move_2_1 causes -occupied_4 if on_2_4;

move_2_3 causes on_2_3;
move_2_3 causes -occupied_1 if on_2_1;
move_2_3 causes -occupied_4 if on_2_4;

move_2_4 causes on_2_4;
move_2_4 causes -occupied_1 if on_2_1;
move_2_4 causes -occupied_3 if on_2_3;

move_3_table causes on_3_table;
move_3_table causes -occupied_1 if on_3_1;
move_3_table causes -occupied_2 if on_3_2;
move_3_table causes -occupied_4 if on_3_4;

move_3_1 causes on_3_1;
move_3_1 causes -occupied_3 if on_2_3;
move_3_1 causes -occupied_4 if on_2_4;

move_3_2 causes on_3_2;
move_3_2 causes -occupied_1 if on_3_1;
move_3_2 causes -occupied_4 if on_3_4;

move_3_4 causes on_3_4;
move_3_4 causes -occupied_1 if on_3_1;
move_3_4 causes -occupied_2 if on_3_2;

move_4_table causes on_4_table;
move_4_table causes -occupied_1 if on_4_1;
move_4_table causes -occupied_2 if on_4_2;
move_4_table causes -occupied_3 if on_4_3;

move_4_2 causes on_4_2;
move_4_2 causes -occupied_1 if on_4_1;
move_4_2 causes -occupied_3 if on_4_3;

move_4_3 causes on_4_3;
move_4_3 causes -occupied_1 if on_4_1;
move_4_3 causes -occupied_2 if on_4_2;

move_4_1 causes on_4_1;
move_4_1 causes -occupied_2 if on_4_2;
move_4_1 causes -occupied_3 if on_4_3;

% static laws

occupied_1 if on_2_1;
occupied_1 if on_3_1;
occupied_1 if on_4_1;

occupied_2 if on_1_2;
occupied_2 if on_3_2;
occupied_2 if on_4_2;

occupied_3 if on_2_3;
occupied_3 if on_1_3;
occupied_3 if on_4_3;

occupied_4 if on_2_4;
occupied_4 if on_3_4;
occupied_4 if on_1_4;

-on_1_2 if on_1_table;
-on_1_3 if on_1_table;
-on_1_4 if on_1_table;

-on_1_table if on_1_2;
-on_1_3 if on_1_2;
-on_1_4 if on_1_2;

-on_1_table if on_1_3;
-on_1_2 if on_1_3;
-on_1_4 if on_1_3;

-on_1_table if on_1_4;
-on_1_3 if on_1_4;
-on_1_2 if on_1_4;

% block 2
-on_2_1 if on_2_table;
-on_2_3 if on_2_table;
-on_2_4 if on_2_table;

-on_2_table if on_2_1;
-on_2_3 if on_2_1;
-on_2_4 if on_2_1;

-on_2_table if on_2_3;
-on_2_1 if on_2_3;
-on_2_4 if on_2_3;

-on_2_table if on_2_4;
-on_2_3 if on_2_4;
-on_2_1 if on_2_4;

% block 3
-on_3_1 if on_3_table;
-on_3_2 if on_3_table;
-on_3_4 if on_3_table;

-on_3_table if on_3_1;
-on_3_2 if on_3_1;
-on_3_4 if on_3_1;

-on_3_table if on_3_2;
-on_3_1 if on_3_2;
-on_3_4 if on_3_2;

-on_3_table if on_3_4;
-on_3_2 if on_3_4;
-on_3_1 if on_3_4;

% block 4
-on_4_1 if on_4_table;
-on_4_2 if on_4_table;
-on_4_3 if on_4_table;

-on_4_table if on_4_1;
-on_4_2 if on_4_1;
-on_4_3 if on_4_1;

-on_4_table if on_4_2;
-on_4_1 if on_4_2;
-on_4_3 if on_4_2;

-on_4_table if on_4_3;
-on_4_2 if on_4_3;
-on_4_1 if on_4_3;

% initial state
initially on_1_table;
initially on_2_table;
initially on_3_table;
initially on_4_3;
initially -occupied_1;
initially -occupied_2;
initially -occupied_4;

% goal state
goal on_1_table;
goal on_2_1;
goal on_3_2;
goal on_4_3;
