%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% BLOCKS WORLD DOMAIN
%
%   INITIAL STATE       GOAL STATE
%
%        2                  1
%        1                  2
%   --------------    ---------------
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% fluent declarations
fluent on_1_table, on_1_2;
fluent on_2_table, on_2_1;

fluent occupied_1, occupied_2;

% action declarations
action move_1_table, move_1_2;
action move_2_table, move_2_1;

% executability conditions
%executable move_1_table if -occupied_1;
%executable move_1_2 if -occupied_1, -occupied_2;

%executable move_2_table if -occupied_2;
%executable move_2_1 if -occupied_2, -occupied_1;

impossible move_1_table if occupied_1;
impossible move_1_2 if occupied_1;
impossible move_1_2 if occupied_2;

impossible move_2_table if occupied_2;
impossible move_2_1 if -occupied_2;
impossible move_2_1 if -occupied_1;

% dynamic laws
move_1_table causes on_1_table;
move_1_table causes -occupied_2 if on_1_2;

move_1_2 causes on_1_2;

move_2_table causes on_2_table;
move_2_table causes -occupied_1 if on_2_1;

move_2_1 causes on_2_1;

% static laws
occupied_1 if on_2_1;
occupied_2 if on_1_2;

-occupied_1 if -on_2_1;
-occupied_2 if -on_1_2;

-on_1_2 if on_1_table;
-on_1_table if on_1_2;

% block 2
-on_2_1 if on_2_table;
-on_2_table if on_2_1;

% initial state
initially on_1_table;
initially on_2_1 | on_2_table;
initially -occupied_2;
%initially occupied_1;

% goal state
goal on_2_table;
goal on_1_2;
