import java.util.*;
import java.util.concurrent.*;

public class search {
//    private static int[] nodes = {1,2,3,4,5};
    private static int[] nodes = {1,2,3,4,5,6,7,8,9,10};

//    private static int[][] edges = {{1,2},{1,3},{1,4},{2,3},{2,4},{3,4},{4,5}};
//    private static int[][] edges = {{1,2},{1,4},{2,3},{2,4},{3,4},{4,5}};
//    private static int[][] edges = {{1,2},{1,3},{1,4},{1,5},{1,6},{1,7},
//				{2,8},{3,4},{3,6},{3,9},{4,6},{4,9},
//				{5,6},{5,7},{6,7},{6,9},{7,9},{8,10}};
    private static int[][] edges = {{1,2},{1,3},{1,4},{1,5},{1,6},{1,7},
				{2,3},{3,5},{3,6},{3,9},{4,10},{5,6},
				{5,7},{5,9},{6,7},{6,9},{7,9},{8,9}};

    private static int[] successors = {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1};
    private static int[] visited_nodes = {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1};
    private static int visited_count = 0;


    // user should input an integer (args[0]):
    //   1 = breadth-first search
    //   2 = depth-first search
    //   defaults to 1
    public static void main(String args[]) {
	int strat = 1;
	int path = 0;

	if (args.length > 0)
	    try {
	    	strat = Integer.parseInt(args[0]);
	    } catch (NumberFormatException nfe) {
		System.out.println("Please enter an integer as your argument");
		System.exit(1);
	    } catch (Exception e) {
		System.out.println("Error processing input: " + e);
		System.exit(2);
	    }
	else
	    strat = 1;


	if (strat == 1) {
//	    path = breadth_first_search(1, 5);
	    path = breadth_first_search(1, 10);
	} else {
//	    path = depth_first_search(1,5);
	    path = depth_first_search(1,10);
	}

	if (path == 1)
	    System.out.println("\nPath found.\n");
	else
	    System.out.println("\nNo path found.\n");

	System.exit(0);
    }


    public static int depth_first_search(int init, int goal) {
	IntStack stack = new IntStack();
	stack.push(init);
	int n, count = 1;
	int children;

	while (!stack.isEmpty()) {
	    n = stack.pop();
	    
	    System.out.println("Iteration number: " + count);
	    System.out.println("  Node to expand:  " + n);
	    System.out.print("  Successors: ");
	
	    if (goal == n) {
		return 1;
	    } else if (!isVisited(n)) {
		log_visit(n);
		children = getSuccessors(n);
		for (int i = 0; i < children; i++) {
		    System.out.print(" " + successors[i] + " ");
		    stack.push(successors[i]);
		}
	    }
	    
	    System.out.println("\n");
	    count++;
	}

	return 0;
    }


    public static boolean isVisited(int n) {
	for (int i = 0; i < visited_count; i++) {
	    if (visited_nodes[i] == n)
		return true;
	}

	return false;
    }


    public static void log_visit(int n) {
	visited_nodes[visited_count] = n;
	visited_count++;
    }


    public static int breadth_first_search(int init, int goal) {
	IntQueue queue = new IntQueue();
	queue.offer(init);
	int n, count = 1;
	int children;

	while (!queue.isEmpty()) {
	    n = queue.poll();

	    System.out.println("Iteration number: " + count);
	    System.out.println("  Node to expand:  " + n);
	    System.out.print("  Successors: ");
	
	    if (goal == n)
		return 1;
	    else {
		children = getSuccessors(n);
		for (int i = 0; i < children; i++) {
		    System.out.print(" " + successors[i] + " ");
		    queue.offer(successors[i]);
		}
	    }
	    
	    System.out.println("\n");
	    count++;
	}

	return 0;
    }


    public static int getSuccessors(int n) {
	int count = 0;

	for (int j = 0; j < 10; j++)
	    successors[j] = -1;

	for (int i = 0; i < edges.length; i++) {
	    if (edges[i][0] == n) {
		successors[count] = edges[i][1];
		count++;
	    } else if (edges[i][1] == n) {
		successors[count] = edges[i][0];
		count++;
	    }
	}

	return count;
    }

}
