package examples;

import javax.servlet.jsp.tagext.*;

public class ExampleLoopTagTEI extends TagExtraInfo {
    public VariableInfo[] getVariableInfo(TagData data) {
      if (data.getAttribute("index")!=TagData.REQUEST_TIME_VALUE) {
        return new VariableInfo[] 
            {
                new VariableInfo(data.getAttributeString("index"),
                                 "oracle.jsp.jml.JmlNumber",
                                 true,
                                 VariableInfo.NESTED)
            };
      }
      return null;
    }

    public boolean isValid(TagData data)
    {
      if (data.getAttribute("count")!=TagData.REQUEST_TIME_VALUE) {
        String countStr=data.getAttributeString("count");
        if (countStr!=null)   // for request time case
        {
          try {
            int count=Integer.parseInt(countStr);
          }
          catch (NumberFormatException e)
          {
            return false;
          }
        }
      }
      return true;
    }
}

