
CREATE TABLE STUDENT(
SSN		CHAR(9) NOT NULL,
Degree		CHAR(6) NOT NULL,
SemYr		CHAR(4) NOT NULL,
Email		CHAR(30) NOT NULL,
Name		CHAR(20) NOT NULL,
Address		CHAR(100),
SpclIntr	CHAR(100),
Defic		CHAR(150),
PRIMARY KEY (SSN) );

CREATE TABLE DomesticStudent(
SSN		CHAR(9) NOT NULL,
PRIMARY KEY (SSN) ,
FOREIGN KEY (SSN) REFERENCES STUDENT(SSN) ON DELETE CASCADE);

CREATE TABLE ForeignStudent(
SSN		CHAR(9) NOT NULL,
TofelScr	INTEGER NOT NULL,
TofelTyp	CHAR(8) NOT NULL,
TofelStat	CHAR(10),
VisaType	CHAR(10),
Country	CHAR(10),
Sponser	CHAR(20),
PRIMARY KEY (SSN) ,
FOREIGN KEY (SSN) REFERENCES STUDENT(SSN) ON DELETE CASCADE);

CREATE TABLE StudStatus(
SSN		CHAR(9) NOT NULL,
Final_stat	CHAR(4),
Reason		CHAR(150),
Accept_Stat	CHAR(6),
AppDate		CHAR(8),
ArrDate		CHAR(8),
ProcDate	CHAR(8),
DepartDate	CHAR(8),
PRIMARY KEY (SSN),
FOREIGN KEY (SSN) REFERENCES STUDENT(SSN) ON DELETE CASCADE);


CREATE TABLE StudGREScore( 
SSN		CHAR(9) NOT NULL,
Type		CHAR(5),
Verb		INTEGER,
Qualitative	INTEGER,
Analytical 	INTEGER,
PRIMARY KEY (SSN),
FOREIGN KEY (SSN) REFERENCES STUDENT(SSN) ON DELETE CASCADE);

CREATE TABLE Advisor(
Name		CHAR(20) NOT NULL,
PRIMARY KEY(Name));

CREATE TABLE AdvisedBy( 
Stud_SSN	CHAR(9) NOT NULL,
AdDate		CHAR(8),
Name 		CHAR(20), 
PRIMARY KEY(Stud_SSN,AdDate,Name),
FOREIGN KEY (Stud_SSN) REFERENCES STUDENT(SSN),
FOREIGN KEY (Name) REFERENCES Advisor(Name));

CREATE TABLE College(
Name		CHAR(20),
PRIMARY KEY(Name));

CREATE TABLE GraduatedFrom(
SSN 		CHAR(9) NOT NULL,
C_Name		CHAR(20),
GPA		FLOAT,
PRIMARY KEY (SSN, C_Name),
FOREIGN KEY (SSN) REFERENCES STUDENT(SSN),
FOREIGN KEY (C_Name) REFERENCES College(Name) ON DELETE CASCADE);

CREATE TABLE StudCommittee(
SSN		CHAR(9),
Committee	CHAR(240),
PRIMARY KEY(SSN),
FOREIGN KEY (SSN) REFERENCES STUDENT(SSN) ON DELETE CASCADE);

CREATE TABLE SpecClassesTaken(
SSN		CHAR(9),
Title		CHAR(20),
Year		CHAR(2),
Semester	CHAR(2),
Grade		FLOAT,
Goal		CHAR(100),
Spcl_Del	CHAR(100),
PRIMARY KEY(SSN,Title),
FOREIGN KEY (SSN) REFERENCES STUDENT(SSN) ON DELETE CASCADE);

CREATE TABLE users ( 
username CHAR(40) NOT NULL,
password CHAR(50) NOT NULL, 
userlevel CHAR(1) DEFAULT '0',
PRIMARY KEY(username));

