/* main.cc */

#include <string>
#include <iostream>
#include <set>
#include <list>
#include <queue>
#include <map>
#include <vector>
#include <algorithm>
#include <sys/time.h>
#include <sys/resource.h>

using namespace std;

class edge
{
public:
  edge();
  ~edge();
  int start;
  int end;
  char label[10];
};

edge::edge()
{
};


edge::~edge()
{
};

class hval
{
public:
  hval();
  ~hval();
  int node;
  int value;
};


hval::hval()
{
};


hval::~hval()
{
};


list<edge> graph;
list<hval> heuristic;

int  startNode, endNode;

// functions

void print_usage(char *);
void read_in_file(char *);
void print_graph();
void search(char *);


int main(int argc, char **argv)
{
  if (argc < 3)
    print_usage(argv[0]);

  read_in_file(argv[1]); 

  print_graph();
  
  search(argv[2]);

  exit(0);
}

void print_usage(char* prog_name)
{
  cout << "USAGE:" << endl;
  cout << "  " << prog_name << " input_domain strategy" << endl << endl;
  cout << "EXAMPLES:" << endl;
  cout << "  " << prog_name << " graph1 1  " << endl;
  cout << "WHERE  1 - depth first  " << endl;
  cout << "       2 - breath first " << endl;
  cout << "       3 - best first   " << endl;
  cout << "       ...              " << endl;
  exit(1);
}


void read_in_file(char *fname)
{
  FILE *fp;
  char line[100];
  int state1, state2, i;
  int state, value;
  char label[10];
  edge *e;
  hval *h;

  if ((fp = fopen(fname, "r")) == NULL) {
    cerr << ": File " << fname << " cannot be opened.\n";
    exit(1);
  }


  i = 0;
  while ((fgets(line, 100, fp)) != NULL)
    { 
      switch(line[0])
	{
	case '%': break; 
	case 'S':
          line[0] = ' ';
	  line[1] = ' ';
	  sscanf(line, "%d",&startNode);
	  break;
	case 'E':
          line[0] = ' ';
	  line[1] = ' ';
	  sscanf(line, "%d",&endNode);
	  break;
	case 'H':
          line[0] = ' ';
	  line[1] = ' ';
	  sscanf(line, "%d,%d",&state,&value);
          h = new hval;
	  h->node = state;
          h->value = value; 
          heuristic.push_back(*h);
	  break;
	default:
	  sscanf(line, "%d,%d,%s",&state1,&state2,label);
	  e = new edge;
	  e->start = state1;
	  e->end = state2;
	  strcpy(e->label,label);
	  graph.push_back(*e);
	  i ++;          
	  break;
	}
    }   

  fclose(fp);
}


void print_graph()
{

  list<edge>::iterator ig;
  list<hval>::iterator ih;

  cout << "The graph: " << endl;
  cout << "========== " << endl;

  for (ig = graph.begin() ; ig != graph.end() ; ig++)
    {
      cout << "  " << ig->start << " " << ig->end << " " << ig->label << endl;
    } 

  cout << "========== " << endl << endl;
  cout << "Start Node: " << startNode << endl;
  cout << "End Node  : " << endNode << endl;
  cout << "========== " << endl << endl;
  cout << "Heuristic Function: " << endl;

  for (ih = heuristic.begin(); ih != heuristic.end() ; ih++)
    {
	cout << "  " << ih->node << " : " << ih->value << endl;
    } 

}


void search(char *strategy)
{
  int st;

  sscanf(strategy, "%d", &st);
  cout << "Your Code Here" << endl;
  switch(st)
    {
    case 1: cout << "Depth First" << endl;
      break;
    case 2: cout << "Breadth First" << endl;
      break;
    case 3: cout << "Best First" << endl;
      break;
    default:
      break;
    }
}
