% This program tests the communication between Eclipse and JAVA
% Some important predicates in dealing with the communication 
% streams are tested here
% Used in conjunction with Test.JAVA

main:-
	remote_connect(sonyxp/1567,Peer,true),
	write('Connected'),nl,
        write('Peer:'),write(Peer),nl.

getPeerName(Peer):-
        peer(Peer), peer_get_property(Peer, language, "java").

queueToName(eclipse_to_java).
queueFromName(java_to_eclipse).

writeToQueue(X):-
        queueToName(QTo),
        write_exdr(QTo, X), 
        write('Wrote to Queue Done'), nl,
        flush(QTo).

final:-
        peer(Peer), peer_get_property(Peer, language, "java"),
        write('Peer in final:'),write(Peer),nl,
	sleep(2),
	stop(Peer).
	

yield(Peer):-
        remote_yield(Peer),
	write('Supposedly returned to Java -> '),nl.

stop(Peer):-
	write('Disconnect'),nl,
        remote_diconnected(Peer).


