//This file is a modification of the file: 
//Title:        Java/ECLiPSe interface
//Version:      $Id: QueueExample2.java,v 1.9 2001/08/29 13:50:06 josh Exp $
//Copyright:    Copyright (c) 2001
//Author:       Josh Singer
//Company:      Parc Technologies
//Description:  Java/ECLiPSe Interface example Java program
//

// This program contains methods and classes for communication 
// between JAVA and Eclipse and between JAVA and RCX
// It facilitates the connection between Indigolog (Eclipse)
// and RCX (robots).
// It is the simplest possible implementation for use with LEGOTOWER 
// USB. 
// It does not handle time out commands - as the original version of 
// Legolog. 

// the libraries needed

import com.parctechnologies.eclipse.*;
import java.io.*;
import java.util.*;
import java.net.*;
import java.lang.*;
import rcx.*;

// start of class control
// if there is no exogenous actions from keyboard 
// then the part `extends Thread' can be removed and 
// all of the instructions related to `Thread' can be removed
// from the program

public class Control extends Thread
{
  // Class variables - for Eclipse <-> Java communication
  // Create some default Eclipse options
  static EclipseEngineOptions 
            eclipseEngineOptions = new EclipseEngineOptions();

  // Data going out from java
  static ToEclipseQueue java_keyboard;

  // Object representing the Eclipse process
  static EclipseEngine eclipse;

  // Data going out from java
  static ToEclipseQueue java_to_eclipse;

  // Data coming in from eclipse
  static FromEclipseQueue eclipse_to_java;

  // Class variables - for RCX <-> Java communication
  static String  portname = new String("LEGOTOWER1"); 
  static RCXPort port;
  static BufferedOutputStream rcxOutStream;
  static BufferedInputStream  rcxInStream;
  static int     rcxRead[] = new int[9];
  static int     decodeList[] = new int[9];
  static int     seqSend[] = {85, 255, 0, 247, 8, 34, 221, 25, 230};
  static String  keyboardStr="";
  static boolean send=false;

  // run menthod for the keyboard   

  public void run() {
      BufferedReader reader = new BufferedReader(new
		InputStreamReader(System.in));

	for ( ; ; ) {
	    System.out.print("Enter a new command:");
    	    try {
		 keyboardStr = reader.readLine();
	    } catch (IOException e) {}	    
	}
  }

  // generate a 8 bytes sequence to be sent to RCX
  // actNo: action number

  public static void updateSequenceToRcx(int actNo){
      seqSend[5] = actNo;
      seqSend[6] = 255 - actNo;
      seqSend[7] = (247+actNo) % 256;
      seqSend[8] = 255 - seqSend[7];          
  }

  // send a sequence to the RCX
  public static void sendSequenceToRcx(){
      try{
         for (int i=0; i < 9; i++) {
            rcxOutStream.write(seqSend[i]);
            // System.out.print(seqSend[i] + " ");
         }
         rcxOutStream.flush();
      }
      catch(IOException ioe){}
  }

  // read a sequence of 8 bytes from RCX
  public static void getSequenceFromRcx(){
    int byteRead;
      try{
         for (int idx=0; idx < 9; idx ++){  
            for (;;){
               byteRead = rcxInStream.read(); 
	       if (byteRead != -1) break;
	    }
            // System.out.print(byteRead + " ");          
            rcxRead[idx] = byteRead;           
         }
      }
      catch(IOException ioe){}
      // System.out.println(" --> out from read RCX ");          
  }

  // the main of `Control'
  public static void main(String[] args) throws Exception
  {
    RemoteEclipse eclipse;

    Control kb = new Control();

    // create a thread for the keyboard
    // start the keyboard
    kb.start();     

    // Connect the Eclipse's standard streams to the JVM's
    eclipseEngineOptions.setUseQueues(false);

    // Initialise Eclipse
    eclipse = new RemoteEclipse(InetAddress.getByName("sonyxp"),1567);

    // System.out.println("Created connection");

    // Set up the java representation of the two queue streams
    java_to_eclipse = eclipse.getToEclipseQueue("java_to_eclipse");
    java_keyboard   = eclipse.getToEclipseQueue("java_keyboard");
    eclipse_to_java = eclipse.getFromEclipseQueue("eclipse_to_java");

    // add a TermProducer as a listener to the java_to_eclipse ToEclipseQueue
    java_to_eclipse.setListener(new TermProducer());

    // add a TermConsumer as a listener to the eclipse_to_java FromEclipseQueue
    eclipse_to_java.setListener(new TermConsumer());

    // add another TermProducer as a listener to the java_keyboard 
    java_keyboard.setListener(new KeyboardProducer());

    //System.out.println("After assigning ... and returning to eclipse");

    // set up RCX
    port = new RCXPort(portname);
    rcxOutStream = new BufferedOutputStream (port.getOutputStream());
    rcxInStream  = new BufferedInputStream (port.getInputStream());
    port.beep();
    
    // return to Eclipse
    eclipse.resume();
    // System.out.println("\nGet back and close everything");

    // close RCX after done
    rcxOutStream.close();
    rcxInStream.close();
    port.close();

    // close the keyboard
    // kb.destroy();

    // done 
  }

  /*
   * QueueListener that returns commands entered by users
     one at a time
   */
  static class KeyboardProducer implements QueueListener
  {
    ToEclipseQueue output_queue_stream = null;
    EXDROutputStream output_queue_stream_formatted = null;

    // Required to implement QueueListener
    public void dataAvailable(Object source)
    {
    }

    // Called when Eclipse tries to read from source when it is empty.
    public void dataRequest(Object source)
    { 

      if(output_queue_stream == null)
      {
	output_queue_stream = (ToEclipseQueue) source;
	output_queue_stream_formatted =
	  new EXDROutputStream(output_queue_stream);
      }
      try{
          if (!keyboardStr.equals("")){ 
	      // a command is entered 
             output_queue_stream_formatted.write(keyboardStr);
             output_queue_stream_formatted.flush();
             keyboardStr = "";
	  }
          else{
	      // no external command -- sendback a star
             output_queue_stream_formatted.write("*");
             output_queue_stream_formatted.flush();
             keyboardStr = "";
	  }
      } catch(IOException ioe){}
    }
  }




  /*
   * QueueListener -- reads response from RCX and returns 
                      to eclipse 
   */
  static class TermProducer implements QueueListener
  {
    ToEclipseQueue output_queue_stream = null;
    EXDROutputStream output_queue_stream_formatted = null;

    // Required to implement QueueListener
    public void dataAvailable(Object source)
    {
    }

    // Called when Eclipse tries to read from source when it is empty.
    public void dataRequest(Object source)
    {
      String toEclipse;
      Integer i;

      if(output_queue_stream == null)
      {
	output_queue_stream = (ToEclipseQueue) source;
	output_queue_stream_formatted =
	  new EXDROutputStream(output_queue_stream);
      }

      try
      {

          // System.out.println("\nData request");
          // get data from RCX
          getSequenceFromRcx();
          // sending to Eclipse
          // System.out.println("Sending to Eclipse " + rcxRead[5]);
          i = new Integer(rcxRead[5]);
          toEclipse = i.toString(); 
          output_queue_stream_formatted.write(toEclipse);
          output_queue_stream_formatted.flush();
      } catch(IOException ioe){}

    }
  }

  /**
   * QueueListener -- gets an instruction from eclipse, 
                      puts it through to the RCX
   */
  static class TermConsumer implements QueueListener
  {
    FromEclipseQueue input_queue_stream = null;
    EXDRInputStream input_queue_stream_formatted = null;

    // Called when Eclipse flushes source
    public void dataAvailable(Object source)
    {
      Object term;
      if(input_queue_stream == null)
      {
	input_queue_stream = (FromEclipseQueue) source;
	input_queue_stream_formatted =
	  new EXDRInputStream(input_queue_stream);
        // System.out.print("\nSending to RCX: ");
      }

      try
      {

	term = input_queue_stream_formatted.readTerm();
        String x = term.toString();
        int    actNo = Integer.parseInt(x);
        updateSequenceToRcx(actNo);
        sendSequenceToRcx();
      } catch(IOException ioe){}

    }

    // Required to implement QueueListener
    public void dataRequest(Object source)
    {
    }
  }

}
