%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% FILE: main.pl
%
% This file is a modification of the main_ecl.pl from the LEGOLOG packet
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DYNAMIC DECLARATIONS
%  These are not required by all Prologs so we include them here so as
%  to make the system-independent files as independent as possible
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% IndiGolog
:- dynamic(indi_exog/1).
:- dynamic(currently/2).
:- dynamic(temp/2).
assertz(X) :- assert(X).
retractall(X) :- retract_all(X).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CONSULT NECESSARY FILES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Consult Lego subsystem plus IndiGolog interpreter

:- set_flag(all_dynamic,on). % ECLiPSe can't deal with predicates not being
                             % listed contiguously
:- ['golog'].                % IndiGolog interpreter
:- ['delivery'].             % Golog delivery program

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% preparation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Msg numbers in RCX for send/receive
% rcxMessageRange(+MesgType, -MesgLow, -MesgHigh, -MesgBase): Send messages
%     using numbered RCX messages in the range MesgLow--MesgHigh in
%     base MesgBase (= 2^n where n is the number of bits per message)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Many of the following constants are not used in this version
% I leave it here for future works
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rcxMessageRange(action, 32, 63, 16).  % Primitive action message range
rcxMessageRange(value, 64, 79, 8).    % Sensing value message range

% Special message numbers
rcxPanicMessage(80).     % Panic message - RCX is in a panicked state
rcxAbortMessage(81).     % Abort message - reset RCX
rcxContinueMessage(82).  % Used for synchronisation in multi-part messages
rcxExogReqMessage(83).   % Request whether RCX has exogenous action to report
rcxNoExogMessage(84).    % Response from RCX when no detected exogenous actions
rcxDelayMessage(85).     % Response from RCX to obtain more time for the
                         %   execution of a primitive action

% Delays in hundredths of seconds
rcxResponseDelay(30).    % Normal delay for RCX that is ready to answer
rcxPyramidDelay(350).    % Window of time while infrared Pyramid is active
rcxLongDelay(1500).      % Time for RCX to complete longest behaviour
rcxGetDelay(50).         % Minimum time between subsequent rcxGetMess

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Defining the streams for communication between Eclipse and JAVA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rcxFromStream(java_to_eclipse).   % for reading from JAVA/RCX
rcxToStream(eclipse_to_java).     % for writing to JAVA/RCX 
keyboardStream(java_keyboard).    % for reading from JAVA (keyboard)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MAIN PREDICATE - evaluate this to run demo
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%main: Gets IndiGolog to evaluate main control procedure

main_test :-                                    % run the test procedure
	remote_connect(sonyxp/1567,Peer,true),
	write('Connected'),nl,
        write('Peer:'),write(Peer),nl,
        indigolog(test),
        remote_yield(Peer),
        remote_disconnect(Peer).

main_control :-                                 % run the control procedure
	remote_connect(sonyxp/1567,Peer,true),
	write('Connected'),nl,
        write('Peer:'),write(Peer),nl,
        indigolog(control),
        remote_yield(Peer),
        remote_disconnect(Peer).

% a simple procedure for decoding an action number

decodeNumber(N, NumberType, [First|Rest]):-
    write('In decode '),write(N),nl,
    rcxMessageRange(NumberType, Low, _, Base),
    (N < Base -> (First is N+Low, Rest = []) ;
                 (First is N, Rest = [])).


% sendRcxActionNumber(+Num, -Result): Send action number N and obtain
%     sensing value Result. Fails if RCX does not return Result

sendRcxActionNumber(Num, Reply) :-
    write('Sending action to RCX: '),write(Num),nl,
    decodeNumber(Num, action, Nums), 
    sendRcxBytes(Nums, Reply),
    write('Result from RCX: '),write(Reply),nl.

sendRcxBytes([Ascii|[]], Reply):-
    rcxToStream(Rcx),
    write('Eclipse write 1 '),write(Ascii),nl,
    write_exdr(Rcx, Ascii),
    flush(Rcx),
    getRcxMess(Reply), !.

sendRcxBytes([Ascii, A | Nums], Reply):-
    rcxToStream(Rcx),
    write('Eclipse write 2 '),write(Ascii),nl,
    write_exdr(Rcx, Ascii),
    flush(Rcx),
    getRcxMess(NoUse), 
    sendRcxBytes([A|Nums], Reply).

% getRcxMess(-MesgNo): 
%   Get a message from RCX

getRcxMess(MesgNo) :-
    write("Ask for result:"), 
    rcxFromStream(Rcx),
    read_exdr(Rcx, Str), 
    number_string(MesgNo, Str), 
    write("Get a message from RCX:"), 
    write(MesgNo),nl.      % ethem out to the RCX    

sendRcxBytes([], _).

% Check for exogenous actions

checkOtherExog(ExogList) :-
    checkKeyboardExog(ExogList).

% Check for exogenous actions from the keyboard

checkKeyboardExog([KbExog]) :-
    keyboardStream(KbStream),
    read_exdr(KbStream, Str), 
    write("Get a message from keyboard:"), 
    write(Str),
    term_string(Term, Str), 
    ((Term = +(From, To), KbExog = request_delivery(From, To));
        (Term = -(From, To), KbExog = cancel_request(From, To))).

checkKeyboardExog([]).

receiveRcxActionNumber(Actions) :-
    rcxExogReqMessage(Msg),
    sendRcxActionNumber(Msg, Ans),
    write('Received action '), write(Ans), nl,
    (Ans = 83 -> Actions = [];
                (getActionNumber(Ans, action, N), Actions = [N])).

getActionNumber(Ans, NumberType, N):-
    rcxMessageRange(NumberType, Low, High, Base),
    Ans >= Low, Ans =< High,
    M is Ans - Low,
    N is M.

