// This program tests the communication between Eclipse and JAVA
// Used in conjunction with ec.pl

import com.parctechnologies.eclipse.*;
import java.io.*;
import java.net.*;

public class Test
{

  // Create some default Eclipse options
  static EclipseEngineOptions eclipseEngineOptions = new EclipseEngineOptions();

  // Object representing the Eclipse process
  static EclipseEngine eclipse;

  // Path of the Eclipse program
  static File eclipseProgram;

  // Data going out from java
  static ToEclipseQueue java_to_eclipse;

  // Data coming in from eclipse
  static FromEclipseQueue eclipse_to_java;

  public static void main(String[] args) throws Exception
  {
    RemoteEclipse eclipse;
    long count; 

    // Connect the Eclipse's standard streams to the JVM's
    eclipseEngineOptions.setUseQueues(false);

    eclipse = new RemoteEclipse(InetAddress.getByName("sonyxp"),1567);
    System.out.println("Created connection");

    // Set up the java representation of the two queue streams
    eclipse_to_java = eclipse.getFromEclipseQueue("eclipse_to_java");

    System.out.println("After get from eclipse queue");

    // add a TermConsumer as a listener to the eclipse_to_java FromEclipseQueue
    eclipse_to_java.setListener(new TermConsumer());


    System.out.println("After assigning the term consumer and returning to eclipse");

    eclipse.resume();

    System.out.println("Back into java");

  }


  /**
   * QueueListener whose dataAvailable method reads a term
   * in exdr format from the queue it is attached to, converts it to the
   * Java representation of the term, and prints this out to stdout.
   */
  static class TermConsumer implements QueueListener
  {
    FromEclipseQueue input_queue_stream = null;
    EXDRInputStream input_queue_stream_formatted = null;

    // Called when Eclipse flushes source
    public void dataAvailable(Object source)
    {

      System.out.println("IN DATA AVAILABLE");
      if(input_queue_stream == null)
      {
	input_queue_stream = (FromEclipseQueue) source;
	input_queue_stream_formatted =
	  new EXDRInputStream(input_queue_stream);
      }

      try
      {
        System.out.println(input_queue_stream_formatted.readTerm());
      } catch(IOException ioe){}

    }
    // Required to implement QueueListener
    public void dataRequest(Object source)
    {
    }

  }
}
