/*
 * Decompiled with CFR 0.152.
 */
package rcx.comm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rcx.comm.USBInputStream;
import rcx.comm.USBOutputStream;
import rcx.comm.USBPort;

public class LinuxUSBPort
implements USBPort {
    static boolean LibLoaded;
    boolean closed = true;
    private InputStream ins;
    private OutputStream outs;
    int receiveTimeout = 0;
    protected String name;

    private native int _open(String var1);

    private native int _read();

    private native int _read(byte[] var1, int var2, int var3);

    private native int _write(int var1);

    private native int _write(byte[] var1, int var2, int var3);

    private native int _close();

    private native int _setReceiveTimeout(int var1);

    private native int _available();

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int open(String string) throws IOException {
        if (this._open(this.name) < 0) {
            return -1;
        }
        this.closed = false;
        this.outs = new USBOutputStream(this);
        this.ins = new USBInputStream(this);
        return 0;
    }

    public LinuxUSBPort() {
        if (!LibLoaded) {
            try {
                System.loadLibrary("linuxusb");
            }
            catch (SecurityException securityException) {
                System.err.println("Security Exception loading: " + securityException);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println("Error loading: " + unsatisfiedLinkError);
                return;
            }
            catch (Exception exception) {
                System.err.println("Exception with: " + exception);
                return;
            }
            LibLoaded = true;
        }
    }

    public int read() throws IOException {
        int n = this._read();
        if (n == -2) {
            throw new IOException();
        }
        return n;
    }

    public void write(int n) throws IOException {
        int n2 = this._write(n);
    }

    public void close() {
        this._close();
        this.closed = true;
    }

    public int available() throws IOException {
        int n = this._available();
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = this._read(byArray, n, n2);
        return n3;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this._write(byArray, n, n2) < 0) {
            throw new IOException();
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.ins;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.outs;
    }

    public void enableReceiveThreshold(int n) {
    }

    public void disableReceiveThreshold() {
    }

    public boolean isReceiveThresholdEnabled() {
        return false;
    }

    public int getReceiveThreshold() {
        return -1;
    }

    public void enableReceiveTimeout(int n) {
        this.receiveTimeout = n;
        this._setReceiveTimeout(this.receiveTimeout);
    }

    public void disableReceiveTimeout() {
    }

    public boolean isReceiveTimeoutEnabled() {
        return false;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void enableReceiveFraming(int n) {
    }

    public void disableReceiveFraming() {
    }

    public boolean isReceiveFramingEnabled() {
        return false;
    }

    public int getReceiveFramingByte() {
        return -1;
    }

    public void setInputBufferSize(int n) {
    }

    public int getInputBufferSize() {
        return -1;
    }

    public void setOutputBufferSize(int n) {
    }

    public int getOutputBufferSize() {
        return -1;
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

