/*
 * Decompiled with CFR 0.152.
 */
package rcx;

import rcx.RCXPort;

public class Sensor {
    public static Sensor S1;
    public static Sensor S2;
    public static Sensor S3;
    public static Sensor[] SENSORS;
    public int emulval;
    private int sensorId;
    private RCXPort port;

    public Sensor(int n, RCXPort rCXPort) {
        this.sensorId = n;
        this.port = rCXPort;
    }

    public static void setPort(RCXPort rCXPort) {
        S1 = new Sensor(0, rCXPort);
        S2 = new Sensor(1, rCXPort);
        S3 = new Sensor(2, rCXPort);
        Sensor.SENSORS[0] = S1;
        Sensor.SENSORS[1] = S2;
        Sensor.SENSORS[2] = S3;
    }

    public final int readValue() {
        return this.port.readSensorValue(this.sensorId, 1);
    }

    public final int readRawValue() {
        return this.port.readSensorValue(this.sensorId, 0);
    }

    public final boolean readBooleanValue() {
        return this.port.readSensorValue(this.sensorId, 1) > 0;
    }

    public final int getId() {
        return this.sensorId;
    }

    public final void activate() {
    }

    public final void passivate() {
    }

    public final void setTypeAndMode(int n, int n2) {
        this.port.setSensorValue(this.sensorId, n, 1);
        this.port.setSensorValue(this.sensorId, n2, 0);
    }

    public final void setPreviousValue(int n) {
        this.port.setSensorValue(this.sensorId, n, 2);
    }

    static {
        SENSORS = new Sensor[]{S1, S2, S3};
    }
}

