/*
 * Decompiled with CFR 0.152.
 */
package rcx;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import rcx.RCXErrorListener;
import rcx.RCXPort;

public class RCXServer
implements RCXErrorListener,
Runnable {
    private ServerSocket listenSocket;
    private Socket tcpPort;
    private int portNumber;
    private RCXPort rcxPort;
    private String rcxPortName;
    private boolean waitforRCX = true;
    private boolean waitforClient = true;

    public static void main(String[] stringArray) {
        int n = 174;
        try {
            if (stringArray.length > 1) {
                n = Integer.parseInt(stringArray[1]);
            }
            if (stringArray.length > 0) {
                RCXServer rCXServer = new RCXServer(stringArray[0], n);
                rCXServer.run();
                rCXServer.stop();
            } else {
                System.out.println("Usage: RCXServer rcxportname [port number]");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RCXServer(String string, int n) {
        this.rcxPortName = string;
        this.portNumber = n;
    }

    public void run() {
        RCXPort.skipalive = true;
        boolean bl = true;
        try {
            this.listenSocket = new ServerSocket(this.portNumber);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        System.out.println("creating rcx port on " + this.rcxPortName);
        this.rcxPort = new RCXPort(this.rcxPortName);
        this.rcxPort.addRCXErrorListener(this);
        while (this.waitforClient) {
            this.waitforRCX = true;
            if (!this.rcxPort.isOpen()) {
                return;
            }
            System.out.println("Listening on port " + this.portNumber);
            try {
                this.tcpPort = this.listenSocket.accept();
                try {
                    System.out.println("accepted connection to " + this.tcpPort.getInetAddress().getHostName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.tcpPort.getInputStream());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.tcpPort.getOutputStream());
                this.rcxPort.setStreams(bufferedInputStream, bufferedOutputStream);
                while (this.waitforRCX) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    System.out.println("disconnecting " + this.tcpPort.getInetAddress().getHostName());
                    this.tcpPort.close();
                }
                catch (Exception exception) {}
            }
            catch (IOException iOException) {
                try {
                    System.out.println("Exception - disconnecting " + this.tcpPort.getInetAddress().getHostName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.tcpPort.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void stop() {
        this.waitforClient = false;
        this.waitforRCX = false;
        if (this.tcpPort != null) {
            try {
                this.tcpPort.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.listenSocket != null) {
            try {
                this.listenSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void receivedError(String string) {
        System.err.println("Server got error: " + string);
        this.waitforRCX = false;
        if (this.tcpPort != null) {
            try {
                this.tcpPort.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

