/*
 * Decompiled with CFR 0.152.
 */
package rcx;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import rcx.AllMessagesListener;
import rcx.Motor;
import rcx.RCXCommPort;
import rcx.RCXErrorListener;
import rcx.RCXListener;
import rcx.RCXOpcode;
import rcx.RCXSerialPort;
import rcx.RCXSocketPort;
import rcx.RCXUSBPort;
import rcx.Sensor;
import rcx.StreamSwap;

public class RCXPort {
    public static boolean debug = false;
    public static boolean skipalive = false;
    public boolean isEmulation;
    private static int MAXRETRIES = 3;
    private static int BUFFSIZE = 4096;
    private boolean isUSB;
    private boolean isSocket;
    private String portName;
    private OutputStream os;
    private InputStream is;
    private boolean open;
    private byte[] responseArray = new byte[BUFFSIZE];
    private byte[] respArray = new byte[BUFFSIZE];
    private RCXListener rcxListener;
    private AllMessagesListener allmsgListener;
    private RCXErrorListener errorListener;
    private int numread;
    private int numretry;
    private byte[] lastcommandArray;
    private byte[] message;
    private boolean towerError;
    private boolean rcxError;
    private byte inputcommand;
    private byte lastcommand;
    private String lasterror;
    private int lastreturnval;
    private RCXOpcode opcodes;
    private StreamSwap outin;
    private RCXCommPort port;

    public RCXPort() {
        this.init(null);
    }

    public void init(String string) {
        this.open = false;
        this.opcodes = new RCXOpcode();
        Motor.setPort(this);
        Sensor.setPort(this);
        this.open(string);
    }

    public RCXPort(String string) {
        this.init(string);
    }

    public void addRCXListener(RCXListener rCXListener) {
        this.rcxListener = rCXListener;
    }

    public void addAllMessagesListener(AllMessagesListener allMessagesListener) {
        this.allmsgListener = allMessagesListener;
    }

    public void addRCXErrorListener(RCXErrorListener rCXErrorListener) {
        this.errorListener = rCXErrorListener;
    }

    public void setDebug(boolean bl) {
        debug = bl;
    }

    protected void initPort() {
        this.port = this.isUSB ? new RCXUSBPort() : (this.isSocket ? new RCXSocketPort() : new RCXSerialPort());
    }

    public void open(String string) {
        this.portName = string;
        if (this.portName == null) {
            Vector vector = RCXSerialPort.getAvailableSerialPorts();
            if (vector.size() == 0) {
                System.err.print("no available serial ports found -");
                System.err.println(" check if other apps are in conflict");
            }
            try {
                this.portName = (String)vector.firstElement();
            }
            catch (Exception exception) {
                this.portName = null;
                return;
            }
        } else if (string.startsWith("LEGO")) {
            this.isUSB = true;
        } else if (string.equals("EMULATION")) {
            this.isEmulation = true;
            this.open = true;
        } else if (string.startsWith("rcx://")) {
            this.isSocket = true;
        }
        if (!this.isEmulation) {
            this.open();
            if (!skipalive) {
                this.alive();
            }
        }
    }

    public void alive() {
        byte[] byArray = new byte[]{16};
        this.write(byArray);
    }

    public boolean open() {
        if (this.open) {
            return true;
        }
        this.initPort();
        this.open = this.port.open(this.portName);
        if (this.open) {
            try {
                this.os = new BufferedOutputStream(this.port.getOutputStream(), 4096);
                this.is = new BufferedInputStream(this.port.getInputStream(), 4096);
            }
            catch (Exception exception) {
                this.port.close();
                return this.open;
            }
        }
        return this.open;
    }

    public void close() {
        if (this.outin != null) {
            this.outin.stop();
        }
        if (!this.open || this.isEmulation) {
            return;
        }
        if (this.port != null) {
            try {
                this.os.close();
                this.is.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            this.port.close();
        }
        this.open = false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean bl) {
        if (this.outin != null) {
            this.outin.stop();
        }
        this.outin = null;
        this.open = bl;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public void setStreams(InputStream inputStream, OutputStream outputStream) {
        if (this.outin != null) {
            this.outin.stop();
        }
        this.outin = new StreamSwap(inputStream, outputStream, this);
    }

    public synchronized boolean write(byte[] byArray) {
        if (debug) {
            System.out.println("port write(): " + RCXPort.ArrayToString(byArray, byArray.length));
        }
        int n = 3;
        int n2 = 0;
        if (this.isEmulation) {
            return true;
        }
        if (byArray.length < 1) {
            return false;
        }
        this.lasterror = null;
        if (this.isSocket) {
            try {
                this.os.write(byArray);
                this.os.flush();
                this.numread = this.is.read(this.responseArray, 0, BUFFSIZE);
                if (debug && this.numread > 0) {
                    System.out.println("socket read(): numread = " + this.numread + " array=" + RCXPort.ArrayToString(this.responseArray, this.numread));
                }
                byte[] byArray2 = new byte[this.numread];
                System.arraycopy(this.responseArray, 0, byArray2, 0, this.numread);
                this.processMessage(byArray2);
                if (this.allmsgListener != null) {
                    this.allmsgListener.receivedMessage(byArray2);
                }
                if (this.rcxListener != null) {
                    this.rcxListener.receivedMessage(byArray2);
                }
            }
            catch (Exception exception) {
                if (this.errorListener != null) {
                    this.errorListener.receivedError("socket write or read error");
                }
                this.open = false;
                return false;
            }
            return true;
        }
        byte[] byArray3 = new byte[byArray.length * 2 + 5];
        byArray3[0] = 85;
        byArray3[1] = -1;
        byArray3[2] = 0;
        if (this.lastcommand == byArray[0]) {
            byArray[0] = (byArray[0] & 8) == 0 ? (byte)(byArray[0] | 8) : (byte)(byArray[0] & 0xFFFFFFF7);
        }
        this.lastcommand = byArray[0];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray3[n] = byArray[n3];
            byArray3[n + 1] = ~byArray[n3];
            n2 += byArray3[n];
            n += 2;
            ++n3;
        }
        byArray3[n] = (byte)n2;
        byArray3[n + 1] = (byte)(~n2);
        try {
            this.os.write(byArray3);
            this.os.flush();
        }
        catch (Exception exception) {
            this.lasterror = "error writing to port";
            this.lastcommandArray = null;
            return false;
        }
        this.lastcommandArray = byArray3;
        if (debug) {
            System.out.println("wrote out: " + RCXPort.ArrayToString(byArray3, byArray3.length));
        }
        this.processRead();
        return true;
    }

    public boolean send(String string) {
        byte[] byArray = RCXOpcode.parseString(string);
        return this.write(byArray);
    }

    private void processRead() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (this.numretry < MAXRETRIES) {
            block38: {
                if (this.rcxError || this.towerError) {
                    this.rcxError = false;
                    this.towerError = false;
                    try {
                        this.os.write(this.lastcommandArray);
                        this.os.flush();
                    }
                    catch (Exception exception) {
                        this.lastcommandArray = null;
                        this.lasterror = "error writing to port";
                        System.err.println("Error: " + this.lasterror);
                        if (this.isSocket) {
                            this.open = false;
                        }
                        if (this.errorListener != null) {
                            this.errorListener.receivedError(this.lasterror);
                        }
                        if (this.rcxListener == null) break;
                        this.rcxListener.receivedError(this.lasterror);
                        break;
                    }
                }
                try {
                    if (((String)RCXOpcode.Opcodes.get(new Byte((byte)(this.lastcommand & 0xFFFFFFF7)))).endsWith("C")) break;
                    if (this.isUSB || (this.lastcommand & 0xFFFFFFF7) != RCXOpcode.GETMEMMAP) break block38;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    break;
                }
            }
            try {
                if (!this.isUSB) {
                    this.numread = this.is.read(this.responseArray, 0, BUFFSIZE);
                    if (debug && this.numread > 0) {
                        System.out.println("processRead(): numread = " + this.numread + " array=" + RCXPort.ArrayToString(this.responseArray, this.numread));
                    }
                } else {
                    this.numread = 1;
                    n2 = 0;
                    while (this.numread > 0) {
                        this.numread = this.is.read(this.respArray, 0, BUFFSIZE);
                        if (this.numread <= 0) continue;
                        if (debug) {
                            System.out.println("processRead(): numreadsofar=" + n2 + " numread=" + this.numread + " array=" + RCXPort.ArrayToString(this.respArray, this.numread));
                        }
                        System.arraycopy(this.respArray, 0, this.responseArray, n2, this.numread);
                        n2 += this.numread;
                    }
                    this.numread = n2;
                }
            }
            catch (Exception exception) {
                this.lasterror = "error reading from port ";
                System.err.println("Error: " + this.lasterror);
                if (this.isSocket) {
                    this.open = false;
                }
                if (this.errorListener != null) {
                    this.errorListener.receivedError(this.lasterror);
                }
                if (this.rcxListener != null) {
                    this.rcxListener.receivedError(this.lasterror);
                }
                this.rcxError = false;
                this.towerError = false;
                break;
            }
            if (!this.isUSB) {
                if (this.lastcommandArray.length > this.numread) {
                    this.lasterror = "error reading message from tower";
                    this.towerError = true;
                    ++this.numretry;
                    continue;
                }
                if (this.responseArray[0] != 85 && this.responseArray[0] != -86 || this.responseArray[1] != -1 || this.responseArray[2] != 0) {
                    this.lasterror = "error in message header from tower";
                    this.towerError = true;
                    ++this.numretry;
                    continue;
                }
                n = this.lastcommandArray.length;
            } else {
                n = 0;
            }
            if (n == this.numread) {
                this.lasterror = "no reponse from RCX";
                this.rcxError = true;
                ++this.numretry;
                continue;
            }
            if (this.numread < n + 7 || (this.numread - n - 3) % 2 != 0) {
                this.lasterror = "error in response length from RCX";
                this.rcxError = true;
                ++this.numretry;
                continue;
            }
            if (this.responseArray[n] != 85 && this.responseArray[n] != -86 || this.responseArray[n + 1] != -1 || this.responseArray[n + 2] != 0) {
                this.lasterror = "error in response header from RCX";
                this.rcxError = true;
                ++this.numretry;
                continue;
            }
            this.message = new byte[(this.numread - (n + 3)) / 2 - 1];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            n4 = n + 3;
            while (n4 < this.numread) {
                if (this.responseArray[n4 + 1] != ~this.responseArray[n4]) {
                    this.lasterror = "error in response from RCX";
                    this.rcxError = true;
                    ++this.numretry;
                } else if (n4 < this.numread - 2) {
                    this.message[n5++] = this.responseArray[n4];
                    n3 += this.responseArray[n4];
                }
                n4 += 2;
            }
            if ((byte)n3 != this.responseArray[this.numread - 2]) {
                this.lasterror = "error in response from RCX";
                this.rcxError = true;
                ++this.numretry;
                continue;
            }
            if (this.responseArray[n + 3] != ~this.lastcommandArray[3]) {
                this.lasterror = "error - invalid response from RCX";
                this.rcxError = true;
                ++this.numretry;
                continue;
            }
            if (this.rcxError || this.towerError) continue;
            this.numretry = 0;
            if ((this.message[0] & 8) == 8) {
                this.message[0] = (byte)(this.message[0] & 0xFFFFFFF7);
            }
            this.processMessage(this.message);
            if (this.allmsgListener != null) {
                this.allmsgListener.receivedMessage(this.message);
            }
            if (this.rcxListener == null) break;
            this.rcxListener.receivedMessage(this.message);
            break;
        }
        if (this.towerError || this.rcxError) {
            System.err.println("Error: " + this.lasterror);
            if (this.errorListener != null) {
                this.errorListener.receivedError(this.lasterror);
            }
            if (this.rcxListener != null) {
                this.rcxListener.receivedError(this.lasterror);
            }
            this.message = null;
            this.numretry = 0;
        }
    }

    public String getLastError() {
        return this.lasterror;
    }

    public int getLastValue() {
        return this.lastreturnval;
    }

    public static String ArrayToString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = byArray[n3];
            if (n2 < 0) {
                n2 += 256;
            }
            stringBuffer.append(Integer.toHexString(n2) + " ");
            ++n3;
        }
        return stringBuffer.toString();
    }

    public void processMessage(byte[] byArray) {
        block5: {
            int n = 0;
            int n2 = 0;
            if (byArray == null || byArray.length != 3) {
                return;
            }
            try {
                n = byArray[1];
                n2 = byArray[2];
                if (n < 0) {
                    n += 256;
                }
                if (n2 < 0) {
                    n2 += 256;
                }
                this.lastreturnval = n2 << 8;
                this.lastreturnval |= n;
            }
            catch (Exception exception) {
                if (!debug) break block5;
                exception.printStackTrace();
            }
        }
    }

    public void setError(String string) {
        if (this.errorListener != null) {
            this.errorListener.receivedError(string);
        }
    }

    public void beep() {
        this.systemSound(true, 0);
    }

    public void twoBeeps() {
        this.systemSound(true, 1);
    }

    public void beepSequence() {
        this.systemSound(true, 2);
    }

    public void beepSequenceUp() {
        this.systemSound(true, 3);
    }

    public void buzz() {
        this.systemSound(true, 4);
    }

    public void upwardTones() {
        this.systemSound(true, 5);
    }

    public void systemSound(boolean bl, int n) {
        byte[] byArray = new byte[]{81, 0};
        byArray[1] = (byte)n;
        this.write(byArray);
    }

    public void playTone(int n, int n2) {
        byte[] byArray = new byte[]{35, 0, 0, 0};
        int n3 = n >> 8;
        byArray[1] = (byte)(n & 0xFF);
        byArray[2] = (byte)n3;
        byArray[3] = (byte)(n2 / 10);
        this.write(byArray);
    }

    public void controlMotor(char c, short s, short s2) {
        if (this.isEmulation) {
            System.out.print("Motor " + c + " is ");
            switch (s) {
                case 1: {
                    System.out.print("moving forward");
                    break;
                }
                case 2: {
                    System.out.print("moving backard");
                    break;
                }
                case 3: {
                    System.out.print("stopping");
                    break;
                }
                case 4: {
                    System.out.print("stopping (floating)");
                }
            }
            System.out.println(".");
        } else {
            byte[] byArray;
            byte[] byArray2 = new byte[]{1, 2, 4};
            byte by = (byte)(c - 65);
            byte[] byArray3 = new byte[]{-128, 0};
            byte[] byArray4 = new byte[]{-128, -128, 64, 0};
            if (s2 > 7) {
                s2 = (short)7;
            } else if (s2 < 0) {
                s2 = 0;
            }
            byte by2 = (byte)s2;
            byte by3 = 3;
            if (s > 0 && s < 3) {
                byArray = new byte[]{-31, (byte)(byArray3[s - 1] | byArray2[by])};
                this.write(byArray);
            }
            byArray = new byte[]{19, by, by3, by2};
            this.write(byArray);
            byte[] byArray5 = new byte[]{33, (byte)(byArray4[s - 1] | byArray2[by])};
            this.write(byArray5);
        }
    }

    public int readSensorValue(int n, int n2) {
        byte[] byArray = new byte[]{18, 9, 19};
        if (this.isEmulation) {
            return Sensor.SENSORS[n].emulval;
        }
        byte[] byArray2 = new byte[]{18, byArray[n2], (byte)n};
        this.write(byArray2);
        return this.getLastValue();
    }

    public void setSensorValue(int n, int n2, int n3) {
        if (this.isEmulation) {
            Sensor.SENSORS[n].emulval = n2;
            return;
        }
        byte[] byArray = new byte[]{50, (byte)n, (byte)n2};
        if (n3 == 1) {
            this.write(byArray);
        } else if (n3 == 0) {
            byArray[0] = 66;
            this.write(byArray);
        }
    }

    public float getBatteryPower() {
        byte[] byArray = new byte[]{48};
        this.write(byArray);
        return (float)this.getLastValue() / 1000.0f;
    }
}

