/*
 * Decompiled with CFR 0.152.
 */
package rcx;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Hashtable;

public class RCXOpcode {
    public static Hashtable Opcodes = new Hashtable(55);
    public static byte PING = (byte)16;
    public static byte GETVAL = (byte)18;
    public static byte SETMOTORPOWER = (byte)19;
    public static byte SETVAL = (byte)20;
    public static byte GETVERSIONS = (byte)21;
    public static byte CALLSUB = (byte)23;
    public static byte GETMEMMAP = (byte)32;
    public static byte SETMOTOR = (byte)33;
    public static byte SETTIME = (byte)34;
    public static byte PLAYTONE = (byte)35;
    public static byte ADDVAR = (byte)36;
    public static byte DOWNLOADTASK = (byte)37;
    public static byte BRANCHALWAYSNEAR = (byte)39;
    public static byte GETBATTERYPOWER = (byte)48;
    public static byte SETTRANSMITRANGE = (byte)49;
    public static byte SETSENSORTYPE = (byte)50;
    public static byte SETDISPLAY = (byte)51;
    public static byte SUBFROMVAR = (byte)52;
    public static byte DOWNLOADSUB = (byte)53;
    public static byte DECLOOPCNTRNEAR = (byte)55;
    public static byte DELALLTASKS = (byte)64;
    public static byte SETSENSORMODE = (byte)66;
    public static byte WAIT = (byte)67;
    public static byte DIVIDEVAR = (byte)68;
    public static byte TRANSFERDATA = (byte)69;
    public static byte STOPALLTASKS = (byte)80;
    public static byte PLAYSOUND = (byte)81;
    public static byte SETDATALOGSIZE = (byte)82;
    public static byte MULTIPLYVAR = (byte)84;
    public static byte POWEROFF = (byte)96;
    public static byte DELTASK = (byte)97;
    public static byte DATALOGNEXT = (byte)98;
    public static byte SIGNVAR = (byte)100;
    public static byte DELFIRMWARE = (byte)101;
    public static byte DELALLSUBS = (byte)112;
    public static byte STARTTASK = (byte)113;
    public static byte BRANCHALWAYSFAR = (byte)114;
    public static byte ABSVAL = (byte)116;
    public static byte DOWNLOADFIRMWARE = (byte)117;
    public static byte STOPTASK = (byte)-127;
    public static byte SETLOOPCOUNTER = (byte)-126;
    public static byte ANDVAR = (byte)-124;
    public static byte TESTANDBRANCHNEAR = (byte)-123;
    public static byte CLEARMESSAGE = (byte)-112;
    public static byte SETPROGRAMNUM = (byte)-111;
    public static byte DECCNTRANDBRANCH = (byte)-110;
    public static byte ORVAR = (byte)-108;
    public static byte TESTANDBRANCH = (byte)-107;
    public static byte CLEARTIME = (byte)-95;
    public static byte UPLOADDATALOG = (byte)-92;
    public static byte UNLOCKFIRMWARE = (byte)-91;
    public static byte SETPOWERDOWN = (byte)-79;
    public static byte SENDMESSAGE = (byte)-78;
    public static byte DELSUB = (byte)-63;
    public static byte CLEARSENSOR = (byte)-47;
    public static byte REMOTECOMMAND = (byte)-46;
    public static byte SETMOTORDIR = (byte)-31;
    public static byte SETMESSAGE = (byte)-9;
    private static Frame opcodeFrame;
    private static TextArea opcodeTextArea;

    public RCXOpcode() {
        Opcodes.put(new Byte(16), "PING            ,void, void,P");
        Opcodes.put(new Byte(18), "GETVAL          ,byte src byte arg, short val,P");
        Opcodes.put(new Byte(19), "SETMOTORPOWER   ,byte motors byte src byte arg, void,CP");
        Opcodes.put(new Byte(20), "SETVAL          ,byte index byte src byte arg, void,CP");
        Opcodes.put(new Byte(21), "GETVERSIONS     ,byte key[5], short rom[2] short firmware[2],P");
        Opcodes.put(new Byte(23), "CALLSUB         ,byte subroutine, void,C");
        Opcodes.put(new Byte(32), "GETMEMMAP       ,void, short map[94],P");
        Opcodes.put(new Byte(33), "SETMOTOR        ,byte code, void,CP");
        Opcodes.put(new Byte(34), "SETTIME         ,byte hours byte minutes, void,CP");
        Opcodes.put(new Byte(35), "PLAYTONE        ,short frequency byte duration, void,CP");
        Opcodes.put(new Byte(36), "ADDVAR          ,byte index byte src short arg, void,CP");
        Opcodes.put(new Byte(37), "DOWNLOADTASK    ,byte unknown short task short length, byte error,P");
        Opcodes.put(new Byte(39), "BRANCHALWAYSNEAR,byte offset, void,C");
        Opcodes.put(new Byte(48), "GETBATTERYPOWER ,void, short millivolts,P");
        Opcodes.put(new Byte(49), "SETTRANSMITRANGE,byte range, void,CP");
        Opcodes.put(new Byte(50), "SETSENSORTYPE   ,byte sensor byte type, void,CP");
        Opcodes.put(new Byte(51), "SETDISPLAY      ,byte src short arg, void,CP");
        Opcodes.put(new Byte(52), "SUBFROMVAR      ,byte index byte src short arg, void,CP");
        Opcodes.put(new Byte(53), "DOWNLOADSUB     ,byte unknown short subroutine short length, byte error,P");
        Opcodes.put(new Byte(64), "DELALLTASKS     ,void, void,CP");
        Opcodes.put(new Byte(66), "SETSENSORMODE   ,byte sensor byte code, void,CP");
        Opcodes.put(new Byte(67), "WAIT            ,byte src short arg, void,C");
        Opcodes.put(new Byte(68), "DIVIDEVAR       ,byte index byte src short arg, void,CP");
        Opcodes.put(new Byte(69), "TRANSFERDATA    ,short index short length byte data[length] byte checksum, byte error,P");
        Opcodes.put(new Byte(80), "STOPALLTASKS    ,void, void,CP");
        Opcodes.put(new Byte(81), "PLAYSOUND       ,byte sound, void,CP");
        Opcodes.put(new Byte(82), "SETDATALOGSIZE  ,short size, byte error,CP");
        Opcodes.put(new Byte(84), "MULTIPLYVAR     ,byte index byte src short arg, void,CP");
        Opcodes.put(new Byte(96), "POWEROFF        ,void, void,CP");
        Opcodes.put(new Byte(97), "DELTASK         ,byte task, void,CP");
        Opcodes.put(new Byte(98), "DATALOGNEXT     ,byte src byte arg, byte error,CP");
        Opcodes.put(new Byte(100), "SIGNVAR         ,byte index byte src short arg, void,CP");
        Opcodes.put(new Byte(101), "DELFIRMWARE     ,byte key[5], void,CP");
        Opcodes.put(new Byte(112), "DELALLSUBS      ,void, void,CP");
        Opcodes.put(new Byte(113), "STARTTASK       ,byte task, void,CP");
        Opcodes.put(new Byte(114), "BRANCHALWAYSFAR ,byte offset byte extension, void,C");
        Opcodes.put(new Byte(116), "ABSVAL          ,byte index byte src short arg, void,CP");
        Opcodes.put(new Byte(117), "DOWNLOADFIRMWARE,short address short checksum byte unknown, void,P");
        Opcodes.put(new Byte(-127), "STOPTASK        ,byte task, void,CP");
        Opcodes.put(new Byte(-126), "SETLOOPCOUNTER  ,byte src byte arg, void,C");
        Opcodes.put(new Byte(-124), "ANDVAR          ,byte index byte src byte arg, void,CP");
        Opcodes.put(new Byte(-112), "CLEARMESSAGE    ,void, void,C");
        Opcodes.put(new Byte(-111), "SETPROGRAMNUM   ,byte program, void,CP");
        Opcodes.put(new Byte(-110), "DECCNTRANDBRANCH,short offset, void,C");
        Opcodes.put(new Byte(-108), "ORVAR           ,byte index byte src byte arg, void,CP");
        Opcodes.put(new Byte(-107), "TESTANDBRANCH   ,byte opsrc1 byte src2 short arg1 byte arg2 short offset,void,C");
        Opcodes.put(new Byte(-95), "CLEARTIME       ,byte timer, void,CP");
        Opcodes.put(new Byte(-92), "UPLOADDATALOG   ,short first short count, dlrec data[length],P");
        Opcodes.put(new Byte(-91), "UNLOCKFIRMWARE  ,byte key[5], byte data[25],P");
        Opcodes.put(new Byte(-79), "SETPOWERDOWN    ,byte minutes, void,CP");
        Opcodes.put(new Byte(-78), "SENDMESSAGE     ,byte src byte arg, void,C");
        Opcodes.put(new Byte(-63), "DELSUB          ,byte subroutine, void,CP");
        Opcodes.put(new Byte(-47), "CLEARSENSOR     ,byte sensor, void,CP");
        Opcodes.put(new Byte(-31), "SETMOTORDIR     ,byte code, void,CP");
        Opcodes.put(new Byte(-9), "SETMESSAGE      ,byte message, void,PC");
    }

    public static void showTable() {
        if (opcodeFrame != null) {
            opcodeFrame.dispose();
            opcodeFrame = null;
            return;
        }
        opcodeFrame = new Frame("RCX Opcodes Table");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        opcodeFrame.setBounds(dimension.width / 2 - 70, 0, dimension.width / 2 + 70, dimension.height);
        opcodeTextArea = new TextArea("   Opcode          ,parameters, response, C=program command P=remote command\n", 60, 100);
        opcodeTextArea.setFont(new Font("Courier", 0, 12));
        opcodeFrame.add(opcodeTextArea);
        Enumeration enumeration = Opcodes.keys();
        Enumeration enumeration2 = Opcodes.elements();
        while (enumeration2.hasMoreElements()) {
            String string = Integer.toHexString(((Byte)enumeration.nextElement()).intValue());
            string = string.substring(string.length() - 2) + " " + (String)enumeration2.nextElement() + "\n";
            opcodeTextArea.append(string);
        }
        opcodeTextArea.setEditable(false);
        opcodeFrame.setVisible(true);
    }

    public static byte[] parseString(String string) {
        byte[] byArray = null;
        string = string.trim();
        int n = string.indexOf(32);
        while (n >= 0) {
            string = string.substring(0, n) + string.substring(n + 1);
            n = string.indexOf(32);
        }
        int n2 = string.length();
        if (n2 % 2 != 0) {
            return null;
        }
        byArray = new byte[n2 /= 2];
        string = string.toUpperCase();
        n = 0;
        byte[] byArray2 = string.getBytes();
        int n3 = 0;
        while (n3 < n2) {
            if (byArray2[n] > 70) {
                return null;
            }
            int n4 = n;
            byArray2[n4] = (byte)(byArray2[n4] - 48);
            if (byArray2[n] > 16) {
                int n5 = n;
                byArray2[n5] = (byte)(byArray2[n5] - 7);
            }
            if (byArray2[n + 1] > 70) {
                return null;
            }
            int n6 = n + 1;
            byArray2[n6] = (byte)(byArray2[n6] - 48);
            if (byArray2[n + 1] > 16) {
                int n7 = n + 1;
                byArray2[n7] = (byte)(byArray2[n7] - 7);
            }
            byArray[n3] = (byte)(16 * byArray2[n] + byArray2[n + 1]);
            n += 2;
            ++n3;
        }
        return byArray;
    }

    public static String ArrayToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            if (n2 < 0) {
                n2 += 256;
            }
            stringBuffer.append(Integer.toHexString(n2) + " ");
            ++n;
        }
        return stringBuffer.toString();
    }
}

