/*
 * Decompiled with CFR 0.152.
 */
package rcx;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import rcx.RCXListener;
import rcx.RCXOpcode;
import rcx.RCXPort;

public class RCXLoader
extends Frame
implements ActionListener,
WindowListener,
RCXListener {
    private String portName;
    private RCXPort rcxPort;
    private Panel textPanel;
    private Panel topPanel;
    private TextArea textArea;
    private TextField textField;
    private Button tableButton;
    private Properties parameters;
    private int inByte;
    private int charPerLine = 48;
    private int lenCount;
    private StringBuffer sbuffer;
    private byte[] byteArray;

    public static void main(String[] stringArray) {
        new RCXLoader();
    }

    public RCXLoader() {
        super("RCX Loader");
        Object object;
        this.addWindowListener(this);
        this.topPanel = new Panel();
        this.topPanel.setLayout(new BorderLayout());
        this.tableButton = new Button("table");
        this.tableButton.addActionListener(this);
        this.textField = new TextField();
        this.textField.setEditable(false);
        this.textField.setEnabled(false);
        this.tableButton.setEnabled(false);
        this.textField.addActionListener(this);
        this.textPanel = new Panel();
        this.textPanel.setLayout(new BorderLayout(5, 5));
        this.topPanel.add((Component)this.textField, "Center");
        this.topPanel.add((Component)this.tableButton, "East");
        this.textPanel.add((Component)this.topPanel, "North");
        this.textArea = new TextArea();
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Courier", 0, 12));
        this.textPanel.add((Component)this.textArea, "Center");
        this.add((Component)this.textPanel, "Center");
        this.textArea.setText("initializing...\n");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(dimension.width / 2 - 185, dimension.height / 2 - 185, 370, 370);
        this.setVisible(true);
        File file = new File("parameters.txt");
        if (!file.exists()) {
            file = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "parameters.txt");
        }
        if (file.exists()) {
            try {
                object = new FileInputStream(file);
                this.parameters = new Properties();
                this.parameters.load((InputStream)object);
                ((FileInputStream)object).close();
                this.portName = this.parameters.getProperty("port");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.rcxPort = new RCXPort(this.portName);
        this.rcxPort.addRCXListener(this);
        this.tableButton.setEnabled(true);
        if (this.rcxPort.isOpen()) {
            object = this.rcxPort.getLastError();
            if (object != null) {
                this.textArea.append((String)object + "\n");
            } else {
                this.textArea.append("RCXPort ready.\n");
            }
            this.textField.setEditable(true);
            this.textField.setEnabled(true);
            this.textField.requestFocus();
        } else {
            this.textArea.append("Failed to create RCXPort with " + this.portName + "\n");
        }
    }

    public void receivedMessage(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            this.sbuffer = new StringBuffer(Integer.toHexString(n2));
            if (this.sbuffer.length() < 2) {
                this.sbuffer.insert(0, '0');
            }
            this.textArea.append(this.sbuffer + " ");
            this.lenCount += 3;
            if (this.lenCount == this.charPerLine) {
                this.lenCount = 0;
                this.textArea.append("\n");
            }
            ++n;
        }
        if (this.lenCount != this.charPerLine) {
            this.textArea.append("\n");
        }
    }

    public void receivedError(String string) {
        this.textArea.append(string + "\n");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.textField) {
            String string = this.textField.getText();
            this.textField.setText("");
            this.textArea.append("> " + string + "\n");
            this.byteArray = RCXOpcode.parseString(string);
            if (this.byteArray == null) {
                this.textArea.append("Error: illegal hex character or length\n");
                return;
            }
            if (this.rcxPort != null && !this.rcxPort.write(this.byteArray)) {
                this.textArea.append("Error: writing data to port " + this.portName + "\n");
            }
        } else if (object == this.tableButton) {
            RCXOpcode.showTable();
            this.setLocation(0, this.getLocation().y);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.rcxPort != null) {
            this.rcxPort.close();
        }
        System.exit(0);
    }
}

