/*
 * Decompiled with CFR 0.152.
 */
package rcx;

import rcx.RCXPort;

public class Motor {
    public static Motor A;
    public static Motor B;
    public static Motor C;
    public static Motor[] MOTORS;
    private char id;
    private short mode = (short)4;
    private short power = (short)3;
    private RCXPort port;

    public Motor(char c, RCXPort rCXPort) {
        this.id = c;
        this.port = rCXPort;
    }

    public static void setPort(RCXPort rCXPort) {
        A = new Motor('A', rCXPort);
        B = new Motor('B', rCXPort);
        C = new Motor('C', rCXPort);
        Motor.MOTORS[0] = A;
        Motor.MOTORS[1] = B;
        Motor.MOTORS[2] = C;
    }

    public final char getId() {
        return this.id;
    }

    public final void setPower(int n) {
        this.power = (short)n;
        this.port.controlMotor(this.id, this.mode, this.power);
    }

    public final void forward() {
        this.mode = 1;
        this.port.controlMotor(this.id, this.mode, this.power);
    }

    public final boolean isForward() {
        return this.mode == 1;
    }

    public final void backward() {
        this.mode = (short)2;
        this.port.controlMotor(this.id, this.mode, this.power);
    }

    public final boolean isBackward() {
        return this.mode == 2;
    }

    public final void reverseDirection() {
        if (this.mode == 1 || this.mode == 2) {
            this.mode = (short)(3 - this.mode);
            this.port.controlMotor(this.id, this.mode, this.power);
        }
    }

    public final int getPower() {
        return this.power;
    }

    public final boolean isMoving() {
        return this.mode == 1 || this.mode == 2;
    }

    public final boolean isFloating() {
        return this.mode == 4;
    }

    public final void stop() {
        this.mode = (short)3;
        this.power = 0;
        this.port.controlMotor(this.id, this.mode, (short)7);
    }

    public final boolean isStopped() {
        return this.mode == 3;
    }

    public final void flt() {
        this.mode = (short)4;
        this.port.controlMotor(this.id, this.mode, this.power);
    }

    static {
        MOTORS = new Motor[]{A, B, C};
    }
}

