/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.IOException;
import javax.comm.SerialPort;

public class Transmitter
extends Panel
implements TextListener,
ItemListener,
Runnable {
    private Panel p;
    private Panel p1;
    private Panel p2;
    private TextArea text;
    private Checkbox auto;
    private Checkbox sendBreak;
    private ByteStatistics counter;
    private SerialPortDisplay owner;
    private Thread thr;
    private Color onColor;
    private Color offColor;
    private boolean first = true;
    private boolean modemMode = false;
    static String testString = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n1234567890\n";

    public Transmitter(SerialPortDisplay serialPortDisplay, int n, int n2) {
        this.owner = serialPortDisplay;
        this.setLayout(new BorderLayout());
        this.p = new Panel();
        this.p.setLayout(new FlowLayout());
        this.p1 = new Panel();
        this.p1.setLayout(new BorderLayout());
        this.p1.add("West", new Label("Auto Transmit"));
        this.auto = new Checkbox();
        this.auto.addItemListener(this);
        this.p1.add("East", this.auto);
        this.p.add(this.p1);
        this.p2 = new Panel();
        this.p2.setLayout(new BorderLayout());
        this.p2.add("West", new Label("Send Break"));
        this.sendBreak = new Checkbox();
        this.sendBreak.addItemListener(this);
        this.p2.add("East", this.sendBreak);
        this.p.add(this.p2);
        this.add("North", this.p);
        this.text = new TextArea(n, n2);
        this.text.append("Type here");
        this.text.addTextListener(this);
        this.add("Center", this.text);
        this.counter = new ByteStatistics("Bytes Sent", 10, serialPortDisplay.port, false);
        this.add("South", this.counter);
        this.thr = null;
        this.onColor = Color.green;
        this.offColor = Color.black;
    }

    public Transmitter(SerialPortDisplay serialPortDisplay, int n, int n2, boolean bl) {
        this(serialPortDisplay, n, n2);
        this.modemMode = bl;
    }

    public void setPort(SerialPort serialPort) {
        this.counter.setPort(serialPort);
    }

    public void showValues() {
        this.counter.showValues();
    }

    public void clearValues() {
        this.counter.clearValues();
    }

    public void setBitsPerCharacter(int n) {
        this.counter.setBitsPerCharacter(n);
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this.first && this.text.getCaretPosition() > 0) {
            this.first = false;
            this.text.replaceRange("", 0, this.text.getCaretPosition() - 1);
        }
        if (!this.first) {
            this.sendData();
        }
    }

    public void run() {
        this.sendData();
    }

    public void sendString(String string) {
        block3: {
            int n = string.length();
            if (n > 0) {
                try {
                    this.owner.out.write(string.getBytes());
                    this.counter.incrementValue(n);
                    this.owner.ctlSigs.BE = false;
                    this.owner.ctlSigs.showErrorValues();
                    return;
                }
                catch (IOException iOException) {
                    if (!this.owner.open) break block3;
                    System.out.println(String.valueOf(this.owner.port.getName()) + ": Cannot write to output stream");
                    this.auto.setState(false);
                    return;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendData() {
        block1: {
            if (!this.owner.open || !this.auto.getState()) break block1;
            if (true) ** GOTO lbl5
            do {
                this.sendString(Transmitter.testString);
lbl5:
                // 2 sources

                if (!this.owner.open) return;
            } while (this.auto.getState());
            return;
        }
        var1_1 = this.text.getText();
        this.sendString(var1_1);
        this.text.setText("");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.auto.getState() && this.thr == null && this.owner.open) {
            this.auto.setForeground(this.onColor);
            this.startTransmit();
        } else {
            this.stopTransmit();
        }
        if (this.sendBreak.getState()) {
            if (this.owner.open) {
                this.sendBreak.setForeground(this.onColor);
                this.owner.port.sendBreak(1000);
            }
            this.sendBreak.setState(false);
            this.sendBreak.setForeground(this.offColor);
        }
    }

    private void startTransmit() {
        this.counter.resetRate();
        this.thr = new Thread((Runnable)this, "Xmt " + this.owner.port.getName());
        this.thr.start();
    }

    public void stopTransmit() {
        this.thr = null;
        this.auto.setState(false);
        this.auto.setForeground(this.offColor);
    }
}

