/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;

public class ReceiveThreshold
extends Panel
implements MouseListener,
ActionListener {
    private int value;
    private int defaultValue;
    private Label label;
    private TextField data;
    private SerialPort port;
    private boolean inputBuffer;

    public ReceiveThreshold(int n, SerialPort serialPort) {
        this.setPort(serialPort);
        this.inputBuffer = this.inputBuffer;
        this.setLayout(new BorderLayout());
        this.label = new Label("Threshold");
        this.label.addMouseListener(this);
        this.add("West", this.label);
        this.data = new TextField(new Integer(this.defaultValue).toString(), n);
        this.data.addActionListener(this);
        this.add("East", this.data);
        this.showValue();
        this.defaultValue = this.value;
    }

    public void setPort(SerialPort serialPort) {
        this.port = serialPort;
    }

    public int getValue() {
        this.value = this.port != null && this.port.isReceiveThresholdEnabled() ? this.port.getReceiveThreshold() : 0;
        return this.value;
    }

    public void showValue() {
        ((TextComponent)this.data).setText(new Integer(this.getValue()).toString());
    }

    public void setValue(int n) {
        if (this.port != null) {
            if (n > 0) {
                try {
                    this.port.enableReceiveThreshold(n);
                }
                catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                    unsupportedCommOperationException.printStackTrace();
                }
            } else {
                this.port.disableReceiveThreshold();
            }
        }
        this.showValue();
    }

    public void setDefaultValue(int n) {
        this.defaultValue = n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            Integer n = new Integer(string);
            this.setValue(n);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Bad value = " + actionEvent.getActionCommand());
            this.showValue();
            return;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setValue(this.defaultValue);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

