/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;

class Parity
extends Choice
implements ItemListener {
    private SerialPortDisplay owner;

    public Parity(SerialPortDisplay serialPortDisplay) {
        this.add("Unknown");
        this.add("None");
        this.add("Odd");
        this.add("Even");
        this.addItemListener(this);
        this.owner = serialPortDisplay;
    }

    protected void showValue() {
        if (this.owner.open) {
            switch (this.owner.port.getParity()) {
                case 0: {
                    this.select("None");
                    return;
                }
                case 1: {
                    this.select("Odd");
                    return;
                }
                case 2: {
                    this.select("Even");
                    return;
                }
            }
            this.select("Unknown");
            return;
        }
        this.select("Unknown");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        int n = 0;
        if (string.equals("None")) {
            n = 0;
        } else if (string.equals("Odd")) {
            n = 1;
        } else if (string.equals("Even")) {
            n = 2;
        } else {
            this.showValue();
        }
        SerialPort serialPort = this.owner.port;
        if (n > 0 && serialPort != null) {
            try {
                serialPort.setSerialPortParams(serialPort.getBaudRate(), serialPort.getDataBits(), serialPort.getStopBits(), n);
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                System.out.println("Cannot set parity to " + string + " for port " + serialPort.getName());
            }
        }
        this.owner.showValues();
    }
}

