/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;

public class FlowCtlDisplay
extends Panel
implements ItemListener {
    SerialPort port;
    Label RTSLabel;
    Label XONLabel;
    Label RCVLabel;
    Label XMTLabel;
    Checkbox RCVRTS;
    Checkbox XMTRTS;
    Checkbox RCVXON;
    Checkbox XMTXON;
    private Color onColor;
    private Color offColor;

    public FlowCtlDisplay(SerialPort serialPort) {
        this.setPort(serialPort);
        this.setLayout(new GridLayout(0, 3));
        this.add(new Label(""));
        this.RTSLabel = new Label("RTS/CTS");
        this.add(this.RTSLabel);
        this.XONLabel = new Label("XON/XOFF");
        this.add(this.XONLabel);
        this.RCVLabel = new Label("RCV");
        this.add(this.RCVLabel);
        this.RCVRTS = new Checkbox();
        this.RCVRTS.addItemListener(this);
        this.add(this.RCVRTS);
        this.RCVXON = new Checkbox();
        this.RCVXON.addItemListener(this);
        this.add(this.RCVXON);
        this.XMTLabel = new Label("XMT");
        this.add(this.XMTLabel);
        this.XMTRTS = new Checkbox();
        this.XMTRTS.addItemListener(this);
        this.add(this.XMTRTS);
        this.XMTXON = new Checkbox();
        this.XMTXON.addItemListener(this);
        this.add(this.XMTXON);
        this.onColor = Color.green;
        this.offColor = Color.black;
    }

    public void setPort(SerialPort serialPort) {
        this.port = serialPort;
    }

    public void showValues() {
        if (this.port != null) {
            int n = this.port.getFlowControlMode();
            if ((n & 1) > 0) {
                this.RCVRTS.setState(true);
                this.RCVRTS.setForeground(this.onColor);
            } else {
                this.RCVRTS.setState(false);
                this.RCVRTS.setForeground(this.offColor);
            }
            if ((n & 4) > 0) {
                this.RCVXON.setState(true);
                this.RCVXON.setForeground(this.onColor);
            } else {
                this.RCVXON.setState(false);
                this.RCVXON.setForeground(this.offColor);
            }
            if ((n & 2) > 0) {
                this.XMTRTS.setState(true);
                this.XMTRTS.setForeground(this.onColor);
            } else {
                this.XMTRTS.setState(false);
                this.XMTRTS.setForeground(this.offColor);
            }
            if ((n & 8) > 0) {
                this.XMTXON.setState(true);
                this.XMTXON.setForeground(this.onColor);
                return;
            }
            this.XMTXON.setState(false);
            this.XMTXON.setForeground(this.offColor);
            return;
        }
        this.clearValues();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String cfr_ignored_0 = (String)itemEvent.getItem();
        int n = 0;
        if (this.port != null) {
            if (this.RCVRTS.getState()) {
                n |= 1;
            }
            if (this.RCVXON.getState()) {
                n |= 4;
            }
            if (this.XMTRTS.getState()) {
                n |= 2;
            }
            if (this.XMTXON.getState()) {
                n |= 8;
            }
            try {
                this.port.setFlowControlMode(n);
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                unsupportedCommOperationException.printStackTrace();
            }
        }
        this.showValues();
    }

    public void clearValues() {
        this.RCVRTS.setState(false);
        this.RCVRTS.setForeground(this.offColor);
        this.RCVXON.setState(false);
        this.RCVXON.setForeground(this.offColor);
        this.XMTRTS.setState(false);
        this.XMTRTS.setForeground(this.offColor);
        this.XMTXON.setState(false);
        this.XMTXON.setForeground(this.offColor);
    }
}

