/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import javax.comm.SerialPort;

public class CtlSigDisplay
extends Panel {
    SerialPort port;
    ToggleLabel RTSLabel;
    ToggleLabel DTRLabel;
    ToggleLabel OELabel;
    ToggleLabel FELabel;
    ToggleLabel PELabel;
    ToggleLabel BILabel;
    Label CTSLabel;
    Label DSRLabel;
    Label RILabel;
    Label CDLabel;
    Label DALabel;
    Label BELabel;
    boolean DA;
    boolean BE;
    private Color onColor;
    private Color offColor;

    public CtlSigDisplay(SerialPort serialPort) {
        this.setPort(serialPort);
        this.setLayout(new FlowLayout());
        this.RTSLabel = new ToggleLabel("RTS");
        this.RTSLabel.addMouseListener(new ToggleMouseListener(this));
        this.add(this.RTSLabel);
        this.CTSLabel = new Label("CTS");
        this.add(this.CTSLabel);
        this.DTRLabel = new ToggleLabel("DTR");
        this.DTRLabel.addMouseListener(new ToggleMouseListener(this));
        this.add(this.DTRLabel);
        this.DSRLabel = new Label("DSR");
        this.add(this.DSRLabel);
        this.RILabel = new Label("RI");
        this.add(this.RILabel);
        this.CDLabel = new Label("CD");
        this.add(this.CDLabel);
        this.OELabel = new ToggleLabel("OE");
        this.OELabel.addMouseListener(new OneWayMouseListener(this));
        this.add(this.OELabel);
        this.FELabel = new ToggleLabel("FE");
        this.FELabel.addMouseListener(new OneWayMouseListener(this));
        this.add(this.FELabel);
        this.PELabel = new ToggleLabel("PE");
        this.PELabel.addMouseListener(new OneWayMouseListener(this));
        this.add(this.PELabel);
        this.BILabel = new ToggleLabel("BI");
        this.BILabel.addMouseListener(new OneWayMouseListener(this));
        this.add(this.BILabel);
        this.DALabel = new Label("DA");
        this.add(this.DALabel);
        this.DA = false;
        this.BELabel = new Label("BE");
        this.add(this.BELabel);
        this.BE = true;
        this.onColor = Color.green;
        this.offColor = Color.black;
    }

    public void setPort(SerialPort serialPort) {
        this.port = serialPort;
    }

    public void showValues() {
        if (this.port != null) {
            this.RTSLabel.setState(this.port.isRTS());
            this.CTSLabel.setForeground(this.port.isCTS() ? this.onColor : this.offColor);
            this.DTRLabel.setState(this.port.isDTR());
            this.DSRLabel.setForeground(this.port.isDSR() ? this.onColor : this.offColor);
            this.RILabel.setForeground(this.port.isRI() ? this.onColor : this.offColor);
            this.CDLabel.setForeground(this.port.isCD() ? this.onColor : this.offColor);
        }
    }

    public void showErrorValues() {
        if (this.port != null) {
            this.OELabel.setForeground(this.OELabel.getState() ? this.onColor : this.offColor);
            this.FELabel.setForeground(this.FELabel.getState() ? this.onColor : this.offColor);
            this.PELabel.setForeground(this.PELabel.getState() ? this.onColor : this.offColor);
            this.BILabel.setForeground(this.BILabel.getState() ? this.onColor : this.offColor);
            this.DALabel.setForeground(this.DA ? this.onColor : this.offColor);
            this.BELabel.setForeground(this.BE ? this.onColor : this.offColor);
        }
    }

    public void clearValues() {
        this.RTSLabel.setState(false);
        this.CTSLabel.setForeground(this.offColor);
        this.DTRLabel.setState(false);
        this.DSRLabel.setForeground(this.offColor);
        this.RILabel.setForeground(this.offColor);
        this.CDLabel.setForeground(this.offColor);
    }

    public void clearErrorValues() {
        this.OELabel.setForeground(this.offColor);
        this.FELabel.setForeground(this.offColor);
        this.PELabel.setForeground(this.offColor);
        this.BILabel.setForeground(this.offColor);
        this.DALabel.setForeground(this.offColor);
        this.BELabel.setForeground(this.offColor);
    }
}

