// Definition of sonar sensors.  Stolen in large part from sensorsim
#ifndef _SONAR_HH_
#define _SONAR_HH_

class Sonar;

#include "arena.hh"

// making arena a reference gives the "can't use default assignment"
// error so it's a pointer
class Sonar {
  private:
	Arena *arena; // arena the sonar is acting in
	float angle; // angle of sonar relative to robot
	float offset; // distance of sonar from center of robot
	float spread; // sensor spread (pixels per hundred)
	float retprob; // return prob (percent)
	float marsprob; // mars return prob (percent)
	unsigned int precision;  // assumed sensor precision
	int distance; // results of most recent reading
	
  public:
	Sonar(Arena *arenap,
		  float anglep, float offsetp,
		  float spreadp,
		  float retprobp, float marsprobp,
		  unsigned int precisionp);

	// take_reading takes a new reading and stores it internally;
	// get_distance returns the value from the most recent take_reading.
	// get_angle gets this sonar's angle (in radians)
	void take_reading(float xp, float yp, float radius, float direction);
	float get_angle();
	int get_distance();
};
#endif
