#include <math.h>
#include <stdio.h>

#include "sonar.hh"

Sonar::Sonar(Arena *arenap,
			 float anglep,
			 float offsetp,
			 float spreadp=0.15,
			 float retprobp=1.0,
			 float marsprobp=0.0,
			 unsigned int precisionp=0) :
  arena(arenap),
  angle(anglep), offset(offsetp),
  spread(spreadp), retprob(retprobp), marsprob(marsprobp), precision(precisionp)
{}

float Sonar::get_angle()
{
	return angle;
}

void Sonar::take_reading(float xp, float yp, float radius, float anglep)
{
	float direction;
	float ssin, scos; // save recomputing
	int range;
	int offset;
	float xoff, yoff;
	int xloc, yloc;
	float x, y;
	
	// send out a ping and see when it hits something
	range = 1;
	distance = 0;
	direction = angle + anglep;
	ssin = sin(direction);
	scos = cos(direction);

	// correct my location to account for offset from center of robot.
	x = xp + radius*scos;
	y = yp + radius*ssin;

	//printf("reading %f %f %f\n", direction, x, y);
	
	// this is a bit of an abuse...  I'll use distance to tell
	// when I've got a reading or I'm giving up.
	while (distance == 0) {
		// if the center spot of the ping lies outside the bounds of the arena,
		// we got no return.  We'll tell the user this by returning -1
		
		xloc = (int) (range*scos + x + 0.5);
		yloc = (int) (range*ssin + y + 0.5);
		
		if ((xloc < 0) ||
			(xloc >= arena->get_width()) ||
			(yloc < 0) ||
			(yloc >= arena->get_height())) {
			distance = -1;
			break;
		}
		
		// Now draw an arc through (xloc, yloc) centered on (x, y) and see
		// if it intersects anything.  If it does, we'll return the range.

		for (yoff = 0; (yoff < range*spread) && (distance == 0); ++yoff) {
			
			// first, get xoff
			xoff = sqrt(range*range - yoff*yoff);
			
			// now compute xloc and yloc by rotating the offsets and
			// translating by the sensor's location
			xloc = (int)(x + xoff * scos - yoff * ssin + 0.5);
			yloc = (int)(y + xoff * ssin + yoff * scos + 0.5);
			
			// if we've got an obstacle at (xloc, yloc) we'll return
			// the range.  Note we have to make sure we aren't outside
			// the arena
			
			if ((xloc >= 0) &&
				(xloc < arena->get_width()) &&
				(yloc >= 0) &&
				(yloc < arena->get_height()) &&
				arena->get_point(xloc, yloc).get_present()) {
				distance = (int)(range + 0.5);
				break;
			}
			
			// Now try the opposite y offset
			
			// now compute xloc and yloc by rotating the offsets and
			// translating by the sensor's location
			xloc = (int)(x + xoff * scos + yoff * ssin + 0.5);
			yloc = (int)(y + xoff * ssin - yoff * scos + 0.5);
			
			// if we've got an obstacle at (xloc, yloc) we'll return
			// the range.  Note we have to make sure we aren't outside
			// the arena
			
			if ((xloc >= 0) &&
				(xloc < arena->get_width()) &&
				(yloc >= 0) &&
				(yloc < arena->get_height()) &&
				arena->get_point(xloc, yloc).get_present()) {
				distance = (int)(range + 0.5);
				break;
			}
		}
		range++;
	}

	// correct range to be from center of robot
	distance += (int) radius;

	//	printf("(xp %f, yp %f) (direction %f scos %f ssin %f) (x %f, y %f) (xoff %f yoff %f) (xloc %d, yloc %d) range %d\n",
	//		     xp,    yp,     direction,   scos,   ssin,     x,    y,     xoff,   yoff,     xloc,    yloc,    range);
}

int Sonar::get_distance()
{
	return distance;
}
