%{
#include <malloc.h>
#include <string.h>
// This is obnoxious:  I need to #include these type definitions here
// as well as in parser.yy, as they don't get included into parser.h
#include "coords.hh"
#include "expr.hh"
#include "object.hh"
#include "pattern.hh"
#include "rule.hh"

#include "parser.hh"
#define STRVAL	do { \
                        yylval.str = strncpy((char *)malloc(yyleng + 1), yytext, yyleng); \
                        yylval.str[yyleng] = 0; \
                } while (0)

#define FLTVAL		sscanf(yytext, "%f", &yylval.flt)
extern int yylineno;
%}
%%
"-"?(([0-9]+)|([0-9]+"."[0-9]*)|([0-9]*"."[0-9]+))	{FLTVAL; return FLOAT;}

"color"   {return COLOR;}

"move" {return MOVE;}

"rule"	{return RULE;}
"left"	{return LEFT;}
"right"	{return RIGHT;}
"min"   {yylval.mtype = MIN; return MTYPE;}
"max"   {yylval.mtype = MAX; return MTYPE;}
[+*/<>=-]	{yylval.chr = (char) yytext[0]; return OP;}

("s"|"S")[0-7] {yylval.integer = (int) yytext[1] - '0'; return SONAR;}
"s"|"S"  {yylval.integer = -1; return SONAR;}
("m"|"M")[0-1] {yylval.integer = (int) yytext[1] - '0'; return MOT;}
("c"|"C")[0-9]+ {yylval.integer = (int) yytext[1] - '0'; return COL;}

"{"   {return '{';}
"}"   {return '}';}
"("   {return '(';}
")"   {return ')';}
"["   {return '[';}
"]"   {return ']';}
","   {return ',';}

\n					{yylineno++;}

"#"[^\n]*

[\t ]+
%%
