#ifndef _RULE_HH_
#define _RULE_HH_
extern "C" {
#include <stdio.h>
}
#include <vector>

class Coords;
#include "object.hh"
#include "pattern.hh"
class Robot;

// There are two types of rules:  movement rules and model
// modification rules.  We'll implement this by defining a base
// Rule class, and building MoveRules and ObjRules on top of that.

class Rule
{
  protected:
	float activation;
	Patterns lhs;

  public:
	// constructor
	Rule(Patterns &lhsp);
	Rule();
	void match(Robot& robot) {
		activation = lhs.match(robot);
	}
	
	virtual void apply(Robot& robot) = 0;
};

class MoveRule : public Rule
{
  private:
	Coords rhs;

  public:
	MoveRule(Patterns &lhsp, Coords &rhsp);
	MoveRule(Coords &rhsp);

	void apply(Robot& robot)
	{
		//we'll need to move robot according to rule
	}
	
	// output
	void print(FILE *ofile);
};

class ObjectRule : public Rule
{
  private:
	Objects rhs;

  public:
	ObjectRule(Patterns &lhsp, Objects &rhs);
	ObjectRule(Objects &rhsp);

	void apply(Robot& robot)
	{
		rhs.apply(activation, robot);
	}
	
	// output
	void print(FILE *ofile);
};

class MoveRules : public std::vector<MoveRule>
{
  public:
	void process(Robot& robot);
	void print(FILE *ofile);
};

class ObjectRules : public std::vector<ObjectRule>
{
  public:
	ObjectRules();
	void process(Robot& robot);
	void print(FILE *ofile);
};

#endif
