extern "C" {
#include <math.h>
#include <stdio.h>
}

#include <vector>

#include "coords.hh"
#include "pattern.hh"
#include "robot.hh"
#include "rule.hh"

// constructor and destructor
Rule::Rule(Patterns &lhsp) : lhs(lhsp)
{}

Rule::Rule()
{}

MoveRule::MoveRule(Patterns &lhsp, Coords &rhsp) :
  Rule(lhsp), rhs(rhsp)
{}

MoveRule::MoveRule(Coords &rhsp) :
  rhs(rhsp)
{}

void MoveRule::print(FILE *ofile)
{
	fprintf(ofile, "rule {\n");
	lhs.print(ofile);
	rhs.print(ofile);
	fprintf(ofile, "}\n");
}

void MoveRules::process(Robot &robot)
{
	float x, y, angle;
	// for the moment, we'll just make the position in the model be
	// Just Plain Right
	x = robot.get_x();	
	y = robot.get_y();
	angle = robot.get_angle();

	robot.get_model().set_location(x, y, angle);
}

void MoveRules::print(FILE *ofile)
{
	fprintf(ofile, "Movement Rules:\n");
	for (iterator i = begin(); i != end(); ++i)
		i->print(ofile);
}

ObjectRule::ObjectRule(Patterns &lhsp, Objects &rhsp) :
  Rule(lhsp), rhs(rhsp)
{}

ObjectRule::ObjectRule(Objects &rhsp) :
  rhs(rhsp)
{}

// hanging on to old dead triangle code
	// OK, now  let's put in the triangles according to our old
	// code...
	
//	float angle, ssin, scos;
//	float sonarx, sonary;
//	int range;
//	for (int i = 0; i < robot.num_sonars(); ++i) {
//		range = robot.get_sonar(i).get_distance() - 4;
//		angle = robot.get_sonar(i).get_angle() + robot.get_angle();
//		
//		ssin = sin(angle);
//		scos = cos(angle);
//
//		// correct for sonar location on robot
//		sonarx = robot.get_model().get_x() + scos*robot.get_radius();
//		sonary = robot.get_model().get_y() + ssin*robot.get_radius();
//
//		//printf("model %f %f %f\n", sonarx, sonary, angle);
//		
//		int x0 = (int) sonarx;
//		int y0 = (int) sonary;
//
//		int x1 = x0 + (int)(range * scos - range * 0.25 * ssin);
//		int y1 = y0 + (int)(range * ssin + range * 0.25 * scos);
//		
//		int x2 = x0 + (int)(range * scos + range * 0.25 * ssin);
//		int y2 = y0 + (int)(range * ssin - range * 0.25 * scos);
//
//		robot.get_model()[0].update_triangle(0.0, 0.25,
//								   x0, y0, x1, y1, x2, y2);
//
//		x0 = x0 + (int)((range + 4) * scos);
//		y0 = y0 + (int)((range + 4) * ssin);
//
//		robot.get_model()[0].update_triangle(0.25, 0.0,
//								   x0, y0, x1, y1, x2, y2);
//	}
//	
//}
	
void ObjectRule::print(FILE *ofile)
{
	fprintf(ofile, "rule {\n");
	lhs.print(ofile);
	rhs.print(ofile);
	fprintf(ofile, "}\n");
}

ObjectRules::ObjectRules()
{}

void ObjectRules::process(Robot &robot)
{
	//  slight subtle point here:  we want to execute all rules
	//  conceptually in parallel.  So we need to match all the LHSs,
	//  and then apply all the RHSs based on the activations worked
	//  out on the LHS pass.
	for (iterator i = begin(); i != end(); ++i)
		i->match(robot);
	
	for (iterator i = begin(); i != end(); ++i)
		i->apply(robot);
}

void ObjectRules::print(FILE *ofile)
{
	//	fprintf(ofile, "Object Rules:\n");
	for (iterator i = begin(); i != end(); ++i)
		i->print(ofile);
}

static MoveRules moverule_add(MoveRules rulesp, MoveRule rulep)
{
	rulesp.push_back(rulep);

	return rulesp;
}

static ObjectRules objectrule_add(ObjectRules rulesp, ObjectRule rulep)
{
	rulesp.push_back(rulep);

	return rulesp;
}
