// Definition of Robby for simulation
#ifndef _ROBOT_HH_
#define _ROBOT_HH_

#include <vector>

class Arena;
class Model;
class MoveRules;
class ObjectRules;

#include "motor.hh"
#include "sonar.hh"

class Robot
{
  private:
	Arena &arena;           // arena robot is working in
	float real_x, real_y;	// actual robot position
	float old_x, old_y;   // robot's last position (used to optimize graphics)
	float  direction;		// robot's actual current direction (model
							// is always Just Plain Right about this)
	float initx, inity;		// robot's initial position and angle
	float initd;
	float radius;			// robot radius (distance of sensors and
							// motors from center of platform --
							// should probably be two params)
	
	std::vector<Motor>motor;// motors
	std::vector<Sonar>sonar;// sonar units
	Model& model;			// environment model
	MoveRules& moveRules;   // robot movement rules
	ObjectRules& objRules;  // object rules
	
	void update_position();
	void update_sonar();
	
  public:
	Robot(Arena &arenap,
		  MoveRules& moveRulesp,
		  ObjectRules& objRulesp,
		  Model& modelp,
		  
		  float initxp, float inityp,   // initial location of robot in arena
		  float initanglep,				// initial angle (measured in radians;
										// facing due right is 0, increasing
										// widdershins
		  // sonar specs (identical for all sonar units on robot, see
		  // sonar specs for these parameters).  numSonarsp is the
		  // number of sonars in the ring.  Sonar 0 is facing due
		  // forward, successive units are distribute evenly
		  // widdershins around platform
		  int numSonarsp,
		  float spreadp, float retprobp, float marsprobp,
		  unsigned int precisionp,
		  float radiusp,

		  // motor specs (identical for both motors, see motor specs
		  // for this parameter)
		  float topspeedp);

	void set_init(float xp, float yp)
	{
		initx = xp;
		inity = yp;

		real_x = xp;
		real_y = yp;
	}
	
	Arena& get_arena();
	Model& get_model();
	float get_x()
	{
		return real_x;
	}
	
	float get_y()
	{
		return real_y;
	}
	
	float  get_old_x()
	{
		return old_x;
	}

	float get_old_y()
	{
		return old_y;
	}
	
	float get_angle()
	{
		return direction;
	}
	
	float get_radius()
	{
		return radius;
	}
	
	bool visible;
	
	// hard to shake the feeling the sonar interface will need at
	// least one more major revision...
	int num_sonars();
	Sonar& get_sonar(int i);
	Motor& get_motor(int i);

	void reset();	
	
	// This is the biggie:  executes one execution cycle for the robot.
	bool step();
};
	
#endif
