#include "constants.hh"
#include "enum.hh"
#include "pattern.hh"

Pattern::Pattern(Mtype mtypep, Object &objectp) :
  matchtype(mtypep), Object(objectp)
{
}

float Pattern::match(Robot &robot)
{
	float matchval;
	float tmatch;

	switch (matchtype) {
	  case MIN:
		matchval = 1.0;
		break;

	  case MAX:
		matchval = 0.0;
		break;

	  default:
		assert(false);
	}

	for (Triangles::iterator i = triangles.begin(); i != triangles.end(); ++i) {
		tmatch = i->match(matchtype, color, belief.get_belief(), belief.get_disbelief(), robot);
	
		switch (matchtype) {
		  case MIN:
			matchval = minimum(matchval, tmatch);
			break;

		  case MAX:
			matchval = maximum(matchval, tmatch);
			break;

		  default:
			assert(false);
		}
	}

	return matchval;
}

void Pattern::print(FILE *ofile)
{
	fprintf(ofile, "        ");
	switch(matchtype) {
	  case MIN:
		fprintf(ofile, "min ");
		break;
		
	  case MAX:
		fprintf(ofile, "max ");
		break;
		
	  default:
		fprintf(ofile, "(mtype unknown %d) ", matchtype);
		break;
	}
	this->Object::print(ofile);
}

Patterns::Patterns()
{}

float Patterns::match(Robot& robot)
{
	float matchval;

	matchval = 1.0;
	for (iterator i = begin(); i != end(); ++i) {
		float tmp = i->match(robot);
		if (tmp < matchval)
			matchval = tmp;
	}

	return matchval;
}

void Patterns::print(FILE *ofile)
{
	if (size() > 0) {
		fprintf(ofile, "    left {\n");
		for (iterator i = begin(); i != end(); ++i)
			i->print(ofile);
		fprintf(ofile, "    }\n");
	}
}

	
  
