%{
extern "C" {
#include <malloc.h>
}

#include "belmap.hh"
#include "coords.hh"
#include "enum.hh"
#include "expr.hh"
#include "object.hh"
#include "pattern.hh"
#include "rule.hh"
	
extern MoveRules moveRules;
extern ObjectRules objRules;
extern Model model;

int yylex();
int yyerror(char *s);

%}
%defines
%token <chr> OP
%token <color> COLOR
%token <flt> FLOAT
%token <integer> SONAR COL MOT
%token <mtype>  MTYPE
%token <objtype> OBJTYPE
%token <str> RULE LEFT RIGHT MOVE
%start ruleset
%error-verbose
%union {
	char chr;
	char *str;
	float flt;
	int integer;
	void *bogus;
	Coords *coords;
	Expr *expr;
	MoveRule *mrule;
	Mtype mtype;
	Object *object;
	Belief *bel;
	ObjectRule *orule;
	Objects *objects;
	Pattern *pattern;
	Patterns *patterns;
	Term *term;
	Triangle *triangle;
	Triangles *triangles;
}

%type <bel> belief
%type <coords> coords
%type <coords> robotmove
%type <expr> expr
%type <mrule> moverule
%type <object> consequent
%type <object> obj
%type <objects> consequentlist
%type <objects> orhs
%type <orule> objrule
%type <patterns> lhs
%type <pattern> antecedent
%type <patterns> antecedentlist
%type <term> term
%type <triangle> triangle
%type <triangles> tlist
%%
ruleset	: colors rules
		;

colors	:  color
		|  colors color
		;

color :   COLOR FLOAT FLOAT belief {
	model.insert_plane($2, $3, $4);
	}
	;

rules : objrule {
	objRules.push_back(*$1);
	}
	| moverule {
	moveRules.push_back(*$1);
	}
	| rules objrule {
	objRules.push_back(*$2);
	}
	| rules moverule {
	moveRules.push_back(*$2);
	}
	;

objrule	: RULE '{' lhs orhs '}' {
	$$ = new ObjectRule(*$3, *$4);
	}
	| RULE '{' orhs '}' {
	$$ = new ObjectRule(*$3);
	}
	;

moverule : RULE '{' lhs robotmove '}' {
	$$ = new  MoveRule(*$3, *$4);
	}
	|
	RULE '{' robotmove '}' {
	$$ = new  MoveRule(*$3);
	}
	;

lhs		: LEFT '{' antecedentlist '}' {
		$$ = $3;
		}
		;

orhs	: RIGHT '{' consequentlist '}' {
		$$= $3;
		}
		;
		
antecedentlist : antecedent {
			   $$ = new Patterns;
			   $$->push_back(*$1);
			   }
			   | antecedentlist antecedent {
			   $1->push_back(*$2);
			   $$ = $1;
			   }
			   ;

antecedent	   :	MTYPE obj {
				   $$ = new Pattern($1, *$2);
			   }
			   ;

consequentlist : consequent {
			   $$ = new Objects;
			   $$->push_back(*$1);
			   }
			   | consequentlist consequent {
			   $1->push_back(*$2);
			   $$ = $1;
			   }
			   ;

consequent	   : obj {
			   $$ = $1;
			   }
			   ;

obj			   : COL belief '{' tlist '}' {
			   $$ = new Object(OBJECT, $1, *$2, *$4);
			   }
			   | MOT belief '{' tlist '}' {
			   $$ = new Object(MOTOR, $1, *$2, *$4);
			   }
			   ;

belief		   : '(' FLOAT ',' FLOAT ')' {
			   $$ = new Belief($2, $4);
			   }
			   ;

tlist		   : triangle {
			   $$ = new Triangles();
			   $$->push_back(*$1);
			   }
			   | tlist triangle {
			   $1->push_back(*$2);
			   $$ = $1;
			   }
			   ;

triangle	   : '[' coords coords coords ']' {
			   $$ = new Triangle(*$2, *$3, *$4);
				}

robotmove		: MOVE coords {
				$$ = $2;
				}

coords			: '(' expr ',' expr ')' {
				$$ = new Coords(*$2, *$4);
				}
				;

expr			: term {
					$$ = new Expr;
					$$->push_back(*$1);
				}
				| expr term {
					$1->push_back(*$2);
					$$ = $1;
				}
				;

term			: FLOAT {
					$$ = new Term($1);
				}
				| OP {
					$$ = new Term($1);
				}
				| SONAR {
					$$ = new Term($1);
				}

%%
