extern "C" {
#include <assert.h>
#include <math.h>
#include <stdio.h>
}

#include "object.hh"
#include "robot.hh"

Object::Object(Objtype objtypep, int colorp, Belief beliefp, Triangles &trianglesp) :
  objtype(objtypep), color(colorp), belief(beliefp), triangles(trianglesp)
{}

Object::Object(Objtype objtypep, int colorp, Belief beliefp) :
  objtype(objtypep), color(colorp), belief(beliefp), triangles(*new Triangles)
{}

void Object::apply(float activation, Robot& robot)
{
	
	// work up the belief values that will apply across all the
	// triangles in the object.
	
	float active_belief = activation * belief.get_belief();
	float active_disbelief = activation * belief.get_disbelief();

	for (Triangles::iterator i = triangles.begin(); i != triangles.end(); ++i)
		i->update(objtype, color, active_belief, active_disbelief, robot);
}

void Object::print(FILE *ofile)
{
	fprintf(ofile, "        ");
	switch (objtype) {
	  case MOTOR:
		fprintf(ofile, " m");
		break;

	  case OBJECT:
		fprintf(ofile, " c");
		break;

	  default:
		assert(false);
		break;
	}

	fprintf(ofile, "%d", color);

	belief.print(ofile);
	triangles.print(ofile);
}

void Objects::apply(float activation, Robot& robot)
{
	for (iterator i = begin(); i != end(); ++i)
		i->apply(activation, robot);
}

void Objects::print(FILE *ofile)
{
	fprintf(ofile, "    right {\n");
	for (iterator i = begin(); i != end(); i++)
		i->print(ofile);
	fprintf(ofile, "    }\n");
}

