#ifndef _MOTOR_HH_
#define _MOTOR_HH_
// At the moment, it seems like the motors are most easily modelled
// with belief functions, using belief for the amount the motor
// "wants" to go forward, and disbelief for the amount it "wants" to
// go backward.  We'll set the top speed with a scaling factor

class Motor;
#include "model.hh"

class Motor {
  private:
	// we'll calculate the motors' speed based on center of
	// gravity of the triangles.
	float moment, mass;
	float topspeed;

  public:
	Motor(float topspeedp)
	   : topspeed(topspeedp)
	{
		reset();
	}

	void reset()
	{
		moment = 0;
		mass = 0;
	}

	void update(float massp, float momentp)
	{
		mass += massp;
		moment += momentp;
	}

	float get_speed()
	{
		if (mass == 0.0)
			return  0.0;
		
		return moment/mass;
	}

	float get_topspeed()
	{
		return topspeed;
	}
};

#endif
