#ifndef _MODEL_HH_
#define _MODEL_HH_

#include <stdio.h>
#include <vector>

class ModelPlane;
class Model;

#include "array2d.hh"
#include "belief.hh"
#include "belmap.hh"

class ModelPlane : public Array2d<Belief>
{
  public:
	BelMap beliefmap;
	float hue;
	ModelPlane(float huep, Belief *belp, unsigned int widthp, unsigned int heightp) :
	  resetbelief(belp->get_belief()), resetdisbelief(belp->get_disbelief()),
	  beliefmap(),
	  hue(huep),
	  Array2d<Belief>(widthp, heightp),
	  visible(true)
	{
	}

	void setup(Glib::RefPtr<Gdk::Colormap>& colormap)
	{
		beliefmap.setup(colormap, hue);
	}

	void reset()
	{
		for (int y = 0; y < get_height(); y++)
			for (int x = 0; x < get_width(); x++)
				get_point(x,y).set(resetbelief, resetdisbelief);
	}

	void print(FILE *ofile)
	{
		fprintf(ofile, " %f (%f, %f)\n", beliefmap.hue, resetbelief,
				resetdisbelief);
	}
	
	bool visible;
	float resetbelief, resetdisbelief;
};

class Model : public std::vector<ModelPlane>
{
  private:
	float x;   // location of robot in model
	float y;
	float angle;
	
  public:
	// ought to be private, with accessors...
	float minx, maxx, miny, maxy;
	int width, height;

	void set_size(int widthp, int heightp)
	{
		width = widthp;
		height = heightp;
	}

	// for the moment, I'm ignoring the plane parameter.  Planes are
	// inserted in turn, starting with 0
	void insert_plane(float planep, float huep, Belief *belp)
	{
		ModelPlane *newplane = new ModelPlane(huep, belp, width, height);
		push_back(*newplane);
	}
	
	void setup(Glib::RefPtr<Gdk::Colormap>& colormap)
	{
		for (iterator i = begin(); i != end(); ++i)
			i->setup(colormap);
	}
	
	void reset()
	{
		for (iterator i = begin(); i != end(); ++i)
			i->reset();
		minx = (*this)[0].get_width()-1;
		maxx = 0;
		miny = (*this)[0].get_height()-1;
		maxy = 0;
	}

	void set_location(float xp, float yp, float ap)
	{
		x = xp;
		y = yp;
		angle = ap;

	};
	float get_x() { return x; } ;
	float get_y() { return y; } ;
	float get_angle() {return angle; };
	int get_width()
	{
		return (*this)[0].get_width();
	}
	
	int get_height()
	{
		return (*this)[0].get_height();
	}
	
	void update_bounds(float minxp, float maxxp, float minyp, float maxyp)
	{
		if (minxp < minx) minx = minxp;
		if (minx < 0) minx = 0;
		if (maxxp > maxx) maxx = maxxp;
		if (maxx >= get_width()) maxx = get_width()-1;
		
		if (minyp < miny) miny = minyp;
		if (miny < 0) miny = 0;
		if (maxyp > maxy) maxy = maxyp;
		if (maxy >= get_height()) maxy = get_height()-1;
		//		printf("minxp %f maxxp %f minyp %f maxyp %f, minx %f maxx %f miny %f maxy %f\n", minxp, maxxp, minyp, maxyp, minx, maxx, miny, maxy);		
	}

	// this print function is a bit flaky:  the planes don't actually
	// know their color numbers, so this function prints the start of
	// each line and they finish it
	void print(FILE *ofile)
	{
		for (int i = 0; i < size(); ++i) {
			fprintf(ofile, "color %2d", i);
			(*this)[i].print(ofile);
		}
	}
};
	
#endif


