// generated 2003/8/6 12:55:16 MDT by pfeiffer@babs.wb
// using glademm V2.0.0
//
// newer (non customized) versions of this file go to isaac.cc_new

// This file is for your program, I won't touch it again!

// I don't really know what the "right" thing to do is regarding
// extern "C" -- should I wrap it around everything that isn't
// explicitly C++ (even though the well-written header files do it for
// themselves), or do I just wrap it around the ones that don't work
// on my machine?  For the moment I'll do the latter; if it turns out
// that there are different versions of the header files on different
// systems, and that on some systems the ones I'm not wrapping turn
// out not to work, I'll reconsider.
extern "C" {
#include <pbm.h>
};

#include <math.h>
#include <stdio.h>

#include <config.h>
#include <libgnomemm/main.h>
#include <libgnomeuimm/init.h>
//#include <bonobomm/widgets/wrap_init.h>
#include <libgnome/gnome-i18n.h>
#include <X11/Xlib.h>
#include "arena.hh"
#include "belmap.hh"
#include "robot.hh"
#include "rule.hh"

#include "window1.hh"

//extern int yydebug;
extern char yytext[];
extern int yylineno;
extern int yyleng;
extern int yyparse();
extern "C" {
int yywrap()
{
	return 1;
}
};

MoveRules moveRules;
ObjectRules objRules;
Model model;
window1 *window1;
// the variables in this first block are initialized to default
// values, which can be changed through command-line options.
int x		= -1;  // window location
int y		= -1;
int width	= 512; // arena width
int height	= 512; // arena height
int box_x		= 255; // box center
int box_y		= 255;
int box_width	=  64; // box size
int box_height	=  64;
int robotx          =  32; // robot's x coordinate
int roboty			= 32; // robot's y coordinate
float spread		= .25; // sensor spread (per pixel of range)
float retprob		=1.00; // return prob
float marsprob		=0.00; // mars return prob
unsigned int precision = 4; // precision of sonar returns
float bel_thresh		=0.25; // threshold to display belief function

char* geomstring = "--geometry";
char* geometry = NULL;
char* box_geom = NULL;
char* arenaname = NULL;

struct poptOption options[] = {
  {
	"arena",
	'a',
	POPT_ARG_STRING,
	&arenaname,
	0,
	N_("PBM file containing arena"),
	N_("filename")
  },
  { 
	"belthresh",
	'b',
	POPT_ARG_FLOAT,
	&bel_thresh,
	0,
	N_("threshold to display belief rather than box"),
	N_("0 to 1")
  },
  { 
	"geometry",
	'g',
	POPT_ARG_STRING,
	&geometry,
	0,
	N_("Specify the geometry of the main window"),
	N_("GEOMETRY")
  },
  { 
	"mars",
	'm',
	POPT_ARG_FLOAT,
	&marsprob,
	0,
	N_("probability of totally random returns"),
	N_("RANDOM PROB")
  },
  { 
	"precision",
	'p',
	POPT_ARG_INT,
	&precision,
	0,
	N_("assumed sensor precision"),
	N_("PIXELS")
  },
  { 
	"return",
	'r',
	POPT_ARG_FLOAT,
	&retprob,
	0,
	N_("probability of target intersection causing return"),
	N_("RETURN PROB")
  },
  { 
	"spread",
	's',
	POPT_ARG_FLOAT,
	&spread,
	0,
	N_("beam spread per pixel"),
	N_("SPREAD")
  },
};

int main(int argc, char **argv)
{
	poptContext pctx;
	const char **args;
	int i;
	FILE *f, *arenafile;
	int format;
	Arena *arena;
	Robot *robot;
	
#if defined(ENABLE_NLS)
   bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
   textdomain (GETTEXT_PACKAGE);
#endif //ENABLE_NLS

   // hmmm....  pbm man page says this has to come first, but gives me
   // no idea as to what is about to happen to my command line.  Looks
   // like it's unchanged...
   pbm_init(&argc, argv);
   
   //for (int i = 0; i < argc; i++)
   // printf("%d: %s\n", i, argv[i]);
	
	// we need to understand the -geometry syntax for geometry, as
	// that's how magicpoint generates it.  Too bad gtk doesn't
	// understand the standard X option syntax...  it really needs a
	// parser for that, doesn't it?  But I ain't going to be the one
	// to write it... 
	for (i = 0; i < argc; i++)
		if (strcmp(argv[i], "-geometry") == 0)
			argv[i] = geomstring;

	// one small note -- to my surprise, this doesn't consume the
	// command line args.  So the whole command line is still
	// available, and argc is unchanged
	Gnome::Main m(PACKAGE, VERSION, Gnome::UI::module_info_get(), argc, argv, options, 0, &pctx);
   args = poptGetArgs(pctx);
   
   //   Gnome::Bonobo::wrap_init();

	// handle the options that take some extra work

	// On geometry, there is no way for the XParseGeometry function to
	// notify us of an error; it can just say which parameters were
	// set in the string.  If none were, I'm going to assume a parse
	// error.
	if (geometry != NULL)
		if (XParseGeometry(geometry, &x, &y,
						   &(unsigned int)width, &(unsigned int)height) == 0)
			g_error(_("Could not parse geometry string `%s'"), geometry);
	
	if (box_geom != NULL)
		if (XParseGeometry(box_geom, &box_x, &box_y,
						   &(unsigned int)box_width,
						   &(unsigned int)box_height) == 0)
			g_error(_("Could not parse box geometry string `%s'"), box_geom);


	// If I'm going to use an arena file, I need to open it out here so I can
	// get the width and height.  I have to have this before I can
	// parse the .rules file
	if (arenaname != NULL) {
		arenafile = fopen(arenaname, "r");
		if (arenafile == NULL) {
			// this should really be a popup...
			fprintf(stderr, "opening file %s ", arenaname);
			perror("fopen");
			abort();
		}

		pbm_readpbminit(arenafile, &width, &height, &format);
	}

	arena = new Arena(arenafile, width, height, box_x, box_y, box_width, box_height);
	model.set_size(width, height);
	
	yylineno=1;
	//	yydebug = 1;

	if (argc < 2) {
		fprintf(stderr, "No .rules file specified\n");
		abort();
	}
	
	f = freopen(argv[argc-1], "r", stdin);
	if (f == NULL) {
		fprintf(stderr, "File %s error ", argv[argc-1]);
		perror("freopen");
		abort();
	}
	yyparse();
	// moveRules.print(stdout);
	//	model.print(stdout);
	//	objRules.print(stdout);
	robot = new Robot(*arena, moveRules, objRules, model,
					  robotx, roboty, 0.0,
					  8, spread, retprob, marsprob, precision, 8.0,
					  1.0);
	window1 = new class window1(*arena, *robot, width, height, x, y, bel_thresh);
	m.run(*window1);
	delete window1;
	
	return 0;
}

int yyerror(char *s)
{
	/*	yytext[yyleng] = 0;
		fprintf(stderr,
		"Line %d:  %s \"%s\"(0%o)\n",
		yylineno, s, yytext, yytext[0] & 0xff);*/
	fprintf(stderr,
			"Line %d:  %s\n",
			yylineno, s);
	
		abort();
}

