#ifndef _EXPR_HH_
#define _EXPR_HH_

#include <assert.h>
#include <stack>
#include <vector>

#include "enum.hh"
#include "robot.hh"

class Robot;

class Term {
  private:
	Termtype termtype;
	union {
		char opname;
		int sensornum;
		float value;
	};

  public:
	Term(char valuep) :
	  termtype(OPERATOR), opname(valuep)
	{}

	Term(float valuep) :
	  termtype(FLTVAL), value(valuep)
	{}
	
	Term(int valuep) :
	  termtype(SENSOR), sensornum(valuep)
	{}
	  
	Termtype get_type()
	{
		return termtype;
	}
	  
	float get_immed_value()
	{
		assert(termtype == FLTVAL);
		
		return value;
	}

	float get_sensor_value(Robot &robot)
	{
		assert(termtype == SENSOR);
		
		if (robot.get_sonar(sensornum).get_distance() < 0)
			printf("gotcha!\n");
		
		return robot.get_sonar(sensornum).get_distance();
	}
	
	char get_op_name()
	{
		assert(termtype == OPERATOR);

		return opname;
	}
	  
	void print(FILE *ofile)
	{
		switch(termtype) {
		  case FLTVAL:
			fprintf(ofile, " %f", value);
			break;
			
		  case OPERATOR:
			fprintf(ofile, " %c", opname);
			break;
			
		  case SENSOR:
			fprintf(ofile, " S%d", sensornum);
			break;
			
		  default:
			fprintf(ofile, "(unknown term type %d)", (int) termtype);
			break;
		}
	}
	
};

class Expr : public std::vector<Term>
{
  public:
	float eval(Robot &robot)
	{
		std::stack<float> s;
		float result, op1, op2;
		
		for (iterator i = begin(); i != end(); ++i) 
			switch (i->get_type()) {
			  case FLTVAL:
				s.push(i->get_immed_value());
				break;;
				
			  case SENSOR:
				s.push(i->get_sensor_value(robot));
				break;
				
			  case OPERATOR:
				// no error checking yet...
				op2 = s.top(); s.pop();
				op1 = s.top(); s.pop();
				
				switch(i->get_op_name()) {
				  case '+':
					result = op1 + op2;
					break;
					
				  case '-':
					result = op1 - op2;
					break;
					
				  case '*':
					result = op1 * op2;
					break;
					
				  case '/':
					result = op1 / op2;
					break;
					
				  default:
					fprintf(stderr, "invalid operator %c\n", i->get_op_name());
				}
				
				s.push(result);
				break;
				
			  default:
				fprintf(stderr, "invalid expression contents\n");
			}
		
		return s.top();
	}

	void print(FILE *ofile)
	{
		for (iterator i = begin(); i != end(); ++i)
			i->print(ofile);
	}
};

#endif
