// generated 2003/8/6 15:18:14 MDT by pfeiffer@babs.wb
// using glademm V2.0.0
//
// newer (non customized) versions of this file go to drawingarea1.cc_new

#if defined __GNUC__ && __GNUC__ < 3
#error This program will crash if compiled with g++ 2.x
// see the dynamic_cast bug in the gtkmm FAQ
#endif //
#include "config.h"
#include <libgnome/libgnome.h>
#include <gtkmm/main.h>
#include "arena.hh"
#include "belmap.hh"
#include "drawingarea1.hh"
#include "enum.hh"
#include "robot.hh"
#include "window1.hh"

void drawingarea1::on_drawingarea1_realize()
{
}

bool drawingarea1::on_drawingarea1_expose_event(GdkEventExpose *ev)
{
	window1->draw_image(gc, image, 0, 0, 0, 0, width, height);
	return false;
}

bool drawingarea1::on_drawingarea1_button_press_event(GdkEventButton
													  *ev)
{
	robot.set_init(ev->x, height - 1 - ev->y);
	draw_all();
	return false;
}

drawingarea1::drawingarea1(GlademmData *gmm_data,
						   Arena &arenap, Robot &robotp,
						   unsigned int widthp, unsigned int heightp, int xp, int yp,
						   float bel_threshp, Glib::RefPtr<Gdk::Colormap> colormapp) :
  arena(arenap),
  robot(robotp),
  x(xp),y(yp),
  width(widthp), height(heightp),
  bel_thresh(bel_threshp),
  colormap(colormapp)
{
	set_size_request(512,512);
	show();
	signal_realize().connect(SigC::slot(*this, &drawingarea1::on_drawingarea1_realize));
	signal_expose_event().connect(SigC::slot(*this, &drawingarea1::on_drawingarea1_expose_event));	signal_expose_event().connect(SigC::slot(*static_cast<class
											 drawingarea1*>(this),
											 &drawingarea1::on_drawingarea1_expose_event));
	add_events(Gdk::BUTTON_PRESS_MASK);
	signal_button_press_event().connect(SigC::slot(*static_cast<class 
											 drawingarea1*>(this),
											 &drawingarea1::on_drawingarea1_button_press_event));
	//	glademm_set_Widget("drawingarea1", this);

	set_size_request(width, height);
	
	signal_realize().connect(SigC::slot(*static_cast<class drawingarea1*>(this), &drawingarea1::my_realize));
	
	show();
}

// if an object is present, show a black pixel.  Otherwise, retrieve
// the correct color, based on belief and disbelief, from the color
// lookup table.

// this is one of the places we have some experiments to run:  how
// best to visualize multidimensional data?

// the general idea should be that the user should see a fusion of the
// belief functions of all six model planes overlaid on the arena.
// But what's a good fusion?  Clearly, just alternating pixels between
// all six is Not The Right Idea.

// One thought is that the highest-belief plane should be shown if it
// is high enough, otherwise show the arena if there is an actual
// obstacle, otherwise show the highest-disbelief plane.  Hmm....
// let's try it.
void drawingarea1::put_pixel(Arena& arena, Model& model, unsigned int x, unsigned int y)
{
	int highestbcolor, highestdcolor;
	float highestbelief, highestdisbelief;
	
	// Which of the planes has the highest belief value?
	highestbelief = 0;
	highestdisbelief = 0;
	highestbcolor = -1;  // default.
	highestdcolor = -1;  // default

	// I'm interested in the belief level of everything.  I'm only
	// interested in the disbelief level of things that aren't
	// initialized to disbelief=1
	for (int i = 0; i != model.size(); i++) {
		if (model[i].visible && (model[i](x, y).get_belief() > highestbelief)) {
			highestbcolor = i;
			highestbelief = model[i](x, y).get_belief();
		}
		if ((model[i].resetdisbelief != 1.0) &&
			model[i].visible &&
			(model[i](x, y).get_disbelief() > highestdisbelief)) {
			highestdcolor = i;
			highestdisbelief = model[i](x, y).get_disbelief();
		}
	}

	// OK, at this point we should have the highest belief and highest
	// disbelief values.
	if ((highestbelief > bel_thresh) &&	(highestbcolor != -1) &&
		model[highestbcolor].visible)
		image->put_pixel(x, model[highestbcolor].get_height()-y-1,
						 model[highestbcolor].beliefmap((int)(model[highestbcolor](x, y).get_belief()*7.0 + 0.5),
											   (int)(model[highestbcolor](x, y).get_disbelief()*7.0 + 0.5)).
						 get_pixel());
	else if (arena(x, y).get_present() && arena.visible)
		image->put_pixel(x, model[0].get_height()-y-1,
						 black.get_pixel());
	else if (highestdcolor != -1)
		image->put_pixel(x, model[highestdcolor].get_height()-y-1,
						 model[highestdcolor].beliefmap
						 ((int)(model[highestdcolor](x, y).get_belief()*7.0 + 0.5),
						  (int)(model[highestdcolor](x, y).get_disbelief()*7.0 + 0.5)).
						 get_pixel());
	else
		image->put_pixel(x, model[0].get_height()-y-1,
						 model[0].beliefmap(0, 0).get_pixel());
	
//	printf("%3d, %3d, %d\n", x, y, image.getixel(x, y));
}

void drawingarea1::my_realize()
{
	visual = get_visual();
	window1 = get_window();
	gc = Gdk::GC::create(window1);
	gc->set_function(Gdk::COPY);
	image = Gdk::Image::create(Gdk::IMAGE_FASTEST, visual, get_width(), get_height());

	black.set_rgb(0, 0, 0);
	colormap->alloc_color(black, true, false);
	reset();
}

void drawingarea1::set_simspeed(unsigned int simspeed_p)
{
	// we always take one step when the user changes the speed (this
	// makes the step button work, and doesn't affect anything else).
	robot.step();
	draw();
	
	if (simspeed != simspeed_p) {
		if (simspeed != 0)
			timeout_conn.disconnect();

		simspeed = simspeed_p;
		
		if (simspeed != 0)
			timeout_conn = Glib::signal_timeout().connect(SigC::slot(*static_cast<class drawingarea1*>(this), &drawingarea1::timer_callback), simspeed);
	}
}

bool drawingarea1::timer_callback()
{
	if (robot.step() == false)
		set_simspeed(0);

	draw();
	
	if (simspeed != 0)
		return(true);
	else
		return(false);
}

// there is a slight catch here: What I'm using as my direction is the
// difference in angle between my frame of reference and that of the
// arena.  Then the robot moves forward in Y.  So, in drawing the
// wedge showing which way I'm moving, I need to rotate pi/2
void drawingarea1::draw()
{
	int minx, miny, maxx, maxy;
	
	if (is_realized()) {
		if ((get_robot().get_model().minx <= get_robot().get_model().maxx) &&
			(get_robot().get_model().miny <= get_robot().get_model().maxy)) {
			// first, the long part:  draw the model itself.
			for (float y = get_robot().get_model().miny; y <= get_robot().get_model().maxy; ++y)
				for (float x = get_robot().get_model().minx; x <= get_robot().get_model().maxx; ++x)
					put_pixel(arena, robot.get_model(), (int) (x + 0.5), (int) (y + 0.5));

			// work out how much of the window needs to be redrawn.  I
			// need to get the bounds of the model mods (which I just
			// worked out) and extend it enough to get the robot's old
			// location.
			minx = (int) maximum(0, minimum(get_robot().get_model().minx,
											get_robot().get_old_x() - get_robot().get_radius()));
			miny = (int) maximum(0, (height - 1 -
									 maximum(get_robot().get_model().maxy,
											 get_robot().get_old_y() + get_robot().get_radius())));
			maxx = (int) minimum(width-1,
								 maximum(get_robot().get_model().maxx,
								 get_robot().get_old_x() +
										 get_robot().get_radius() + 1));
			maxy = (int) minimum(height-1,
								 height -
								 minimum(get_robot().get_model().miny,
										 get_robot().get_old_y() - get_robot().get_radius()));

			window1->draw_image(gc, image, minx, miny, minx, miny,
								maxx - minx + 1, maxy - miny + 1);
			
			//			window1->draw_rectangle(get_style()->get_black_gc(), false,
			//					minx, miny, maxx-minx+1, maxy-miny+1);
			
			// reset the drawing area parameters
			get_robot().get_model().minx = width-1;
			get_robot().get_model().maxx = 0;
			get_robot().get_model().miny = height-1;
			get_robot().get_model().maxy = 0;
		}
		
		// Now draw the robot.  I'll just draw it as a simple black
		// circle with a white wedge showing which way is forward.
		// I'll just assume the whole robot fits in the arena.
		if (robot.visible) {
			window1->draw_arc(get_style()->get_black_gc(), true,
							  (int) (robot.get_x() - robot.get_radius() + 0.5),
							  (int) (height - 1 - robot.get_y() - robot.get_radius() + 0.5),
							  (int) (2*robot.get_radius() + 0.5),
							  (int) (2*robot.get_radius() + 0.5),
							  0, 64*360);
			window1->draw_arc(get_style()->get_white_gc(), true,
							  (int) (robot.get_x() - robot.get_radius() + 0.5),
							  (int) (height - 1 - robot.get_y() - robot.get_radius() + 0.5),
							  (int) (2*robot.get_radius() + 0.5),
							  (int) (2*robot.get_radius() + 0.5),
							  (int) ((robot.get_angle() + M_PI_2)*64*360/(2.0*M_PI) - 45*64 + 0.5),
							  90 * 64);
		}
		
		// let's make sure we pick up any outstanding events.  I
		// don't know why this crashes if the drawing bounds are
		// messed up...
		while (Gtk::Main::events_pending())
			Gtk::Main::iteration(false);
	}
}

void drawingarea1::draw_all()
{
	get_robot().get_model().minx = 0;
	get_robot().get_model().maxx = width-1;
	get_robot().get_model().miny = 0;
	get_robot().get_model().maxy = height-1;

	draw();
}

void drawingarea1::reset()
{
	int x, y;

	// reset the robot and arena
	robot.reset();
	arena.reset();
	
	// draw the current appearance
	draw_all();
}
